%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Name:         test_gmac = test global active contour model
% Description:  see paper "Fast Global Minimization of the Active Contour/Snake Model" in JMIV07
% Author: 	Xavier Bresson (xbresson@math.ucla.edu)
% Latest version: 07-09-21
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% General Constants
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RD = Region Descriptor
RD_MEAN = 0; % RD = Mean Intensity
RD_PDF = 1; % RD = Probability Density Function (PDF)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Description of parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [Im0,map] = imread('YOUR_PICTURE.FORMAT');
% EDGE DETECTOR function (Gb) = 1/ ( 1 + beta*convolution(Im0,Gaussian(std_Gb))^2 )
% std_Gb = standard deviation of the 2D Gaussian function used in Gb
% beta = parameter that controls the depth of Gb 
% region_descriptor = type of REGION DESCRIPTOR to make the image segmentation
% if region_descriptor = RD_MEAN then model of Active Contours Without Edges of Chan-Vese
% if region_descriptor = RD_PDF (Probability Density Function) then segmentation model based 
%                        on the region competition between the PDF inside and outside the evolving active contour
% theta = regularization parameter for function u in the ROF model
% lambda = segmentation parameter for function v (use the values of Min/MaxRegionTerm to choose this constant)
% dt = time step for the dual minimization scheme in the ROF model (usually equal to 1/8)
% std_pwm = standard deviation of the 1D Gaussian kernel in the estimation of the PDF, pwm stands for Parzen windowing method
% NbIterUpdate = number of iterations before recomputing the region-based term
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Default values
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
std_Gb = 1; 
beta = 50/255^2; 
region_descriptor = RD_MEAN; 
theta = 1/7; 
lambda = 1/theta*1e-6*5;
dt = 1/8; 
std_pwm = 2;
NbIterUpdate = 10;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Note: Comment and Uncomment different exemples
% Liver Picture
[Im0,map] = imread('images/liver.tif');  
std_Gb = 0.5;
beta = 50/255^2; 
region_descriptor = RD_MEAN;
theta = 1/1.5;
lambda = 1; 
dt = 1/8;
NbIterUpdate = 10;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%





% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Note: Comment and Uncomment different exemples
% % Zebra Picture, Region descriptor = MEAN
% [Im0,map] = imread('images/zebra.jpg'); 
% std_Gb = 3;
% beta = 50/255^2; 
% region_descriptor = RD_MEAN;
% theta = 1/7;
% lambda = 1/theta*1e-6*5; 
% dt = 1/8;
% NbIterUpdate = 50;
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Note: Comment and Uncomment different exemples
% % Zebra Picture, Region descriptor = PDF
% [Im0,map] = imread('images/zebra.jpg'); 
% std_Gb = 3; 
% beta = 50/255^2; 
% region_descriptor = RD_PDF; 
% theta = 1/450;
% lambda = 1/theta*1e3*4;
% dt = 1/8; 
% std_pwm = 8;
% NbIterUpdate = 50;
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%







%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Global Minimization of the Active Contour Model
gmac(Im0,std_Gb,beta,region_descriptor,theta,lambda,dt,std_pwm,NbIterUpdate);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




