
% Author: Xavier Bresson (xbresson at math.ucla.edu)
% Last version: Oct 06 2008
% Name: computePCA
% Description: This function performs the principal components analysis
% (PCA) on a training set of signed distance functions.


function computePCA

close all;





%%%%%%%%% load training set of ellipses %%%%%%%%%
disp('load training set of ellipses');
loadfile = '../data/trainingSetEllipses.mat';
load(loadfile,'training_set');
[Ny,Nx,NbData] = size(training_set);
%%%%%%%%% END load training set of ellipses %%%%%%%%%




%%%%%%%%% compute PCA %%%%%%%%%
disp('compute PCA');
FittingGoodness = 0.98; % percentage of fitting with training set
p = -1; % number of eigenvalues for PCA. If p=-1, then apply FittingGoodness
MODE_PCA_DECOMPOSITION = 0;
modePCA = MODE_PCA_DECOMPOSITION;
[EVec,EVal,p,MeanValue] = pca_mex(int32(modePCA),single(training_set),int32(Nx),int32(Ny),int32(NbData),...
    single(FittingGoodness),int32(p),int32(0));
p=double(p);

disp('save PCA');
savefile = '../data/pcaEllipses.mat';
save(savefile,'p','EVec','EVal','MeanValue');
%%%%%%%%% END compute PCA %%%%%%%%%



%%%%%%%%% display eigenvectors %%%%%%%%%
disp('display eigenvectors');
n= ceil(sqrt(p));
m= ceil(p/n);
cpt_fig = 1;
figure(cpt_fig);
for e=1:p
    subplot(m,n,e); imagesc(EVec(:,:,e)); hold on; axis off; colorbar;
    title( ['eigenvalue = ',num2str(double(EVal(e)),6) ] );
end
f=3; truesize(cpt_fig,[round(f*Ny) round(f*Nx)]);
%pause
%%%%%%%%% END display eigenvectors %%%%%%%%%




%%%%%%%%% generate new data using PCA %%%%%%%%%
%%%%%%%%% x_new = Mean + Matrix(eigenvector)*x_pca %%%%%%%%%
disp('generate new data using PCA');
Vcoef = zeros(p,1); % = x_pca
% Vcoef(1) = 2*sqrt(double(EVal(1)));
% Vcoef(2) = 0*sqrt(double(EVal(2)));
% Vcoef(3) = 0*sqrt(double(EVal(3)));

MODE_PCA_RECONSTRUCTION = 1;
modePCA = MODE_PCA_RECONSTRUCTION;

% 1st data
Vcoef(1) = 2*sqrt(double(EVal(1))); xpca1=Vcoef(1);
[NewPcaFunction1,Pr] = pca_mex(int32(modePCA),single(EVec),single(EVal),single(MeanValue),single(Vcoef),...
    int32(p),int32(Nx),int32(Ny),int32(0));

% 2nd data
Vcoef(1) = -2*sqrt(double(EVal(1))); xpca2=Vcoef(1);
[NewPcaFunction2,Pr] = pca_mex(int32(modePCA),single(EVec),single(EVal),single(MeanValue),single(Vcoef),...
    int32(p),int32(Nx),int32(Ny),int32(0));

disp('display new data using PCA');
cpt_fig = 2;
figure(cpt_fig);
subplot(121); imagesc(NewPcaFunction1); hold on; colorbar; title( ['New data (magenta) xpca=',num2str(xpca1),' Mean value (black)' ] );
contour(NewPcaFunction1,[0 0],'m'); contour(MeanValue,[0 0],'k');
subplot(122); imagesc(NewPcaFunction2); hold on; colorbar; title( ['New data (magenta) xpca=',num2str(xpca2),' Mean value (black)' ] );
contour(NewPcaFunction2,[0 0],'m'); contour(MeanValue,[0 0],'k');
f=3; truesize(cpt_fig,[round(f*Ny) round(f*Nx)]);
%%%%%%%%% END generate new data using PCA %%%%%%%%%




