/*
 * Decompiled with CFR 0.152.
 */
package com.xson;

import com.xson.JsonArray;
import com.xson.JsonArrayAware;
import com.xson.JsonAware;
import com.xson.JsonBeanAware;
import com.xson.JsonObject;
import com.xson.JsonObjectAware;
import com.xson.JsonParseException;
import com.xson.feature.DefaultDeserializeFeature;
import com.xson.feature.DefaultSerializeFeature;
import com.xson.feature.DeserializeFeature;
import com.xson.feature.SerializeFeature;
import com.xson.lexer.JSONLexer;
import com.xson.lexer.JSONParser;
import com.xson.parser.JsonArrayListener;
import com.xson.parser.JsonObjectListener;
import com.xson.parser.JsonValueParser;
import com.xson.util.DateUtil;
import com.xson.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public abstract class Json {
    protected Json() {
    }

    public static String toJsonString(Object obj, SerializeFeature feature) {
        if (obj == null) {
            return "null";
        }
        if (feature == null) {
            feature = DefaultSerializeFeature.globalDefaultFuture;
        }
        if (obj.getClass().isArray()) {
            JsonArray jsonArray = new JsonArray(obj);
            return jsonArray.toJsonString(feature);
        }
        if (obj instanceof JsonAware) {
            return ((JsonAware)obj).toJsonString(feature);
        }
        if (obj instanceof JsonObjectAware) {
            JsonObjectAware jsonObjectAware = (JsonObjectAware)obj;
            JsonObject jsonObject = new JsonObject();
            jsonObjectAware.toJson(jsonObject, feature);
            return jsonObject.toJsonString(feature);
        }
        if (obj instanceof JsonArrayAware) {
            JsonArrayAware jsonArrayAware = (JsonArrayAware)obj;
            JsonArray jsonArray = new JsonArray();
            jsonArrayAware.toJson(jsonArray, feature);
            return jsonArray.toJsonString(feature);
        }
        if (obj instanceof String) {
            return StringUtil.parseString((String)obj, feature);
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            if (feature.dateFormat() == null) {
                return StringUtil.parseString(DateUtil.format(date), feature);
            }
            return StringUtil.parseString(DateUtil.format(date, feature.dateFormat()), feature);
        }
        if (obj instanceof List || obj instanceof Set) {
            Collection collection = (Collection)obj;
            if (feature.writeCollectionAsJson()) {
                return new JsonArray(collection).toJsonString(feature);
            }
            return StringUtil.parseString(collection.toString(), feature);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (feature.writeCollectionAsJson()) {
                JsonObject jsonObject = new JsonObject();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    jsonObject.put(String.valueOf(entry.getKey()), entry.getValue());
                }
                return jsonObject.toJsonString(feature);
            }
            return StringUtil.parseString(map.toString(), feature);
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            return String.valueOf(obj);
        }
        return StringUtil.parseString(obj.toString(), feature);
    }

    public static JsonObject parseObject(InputStream inputStream) throws IOException {
        return Json.parseObject(inputStream, null);
    }

    public static JsonObject parseObject(InputStream inputStream, DeserializeFeature feature) throws IOException {
        JSONLexer lexer = JsonValueParser.initLexer(inputStream);
        return Json.parseLexer(lexer, feature);
    }

    private static JsonObject parseLexer(JSONLexer lexer, DeserializeFeature feature) {
        if (feature == null) {
            feature = DefaultDeserializeFeature.globalDefaultDeserializeFeature;
        }
        JSONParser parser = JsonValueParser.initParser(lexer);
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new JsonParseException("syntax error:" + msg + ",line " + line);
            }
        });
        JsonObjectListener jsonObjectListener = new JsonObjectListener(feature);
        JsonValueParser.walk(parser, jsonObjectListener);
        return jsonObjectListener.getJsonObject();
    }

    public static JsonObject parseObject(String jsonString, DeserializeFeature feature) {
        JSONLexer lexer = JsonValueParser.initLexer(jsonString);
        return Json.parseLexer(lexer, feature);
    }

    public static JsonArray parseArray(String jsonString, DeserializeFeature feature) {
        return Json.parseArray0(JsonValueParser.initLexer(jsonString), feature);
    }

    public static JsonArray parseArray(InputStream inputStream, DeserializeFeature feature) throws IOException {
        return Json.parseArray0(JsonValueParser.initLexer(inputStream), feature);
    }

    public static JsonArray parseArray(InputStream inputStream) throws IOException {
        return Json.parseArray(inputStream, null);
    }

    private static JsonArray parseArray0(JSONLexer lexer, DeserializeFeature feature) {
        if (feature == null) {
            feature = DefaultDeserializeFeature.globalDefaultDeserializeFeature;
        }
        JSONParser parser = JsonValueParser.initParser(lexer);
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new JsonParseException("syntax error:" + msg + ",line " + line);
            }
        });
        JsonArrayListener jsonArrayListener = new JsonArrayListener(feature);
        JsonValueParser.walk(parser, jsonArrayListener);
        return jsonArrayListener.getJsonArray();
    }

    public static String toJsonString(Object obj) {
        return Json.toJsonString(obj, null);
    }

    public static JsonObject parseObject(String jsonString) {
        return Json.parseObject(jsonString, null);
    }

    public static JsonArray parseArray(String jsonString) {
        return Json.parseArray(jsonString, null);
    }

    private static <T extends JsonBeanAware> T parseBean(JsonObject jsonObject, Class<T> type, DeserializeFeature feature) {
        try {
            JsonBeanAware t = (JsonBeanAware)type.newInstance();
            t.parse(jsonObject, feature);
            return (T)t;
        }
        catch (InstantiationException e) {
            throw new JsonParseException(e);
        }
        catch (IllegalAccessException e) {
            throw new JsonParseException(e);
        }
    }

    public static <T extends JsonBeanAware> T parseBean(String jsonString, Class<T> type, DeserializeFeature feature) {
        if (feature == null) {
            feature = DefaultDeserializeFeature.globalDefaultDeserializeFeature;
        }
        JsonObject jsonObject = Json.parseObject(jsonString, feature);
        return Json.parseBean(jsonObject, type, feature);
    }

    public static <T extends JsonBeanAware> T parseBean(InputStream inputStream, Class<T> type) throws IOException {
        return Json.parseBean(inputStream, type, null);
    }

    public static <T extends JsonBeanAware> T parseBean(InputStream inputStream, Class<T> type, DeserializeFeature feature) throws IOException {
        if (feature == null) {
            feature = DefaultDeserializeFeature.globalDefaultDeserializeFeature;
        }
        JsonObject jsonObject = Json.parseObject(inputStream, feature);
        return Json.parseBean(jsonObject, type, feature);
    }

    public static <T extends JsonBeanAware> List<T> parseBeanList(InputStream inputStream, Class<T> type) throws IOException {
        return Json.parseBeanList(inputStream, type, null);
    }

    public static <T extends JsonBeanAware> List<T> parseBeanList(InputStream inputStream, Class<T> type, DeserializeFeature feature) throws IOException {
        if (feature == null) {
            feature = DefaultDeserializeFeature.globalDefaultDeserializeFeature;
        }
        JsonArray jsonArray = Json.parseArray(inputStream, feature);
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            if (!(jsonArray.get(i) instanceof JsonObject)) {
                throw new JsonParseException("Array item " + i + " is not a JsonObject!");
            }
            list.add(Json.parseBean((JsonObject)jsonArray.get(i), type, feature));
        }
        return list;
    }

    public static <T extends JsonBeanAware> List<T> parseBeanList(String jsonString, Class<T> type, DeserializeFeature feature) {
        if (feature == null) {
            feature = DefaultDeserializeFeature.globalDefaultDeserializeFeature;
        }
        JsonArray jsonArray = Json.parseArray(jsonString, feature);
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            if (!(jsonArray.get(i) instanceof JsonObject)) {
                throw new JsonParseException("Array item " + i + " is not a JsonObject!");
            }
            list.add(Json.parseBean((JsonObject)jsonArray.get(i), type, feature));
        }
        return list;
    }

    public static <T extends JsonBeanAware> T parseBean(String jsonString, Class<T> type) {
        return Json.parseBean(jsonString, type, null);
    }

    public static <T extends JsonBeanAware> List<T> parseBeanList(String jsonString, Class<T> type) {
        return Json.parseBeanList(jsonString, type, null);
    }

    public String toString() {
        return Json.toJsonString(this, null);
    }

    public String toString(SerializeFeature feature) {
        return Json.toJsonString(this, feature);
    }
}

