/*
 * Decompiled with CFR 0.152.
 */
package com.xson;

import com.xson.Json;
import com.xson.JsonAware;
import com.xson.JsonObject;
import com.xson.cast.TypeUtils;
import com.xson.feature.SerializeFeature;
import com.xson.util.Args;
import com.xson.util.Null;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class JsonArray
extends Json
implements Serializable,
Iterable<Object>,
JsonAware {
    private static final long serialVersionUID = 1502182893478537858L;
    private List<Object> list;
    private static final Null NULL = Null.instance;

    public JsonArray() {
        this.list = this.createList();
    }

    public JsonArray(JsonArray jsonArray) {
        this.list = this.createList(jsonArray.list);
    }

    public JsonArray(List<Object> list) {
        this.list = this.createList();
        for (Object o : list) {
            list.add(o == null ? NULL : o);
        }
    }

    public JsonArray(Collection<Object> collection) {
        this.list = this.createList();
        this.list.addAll(collection);
    }

    JsonArray(Object array) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            this.list.add(Array.get(array, i));
        }
    }

    private JsonArray(List<Object> list, Object o) {
        this.list = list;
    }

    protected List<Object> createList() {
        return new ArrayList<Object>();
    }

    protected List<Object> createList(List<Object> list) {
        return new ArrayList<Object>(list);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public JsonArray add(Object o) {
        this.list.add(o == null ? NULL : o);
        return this;
    }

    public Object get(int index, Object defaultValue) {
        Object o = this.list.get(index);
        if (o == null || o instanceof Null) {
            return defaultValue;
        }
        return o;
    }

    public Object get(int index) {
        return this.get(index, null);
    }

    public Object remove(int index) {
        Object o = this.list.remove(index);
        if (o instanceof Null) {
            return null;
        }
        return o;
    }

    public Object remove(Object object) {
        Boolean o = this.list.remove(object == null ? NULL : object);
        if (o instanceof Null) {
            return null;
        }
        return o;
    }

    public void clear() {
        this.list.clear();
    }

    public List<Object> toList() {
        List<Object> list = this.createList();
        for (Object o : this.list) {
            list.add(o instanceof Null ? null : o);
        }
        return list;
    }

    public List<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : this) {
            list.add(String.valueOf(o));
        }
        return list;
    }

    public JsonArray subArray(int start, int offset) {
        List<Object> subList = this.list.subList(start, offset);
        return new JsonArray(subList, null);
    }

    @Override
    public Iterator<Object> iterator() {
        return new JsonArrayItr();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArray jsonArray = (JsonArray)o;
        return this.list != null ? this.list.equals(jsonArray.list) : jsonArray.list == null;
    }

    public int hashCode() {
        return this.list != null ? this.list.hashCode() : 0;
    }

    @Override
    public String toJsonString(SerializeFeature feature) {
        StringBuilder stringBuilder = new StringBuilder("[");
        int i = 0;
        for (Object o : this) {
            if (o == null && !feature.writesNullValue()) continue;
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Json.toJsonString(o, feature));
            ++i;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String getString(int index) {
        Object value = this.get(index);
        return TypeUtils.castToString(value);
    }

    public Byte getByte(int index) {
        Object value = this.get(index);
        return TypeUtils.castToByte(value);
    }

    public Character getChar(int index) {
        Object value = this.get(index);
        return TypeUtils.castToChar(value);
    }

    public Short getShort(int index) {
        Object value = this.get(index);
        return TypeUtils.castToShort(value);
    }

    public BigDecimal getBigDecimal(int index) {
        Object value = this.get(index);
        return TypeUtils.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(int index) {
        Object value = this.get(index);
        return TypeUtils.castToBigInteger(value);
    }

    public Float getFloat(int index) {
        Object value = this.get(index);
        return TypeUtils.castToFloat(value);
    }

    public Double getDouble(int index) {
        Object value = this.get(index);
        return TypeUtils.castToDouble(value);
    }

    public java.util.Date getDate(int index) {
        Object value = this.get(index);
        return TypeUtils.castToDate(value);
    }

    public Date getSqlDate(int index) {
        Object value = this.get(index);
        return TypeUtils.castToSqlDate(value);
    }

    public Timestamp getTimestamp(int index) {
        Object value = this.get(index);
        return TypeUtils.castToTimestamp(value);
    }

    public Long getLong(int index) {
        Object value = this.get(index);
        return TypeUtils.castToLong(value);
    }

    public Integer getInt(int index) {
        Object value = this.get(index);
        return TypeUtils.castToInt(value);
    }

    public byte[] getBytes(int index) {
        Object value = this.get(index);
        return TypeUtils.castToBytes(value);
    }

    public Boolean getBoolean(int index) {
        Object value = this.get(index);
        return TypeUtils.castToBoolean(value);
    }

    public JsonObject getJsonObject(int index) {
        Object value = this.get(index);
        return TypeUtils.castToJsonObject(value);
    }

    public JsonArray getJsonArray(int index) {
        Object value = this.get(index);
        return TypeUtils.castToJsonArray(value);
    }

    public String getJson(int index) {
        Object value = this.get(index);
        return Json.toJsonString(value);
    }

    public JsonObject toJsonObject() {
        JsonObject jsonObject = new JsonObject();
        this.putTo(jsonObject);
        return jsonObject;
    }

    protected void putTo(JsonObject jsonObject) {
        for (int i = 0; i < this.size(); ++i) {
            Object value = this.get(i);
            jsonObject.put(String.valueOf(i), value);
        }
    }

    public void sort(Comparator<Object> comparator) {
        Collections.sort(this.list, comparator);
    }

    public void foreach(ForeachHelper foreachHelper) {
        Args.notNull(foreachHelper, "foreach helper");
        int i = 0;
        for (Object o : this.list) {
            if (!foreachHelper.flag) break;
            foreachHelper.foreach(i, o instanceof Null ? null : o);
            ++i;
        }
    }

    public static abstract class ForeachHelper {
        boolean flag = true;

        protected abstract void foreach(int var1, Object var2);

        public final void BREAK() {
            this.flag = false;
        }
    }

    private class JsonArrayItr
    implements Iterator<Object> {
        private Iterator<Object> innerIterator;

        private JsonArrayItr() {
            this.innerIterator = JsonArray.this.list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public Object next() {
            Object o = this.innerIterator.next();
            if (o instanceof Null) {
                return null;
            }
            return o;
        }

        @Override
        public void remove() {
            this.innerIterator.remove();
        }
    }
}

