/*
 * Decompiled with CFR 0.152.
 */
package com.xson.parser;

import com.xson.JsonArray;
import com.xson.JsonObject;
import com.xson.JsonParseException;
import com.xson.feature.DeserializeFeature;
import com.xson.lexer.JSONBaseListener;
import com.xson.lexer.JSONParser;
import com.xson.util.StringUtil;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;

public class JsonObjectListener
extends JSONBaseListener {
    protected ParseTreeProperty<Object> property = new ParseTreeProperty();
    protected ParseTreeProperty<JsonObject> jsonObjectParseTreeProperty = new ParseTreeProperty();
    protected ParseTreeProperty<JsonArray> jsonArrayParseTreeProperty = new ParseTreeProperty();
    private JsonObject jsonObject;
    private DeserializeFeature feature;

    public JsonObjectListener(DeserializeFeature feature) {
        this.feature = feature;
    }

    @Override
    public void enterJsonArray(JSONParser.JsonArrayContext ctx) {
        throw new JsonParseException("need JsonObject but meet JsonArray!");
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    @Override
    public void exitJsonObject(JSONParser.JsonObjectContext ctx) {
        this.jsonObject = (JsonObject)this.jsonObjectParseTreeProperty.get((ParseTree)ctx.object());
    }

    @Override
    public void enterObject(JSONParser.ObjectContext ctx) {
        this.jsonObjectParseTreeProperty.put((ParseTree)ctx, (Object)new JsonObject());
    }

    @Override
    public void enterArray(JSONParser.ArrayContext ctx) {
        this.jsonArrayParseTreeProperty.put((ParseTree)ctx, (Object)new JsonArray());
    }

    @Override
    public void exitPair(JSONParser.PairContext ctx) {
        JsonObject jsonObject = (JsonObject)this.jsonObjectParseTreeProperty.get((ParseTree)ctx.getParent());
        String name = StringUtil.parseJson(ctx.STRING().getText(), this.feature);
        JSONParser.ValueContext valueContext = ctx.value();
        Object value = this.property.get((ParseTree)valueContext);
        if (value != null || this.feature.readNullValue()) {
            jsonObject.put(name, value);
        }
    }

    @Override
    public void exitString(JSONParser.StringContext ctx) {
        this.property.put((ParseTree)ctx, (Object)StringUtil.parseJson(ctx.STRING().getText(), this.feature));
    }

    @Override
    public void exitNUMBER(JSONParser.NUMBERContext ctx) {
        String numberString = ctx.NUMBER().getText();
        this.property.put((ParseTree)ctx, (Object)this.feature.numberCaster().toNumber(numberString));
    }

    @Override
    public void exitArray(JSONParser.ArrayContext ctx) {
        JsonArray jsonArray = (JsonArray)this.jsonArrayParseTreeProperty.get((ParseTree)ctx);
        List<JSONParser.ValueContext> valueContexts = ctx.value();
        for (JSONParser.ValueContext valueContext : valueContexts) {
            jsonArray.add(this.property.get((ParseTree)valueContext));
        }
    }

    @Override
    public void exitObjectValue(JSONParser.ObjectValueContext ctx) {
        JsonObject jsonObject = (JsonObject)this.jsonObjectParseTreeProperty.get((ParseTree)ctx.object());
        this.property.put((ParseTree)ctx, (Object)jsonObject);
    }

    @Override
    public void exitArrayValue(JSONParser.ArrayValueContext ctx) {
        JsonArray jsonArray = (JsonArray)this.jsonArrayParseTreeProperty.get((ParseTree)ctx.array());
        this.property.put((ParseTree)ctx, (Object)jsonArray);
    }

    @Override
    public void exitBOOLEANTRUE(JSONParser.BOOLEANTRUEContext ctx) {
        this.property.put((ParseTree)ctx, (Object)true);
    }

    @Override
    public void exitBOOLEANFALSE(JSONParser.BOOLEANFALSEContext ctx) {
        this.property.put((ParseTree)ctx, (Object)false);
    }

    @Override
    public void exitNULL(JSONParser.NULLContext ctx) {
        this.property.put((ParseTree)ctx, null);
    }
}

