/*
 * Decompiled with CFR 0.152.
 */
package com.xson;

import com.xson.Json;
import com.xson.JsonArray;
import com.xson.JsonAware;
import com.xson.cast.TypeUtils;
import com.xson.feature.SerializeFeature;
import com.xson.util.Args;
import com.xson.util.Null;
import com.xson.util.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonObject
extends Json
implements Serializable,
Iterable<Map.Entry<String, Object>>,
JsonAware {
    private static final long serialVersionUID = 996072007977713757L;
    private Map<String, Object> map;
    private static final Null NULL = Null.instance;

    protected Map<String, Object> createMap() {
        return new LinkedHashMap<String, Object>();
    }

    protected Map<String, Object> createMap(Map<String, Object> map) {
        return new LinkedHashMap<String, Object>(map);
    }

    public JsonObject() {
        this.map = this.createMap();
    }

    public JsonObject(JsonObject jsonObject) {
        this.map = this.createMap(jsonObject.map);
    }

    public JsonObject(Map<String, Object> map) {
        this.map = this.createMap(map);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject that = (JsonObject)o;
        return this.map != null ? this.map.equals(that.map) : that.map == null;
    }

    public int hashCode() {
        return this.map != null ? this.map.hashCode() : 0;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.size() > 0;
    }

    public Object get(String name) {
        return this.get(name, null);
    }

    public Object get(String name, Object defaultValue) {
        Args.notNull(name, "the name");
        Object object = this.map.get(name);
        if (object == null || object instanceof Null) {
            return defaultValue;
        }
        return object;
    }

    public void put(String name, Object o) {
        Args.notNull(name, "the name");
        this.map.put(name, o == null ? NULL : o);
    }

    public boolean containsKey(String name) {
        Args.notNull(name, "the name");
        return this.map.containsKey(name);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value == null ? NULL : value);
    }

    public Object remove(String name) {
        Args.notNull(name, "the name");
        Object o = this.map.remove(name);
        if (o instanceof Null) {
            return null;
        }
        return o;
    }

    public Map<String, Object> toMap() {
        Map<String, Object> map = this.createMap();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue() instanceof Null ? null : entry.getValue();
            map.put(name, value);
        }
        return map;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new JsonObjectItr();
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public String toJsonString(SerializeFeature feature) {
        StringBuilder stringBuilder = new StringBuilder("{");
        int i = 0;
        for (Map.Entry<String, Object> entry : this) {
            Object value = entry.getValue();
            if (value == null && !feature.writesNullValue()) continue;
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(StringUtil.parseString(entry.getKey(), feature));
            stringBuilder.append(':');
            stringBuilder.append(Json.toJsonString(value, feature));
            ++i;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String getString(String name) {
        Object value = this.get(name);
        return TypeUtils.castToString(value);
    }

    public Byte getByte(String name) {
        Object value = this.get(name);
        return TypeUtils.castToByte(value);
    }

    public Character getChar(String name) {
        Object value = this.get(name);
        return TypeUtils.castToChar(value);
    }

    public Short getShort(String name) {
        Object value = this.get(name);
        return TypeUtils.castToShort(value);
    }

    public BigDecimal getBigDecimal(String name) {
        Object value = this.get(name);
        return TypeUtils.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(String name) {
        Object value = this.get(name);
        return TypeUtils.castToBigInteger(value);
    }

    public Float getFloat(String name) {
        Object value = this.get(name);
        return TypeUtils.castToFloat(value);
    }

    public Double getDouble(String name) {
        Object value = this.get(name);
        return TypeUtils.castToDouble(value);
    }

    public java.util.Date getDate(String name) {
        Object value = this.get(name);
        return TypeUtils.castToDate(value);
    }

    public Date getSqlDate(String name) {
        Object value = this.get(name);
        return TypeUtils.castToSqlDate(value);
    }

    public Timestamp getTimestamp(String name) {
        Object value = this.get(name);
        return TypeUtils.castToTimestamp(value);
    }

    public Long getLong(String name) {
        Object value = this.get(name);
        return TypeUtils.castToLong(value);
    }

    public Integer getInt(String name) {
        Object value = this.get(name);
        return TypeUtils.castToInt(value);
    }

    public byte[] getBytes(String name) {
        Object value = this.get(name);
        return TypeUtils.castToBytes(value);
    }

    public Boolean getBoolean(String name) {
        Object value = this.get(name);
        return TypeUtils.castToBoolean(value);
    }

    public JsonObject getJsonObject(String name) {
        Object value = this.get(name);
        return TypeUtils.castToJsonObject(value);
    }

    public JsonArray getJsonArray(String name) {
        Object value = this.get(name);
        return TypeUtils.castToJsonArray(value);
    }

    public String getJson(String name) {
        Object value = this.get(name);
        return Json.toJsonString(value);
    }

    public void foreach(ForeachHelper foreachHelper) {
        Args.notNull(foreachHelper, "foreach helper");
        int i = 0;
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object value;
            String name = entry.getKey();
            Object object = value = entry.getValue() instanceof Null ? null : entry.getValue();
            if (!foreachHelper.flag) break;
            foreachHelper.foreach(i, name, value);
            ++i;
        }
    }

    public static abstract class ForeachHelper {
        boolean flag = true;

        protected abstract void foreach(int var1, String var2, Object var3);

        public final void BREAK() {
            this.flag = false;
        }
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -2630259904409855745L;
        private final K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleEntry that = (SimpleEntry)o;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        @Override
        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class JsonObjectItr
    implements Iterator<Map.Entry<String, Object>> {
        private Iterator<Map.Entry<String, Object>> innerIterator;

        private JsonObjectItr() {
            this.innerIterator = JsonObject.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Map.Entry<String, Object> entry = this.innerIterator.next();
            String name = entry.getKey();
            Object value = entry.getValue() instanceof Null ? null : entry.getValue();
            return new SimpleEntry<String, Object>(name, value);
        }

        @Override
        public void remove() {
            this.innerIterator.remove();
        }
    }
}

