/*
 * Decompiled with CFR 0.152.
 */
package com.xson.util;

import com.xson.feature.DeserializeFeature;
import com.xson.feature.SerializeFeature;
import com.xson.util.Unicode;
import com.xson.util.base64.Base64;

public class StringUtil {
    private static String quoteString(String str) {
        return "\"" + str + "\"";
    }

    private static String replaceQuote(String str) {
        return str.replace("\"", "\\\"");
    }

    private static String jsonString(String str) {
        return StringUtil.quoteString(StringUtil.replaceQuote(str));
    }

    private static String unicodeString(String str) {
        return StringUtil.quoteString(Unicode.string2Unicode(str));
    }

    public static String parseJson(String str, DeserializeFeature feature) {
        if (feature.unicode()) {
            return Unicode.unicode2String(StringUtil.removeQuote(str));
        }
        if (feature.base64()) {
            return Base64.decode(StringUtil.removeQuote(str));
        }
        return StringUtil.removeQuote(str).replace("\\", "\"");
    }

    public static String parseString(String str, SerializeFeature feature) {
        if (feature.unicode()) {
            return StringUtil.unicodeString(str);
        }
        if (feature.base64()) {
            return StringUtil.quoteString(Base64.encode(str));
        }
        return StringUtil.jsonString(str);
    }

    public static String removeQuote(String str) {
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.charAt(48) == '\"' ? "" : str;
        }
        int l = str.charAt(0) == '\"' ? 1 : 0;
        int r = str.charAt(str.length() - 1) == '\"' ? str.length() - 1 : str.length();
        return str.substring(l, r);
    }
}

