/*
 * Decompiled with CFR 0.152.
 */
package net.fs.client;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import net.fs.client.MapClient;
import net.fs.client.MapRule;
import net.fs.client.PortMapProcess;
import net.fs.rudp.Route;

public class PortMapManager {
    MapClient mapClient;
    ArrayList<MapRule> mapList = new ArrayList();
    HashMap<Integer, MapRule> mapRuleTable = new HashMap();
    String configFilePath = "port_map.json";

    PortMapManager(MapClient mapClient) {
        this.mapClient = mapClient;
        this.loadMapRule();
    }

    void addMapRule(MapRule mapRule) throws Exception {
        if (this.getMapRule(mapRule.name) != null) {
            throw new Exception("\u6620\u5c04 " + mapRule.name + " \u5df2\u5b58\u5728,\u8bf7\u4fee\u6539\u540d\u79f0!");
        }
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(mapRule.getListen_port());
            this.listen(serverSocket);
            this.mapList.add(mapRule);
            this.mapRuleTable.put(mapRule.listen_port, mapRule);
            this.saveMapRule();
        }
        catch (IOException e2) {
            throw new Exception("\u7aef\u53e3 " + mapRule.getListen_port() + " \u5df2\u7ecf\u88ab\u5360\u7528!");
        }
    }

    void removeMapRule(String name) {
        MapRule mapRule = this.getMapRule(name);
        if (mapRule != null) {
            this.mapList.remove(mapRule);
            this.mapRuleTable.remove(mapRule.listen_port);
            if (mapRule.serverSocket != null) {
                try {
                    mapRule.serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.saveMapRule();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void updateMapRule(MapRule mapRule_origin, MapRule mapRule_new) throws Exception {
        if (this.getMapRule(mapRule_new.name) != null && !mapRule_origin.name.equals(mapRule_new.name)) {
            throw new Exception("\u6620\u5c04 " + mapRule_new.name + " \u5df2\u5b58\u5728,\u8bf7\u4fee\u6539\u540d\u79f0!");
        }
        ServerSocket serverSocket = null;
        if (mapRule_origin.listen_port != mapRule_new.listen_port) {
            try {
                serverSocket = new ServerSocket(mapRule_new.getListen_port());
                this.listen(serverSocket);
                mapRule_origin.using = false;
                if (mapRule_origin.serverSocket != null) {
                    mapRule_origin.serverSocket.close();
                }
                mapRule_origin.serverSocket = serverSocket;
                this.mapRuleTable.remove(mapRule_origin.listen_port);
                this.mapRuleTable.put(mapRule_new.listen_port, mapRule_new);
            }
            catch (IOException e2) {
                throw new Exception("\u7aef\u53e3 " + mapRule_new.getListen_port() + " \u5df2\u7ecf\u88ab\u5360\u7528!");
            }
        }
        mapRule_origin.name = mapRule_new.name;
        mapRule_origin.listen_port = mapRule_new.listen_port;
        mapRule_origin.dst_port = mapRule_new.dst_port;
        this.saveMapRule();
    }

    void saveMapRule() throws Exception {
        JSONObject json = new JSONObject();
        JSONArray json_map_list = new JSONArray();
        json.put("map_list", (Object)json_map_list);
        this.mapList.size();
        for (MapRule r : this.mapList) {
            JSONObject json_rule = new JSONObject();
            json_rule.put("name", (Object)r.name);
            json_rule.put("listen_port", (Object)r.listen_port);
            json_rule.put("dst_port", (Object)r.dst_port);
            json_map_list.add(json_rule);
        }
        try {
            this.saveFile(json.toJSONString().getBytes("utf-8"), this.configFilePath);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    void loadMapRule() {
        JSONObject json = null;
        try {
            String content = PortMapManager.readFileUtf8(this.configFilePath);
            json = JSONObject.parseObject(content);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (json != null && json.containsKey("map_list")) {
            JSONArray json_map_list = json.getJSONArray("map_list");
            int i = 0;
            while (i < json_map_list.size()) {
                JSONObject json_rule = (JSONObject)json_map_list.get(i);
                MapRule mapRule = new MapRule();
                mapRule.name = json_rule.getString("name");
                mapRule.listen_port = json_rule.getIntValue("listen_port");
                mapRule.dst_port = json_rule.getIntValue("dst_port");
                this.mapList.add(mapRule);
                try {
                    ServerSocket serverSocket = new ServerSocket(mapRule.getListen_port());
                    this.listen(serverSocket);
                    mapRule.serverSocket = serverSocket;
                }
                catch (IOException e) {
                    mapRule.using = true;
                    e.printStackTrace();
                }
                this.mapRuleTable.put(mapRule.listen_port, mapRule);
                ++i;
            }
        }
    }

    MapRule getMapRule(String name) {
        MapRule rule = null;
        for (MapRule r : this.mapList) {
            if (!r.getName().equals(name)) continue;
            rule = r;
            break;
        }
        return rule;
    }

    public ArrayList<MapRule> getMapList() {
        return this.mapList;
    }

    public void setMapList(ArrayList<MapRule> mapList) {
        this.mapList = mapList;
    }

    void listen(final ServerSocket serverSocket) {
        Route.es.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        final Socket socket = serverSocket.accept();
                        Route.es.execute(new Runnable(){

                            @Override
                            public void run() {
                                int listenPort = serverSocket.getLocalPort();
                                MapRule mapRule = (this).PortMapManager.this.mapRuleTable.get(listenPort);
                                if (mapRule != null) {
                                    Route route = null;
                                    route = (this).PortMapManager.this.mapClient.isUseTcp() ? (this).PortMapManager.this.mapClient.route_tcp : (this).PortMapManager.this.mapClient.route_udp;
                                    PortMapProcess portMapProcess = new PortMapProcess((this).PortMapManager.this.mapClient, route, socket, (this).PortMapManager.this.mapClient.serverAddress, (this).PortMapManager.this.mapClient.serverPort, null, null, mapRule.dst_port);
                                }
                            }
                        });
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
    }

    void saveFile(byte[] data, String path) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(data);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static String readFileUtf8(String path) throws Exception {
        String str = null;
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            File file = new File(path);
            int length = (int)file.length();
            byte[] data = new byte[length];
            fis = new FileInputStream(file);
            dis = new DataInputStream(fis);
            ((DataInputStream)dis).readFully(data);
            str = new String(data, "utf-8");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return str;
    }
}

