/*
 * Decompiled with CFR 0.152.
 */
package net.fs.rudp;

import java.util.ArrayList;
import java.util.HashSet;
import net.fs.rudp.ConnectionUDP;
import net.fs.rudp.RUDPConfig;
import net.fs.rudp.message.AckListMessage;

public class AckListTask {
    ConnectionUDP conn;
    AckListMessage alm;
    int lastRead = 0;
    ArrayList<Integer> ackList;
    HashSet set;

    AckListTask(ConnectionUDP conn) {
        this.conn = conn;
        this.ackList = new ArrayList();
        this.set = new HashSet();
    }

    synchronized void addAck(int sequence) {
        if (!this.set.contains(sequence)) {
            this.ackList.add(sequence);
            this.set.add(sequence);
        }
    }

    synchronized void run() {
        int len;
        int offset = 0;
        int packetLength = RUDPConfig.ackListSum;
        int length = this.ackList.size();
        int sum = length / packetLength;
        if (length % packetLength != 0) {
            ++sum;
        }
        if (sum == 0) {
            sum = 1;
        }
        if (length <= (len = packetLength)) {
            this.conn.sender.sendALMessage(this.ackList);
            this.conn.sender.sendALMessage(this.ackList);
        } else {
            int i = 0;
            while (i < sum) {
                ArrayList<Integer> nl = this.copy(offset, len, this.ackList);
                this.conn.sender.sendALMessage(nl);
                this.conn.sender.sendALMessage(nl);
                if ((offset += packetLength) + len > length) {
                    len = length - (sum - 1) * packetLength;
                }
                ++i;
            }
        }
    }

    ArrayList<Integer> copy(int offset, int length, ArrayList<Integer> ackList) {
        ArrayList<Integer> nl = new ArrayList<Integer>();
        int i = 0;
        while (i < length) {
            nl.add(ackList.get(offset + i));
            ++i;
        }
        return nl;
    }
}

