/*
 * Decompiled with CFR 0.152.
 */
package net.fs.rudp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.fs.cap.CapEnv;
import net.fs.cap.VDatagramSocket;
import net.fs.rudp.AckListManage;
import net.fs.rudp.ClientControl;
import net.fs.rudp.ClientManager;
import net.fs.rudp.ConnectionProcessor;
import net.fs.rudp.ConnectionUDP;
import net.fs.rudp.TrafficEvent;
import net.fs.rudp.Trafficlistener;
import net.fs.rudp.message.MessageType;
import net.fs.utils.ByteIntConvert;
import net.fs.utils.MLog;
import net.fs.utils.MessageCheck;

public class Route {
    private DatagramSocket ds;
    public HashMap<Integer, ConnectionUDP> connTable;
    Route route;
    Thread mainThread;
    Thread reveiveThread;
    public static ThreadPoolExecutor es;
    public AckListManage delayAckManage;
    Object syn_ds2Table = new Object();
    Object syn_tunTable = new Object();
    Random ran = new Random();
    public int localclientId = Math.abs(this.ran.nextInt());
    LinkedBlockingQueue<DatagramPacket> packetBuffer = new LinkedBlockingQueue();
    public static int mode_server;
    public static int mode_client;
    public int mode = mode_client;
    String pocessName = "";
    HashSet<Integer> setedTable = new HashSet();
    static int vv;
    HashSet<Integer> closedTable = new HashSet();
    public static int localDownloadSpeed;
    public static int localUploadSpeed;
    ClientManager clientManager;
    HashSet<Integer> pingTable = new HashSet();
    public CapEnv capEnv = null;
    public ClientControl lastClientControl;
    public boolean useTcpTun = true;
    public HashMap<Object, Object> contentTable = new HashMap();
    private static List<Trafficlistener> listenerList;

    static {
        ThreadPoolExecutor executor;
        mode_server = 2;
        mode_client = 1;
        listenerList = new Vector<Trafficlistener>();
        SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        es = executor = new ThreadPoolExecutor(100, Integer.MAX_VALUE, 10000L, TimeUnit.MILLISECONDS, queue);
    }

    public Route(String pocessName, short routePort, int mode2, boolean tcp, boolean tcpEnvSuccess) throws Exception {
        this.delayAckManage = new AckListManage();
        this.mode = mode2;
        this.useTcpTun = tcp;
        this.pocessName = pocessName;
        if (this.useTcpTun) {
            if (this.mode == 2) {
                VDatagramSocket d = new VDatagramSocket(routePort);
                d.setClient(false);
                this.capEnv = new CapEnv(false, tcpEnvSuccess);
                this.capEnv.setListenPort(routePort);
                this.capEnv.init();
                d.setCapEnv(this.capEnv);
                this.ds = d;
            } else {
                VDatagramSocket d = new VDatagramSocket();
                d.setClient(true);
                this.capEnv = new CapEnv(true, tcpEnvSuccess);
                this.capEnv.init();
                d.setCapEnv(this.capEnv);
                this.ds = d;
            }
        } else if (this.mode == 2) {
            MLog.info("Listen udp port: " + CapEnv.toUnsigned(routePort));
            this.ds = new DatagramSocket(CapEnv.toUnsigned(routePort));
        } else {
            this.ds = new DatagramSocket();
        }
        this.connTable = new HashMap();
        this.clientManager = new ClientManager(this);
        this.reveiveThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    byte[] b = new byte[1500];
                    DatagramPacket dp = new DatagramPacket(b, b.length);
                    try {
                        Route.this.ds.receive(dp);
                        Route.this.packetBuffer.add(dp);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                            continue;
                        }
                    }
                    break;
                }
            }
        };
        this.reveiveThread.start();
        this.mainThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    ConnectionUDP ds3;
                    DatagramPacket dp = null;
                    try {
                        dp = Route.this.packetBuffer.take();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    if (dp == null) continue;
                    long t1 = System.currentTimeMillis();
                    byte[] dpData = dp.getData();
                    int sType = 0;
                    if (dp.getData().length < 4) {
                        return;
                    }
                    sType = MessageCheck.checkSType(dp);
                    if (dp == null) continue;
                    int connectId = ByteIntConvert.toInt(dpData, 4);
                    int remote_clientId = ByteIntConvert.toInt(dpData, 8);
                    if (Route.this.closedTable.contains(connectId) && connectId != 0) continue;
                    if (sType == MessageType.sType_PingMessage || sType == MessageType.sType_PingMessage2) {
                        ClientControl clientControl = null;
                        if (Route.this.mode == 2) {
                            clientControl = Route.this.clientManager.getClientControl(remote_clientId, dp.getAddress(), dp.getPort());
                        } else if (Route.this.mode == 1) {
                            String key = String.valueOf(dp.getAddress().getHostAddress()) + ":" + dp.getPort();
                            int sim_clientId = Math.abs(key.hashCode());
                            clientControl = Route.this.clientManager.getClientControl(sim_clientId, dp.getAddress(), dp.getPort());
                        }
                        clientControl.onReceivePacket(dp);
                        continue;
                    }
                    if (Route.this.mode == 1 && !Route.this.setedTable.contains(remote_clientId)) {
                        String key = String.valueOf(dp.getAddress().getHostAddress()) + ":" + dp.getPort();
                        int sim_clientId = Math.abs(key.hashCode());
                        ClientControl clientControl = Route.this.clientManager.getClientControl(sim_clientId, dp.getAddress(), dp.getPort());
                        if (clientControl.getClientId_real() == -1) {
                            clientControl.setClientId_real(remote_clientId);
                        } else if (clientControl.getClientId_real() != remote_clientId) {
                            clientControl.updateClientId(remote_clientId);
                        }
                        Route.this.setedTable.add(remote_clientId);
                    }
                    if (Route.this.mode == 2) {
                        try {
                            Route.this.getConnection2(dp.getAddress(), dp.getPort(), connectId, remote_clientId);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if ((ds3 = Route.this.connTable.get(connectId)) == null) continue;
                    DatagramPacket dp2 = dp;
                    ds3.receiver.onReceivePacket(dp2);
                    if (sType != MessageType.sType_DataMessage) continue;
                    TrafficEvent event = new TrafficEvent("", Route.this.ran.nextLong(), dp.getLength(), TrafficEvent.type_downloadTraffic);
                    Route.fireEvent(event);
                }
            }
        };
        this.mainThread.start();
    }

    public static void addTrafficlistener(Trafficlistener listener) {
        listenerList.add(listener);
    }

    static void fireEvent(TrafficEvent event) {
        for (Trafficlistener listener : listenerList) {
            int type = event.getType();
            if (type == TrafficEvent.type_downloadTraffic) {
                listener.trafficDownload(event);
                continue;
            }
            if (type != TrafficEvent.type_uploadTraffic) continue;
            listener.trafficUpload(event);
        }
    }

    public void sendPacket(DatagramPacket dp) throws IOException {
        this.ds.send(dp);
    }

    public ConnectionProcessor createTunnelProcessor() {
        ConnectionProcessor o = null;
        try {
            Class<?> onwClass = Class.forName(this.pocessName);
            o = (ConnectionProcessor)onwClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(ConnectionUDP conn) {
        Object object = this.syn_ds2Table;
        synchronized (object) {
            this.closedTable.add(conn.connectId);
            this.connTable.remove(conn.connectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionUDP getConnection2(InetAddress dstIp, int dstPort, int connectId, int clientId) throws Exception {
        ConnectionUDP conn = this.connTable.get(connectId);
        if (conn == null) {
            ClientControl clientControl = this.clientManager.getClientControl(clientId, dstIp, dstPort);
            conn = new ConnectionUDP(this, dstIp, dstPort, 2, connectId, clientControl);
            Object object = this.syn_ds2Table;
            synchronized (object) {
                this.connTable.put(connectId, conn);
            }
            clientControl.addConnection(conn);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionUDP getConnection(String address, int dstPort, String password) throws Exception {
        InetAddress dstIp = InetAddress.getByName(address);
        int connectId = Math.abs(this.ran.nextInt());
        String key = String.valueOf(dstIp.getHostAddress()) + ":" + dstPort;
        int remote_clientId = Math.abs(key.hashCode());
        ClientControl clientControl = this.clientManager.getClientControl(remote_clientId, dstIp, dstPort);
        clientControl.setPassword(password);
        ConnectionUDP conn = new ConnectionUDP(this, dstIp, dstPort, 1, connectId, clientControl);
        Object object = this.syn_ds2Table;
        synchronized (object) {
            this.connTable.put(connectId, conn);
        }
        clientControl.addConnection(conn);
        this.lastClientControl = clientControl;
        return conn;
    }

    public boolean isUseTcpTun() {
        return this.useTcpTun;
    }

    public void setUseTcpTun(boolean useTcpTun) {
        this.useTcpTun = useTcpTun;
    }
}

