/*
 * Decompiled with CFR 0.152.
 */
package net.fs.utils;

import java.util.Vector;
import net.fs.utils.SpeedUnit;

public class NetStatus {
    public long uploadSum;
    public long downloadSum;
    Thread mainThread;
    int averageTime;
    Vector<SpeedUnit> speedList;
    SpeedUnit currentUnit;
    public int upSpeed = 0;
    public int downSpeed = 0;

    public NetStatus() {
        this(2);
    }

    public NetStatus(int averageTime) {
        this.averageTime = averageTime;
        this.speedList = new Vector();
        int i = 0;
        while (i < averageTime) {
            SpeedUnit unit = new SpeedUnit();
            if (i == 0) {
                this.currentUnit = unit;
            }
            this.speedList.add(unit);
            ++i;
        }
        this.mainThread = new Thread(){

            @Override
            public void run() {
                long lastTime = System.currentTimeMillis();
                while (true) {
                    if (Math.abs(System.currentTimeMillis() - lastTime) > 1000L) {
                        lastTime = System.currentTimeMillis();
                        NetStatus.this.calcuSpeed();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        };
        this.mainThread.start();
    }

    public void stop() {
        this.mainThread.interrupt();
    }

    public int getUpSpeed() {
        return this.upSpeed;
    }

    public void setUpSpeed(int upSpeed) {
        this.upSpeed = upSpeed;
    }

    public int getDownSpeed() {
        return this.downSpeed;
    }

    public void setDownSpeed(int downSpeed) {
        this.downSpeed = downSpeed;
    }

    void calcuSpeed() {
        SpeedUnit unit2;
        int ds = 0;
        int us = 0;
        for (SpeedUnit unit2 : this.speedList) {
            ds += unit2.downSum;
            us += unit2.upSum;
        }
        this.upSpeed = (int)((float)us / (float)this.speedList.size());
        this.downSpeed = (int)((float)ds) / this.speedList.size();
        this.speedList.remove(0);
        this.currentUnit = unit2 = new SpeedUnit();
        this.speedList.add(unit2);
    }

    public void addDownload(int sum) {
        this.downloadSum += (long)sum;
        this.currentUnit.addDown(sum);
    }

    public void addUpload(int sum) {
        this.uploadSum += (long)sum;
        this.currentUnit.addUp(sum);
    }

    public void sendAvail() {
    }

    public void receiveAvail() {
    }

    public void setUpLimite(int speed) {
    }

    public void setDownLimite(int speed) {
    }
}

