/*
 * Decompiled with CFR 0.152.
 */
package net.fs.utils;

import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class Tools {
    public static HttpURLConnection getConnection(String urlString) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection conn = null;
        if (urlString.startsWith("http://")) {
            conn = (HttpURLConnection)url.openConnection();
        } else if (urlString.startsWith("https://")) {
            HttpsURLConnection conns = (HttpsURLConnection)url.openConnection();
            conns.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = conns;
        }
        if (conn != null) {
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
        }
        return conn;
    }

    public static String getMD5(String str) {
        byte[] source = str.getBytes();
        return Tools.getMD5(source);
    }

    public static String getMD5(byte[] source) {
        String s = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source);
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            int i = 0;
            while (i < 16) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
                ++i;
            }
            s = new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String getSizeStringKB(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return String.valueOf(new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups))) + " " + units[digitGroups];
    }
}

