/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateDeserializer
implements ObjectDeserializer {
    public static final SqlDateDeserializer instance = new SqlDateDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Object val = parser.parse();
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            val = new java.sql.Date(((Date)val).getTime());
        } else if (val instanceof Number) {
            val = new java.sql.Date(((Number)val).longValue());
        } else {
            if (val instanceof String) {
                String strVal = (String)val;
                if (strVal.length() == 0) {
                    return null;
                }
                long longVal = Long.parseLong(strVal);
                return (T)new java.sql.Date(longVal);
            }
            throw new JSONException("parse error : " + val);
        }
        return (T)val;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

