/*
 * Decompiled with CFR 0.152.
 */
package net.fs.client;

import com.alibaba.fastjson.JSONObject;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import net.fs.client.ClientConfig;
import net.fs.client.ClientUII;
import net.fs.client.MapClient;
import net.fs.rudp.Route;

public class ClientNoUI
implements ClientUII {
    MapClient mapClient;
    ClientConfig config;
    String configFilePath = "client_config.json";

    ClientNoUI() {
        this.loadConfig();
        Route.localDownloadSpeed = this.config.downloadSpeed;
        Route.localUploadSpeed = this.config.uploadSpeed;
    }

    void openUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void setMessage(String message) {
    }

    ClientConfig loadConfig() {
        ClientConfig cfg = new ClientConfig();
        if (!new File(this.configFilePath).exists()) {
            JSONObject json = new JSONObject();
            try {
                this.saveFile(json.toJSONString().getBytes(), this.configFilePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String content = ClientNoUI.readFileUtf8(this.configFilePath);
            JSONObject json = JSONObject.parseObject(content);
            cfg.setServerAddress(json.getString("server_address"));
            cfg.setServerPort(json.getIntValue("server_port"));
            cfg.setRemotePort(json.getIntValue("remote_port"));
            if (json.containsKey("direct_cn")) {
                cfg.setDirect_cn(json.getBooleanValue("direct_cn"));
            }
            cfg.setDownloadSpeed(json.getIntValue("download_speed"));
            cfg.setUploadSpeed(json.getIntValue("upload_speed"));
            if (json.containsKey("socks5_port")) {
                cfg.setSocks5Port(json.getIntValue("socks5_port"));
            }
            this.config = cfg;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cfg;
    }

    public static String readFileUtf8(String path) throws Exception {
        String str = null;
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            try {
                File file = new File(path);
                int length = (int)file.length();
                byte[] data = new byte[length];
                fis = new FileInputStream(file);
                dis = new DataInputStream(fis);
                ((DataInputStream)dis).readFully(data);
                str = new String(data, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return str;
    }

    void saveFile(byte[] data, String path) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(data);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    @Override
    public void updateUISpeed(int conn, int downloadSpeed, int uploadSpeed) {
    }

    JButton createButton(String name) {
        JButton button = new JButton(name);
        button.setMargin(new Insets(0, 5, 0, 5));
        button.setFocusPainted(false);
        return button;
    }

    void initUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Font font = new Font("\u5b8b\u4f53", 0, 12);
                UIManager.put("ToolTip.font", font);
                UIManager.put("Table.font", font);
                UIManager.put("TableHeader.font", font);
                UIManager.put("TextField.font", font);
                UIManager.put("ComboBox.font", font);
                UIManager.put("TextField.font", font);
                UIManager.put("PasswordField.font", font);
                UIManager.put("TextArea.font,font", font);
                UIManager.put("TextPane.font", font);
                UIManager.put("EditorPane.font", font);
                UIManager.put("FormattedTextField.font", font);
                UIManager.put("Button.font", font);
                UIManager.put("CheckBox.font", font);
                UIManager.put("RadioButton.font", font);
                UIManager.put("ToggleButton.font", font);
                UIManager.put("ProgressBar.font", font);
                UIManager.put("DesktopIcon.font", font);
                UIManager.put("TitledBorder.font", font);
                UIManager.put("Label.font", font);
                UIManager.put("List.font", font);
                UIManager.put("TabbedPane.font", font);
                UIManager.put("MenuBar.font", font);
                UIManager.put("Menu.font", font);
                UIManager.put("MenuItem.font", font);
                UIManager.put("PopupMenu.font", font);
                UIManager.put("CheckBoxMenuItem.font", font);
                UIManager.put("RadioButtonMenuItem.font", font);
                UIManager.put("Spinner.font", font);
                UIManager.put("Tree.font", font);
                UIManager.put("ToolBar.font", font);
                UIManager.put("OptionPane.messageFont", font);
                UIManager.put("OptionPane.buttonFont", font);
                ToolTipManager.sharedInstance().setInitialDelay(200);
            }
        });
    }

    @Override
    public boolean login() {
        return false;
    }

    @Override
    public boolean updateNode(boolean testSpeed) {
        return false;
    }

    @Override
    public boolean isOsx_fw_pf() {
        return false;
    }

    @Override
    public boolean isOsx_fw_ipfw() {
        return false;
    }
}

