/*
 * Decompiled with CFR 0.152.
 */
package net.fs.client;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.fs.client.MapRule;

public class MapRuleListModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2267856423317178816L;
    private List<MapRule> mapRuleList;
    String[] titles;
    Class<?>[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};

    MapRuleListModel() {
        this.mapRuleList = new ArrayList<MapRule>();
        this.titles = new String[]{""};
    }

    public void setMapRuleList(List<MapRule> list) {
        this.mapRuleList.clear();
        if (list != null) {
            this.mapRuleList.addAll(list);
        }
        this.fireTableDataChanged();
    }

    public int getMapRuleIndex(String name) {
        int index = -1;
        int i = 0;
        for (MapRule r : this.mapRuleList) {
            if (name.equals(r.getName())) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    List<MapRule> getMapRuleList() {
        return this.mapRuleList;
    }

    public MapRule getMapRuleAt(int row) {
        if (row > -1 & row < this.mapRuleList.size()) {
            return this.mapRuleList.get(row);
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MapRule node = this.mapRuleList.get(rowIndex);
        return node;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public int getRowCount() {
        return this.mapRuleList.size();
    }

    @Override
    public int getColumnCount() {
        return this.titles.length;
    }

    @Override
    public String getColumnName(int c) {
        return this.titles[c];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.types[c];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean b = false;
        if (col == 0) {
            b = true;
        }
        return false;
    }
}

