/*
 * Decompiled with CFR 0.152.
 */
package net.fs.rudp;

import java.util.concurrent.LinkedBlockingQueue;
import net.fs.rudp.ConnectionUDP;
import net.fs.rudp.RUDPConfig;
import net.fs.rudp.ResendItem;
import net.fs.rudp.Route;

public class ResendManage
implements Runnable {
    boolean haveTask = false;
    Object signalOb = new Object();
    Thread mainThread;
    long vTime = 0L;
    long lastReSendTime;
    LinkedBlockingQueue<ResendItem> taskList = new LinkedBlockingQueue();

    public ResendManage() {
        Route.es.execute(this);
    }

    public void addTask(ConnectionUDP conn, int sequence) {
        ResendItem ri = new ResendItem(conn, sequence);
        ri.setResendTime(this.getNewResendTime(conn));
        this.taskList.add(ri);
    }

    long getNewResendTime(ConnectionUDP conn) {
        int delayAdd = conn.clientControl.pingDelay + (int)((float)conn.clientControl.pingDelay * RUDPConfig.reSendDelay);
        if (delayAdd < RUDPConfig.reSendDelay_min) {
            delayAdd = RUDPConfig.reSendDelay_min;
        }
        long time = System.currentTimeMillis() + (long)delayAdd;
        return time;
    }

    @Override
    public void run() {
        while (true) {
            try {
                ResendItem ri;
                do {
                    ri = this.taskList.take();
                    if (!ri.conn.isConnected()) continue;
                    long sleepTime = ri.getResendTime() - System.currentTimeMillis();
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    ri.addCount();
                    if (ri.conn.sender.getDataMessage(ri.sequence) != null && !ri.conn.stopnow) {
                        ri.conn.sender.reSend(ri.sequence, ri.getCount());
                    }
                    if (ri.getCount() >= RUDPConfig.reSendTryTimes) continue;
                    ri.setResendTime(this.getNewResendTime(ri.conn));
                    this.taskList.add(ri);
                } while (!ri.conn.clientControl.closed);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

