/*
 * Decompiled with CFR 0.152.
 */
package net.fs.rudp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.fs.rudp.ConnectException;
import net.fs.rudp.ConnectionUDP;
import net.fs.rudp.RUDPConfig;
import net.fs.rudp.Receiver;
import net.fs.rudp.Route;
import net.fs.rudp.SendRecord;
import net.fs.rudp.TrafficEvent;
import net.fs.rudp.UDPOutputStream;
import net.fs.rudp.message.AckListMessage;
import net.fs.rudp.message.CloseMessage_Conn;
import net.fs.rudp.message.CloseMessage_Stream;
import net.fs.rudp.message.DataMessage;

public class Sender {
    DataMessage me2 = null;
    int interval;
    public int sum = 0;
    int sleepTime = 100;
    ConnectionUDP conn;
    Receiver receiver = null;
    boolean bussy = false;
    Object bussyOb = new Object();
    boolean isHave = false;
    public HashMap<Integer, DataMessage> sendTable = new HashMap();
    boolean isReady = false;
    Object readyOb = new Object();
    Object winOb = new Object();
    public InetAddress dstIp;
    public int dstPort;
    public int sequence = 0;
    int sendOffset = -1;
    boolean pause = false;
    int unAckMin = 0;
    int unAckMax = -1;
    int sendSum = 0;
    int reSendSum = 0;
    UDPOutputStream uos;
    int sw = 0;
    static Random ran = new Random();
    long lastSendTime = -1L;
    boolean closed = false;
    boolean streamClosed = false;
    static int s = 0;
    Object syn_send_table = new Object();
    HashMap<Integer, DataMessage> unAckTable = new HashMap();

    Sender(ConnectionUDP conn) {
        this.conn = conn;
        this.uos = new UDPOutputStream(conn);
        this.receiver = conn.receiver;
        this.dstIp = conn.dstIp;
        this.dstPort = conn.dstPort;
    }

    void sendData(byte[] data, int offset, int length) throws ConnectException, InterruptedException {
        int len;
        int packetLength = RUDPConfig.packageSize;
        int sum = length / packetLength;
        if (length % packetLength != 0) {
            ++sum;
        }
        if (sum == 0) {
            sum = 1;
        }
        if (length <= (len = packetLength)) {
            ++this.sw;
            this.sendNata(data, 0, length);
            --this.sw;
        } else {
            int i = 0;
            while (i < sum) {
                byte[] b = new byte[len];
                System.arraycopy(data, offset, b, 0, len);
                this.sendNata(b, 0, b.length);
                if ((offset += packetLength) + len > length) {
                    len = length - (sum - 1) * packetLength;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void sendNata(byte[] data, int offset, int length) throws ConnectException, InterruptedException {
        if (this.closed) throw new ConnectException("RDP\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed");
        if (this.streamClosed) throw new ConnectException("RDP\u8fde\u63a5\u5df2\u65ad\u5f00sendData");
        DataMessage me = new DataMessage(this.sequence, data, 0, (short)length, this.conn.connectId, this.conn.route.localclientId);
        me.setDstAddress(this.dstIp);
        me.setDstPort(this.dstPort);
        Object object = this.syn_send_table;
        synchronized (object) {
            this.sendTable.put(me.getSequence(), me);
        }
        object = this.winOb;
        synchronized (object) {
            if (!this.conn.receiver.checkWin()) {
                this.winOb.wait();
            }
        }
        boolean twice = false;
        if (RUDPConfig.twice_tcp) {
            twice = true;
        }
        if (RUDPConfig.double_send_start && me.getSequence() <= 5) {
            twice = true;
        }
        this.sendDataMessage(me, false, twice, true);
        this.lastSendTime = System.currentTimeMillis();
        ++this.sendOffset;
        s += me.getData().length;
        this.conn.clientControl.resendMange.addTask(this.conn, this.sequence);
        ++this.sequence;
    }

    public void closeStream_Local() {
        if (!this.streamClosed) {
            this.streamClosed = true;
            this.conn.receiver.closeStream_Local();
            if (!this.conn.stopnow) {
                this.sendCloseMessage_Stream();
            }
        }
    }

    public void closeStream_Remote() {
        if (!this.streamClosed) {
            this.streamClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDataMessage(DataMessage me, boolean resend, boolean twice, boolean block) {
        Object object = this.conn.clientControl.getSynlock();
        synchronized (object) {
            long startTime = System.nanoTime();
            long t1 = System.currentTimeMillis();
            this.conn.clientControl.onSendDataPacket(this.conn);
            int timeId = this.conn.clientControl.getCurrentTimeId();
            me.create(timeId);
            SendRecord record_current = this.conn.clientControl.getSendRecord(timeId);
            if (!resend) {
                me.setFirstSendTimeId(timeId);
                me.setFirstSendTime(System.currentTimeMillis());
                record_current.addSended_First(me.getData().length);
                record_current.addSended(me.getData().length);
            } else {
                SendRecord record = this.conn.clientControl.getSendRecord(me.getFirstSendTimeId());
                record.addResended(me.getData().length);
                record_current.addSended(me.getData().length);
            }
            try {
                ++this.sendSum;
                ++this.sum;
                ++this.unAckMax;
                long t = System.currentTimeMillis();
                this.send(me.getDatagramPacket());
                if (twice) {
                    this.send(me.getDatagramPacket());
                }
                if (block) {
                    this.conn.clientControl.sendSleep(startTime, me.getData().length);
                }
                TrafficEvent event = new TrafficEvent("", ran.nextLong(), me.getData().length, TrafficEvent.type_uploadTraffic);
                Route.fireEvent(event);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void sendAckDelay(int ackSequence) {
        this.conn.route.delayAckManage.addAck(this.conn, ackSequence);
    }

    void sendLastReadDelay() {
        this.conn.route.delayAckManage.addLastRead(this.conn);
    }

    DataMessage getDataMessage(int sequence) {
        return this.sendTable.get(sequence);
    }

    public void reSend(int sequence, int count) {
        DataMessage dm;
        if (this.sendTable.containsKey(sequence) && (dm = this.sendTable.get(sequence)) != null) {
            this.sendDataMessage(dm, true, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.syn_send_table;
        synchronized (object) {
            this.sendTable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSended_Ack(int sequence) {
        Object object = this.syn_send_table;
        synchronized (object) {
            DataMessage dataMessage = this.sendTable.remove(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void play() {
        Object object = this.winOb;
        synchronized (object) {
            this.winOb.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.winOb;
        synchronized (object) {
            this.closed = true;
            this.winOb.notifyAll();
        }
    }

    void sendCloseMessage_Stream() {
        CloseMessage_Stream cm = new CloseMessage_Stream(this.conn.connectId, this.conn.route.localclientId, this.sequence);
        cm.setDstAddress(this.dstIp);
        cm.setDstPort(this.dstPort);
        try {
            this.send(cm.getDatagramPacket());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.send(cm.getDatagramPacket());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void sendCloseMessage_Conn() {
        CloseMessage_Conn cm = new CloseMessage_Conn(this.conn.connectId, this.conn.route.localclientId);
        cm.setDstAddress(this.dstIp);
        cm.setDstPort(this.dstPort);
        try {
            this.send(cm.getDatagramPacket());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.send(cm.getDatagramPacket());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void sendALMessage(ArrayList ackList) {
        int currentTimeId = this.conn.receiver.getCurrentTimeId();
        AckListMessage alm = new AckListMessage(this.conn.connetionId, ackList, this.conn.receiver.lastRead, this.conn.clientControl.sendRecordTable_remote, currentTimeId, this.conn.connectId, this.conn.route.localclientId);
        alm.setDstAddress(this.dstIp);
        alm.setDstPort(this.dstPort);
        try {
            this.send(alm.getDatagramPacket());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void send(DatagramPacket dp) throws IOException {
        this.sendPacket(dp, this.conn.connectId);
    }

    public void sendPacket(DatagramPacket dp, Integer di) throws IOException {
        this.conn.clientControl.sendPacket(dp);
    }
}

