/*
 * Decompiled with CFR 0.152.
 */
package net.fs.server;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import net.fs.rudp.ConnectionProcessor;
import net.fs.rudp.Route;
import net.fs.server.MapTunnelProcessor;
import net.fs.utils.MLog;

public class FSServer {
    ConnectionProcessor imTunnelProcessor;
    Route route_udp;
    Route route_tcp;
    Route route;
    int routePort = 150;
    static FSServer udpServer;
    String systemName = System.getProperty("os.name").toLowerCase();
    boolean success_firewall_windows = true;

    public static void main(String[] args) {
        try {
            FSServer fSServer = new FSServer();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BindException) {
                MLog.println("Udp port already in use.");
            }
            MLog.println("Start failed.");
            System.exit(0);
        }
    }

    static FSServer get() {
        return udpServer;
    }

    public FSServer() throws Exception {
        MLog.info("");
        MLog.info("FinalSpeed server starting... ");
        MLog.info("System Name: " + this.systemName);
        udpServer = this;
        final MapTunnelProcessor mp = new MapTunnelProcessor();
        String port_s = this.readFileData("./cnf/listen_port");
        if (port_s != null && !port_s.trim().equals("")) {
            port_s = port_s.replaceAll("\n", "").replaceAll("\r", "");
            this.routePort = Integer.parseInt(port_s);
        }
        this.route_udp = new Route(mp.getClass().getName(), (short)this.routePort, Route.mode_server, false, true);
        if (this.systemName.equals("linux")) {
            this.startFirewall_linux();
            this.setFireWall_linux_udp();
        } else if (this.systemName.contains("windows")) {
            this.startFirewall_windows();
        }
        Route.es.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FSServer.this.route_tcp = new Route(mp.getClass().getName(), (short)FSServer.this.routePort, Route.mode_server, true, true);
                    if (FSServer.this.systemName.equals("linux")) {
                        FSServer.this.setFireWall_linux_tcp();
                    } else if (FSServer.this.systemName.contains("windows")) {
                        if (FSServer.this.success_firewall_windows) {
                            FSServer.this.setFireWall_windows_tcp();
                        } else {
                            System.out.println("\u542f\u52a8windows\u9632\u706b\u5899\u5931\u8d25,\u8bf7\u5148\u8fd0\u884c\u9632\u706b\u5899\u670d\u52a1.");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    void startFirewall_windows() {
        String runFirewall = "netsh advfirewall set allprofiles state on";
        Thread standReadThread = null;
        Thread errorReadThread = null;
        try {
            final Process p = Runtime.getRuntime().exec(runFirewall, null);
            standReadThread = new Thread(){

                @Override
                public void run() {
                    InputStream is = p.getInputStream();
                    BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
                    try {
                        String line;
                        while ((line = localBufferedReader.readLine()) != null) {
                            if (!line.contains("Windows")) continue;
                            FSServer.this.success_firewall_windows = false;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            standReadThread.start();
            errorReadThread = new Thread(){

                @Override
                public void run() {
                    InputStream is = p.getErrorStream();
                    BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
                    try {
                        String line;
                        while ((line = localBufferedReader.readLine()) != null) {
                            System.out.println("error" + line);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            errorReadThread.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.success_firewall_windows = false;
        }
        if (standReadThread != null) {
            try {
                standReadThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (errorReadThread != null) {
            try {
                errorReadThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    void setFireWall_windows_tcp() {
        this.cleanRule_windows();
        try {
            if (this.systemName.contains("xp") || this.systemName.contains("2003")) {
                String cmd_add1 = "ipseccmd -w REG -p \"tcptun_fs_server\" -r \"Block TCP/" + this.routePort + "\" -f *+0:" + this.routePort + ":TCP " + " -n BLOCK -x ";
                Process p2 = Runtime.getRuntime().exec(cmd_add1, null);
                p2.waitFor();
            } else {
                String cmd_add1 = "netsh advfirewall firewall add rule name=tcptun_fs_server protocol=TCP dir=out localport=" + this.routePort + " action=block ";
                Process p2 = Runtime.getRuntime().exec(cmd_add1, null);
                p2.waitFor();
                String cmd_add2 = "netsh advfirewall firewall add rule name=tcptun_fs_server protocol=TCP dir=in localport=" + this.routePort + " action=block ";
                Process p3 = Runtime.getRuntime().exec(cmd_add2, null);
                p3.waitFor();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    void cleanRule_windows() {
        try {
            if (this.systemName.contains("xp") || this.systemName.contains("2003")) {
                String cmd_delete = "ipseccmd -p \"tcptun_fs_server\" -w reg -y";
                Process p1 = Runtime.getRuntime().exec(cmd_delete, null);
                p1.waitFor();
            } else {
                String cmd_delete = "netsh advfirewall firewall delete rule name=tcptun_fs_server ";
                Process p1 = Runtime.getRuntime().exec(cmd_delete, null);
                p1.waitFor();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void startFirewall_linux() {
        String cmd1 = "service iptables start";
        this.runCommand(cmd1);
    }

    void setFireWall_linux_udp() {
        this.cleanUdpTunRule();
        String cmd2 = "iptables -I INPUT -p udp --dport " + this.routePort + " -j ACCEPT" + " -m comment --comment udptun_fs_server";
        this.runCommand(cmd2);
    }

    void cleanUdpTunRule() {
        int row;
        while ((row = this.getRow("udptun_fs_server")) > 0) {
            String cmd = "iptables -D INPUT " + row;
            this.runCommand(cmd);
        }
    }

    void setFireWall_linux_tcp() {
        this.cleanTcpTunRule();
        String cmd2 = "iptables -I INPUT -p tcp --dport " + this.routePort + " -j DROP" + " -m comment --comment tcptun_fs_server ";
        this.runCommand(cmd2);
    }

    void cleanTcpTunRule() {
        int row;
        while ((row = this.getRow("tcptun_fs_server")) > 0) {
            String cmd = "iptables -D INPUT " + row;
            this.runCommand(cmd);
        }
    }

    int getRow(String name) {
        int row_delect = -1;
        String cme_list_rule = "iptables -L -n --line-number";
        Thread errorReadThread = null;
        try {
            final Process p = Runtime.getRuntime().exec(cme_list_rule, null);
            errorReadThread = new Thread(){

                @Override
                public void run() {
                    InputStream is = p.getErrorStream();
                    BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
                    try {
                        String line;
                        while ((line = localBufferedReader.readLine()) != null) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            errorReadThread.start();
            InputStream is = p.getInputStream();
            BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
            try {
                String line;
                while ((line = localBufferedReader.readLine()) != null) {
                    int index;
                    if (!line.contains(name) || (index = line.indexOf("   ")) <= 0) continue;
                    String n = line.substring(0, index);
                    try {
                        if (row_delect >= 0) continue;
                        row_delect = Integer.parseInt(n);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            errorReadThread.join();
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row_delect;
    }

    void runCommand(String command) {
        Thread standReadThread = null;
        Thread errorReadThread = null;
        try {
            final Process p = Runtime.getRuntime().exec(command, null);
            standReadThread = new Thread(){

                @Override
                public void run() {
                    InputStream is = p.getInputStream();
                    BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
                    try {
                        String line;
                        while ((line = localBufferedReader.readLine()) != null) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            standReadThread.start();
            errorReadThread = new Thread(){

                @Override
                public void run() {
                    InputStream is = p.getErrorStream();
                    BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
                    try {
                        String line;
                        while ((line = localBufferedReader.readLine()) != null) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            errorReadThread.start();
            standReadThread.join();
            errorReadThread.join();
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String readFileData(String path) {
        String content;
        block12: {
            content = null;
            FileInputStream fis = null;
            FilterInputStream dis = null;
            try {
                try {
                    File file = new File(path);
                    fis = new FileInputStream(file);
                    dis = new DataInputStream(fis);
                    byte[] data = new byte[(int)file.length()];
                    ((DataInputStream)dis).readFully(data);
                    content = new String(data, "utf-8");
                }
                catch (Exception exception) {
                    if (dis == null) break block12;
                    try {
                        dis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return content;
    }

    public int getRoutePort() {
        return this.routePort;
    }
}

