/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.EOFException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.PcapStat;
import org.pcap4j.core.RawPacketListener;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.util.ByteArrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcapHandle {
    private static final Logger logger = LoggerFactory.getLogger(PcapHandle.class);
    private volatile DataLinkType dlt;
    private final TimestampPrecision timestampPrecision;
    private final Pointer handle;
    private final ThreadLocal<Timestamp> timestamps = new ThreadLocal();
    private final ReentrantReadWriteLock handleLock = new ReentrantReadWriteLock(true);
    private static final Object compileLock = new Object();
    private volatile boolean open = true;
    private volatile String filteringExpression = "";
    private static final Inet4Address WILDCARD_MASK;

    PcapHandle(Pointer handle, TimestampPrecision timestampPrecision) {
        this.handle = handle;
        this.dlt = this.getDltByNative();
        this.timestampPrecision = timestampPrecision;
    }

    private PcapHandle(Builder builder) throws PcapNativeException {
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        this.handle = NativeMappings.pcap_create(builder.deviceName, errbuf);
        if (this.handle == null || errbuf.length() != 0) {
            throw new PcapNativeException(errbuf.toString());
        }
        try {
            int rc;
            if (builder.isSnaplenSet && (rc = NativeMappings.pcap_set_snaplen(this.handle, builder.snaplen)) != 0) {
                throw new PcapNativeException(this.getError(), rc);
            }
            if (builder.promiscuousMode != null && (rc = NativeMappings.pcap_set_promisc(this.handle, builder.promiscuousMode.getValue())) != 0) {
                throw new PcapNativeException(this.getError(), rc);
            }
            if (builder.isRfmonSet) {
                try {
                    rc = NativeMappings.PcapLibrary.INSTANCE.pcap_set_rfmon(this.handle, builder.rfmon ? 1 : 0);
                    if (rc != 0) {
                        throw new PcapNativeException(this.getError(), rc);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    logger.error("Failed to instantiate PcapHandle object.", e);
                    throw new PcapNativeException("Monitor mode is not supported on this platform.");
                }
            }
            if (builder.isTimeoutMillisSet && (rc = NativeMappings.pcap_set_timeout(this.handle, builder.timeoutMillis)) != 0) {
                throw new PcapNativeException(this.getError(), rc);
            }
            if (builder.isBufferSizeSet && (rc = NativeMappings.pcap_set_buffer_size(this.handle, builder.bufferSize)) != 0) {
                throw new PcapNativeException(this.getError(), rc);
            }
            if (builder.timestampPrecision != null) {
                try {
                    rc = NativeMappings.PcapLibrary.INSTANCE.pcap_set_tstamp_precision(this.handle, builder.timestampPrecision.getValue());
                    if (rc == 0) {
                        this.timestampPrecision = builder.timestampPrecision;
                    }
                    StringBuilder sb = new StringBuilder(100).append("The specified timestamp precision ").append((Object)builder.timestampPrecision).append(" is not supported on this platform. ").append((Object)TimestampPrecision.MICRO).append(" is set instead.");
                    logger.error(sb.toString());
                    this.timestampPrecision = TimestampPrecision.MICRO;
                }
                catch (UnsatisfiedLinkError e) {
                    throw new PcapNativeException("pcap_set_tstamp_precision is not supported by the pcap library installed in this environment.");
                }
            } else {
                this.timestampPrecision = TimestampPrecision.MICRO;
            }
            rc = NativeMappings.pcap_activate(this.handle);
            if (rc < 0) {
                throw new PcapNativeException(this.getError(), rc);
            }
        }
        catch (NotOpenException e) {
            throw new AssertionError((Object)"Never get here.");
        }
        this.dlt = this.getDltByNative();
    }

    private DataLinkType getDltByNative() {
        return DataLinkType.getInstance(NativeMappings.pcap_datalink(this.handle));
    }

    public DataLinkType getDlt() {
        return this.dlt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDlt(DataLinkType dlt) throws PcapNativeException, NotOpenException {
        if (dlt == null) {
            throw new NullPointerException("dlt must not be null.");
        }
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            int rc = NativeMappings.pcap_set_datalink(this.handle, (Integer)dlt.value());
            if (rc < 0) {
                throw new PcapNativeException(this.getError(), rc);
            }
        }
        finally {
            this.handleLock.readLock().unlock();
        }
        this.dlt = dlt;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getFilteringExpression() {
        return this.filteringExpression;
    }

    public TimestampPrecision getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public Timestamp getTimestamp() {
        return this.timestamps.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSnapshot() throws NotOpenException {
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            int n = NativeMappings.pcap_snapshot(this.handle);
            return n;
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwappedType isSwapped() throws NotOpenException {
        int rc;
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_is_swapped(this.handle);
        }
        finally {
            this.handleLock.readLock().unlock();
        }
        switch (rc) {
            case 0: {
                return SwappedType.NOT_SWAPPED;
            }
            case 1: {
                return SwappedType.SWAPPED;
            }
            case 2: {
                return SwappedType.MAYBE_SWAPPED;
            }
        }
        logger.warn("pcap_snapshot returned an unexpected code: " + rc);
        return SwappedType.MAYBE_SWAPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMajorVersion() throws NotOpenException {
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            int n = NativeMappings.pcap_major_version(this.handle);
            return n;
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinorVersion() throws NotOpenException {
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            int n = NativeMappings.pcap_minor_version(this.handle);
            return n;
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpfProgram compileFilter(String bpfExpression, BpfProgram.BpfCompileMode mode, Inet4Address netmask) throws PcapNativeException, NotOpenException {
        NativeMappings.bpf_program prog;
        if (bpfExpression == null || mode == null || netmask == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("bpfExpression: ").append(bpfExpression).append(" mode: ").append((Object)mode).append(" netmask: ").append(netmask);
            throw new NullPointerException(sb.toString());
        }
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            int rc;
            if (!this.open) {
                throw new NotOpenException();
            }
            prog = new NativeMappings.bpf_program();
            Object object = compileLock;
            synchronized (object) {
                rc = NativeMappings.pcap_compile(this.handle, prog, bpfExpression, mode.getValue(), ByteArrays.getInt(ByteArrays.toByteArray(netmask), 0));
            }
            if (rc < 0) {
                throw new PcapNativeException(this.getError(), rc);
            }
        }
        finally {
            this.handleLock.readLock().unlock();
        }
        return new BpfProgram(prog, bpfExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(String bpfExpression, BpfProgram.BpfCompileMode mode, Inet4Address netmask) throws PcapNativeException, NotOpenException {
        if (bpfExpression == null || mode == null || netmask == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("bpfExpression: ").append(bpfExpression).append(" mode: ").append((Object)mode).append(" netmask: ").append(netmask);
            throw new NullPointerException(sb.toString());
        }
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            NativeMappings.bpf_program prog = new NativeMappings.bpf_program();
            try {
                int rc;
                int mask = ByteArrays.getInt(ByteArrays.toByteArray(netmask), 0);
                Object object = compileLock;
                synchronized (object) {
                    rc = NativeMappings.pcap_compile(this.handle, prog, bpfExpression, mode.getValue(), mask);
                }
                if (rc < 0) {
                    throw new PcapNativeException("Error occured in pcap_compile: " + this.getError(), rc);
                }
                rc = NativeMappings.pcap_setfilter(this.handle, prog);
                if (rc < 0) {
                    throw new PcapNativeException("Error occured in pcap_setfilger: " + this.getError(), rc);
                }
                this.filteringExpression = bpfExpression;
            }
            finally {
                NativeMappings.pcap_freecode(prog);
            }
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    public void setFilter(String bpfExpression, BpfProgram.BpfCompileMode mode) throws PcapNativeException, NotOpenException {
        this.setFilter(bpfExpression, mode, WILDCARD_MASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(BpfProgram prog) throws PcapNativeException, NotOpenException {
        if (prog == null) {
            throw new NullPointerException("prog is null.");
        }
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            int rc = NativeMappings.pcap_setfilter(this.handle, prog.getProgram());
            if (rc < 0) {
                throw new PcapNativeException("Failed to set filter: " + this.getError(), rc);
            }
        }
        finally {
            this.handleLock.readLock().unlock();
        }
        this.filteringExpression = prog.getExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockingMode(BlockingMode mode) throws PcapNativeException, NotOpenException {
        if (mode == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(" mode: ").append((Object)mode);
            throw new NullPointerException(sb.toString());
        }
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
            int rc = NativeMappings.pcap_setnonblock(this.handle, mode.getValue(), errbuf);
            if (rc < 0) {
                throw new PcapNativeException(errbuf.toString(), rc);
            }
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockingMode getBlockingMode() throws PcapNativeException, NotOpenException {
        int rc;
        if (!this.open) {
            throw new NotOpenException();
        }
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_getnonblock(this.handle, errbuf);
        }
        finally {
            this.handleLock.readLock().unlock();
        }
        if (rc == 0) {
            return BlockingMode.BLOCKING;
        }
        if (rc > 0) {
            return BlockingMode.NONBLOCKING;
        }
        throw new PcapNativeException(errbuf.toString(), rc);
    }

    public Packet getNextPacket() throws NotOpenException {
        byte[] ba = this.getNextRawPacket();
        if (ba == null) {
            return null;
        }
        return PacketFactories.getFactory(Packet.class, DataLinkType.class).newInstance(ba, 0, ba.length, this.dlt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getNextRawPacket() throws NotOpenException {
        Pointer packet;
        if (!this.open) {
            throw new NotOpenException();
        }
        NativeMappings.pcap_pkthdr header = new NativeMappings.pcap_pkthdr();
        header.setAutoSynch(false);
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            packet = NativeMappings.pcap_next(this.handle, header);
        }
        finally {
            this.handleLock.readLock().unlock();
        }
        if (packet != null) {
            Pointer headerP = header.getPointer();
            this.timestamps.set(this.buildTimestamp(headerP));
            return packet.getByteArray(0L, NativeMappings.pcap_pkthdr.getCaplen(headerP));
        }
        return null;
    }

    public Packet getNextPacketEx() throws PcapNativeException, EOFException, TimeoutException, NotOpenException {
        byte[] ba = this.getNextRawPacketEx();
        return PacketFactories.getFactory(Packet.class, DataLinkType.class).newInstance(ba, 0, ba.length, this.dlt);
    }

    public byte[] getNextRawPacketEx() throws PcapNativeException, EOFException, TimeoutException, NotOpenException {
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            PointerByReference headerPP = new PointerByReference();
            PointerByReference dataPP = new PointerByReference();
            int rc = NativeMappings.pcap_next_ex(this.handle, headerPP, dataPP);
            switch (rc) {
                case 0: {
                    throw new TimeoutException();
                }
                case 1: {
                    Pointer headerP = headerPP.getValue();
                    Pointer dataP = dataPP.getValue();
                    if (headerP == null || dataP == null) {
                        throw new PcapNativeException("Failed to get packet. *header: " + headerP + " *data: " + dataP);
                    }
                    this.timestamps.set(this.buildTimestamp(headerP));
                    byte[] byArray = dataP.getByteArray(0L, NativeMappings.pcap_pkthdr.getCaplen(headerP));
                    return byArray;
                }
                case -1: {
                    throw new PcapNativeException("Error occured in pcap_next_ex(): " + this.getError(), rc);
                }
                case -2: {
                    throw new EOFException();
                }
            }
            throw new PcapNativeException("Unexpected error occured: " + this.getError(), rc);
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    public void loop(int packetCount, PacketListener listener) throws PcapNativeException, InterruptedException, NotOpenException {
        this.loop(packetCount, listener, (Executor)SimpleExecutor.getInstance());
    }

    public void loop(int packetCount, PacketListener listener, Executor executor) throws PcapNativeException, InterruptedException, NotOpenException {
        if (listener == null || executor == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("listener: ").append(listener).append(" executor: ").append(executor);
            throw new NullPointerException(sb.toString());
        }
        this.doLoop(packetCount, new GotPacketFuncExecutor(listener, this.dlt, executor));
    }

    public void loop(int packetCount, RawPacketListener listener) throws PcapNativeException, InterruptedException, NotOpenException {
        this.loop(packetCount, listener, (Executor)SimpleExecutor.getInstance());
    }

    public void loop(int packetCount, RawPacketListener listener, Executor executor) throws PcapNativeException, InterruptedException, NotOpenException {
        if (listener == null || executor == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("listener: ").append(listener).append(" executor: ").append(executor);
            throw new NullPointerException(sb.toString());
        }
        this.doLoop(packetCount, new GotRawPacketFuncExecutor(listener, executor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doLoop(int packetCount, NativeMappings.pcap_handler handler) throws PcapNativeException, InterruptedException, NotOpenException {
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            logger.info("Starting loop.");
            int rc = NativeMappings.pcap_loop(this.handle, packetCount, handler, null);
            switch (rc) {
                case 0: {
                    logger.info("Finished loop.");
                    return;
                }
                case -1: {
                    throw new PcapNativeException("Error occured: " + this.getError(), rc);
                }
                case -2: {
                    logger.info("Broken.");
                    throw new InterruptedException();
                }
                default: {
                    throw new PcapNativeException("Unexpected error occured: " + this.getError(), rc);
                }
            }
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    public int dispatch(int packetCount, PacketListener listener) throws PcapNativeException, InterruptedException, NotOpenException {
        return this.dispatch(packetCount, listener, (Executor)SimpleExecutor.getInstance());
    }

    public int dispatch(int packetCount, PacketListener listener, Executor executor) throws PcapNativeException, InterruptedException, NotOpenException {
        if (listener == null || executor == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("listener: ").append(listener).append(" executor: ").append(executor);
            throw new NullPointerException(sb.toString());
        }
        return this.doDispatch(packetCount, new GotPacketFuncExecutor(listener, this.dlt, executor));
    }

    public int dispatch(int packetCount, RawPacketListener listener) throws PcapNativeException, InterruptedException, NotOpenException {
        return this.dispatch(packetCount, listener, (Executor)SimpleExecutor.getInstance());
    }

    public int dispatch(int packetCount, RawPacketListener listener, Executor executor) throws PcapNativeException, InterruptedException, NotOpenException {
        if (listener == null || executor == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("listener: ").append(listener).append(" executor: ").append(executor);
            throw new NullPointerException(sb.toString());
        }
        return this.doDispatch(packetCount, new GotRawPacketFuncExecutor(listener, executor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doDispatch(int packetCount, NativeMappings.pcap_handler handler) throws PcapNativeException, InterruptedException, NotOpenException {
        int rc;
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            logger.info("Starting dispatch.");
            rc = NativeMappings.pcap_dispatch(this.handle, packetCount, handler, null);
            if (rc < 0) {
                switch (rc) {
                    case -1: {
                        throw new PcapNativeException("Error occured: " + this.getError(), rc);
                    }
                    case -2: {
                        logger.info("Broken.");
                        throw new InterruptedException();
                    }
                }
                throw new PcapNativeException("Unexpected error occured: " + this.getError(), rc);
            }
        }
        finally {
            this.handleLock.readLock().unlock();
        }
        logger.info("Finish dispatch.");
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PcapDumper dumpOpen(String filePath) throws PcapNativeException, NotOpenException {
        Pointer dumper;
        if (filePath == null) {
            throw new NullPointerException("filePath must not be null.");
        }
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            dumper = NativeMappings.pcap_dump_open(this.handle, filePath);
            if (dumper == null) {
                throw new PcapNativeException(this.getError());
            }
        }
        finally {
            this.handleLock.readLock().unlock();
        }
        return new PcapDumper(dumper, this.timestampPrecision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loop(int packetCount, PcapDumper dumper) throws PcapNativeException, InterruptedException, NotOpenException {
        if (dumper == null) {
            throw new NullPointerException("dumper must not be null.");
        }
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            logger.info("Starting dump loop.");
            int rc = NativeMappings.pcap_loop(this.handle, packetCount, NativeMappings.PCAP_DUMP, dumper.getDumper());
            switch (rc) {
                case 0: {
                    logger.info("Finished dump loop.");
                    return;
                }
                case -1: {
                    throw new PcapNativeException("Error occured: " + this.getError(), rc);
                }
                case -2: {
                    logger.info("Broken.");
                    throw new InterruptedException();
                }
                default: {
                    throw new PcapNativeException("Unexpected error occured: " + this.getError(), rc);
                }
            }
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakLoop() throws NotOpenException {
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            logger.info("Break loop.");
            NativeMappings.pcap_breakloop(this.handle);
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) throws PcapNativeException, NotOpenException {
        if (packet == null) {
            throw new NullPointerException("packet may not be null");
        }
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            int rc = NativeMappings.pcap_sendpacket(this.handle, packet.getRawData(), packet.length());
            if (rc < 0) {
                throw new PcapNativeException("Error occured in pcap_sendpacket(): " + this.getError(), rc);
            }
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PcapStat getStats() throws PcapNativeException, NotOpenException {
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            if (Platform.isWindows()) {
                IntByReference pcapStatSize = new IntByReference();
                Pointer psp = NativeMappings.PcapLibrary.INSTANCE.win_pcap_stats_ex(this.handle, pcapStatSize);
                if (pcapStatSize.getValue() != 24) {
                    throw new PcapNativeException(this.getError());
                }
                if (psp == null) {
                    throw new PcapNativeException(this.getError());
                }
                PcapStat pcapStat = new PcapStat(psp, true);
                return pcapStat;
            }
            NativeMappings.pcap_stat ps = new NativeMappings.pcap_stat();
            ps.setAutoSynch(false);
            int rc = NativeMappings.pcap_stats(this.handle, ps);
            if (rc < 0) {
                throw new PcapNativeException(this.getError(), rc);
            }
            PcapStat pcapStat = new PcapStat(ps.getPointer(), false);
            return pcapStat;
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataLinkType> listDatalinks() throws PcapNativeException, NotOpenException {
        ArrayList<DataLinkType> list;
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            PointerByReference dltBufPP = new PointerByReference();
            int rc = NativeMappings.pcap_list_datalinks(this.handle, dltBufPP);
            if (rc < 0) {
                throw new PcapNativeException(this.getError(), rc);
            }
            Pointer dltBufP = dltBufPP.getValue();
            list = new ArrayList<DataLinkType>(rc);
            for (int i : dltBufP.getIntArray(0L, rc)) {
                list.add(DataLinkType.getInstance(i));
            }
            NativeMappings.pcap_free_datalinks(dltBufP);
        }
        finally {
            this.handleLock.readLock().unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getError() throws NotOpenException {
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.handleLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            String string = NativeMappings.pcap_geterr(this.handle).getString(0L);
            return string;
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.open) {
            logger.warn("Already closed.");
            return;
        }
        this.handleLock.writeLock().lock();
        try {
            if (!this.open) {
                logger.warn("Already closed.");
                return;
            }
            this.open = false;
        }
        finally {
            this.handleLock.writeLock().unlock();
        }
        NativeMappings.pcap_close(this.handle);
        logger.info("Closed.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("Link type: [").append(this.dlt).append("] handle: [").append(this.handle).append("] Open: [").append(this.open).append("] Filtering Expression: [").append(this.filteringExpression).append("]");
        return sb.toString();
    }

    private Timestamp buildTimestamp(Pointer header) {
        Timestamp ts = new Timestamp(NativeMappings.pcap_pkthdr.getTvSec(header).longValue() * 1000L);
        switch (this.timestampPrecision) {
            case MICRO: {
                ts.setNanos(NativeMappings.pcap_pkthdr.getTvUsec(header).intValue() * 1000);
                break;
            }
            case NANO: {
                ts.setNanos(NativeMappings.pcap_pkthdr.getTvUsec(header).intValue());
                break;
            }
            default: {
                throw new AssertionError((Object)"Never get here.");
            }
        }
        return ts;
    }

    static {
        try {
            WILDCARD_MASK = (Inet4Address)InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)"never get here");
        }
    }

    public static enum TimestampPrecision {
        MICRO(0),
        NANO(1);

        private final int value;

        private TimestampPrecision(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum BlockingMode {
        BLOCKING(0),
        NONBLOCKING(1);

        private final int value;

        private BlockingMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum SwappedType {
        NOT_SWAPPED(0),
        SWAPPED(1),
        MAYBE_SWAPPED(2);

        private final int value;

        private SwappedType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static final class Builder {
        private final String deviceName;
        private int snaplen;
        private boolean isSnaplenSet = false;
        private PcapNetworkInterface.PromiscuousMode promiscuousMode = null;
        private boolean rfmon;
        private boolean isRfmonSet = false;
        private int timeoutMillis;
        private boolean isTimeoutMillisSet = false;
        private int bufferSize;
        private boolean isBufferSizeSet = false;
        private TimestampPrecision timestampPrecision = null;

        public Builder(String deviceName) {
            if (deviceName == null || deviceName.length() == 0) {
                throw new IllegalArgumentException("deviceName: " + deviceName);
            }
            this.deviceName = deviceName;
        }

        public Builder snaplen(int snaplen) {
            this.snaplen = snaplen;
            this.isSnaplenSet = true;
            return this;
        }

        public Builder promiscuousMode(PcapNetworkInterface.PromiscuousMode promiscuousMode) {
            this.promiscuousMode = promiscuousMode;
            return this;
        }

        public Builder rfmon(boolean rfmon) {
            this.rfmon = rfmon;
            this.isRfmonSet = true;
            return this;
        }

        public Builder timeoutMillis(int timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            this.isTimeoutMillisSet = true;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            this.isBufferSizeSet = true;
            return this;
        }

        public Builder timestampPrecision(TimestampPrecision timestampPrecision) {
            this.timestampPrecision = timestampPrecision;
            return this;
        }

        public PcapHandle build() throws PcapNativeException {
            return new PcapHandle(this);
        }
    }

    private final class GotRawPacketFuncExecutor
    implements NativeMappings.pcap_handler {
        private final RawPacketListener listener;
        private final Executor executor;

        public GotRawPacketFuncExecutor(RawPacketListener listener, Executor executor) {
            this.listener = listener;
            this.executor = executor;
        }

        @Override
        public void got_packet(Pointer args, Pointer header, Pointer packet) {
            final Timestamp ts = PcapHandle.this.buildTimestamp(header);
            final byte[] ba = packet.getByteArray(0L, NativeMappings.pcap_pkthdr.getCaplen(header));
            try {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        PcapHandle.this.timestamps.set(ts);
                        GotRawPacketFuncExecutor.this.listener.gotPacket(ba);
                    }
                });
            }
            catch (Throwable e) {
                logger.error("The executor has thrown an exception.", e);
            }
        }
    }

    private final class GotPacketFuncExecutor
    implements NativeMappings.pcap_handler {
        private final DataLinkType dlt;
        private final PacketListener listener;
        private final Executor executor;

        public GotPacketFuncExecutor(PacketListener listener, DataLinkType dlt, Executor executor) {
            this.dlt = dlt;
            this.listener = listener;
            this.executor = executor;
        }

        @Override
        public void got_packet(Pointer args, Pointer header, Pointer packet) {
            final Timestamp ts = PcapHandle.this.buildTimestamp(header);
            final byte[] ba = packet.getByteArray(0L, NativeMappings.pcap_pkthdr.getCaplen(header));
            try {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        PcapHandle.this.timestamps.set(ts);
                        GotPacketFuncExecutor.this.listener.gotPacket(PacketFactories.getFactory(Packet.class, DataLinkType.class).newInstance(ba, 0, ba.length, GotPacketFuncExecutor.this.dlt));
                    }
                });
            }
            catch (Throwable e) {
                logger.error("The executor has thrown an exception.", e);
            }
        }
    }

    private static final class SimpleExecutor
    implements Executor {
        private static final SimpleExecutor INSTANCE = new SimpleExecutor();

        private SimpleExecutor() {
        }

        public static SimpleExecutor getInstance() {
            return INSTANCE;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

