"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Rewrite imports using next/<something> to next-server/<something>
function NextToNextServer() {
    return {
        visitor: {
            ImportDeclaration(path) {
                const source = path.node.source.value;
                if (source === 'next/dynamic') {
                    path.node.source.value = 'next-server/dynamic';
                }
                if (source === 'next/constants') {
                    path.node.source.value = 'next-server/constants';
                }
                if (source === 'next/config') {
                    path.node.source.value = 'next-server/config';
                }
                if (source === 'next/head') {
                    path.node.source.value = 'next-server/head';
                }
            }
        }
    };
}
exports.default = NextToNextServer;
