"use strict";exports.__esModule=true;exports.recursiveDelete=recursiveDelete;var _fs=_interopRequireDefault(require("fs"));var _path=require("path");var _util=require("util");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}const readdir=(0,_util.promisify)(_fs.default.readdir);const stat=(0,_util.promisify)(_fs.default.stat);const rmdir=(0,_util.promisify)(_fs.default.rmdir);const unlink=(0,_util.promisify)(_fs.default.unlink);const sleep=(0,_util.promisify)(setTimeout);const unlinkFile=async(p,t=1)=>{try{await unlink(p);}catch(e){if((e.code==='EBUSY'||e.code==='ENOTEMPTY'||e.code==='EPERM'||e.code==='EMFILE')&&t<3){await sleep(t*100);return unlinkFile(p,t++);}if(e.code==='ENOENT'){return;}throw e;}};/**
 * Recursively delete directory contents
 * @param  {string} dir Directory to delete the contents of
 * @param  {RegExp} [filter] Filter for the relative file path
 * @param  {boolean} [ensure] Ensures that parameter dir exists, this is not passed recursively
 * @param  {string} [previousPath] Ensures that parameter dir exists, this is not passed recursively
 * @returns Promise void
 */async function recursiveDelete(dir,filter,previousPath='',ensure){let result;try{result=await readdir(dir);}catch(e){if(e.code==='ENOENT'&&!ensure){return;}throw e;}await Promise.all(result.map(async part=>{const absolutePath=(0,_path.join)(dir,part);const pathStat=await stat(absolutePath).catch(e=>{if(e.code!=='ENOENT')throw e;});if(!pathStat){return;}if(pathStat.isDirectory()){const pp=(0,_path.join)(previousPath,part);await recursiveDelete(absolutePath,filter,pp);if(!filter||filter.test(pp)){return rmdir(absolutePath);}return;}if(!filter||filter.test((0,_path.join)(previousPath,part))){return unlinkFile(absolutePath);}}));}