import React from 'react';
import { shallow } from 'enzyme';
import { Navbar } from '../';

describe('Navbar', () => {
  it('should render .navbar markup', () => {
    const wrapper = shallow(<Navbar />);

    expect(wrapper.html()).toBe('<nav class="navbar"></nav>');
  });

  it('should render default .navbar-expand class', () => {
    const wrapper = shallow(<Navbar expand />);

    expect(wrapper.html()).toBe('<nav class="navbar navbar-expand"></nav>');
  });

  it('should render size based .navbar-expand-* classes', () => {
    const wrapper = shallow(<Navbar expand="md" />);

    expect(wrapper.html()).toBe('<nav class="navbar navbar-expand-md"></nav>');
  });

  it('should render default .navbar-expand class for toggleable false [DEPRECATED]', () => {
    const wrapper = shallow(<Navbar toggleable={false} />);

    expect(wrapper.html()).toBe('<nav class="navbar navbar-expand"></nav>');
  });

  it('should render default .navbar-expand class for toggleable true [DEPRECATED]', () => {
    const wrapper = shallow(<Navbar toggleable />);

    expect(wrapper.html()).toBe('<nav class="navbar navbar-expand-sm"></nav>');
  });

  it('should render size based .navbar-expand-* classes for toggleable (bumping breakpoint) [DEPRECATED]', () => {
    const wrapper = shallow(<Navbar toggleable="md" />);

    expect(wrapper.html()).toBe('<nav class="navbar navbar-expand-lg"></nav>');
  });

  it('should render custom tag', () => {
    const wrapper = shallow(<Navbar tag="div" />);

    expect(wrapper.html()).toBe('<div class="navbar"></div>');
  });

  it('should render role', () => {
    const wrapper = shallow(<Navbar role="navigation" />);

    expect(wrapper.html()).toBe('<nav role="navigation" class="navbar"></nav>');
  });

  it('should render children', () => {
    const wrapper = shallow(<Navbar>Children</Navbar>);

    expect(wrapper.html()).toBe('<nav class="navbar">Children</nav>');
  });

  it('should pass additional classNames', () => {
    const wrapper = shallow(<Navbar className="extra" />);

    expect(wrapper.hasClass('extra')).toBe(true);
    expect(wrapper.hasClass('navbar')).toBe(true);
  });

  it('should render prop based classes', () => {
    const wrapper = shallow(<Navbar light dark expand="sm" color="success" full sticky="top" fixed="top" />);

    expect(wrapper.hasClass('bg-success')).toBe(true);
    expect(wrapper.hasClass('navbar')).toBe(true);
    expect(wrapper.hasClass('navbar-expand-sm')).toBe(true);
    expect(wrapper.hasClass('navbar-light')).toBe(true);
    expect(wrapper.hasClass('navbar-dark')).toBe(true);
    expect(wrapper.hasClass('fixed-top')).toBe(true);
    expect(wrapper.hasClass('sticky-top')).toBe(true);
  });
});
