/*!
 *
 */
import _Object$assign from 'babel-runtime/core-js/object/assign';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _JSON$stringify from 'babel-runtime/core-js/json/stringify';
import _regeneratorRuntime from 'babel-runtime/regenerator';
import _asyncToGenerator from 'babel-runtime/helpers/asyncToGenerator';
import 'isomorphic-fetch';
import _typeof from 'babel-runtime/helpers/typeof';
import _Object$entries from 'babel-runtime/core-js/object/entries';
import deepcopy from 'deepcopy';
import { createStore, applyMiddleware } from 'redux';
import { composeWithDevTools } from 'redux-devtools-extension';
import thunkMiddleware from 'redux-thunk';
import _Object$values from 'babel-runtime/core-js/object/values';

var Context = function () {
  function Context() {
    _classCallCheck(this, Context);

    this.context = {};
  }

  Context.prototype.set = function set$$1(obj) {
    this.context = _Object$assign({}, this.context, obj);
  };

  Context.prototype.getValue = function getValue(key) {
    return this.context[key];
  };

  Context.prototype.setValue = function setValue(key, value) {
    this.context[key] = value;
  };

  Context.prototype.clear = function clear() {
    this.context = {};
  };

  Context.prototype.get = function get$$1() {
    return this.context;
  };

  return Context;
}();

var contextService = new Context();

var Logger = function () {
  function Logger() {
    _classCallCheck(this, Logger);
  }

  Logger.prototype.log = function log() {
    var _logger;

    (_logger = this.logger).log.apply(_logger, arguments);
  };

  Logger.prototype.warn = function warn() {
    var _logger2;

    (_logger2 = this.logger).warn.apply(_logger2, arguments);
  };

  Logger.prototype.info = function info() {
    var _logger3;

    (_logger3 = this.logger).info.apply(_logger3, arguments);
  };

  Logger.prototype.error = function error() {
    var _logger4;

    (_logger4 = this.logger).error.apply(_logger4, arguments);
  };

  _createClass(Logger, [{
    key: 'logger',
    get: function get$$1() {
      if (!this._logger) {
        this._logger = require('logdown')('ustore');
        this._logger.isEnabled = process.env.NODE_ENV !== "production";
      }
      return this._logger;
    }
  }]);

  return Logger;
}();

var logger = new Logger();

var formatResponse = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(callOptions, response) {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;

            if (!callOptions.json) {
              _context.next = 5;
              break;
            }

            _context.next = 4;
            return response.json();

          case 4:
            return _context.abrupt('return', _context.sent);

          case 5:
            _context.next = 7;
            return response.text();

          case 7:
            return _context.abrupt('return', _context.sent);

          case 10:
            _context.prev = 10;
            _context.t0 = _context['catch'](0);

            logger.error('Error on formatting response : ', callOptions, response);
            return _context.abrupt('return', response);

          case 14:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this, [[0, 10]]);
  }));

  return function formatResponse(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

function createHeaders(options) {
  //get parameters from coreStateParams to init data in header
  var token = contextService.getValue('securityToken');
  var contentLanguage = contextService.getValue('languageCode');

  if (!options.static) {
    var headers = _Object$assign({}, {
      'Accept': 'application/json',
      'Content-Type': 'application/json',
      'Accept-Language': contentLanguage
    });

    if (options.auth) {
      _Object$assign(headers, { 'Authorization': 'uStore ' + token });
    }

    return headers;
  }

  return {};
}

var http = ['get', 'post', 'put', 'delete'].reduce(function (map, method) {
  map[method] = function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(url, requestBody, options) {
      var callOptions, reqOptions, res, formatedResponse;
      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              callOptions = _Object$assign({
                auth: true,
                json: true,
                static: false
              }, options);
              reqOptions = {
                headers: createHeaders(callOptions),
                method: method,
                body: requestBody ? _JSON$stringify(requestBody) : undefined
              };
              _context2.next = 4;
              return fetch('' + url, reqOptions);

            case 4:
              res = _context2.sent;

              logger.info('Request to API : ', url, reqOptions);

              _context2.next = 8;
              return formatResponse(callOptions, res);

            case 8:
              formatedResponse = _context2.sent;

              logger.info('Response from API : ', _JSON$stringify(formatedResponse));

              if (res.ok) {
                _context2.next = 21;
                break;
              }

              _context2.prev = 11;

              logger.error('Error in request : ', url, reqOptions);

              if (formatedResponse.TypeName === 'AccessDenied') {
                contextService.getValue('onAccessDenied')();
              } else if (formatedResponse.TypeName === 'ResourceNotAvailable.Store') {
                contextService.getValue('onStoreNotAvailable')();
              } else contextService.getValue('onGeneralError')();
              throw formatedResponse;

            case 17:
              _context2.prev = 17;
              _context2.t0 = _context2['catch'](11);

              // logger.info('General Error')
              if (!_context2.t0 || !_context2.t0.TypeName) contextService.getValue('onGeneralError')();

              throw formatedResponse;

            case 21:
              return _context2.abrupt('return', formatedResponse);

            case 22:
            case 'end':
              return _context2.stop();
          }
        }
      }, _callee2, this, [[11, 17]]);
    }));

    return function (_x3, _x4, _x5) {
      return _ref2.apply(this, arguments);
    };
  }();

  return map;
}, {});

var defaultState = {
  currentStore: null,
  currentUser: null,
  initState: true,
  customState: {},
  cultures: [],
  currentCulture: null,
  currencies: [],
  currentCurrency: null
};

var LOAD_CURRENT_STORE = 'LOAD_CURRENT_STORE';
var LOAD_CURRENT_USER = 'LOAD_CURRENT_USER';
var LOAD_USER_ORDERS_SUMMARY = 'LOAD_USER_ORDERS_SUMMARY';
var LOAD_PRODUCTS = 'LOAD_PRODUCTS';
var SET_CUSTOM_VAR = 'SET_CUSTOM_VAR';
var DELETE_CUSTOM_VAR = 'DELETE_CUSTOM_VAR';
var MERGE_CUSTOM_STATE = 'MERGE_CUSTOM_STATE';
var LOAD_CATEGORIES = 'LOAD_CATEGORIES';
var LOAD_CATEGORIES_TREE = 'LOAD_CATEGORIES_TREE';
var LOAD_SUB_CATEGORIES = 'LOAD_SUB_CATEGORIES';
var LOAD_CULTURES = 'LOAD_CULTURES';
var LOAD_CURRENT_CATEGORY = 'LOAD_CURRENT_CATEGORY';

var LOAD_CURRENCIES = 'LOAD_CURRENCIES';
var SET_CURRENT_CURRENCY = 'SET_CURRENT_CURRENCY';
var SET_CURRENT_CULTURE = 'SET_CURRENT_CULTURE';
var SET_CURRENT_CULTURE_BY_LANGUAGE = 'SET_CURRENT_CULTURE_BY_LANGUAGE';
var CLEAR_STATE = 'CLEAR_STATE';

var convertObjectToQueryString = function convertObjectToQueryString(obj) {
  return _Object$entries(obj).map(function (_ref) {
    var key = _ref[0],
        value = _ref[1];
    return key && value ? key + '=' + encodeURIComponent(value) : '';
  }).filter(function (s) {
    return !!s;
  }).join('&');
};

var merge = function merge(o1, o2) {
  var o = deepcopy(o1);
  for (var n in o2) {
    if (_typeof(o2[n]) !== 'object' || o2[n] === null) {
      o[n] = o2[n];
    } else if (Array.isArray(o2[n])) {
      o[n] = [].concat(o2[n]);
    } else {
      o[n] = o[n] ? merge(o[n], o2[n]) : merge({}, o2[n]);
    }
  }
  return o;
};

// REDUCERS
var reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultState;
  var action = arguments[1];


  switch (action.type) {
    case '@@INIT_STATE':
      return _Object$assign({}, state, action.data, { initState: false });
    case LOAD_CURRENT_STORE:
      return _Object$assign({}, state, { currentStore: action.data });
    case LOAD_CURRENT_USER:
      return _Object$assign({}, state, { currentUser: action.data });
    case LOAD_USER_ORDERS_SUMMARY:
      return _Object$assign({}, state, { userOrdersSummary: action.data });
    case LOAD_CATEGORIES:
      return _Object$assign({}, state, { categories: action.data });
    case LOAD_CATEGORIES_TREE:
      var categoriesTree = action.data;
      var firstLevelCategories = categoriesTree.map(function (node) {
        return node.Category;
      });
      return _Object$assign({}, state, { categoriesTree: categoriesTree, categories: firstLevelCategories });
    case LOAD_SUB_CATEGORIES:
      return _Object$assign({}, state, { subCategories: action.data });
    case LOAD_CULTURES:
      return _Object$assign({}, state, { cultures: action.data });
    case LOAD_CURRENCIES:
      return _Object$assign({}, state, { currencies: action.data });
    case SET_CURRENT_CULTURE:
      return _Object$assign({}, state, { currentCulture: action.data });
    case SET_CURRENT_CULTURE_BY_LANGUAGE:
      var culture = action.data && state.cultures.length > 0 ? state.cultures.filter(function (c) {
        return c.LanguageCode === action.data;
      })[0] : null;
      return _Object$assign({}, state, { currentCulture: culture });
    case SET_CURRENT_CURRENCY:
      var currency = action.data ? action.data : state.currencies.length > 0 ? state.currencies.filter(function (c) {
        return c.ID === state.currentStore.PrimaryCurrencyID;
      })[0] : null;
      return _Object$assign({}, state, { currentCurrency: currency });
    case LOAD_CURRENT_CATEGORY:
      return _Object$assign({}, state, { currentCategory: action.data, subCategories: null });
    case LOAD_PRODUCTS:
      return _Object$assign({}, state, { products: action.data.products });
    case SET_CUSTOM_VAR:
      var mergedCustomState = _Object$assign(state.customState, action.data);
      return _Object$assign({}, state, { customState: mergedCustomState });
    case DELETE_CUSTOM_VAR:
      var customStateDup = _Object$assign({}, state.customState);
      delete customStateDup[action.data.name];
      return _Object$assign({}, state, { customState: customStateDup });
    case MERGE_CUSTOM_STATE:
      return _Object$assign({}, state, { customState: merge(state.customState, action.data) });
    case CLEAR_STATE:
      return _Object$assign({}, state, defaultState);
  }

  return state;
});

var initStore = function initStore() {
  var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultState;


  // the following lines are not duplicate
  // the build will select the correct line according to the type of the build
  // ==== DO NOT DELETE ====
  return createStore(reducer, initialState, composeWithDevTools(applyMiddleware(thunkMiddleware)));
  return createStore(reducer, initialState, applyMiddleware(thunkMiddleware));
};

var ProviderState = function () {
  function ProviderState() {
    _classCallCheck(this, ProviderState);

    this.store = initStore();
  }

  ProviderState.prototype.get = function get$$1() {
    return this.store.getState();
  };

  ProviderState.prototype.set = function set$$1(state) {
    this.store.dispatch({ type: '@@INIT_STATE', data: state });
  };

  ProviderState.prototype.setCustomState = function setCustomState(name, value) {
    var _data;

    this.store.dispatch({ type: SET_CUSTOM_VAR, data: (_data = {}, _data[name] = value, _data) });
  };

  ProviderState.prototype.setBulkCustomState = function setBulkCustomState(obj) {
    this.store.dispatch({ type: SET_CUSTOM_VAR, data: obj });
  };

  ProviderState.prototype.deleteCustomState = function deleteCustomState(name) {
    this.store.dispatch({ type: DELETE_CUSTOM_VAR, data: { name: name } });
  };

  ProviderState.prototype.mergeCustomState = function mergeCustomState(newState) {
    this.store.dispatch({ type: MERGE_CUSTOM_STATE, data: newState });
  };

  ProviderState.prototype.clear = function clear() {
    this.store.dispatch({ type: CLEAR_STATE, data: {} });
  };

  _createClass(ProviderState, [{
    key: 'dispatch',
    get: function get$$1() {
      return this.store.dispatch;
    }
  }, {
    key: 'subscribe',
    get: function get$$1() {
      return this.store.subscribe;
    }
  }]);

  return ProviderState;
}();

var providerState = new ProviderState();

var Config = function () {
  function Config() {
    _classCallCheck(this, Config);
  }

  Config.prototype.set = function set$$1(obj) {
    this.config = obj;
    this.configInit = true;
  };

  Config.prototype.getValue = function getValue(key) {
    return this.config[key];
  };

  Config.prototype.isInit = function isInit() {
    return this.configInit;
  };

  Config.prototype.get = function get$$1() {
    return this.config;
  };

  return Config;
}();

var config = new Config();

var _this = undefined;

var getTopCategories = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories' + (params.length ? '?' + params : ''));

          case 3:
            return _context.abrupt('return', _context.sent);

          case 4:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, _this);
  }));

  return function getTopCategories(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

var getSubCategories = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryID, pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context2.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID + '/categories' + (params.length ? '?' + params : ''));

          case 3:
            return _context2.abrupt('return', _context2.sent);

          case 4:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, _this);
  }));

  return function getSubCategories(_x3, _x4, _x5) {
    return _ref2.apply(this, arguments);
  };
}();

var getCategoryIDByFriendlyID = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(categoryFriendlyID) {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/id?friendlyID=' + categoryFriendlyID);

          case 2:
            return _context3.abrupt('return', _context3.sent);

          case 3:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, _this);
  }));

  return function getCategoryIDByFriendlyID(_x6) {
    return _ref3.apply(this, arguments);
  };
}();

var getCategory = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(categoryID) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID);

          case 2:
            return _context4.abrupt('return', _context4.sent);

          case 3:
          case 'end':
            return _context4.stop();
        }
      }
    }, _callee4, _this);
  }));

  return function getCategory(_x7) {
    return _ref4.apply(this, arguments);
  };
}();

var getCategoryTree = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(depth) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/tree?depth=' + depth);

          case 2:
            return _context5.abrupt('return', _context5.sent);

          case 3:
          case 'end':
            return _context5.stop();
        }
      }
    }, _callee5, _this);
  }));

  return function getCategoryTree(_x8) {
    return _ref5.apply(this, arguments);
  };
}();

/**
 * Represent the categories logic and API in the system
 */

var Categories = function () {
  function Categories() {
    _classCallCheck(this, Categories);
  }

  /**
   * Set **state.categoriesTree** with the categories tree.
   * Set **state.categories** with the first level categories group.
   * @param {number} [depth] - Indicates the maximum depth of the tree to return. By default (1), returns root categories only.
   * @returns {CategoryTreeModel} - The tree of categories
   */
  Categories.prototype.loadCategoriesTree = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var depth = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

      var _ref2, Categories;

      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return getCategoryTree(depth);

            case 2:
              _ref2 = _context.sent;
              Categories = _ref2.Categories;

              providerState.dispatch({ type: LOAD_CATEGORIES_TREE, data: Categories });
              return _context.abrupt('return', Categories);

            case 6:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadCategoriesTree() {
      return _ref.apply(this, arguments);
    }

    return loadCategoriesTree;
  }();

  /**
   * Set **state.subCategories** with the sub-categories of the given category in the store, using paging.
   * Sub-categories without online product(s) on any level of their branch - are not included.
   * @param {string} categoryFriendlyID - the category friendly ID
   * @param {number} [pageNumber] - The 1-based number of the page.
   * @param {number} [pageSize] - The amount of the categories in one page.
   * @returns Array of sub categories in a specific page
   */


  Categories.prototype.loadSubCategories = function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryFriendlyID) {
      var pageNumber = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var pageSize = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      var categoryID, _ref4, Categories;

      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return getCategoryIDByFriendlyID(categoryFriendlyID);

            case 2:
              categoryID = _context2.sent;
              _context2.next = 5;
              return getSubCategories(categoryID, pageNumber, pageSize);

            case 5:
              _ref4 = _context2.sent;
              Categories = _ref4.Categories;

              providerState.dispatch({ type: LOAD_SUB_CATEGORIES, data: Categories });
              return _context2.abrupt('return', Categories);

            case 9:
            case 'end':
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));

    function loadSubCategories(_x4) {
      return _ref3.apply(this, arguments);
    }

    return loadSubCategories;
  }();

  /**
   * Set state.currentCategory with the requested category by friendlyID.
   * @param {string} categoryFriendlyID - the category friendly ID
   * @returns {CategoryModel} - A category model
   */


  Categories.prototype.loadCurrentCategory = function () {
    var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(categoryFriendlyID) {
      var categoryID, currentCategory;
      return _regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return getCategoryIDByFriendlyID(categoryFriendlyID);

            case 2:
              categoryID = _context3.sent;
              _context3.next = 5;
              return getCategory(categoryID);

            case 5:
              currentCategory = _context3.sent;

              providerState.dispatch({ type: LOAD_CURRENT_CATEGORY, data: currentCategory });
              return _context3.abrupt('return', currentCategory);

            case 8:
            case 'end':
              return _context3.stop();
          }
        }
      }, _callee3, this);
    }));

    function loadCurrentCategory(_x5) {
      return _ref5.apply(this, arguments);
    }

    return loadCurrentCategory;
  }();

  return Categories;
}();

var categories = new Categories();

/**
 * Represent the products logic and API in the system
 */
var Products = function Products() {
  _classCallCheck(this, Products);
};

var products = new Products();

var Binding = function () {
  function Binding() {
    var _this = this;

    _classCallCheck(this, Binding);

    this.webComponents = {};
    this.componentId = 1;
    this.state = providerState;

    //subscribe to store changes and set model attribute on all
    //connected components
    this.state.store.subscribe(function () {
      setTimeout(function () {
        var model = _JSON$stringify(_this.state.get());
        _Object$values(_this.webComponents).forEach(function (c) {
          return c.setAttribute('model', model);
        });
      }, 0);
    });
  }

  //register a new component set an binding id to allow removing the
  //component when unregistering
  //listening to the action event and dispatching it to redux store.


  Binding.prototype.register = function register(component) {
    var _this2 = this;

    var model = _JSON$stringify(this.state.get());
    component.ustoreBindingId = this.componentId;
    component.addEventListener('action', function (_ref) {
      var data = _ref.data;
      return _this2.state.dispatch(data);
    });
    this.webComponents[this.componentId] = component;
    component.setAttribute('model', model);
    this.componentId++;
  };

  Binding.prototype.unregister = function unregister(ustoreBindingId) {
    delete this.webComponents[ustoreBindingId];
  };

  return Binding;
}();

var bindingService = new Binding();

/**
 * Represents the culture logic in the system
 */

var Culture = function () {
  function Culture() {
    _classCallCheck(this, Culture);
  }

  /**
   * Set **state.currentCurrency** with the requested currency model
   * @param {CurrencyModel} currentCurrency - the requested currency to set as the current currency
   */
  Culture.prototype.setCurrentCurrency = function setCurrentCurrency(currentCurrency) {
    providerState.dispatch({ type: SET_CURRENT_CURRENCY, data: currentCurrency });
  };

  /**
   * Set **state.currentCurrency** according the the language code requested
   * @param {string} languageCode - the requested language code
   */


  Culture.prototype.setCurrentCultureByLanguage = function setCurrentCultureByLanguage(languageCode) {
    providerState.dispatch({ type: SET_CURRENT_CULTURE_BY_LANGUAGE, data: languageCode });
  };

  /**
   * Get the converted price according to the current currency in the state
   * @param {ProductPriceModel} priceModel - the price model to be converted
   * @returns {json} - price, tax and priceIncludingTax that are converted by the current currency
   */


  Culture.prototype.getConvertedPrices = function getConvertedPrices(priceModel) {
    var _providerState$get = providerState.get(),
        currentCurrency = _providerState$get.currentCurrency;

    return {
      price: priceModel.Price * currentCurrency.ConversionRate,
      tax: priceModel.Tax * currentCurrency.ConversionRate,
      priceIncludingTax: (priceModel.Price + priceModel.Tax) * currentCurrency.ConversionRate
    };
  };

  return Culture;
}();

var culture = new Culture();

var _this$1 = undefined;

var getCurrentStore = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store");

          case 2:
            return _context.abrupt("return", _context.sent);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, _this$1);
  }));

  return function getCurrentStore() {
    return _ref.apply(this, arguments);
  };
}();

var getCurrentUser = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user");

          case 2:
            return _context2.abrupt("return", _context2.sent);

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, _this$1);
  }));

  return function getCurrentUser() {
    return _ref2.apply(this, arguments);
  };
}();

var getCultures = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3() {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/cultures", null);

          case 2:
            return _context3.abrupt("return", _context3.sent);

          case 3:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, _this$1);
  }));

  return function getCultures() {
    return _ref3.apply(this, arguments);
  };
}();

var getCurrencies = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4() {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/currencies");

          case 2:
            return _context4.abrupt("return", _context4.sent);

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, _this$1);
  }));

  return function getCurrencies() {
    return _ref4.apply(this, arguments);
  };
}();

/**
 * Represent the store logic and API in the system
 */

var Store = function () {
  function Store() {
    _classCallCheck(this, Store);
  }

  /**
   * Set **state.currentStore** with the data of the store, that is associated with the security token and culture
   * in the request headers.
   * @returns {StoreModel} - the store data
   */
  Store.prototype.loadCurrentStore = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var currentStore;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return getCurrentStore();

            case 2:
              currentStore = _context.sent;

              providerState.dispatch({ type: LOAD_CURRENT_STORE, data: currentStore });
              return _context.abrupt("return", currentStore);

            case 5:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadCurrentStore() {
      return _ref.apply(this, arguments);
    }

    return loadCurrentStore;
  }();

  /**
   * Set **state.currentUser** with the user, that is logged-in to the store
   * @returns {UserModel} - the user data
   */


  Store.prototype.loadCurrentUser = function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
      var currentUser;
      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return getCurrentUser();

            case 2:
              currentUser = _context2.sent;

              providerState.dispatch({ type: LOAD_CURRENT_USER, data: currentUser });
              return _context2.abrupt("return", currentUser);

            case 5:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));

    function loadCurrentUser() {
      return _ref2.apply(this, arguments);
    }

    return loadCurrentUser;
  }();

  /**
   * Set **state.cultures** with the list of the cultures, that are set for the store.
   * @returns {CultureModel[]} - list of the cultures
   */


  Store.prototype.loadStoreCultures = function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3() {
      var cultures;
      return _regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return getCultures();

            case 2:
              cultures = _context3.sent;

              providerState.dispatch({ type: LOAD_CULTURES, data: cultures });
              return _context3.abrupt("return", cultures);

            case 5:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3, this);
    }));

    function loadStoreCultures() {
      return _ref3.apply(this, arguments);
    }

    return loadStoreCultures;
  }();

  /**
   * Set **state.currencies** with the list of the currencies, that are set for the store.
   * @returns {CurrencyModel[]} - list of the currencies
   */


  Store.prototype.loadStoreCurrencies = function () {
    var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4() {
      var currencies;
      return _regeneratorRuntime.wrap(function _callee4$(_context4) {
        while (1) {
          switch (_context4.prev = _context4.next) {
            case 0:
              _context4.next = 2;
              return getCurrencies();

            case 2:
              currencies = _context4.sent;

              providerState.dispatch({ type: LOAD_CURRENCIES, data: currencies });
              return _context4.abrupt("return", currencies);

            case 5:
            case "end":
              return _context4.stop();
          }
        }
      }, _callee4, this);
    }));

    function loadStoreCurrencies() {
      return _ref4.apply(this, arguments);
    }

    return loadStoreCurrencies;
  }();

  return Store;
}();

var store = new Store();

var _this$2 = undefined;

var getUserOrdersSummary = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/summary");

          case 2:
            return _context.abrupt("return", _context.sent);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, _this$2);
  }));

  return function getUserOrdersSummary() {
    return _ref.apply(this, arguments);
  };
}();

var addOrderItem = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(productID) {
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/draft/items?productID=" + productID);

          case 2:
            return _context2.abrupt("return", _context2.sent);

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, _this$2);
  }));

  return function addOrderItem(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var getOrderItem = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID);

          case 2:
            return _context3.abrupt("return", _context3.sent);

          case 3:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, _this$2);
  }));

  return function getOrderItem(_x2) {
    return _ref3.apply(this, arguments);
  };
}();

var updateOrderItem = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(orderItemID, orderItem) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.put(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID, orderItem);

          case 2:
            return _context4.abrupt("return", _context4.sent);

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, _this$2);
  }));

  return function updateOrderItem(_x3, _x4) {
    return _ref4.apply(this, arguments);
  };
}();

var getPriceOrderItem = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(orderItemID, orderItem) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/price/calculate", orderItem);

          case 2:
            return _context5.abrupt("return", _context5.sent);

          case 3:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5, _this$2);
  }));

  return function getPriceOrderItem(_x5, _x6) {
    return _ref5.apply(this, arguments);
  };
}();

var reorder = function () {
  var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee6(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            _context6.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/submitted/items/" + orderItemID + "/reorder");

          case 2:
            return _context6.abrupt("return", _context6.sent);

          case 3:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6, _this$2);
  }));

  return function reorder(_x7) {
    return _ref6.apply(this, arguments);
  };
}();

var getLastOrder = function () {
  var _ref7 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee7(productID) {
    return _regeneratorRuntime.wrap(function _callee7$(_context7) {
      while (1) {
        switch (_context7.prev = _context7.next) {
          case 0:
            _context7.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/submitted/items/last/status?productID=" + productID);

          case 2:
            return _context7.abrupt("return", _context7.sent);

          case 3:
          case "end":
            return _context7.stop();
        }
      }
    }, _callee7, _this$2);
  }));

  return function getLastOrder(_x8) {
    return _ref7.apply(this, arguments);
  };
}();

var _this$3 = undefined;

var getProductIDByFriendlyID = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(friendlyID) {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/products/id?friendlyID=" + friendlyID);

          case 2:
            return _context.abrupt("return", _context.sent);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, _this$3);
  }));

  return function getProductIDByFriendlyID(_x) {
    return _ref.apply(this, arguments);
  };
}();

var getProducts = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryID, pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context2.next = 3;
            return http.get(config.getValue('apiUrl') + "/v1/store/categories/" + categoryID + "/products" + (params.length ? "?" + params : ''));

          case 3:
            return _context2.abrupt("return", _context2.sent);

          case 4:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, _this$3);
  }));

  return function getProducts(_x2, _x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();

var getProductsByIDs = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(IDs) {
    var sIDs;
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            sIDs = IDs.map(function (val, ind) {
              return "productIDs[" + ind + "]=" + val;
            }).join('&');
            _context3.next = 3;
            return http.get(config.getValue('apiUrl') + "/v1/store/products?" + sIDs);

          case 3:
            return _context3.abrupt("return", _context3.sent);

          case 4:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, _this$3);
  }));

  return function getProductsByIDs(_x5) {
    return _ref3.apply(this, arguments);
  };
}();

var getProductByID = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(productID, retrieveTypeSpecificData) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/products/" + productID + "?retrieveTypeSpecificData=" + retrieveTypeSpecificData);

          case 2:
            return _context4.abrupt("return", _context4.sent);

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, _this$3);
  }));

  return function getProductByID(_x6, _x7) {
    return _ref4.apply(this, arguments);
  };
}();

var productType = {
  Undefined: -1,
  Dynamic: 1,
  Static: 2,
  Email: 3,
  Uploaded: 4,
  Composite: 5,
  DynamicWithPurl: 6,
  EmailWithPurl: 7,
  CircleProject: 8,
  PrintTouchPoint: 9,
  EmailTouchPoint: 10,
  WebTouchPoint: 11,
  PdfOnDemandTouchPoint: 12,
  TriggeredEmailTouchPoint: 13,
  Kit: 14
};

var api = {

  categories: {
    getTopCategories: getTopCategories,
    getSubCategories: getSubCategories,
    getCategoryIDByFriendlyID: getCategoryIDByFriendlyID,
    getCategory: getCategory,
    getCategoryTree: getCategoryTree
  },
  orders: {
    getUserOrdersSummary: getUserOrdersSummary,
    addOrderItem: addOrderItem,
    getOrderItem: getOrderItem,
    updateOrderItem: updateOrderItem,
    getPriceOrderItem: getPriceOrderItem,
    reorder: reorder,
    getLastOrder: getLastOrder
  },
  products: {
    getProductIDByFriendlyID: getProductIDByFriendlyID,
    getProducts: getProducts,
    getProductByID: getProductByID,
    productType: productType,
    getProductsByIDs: getProductsByIDs

  },
  store: {
    getCurrentStore: getCurrentStore,
    getCurrentUser: getCurrentUser,
    getCultures: getCultures,
    getCurrencies: getCurrencies
  }

};

var InitialState = function () {
    function InitialState() {
        _classCallCheck(this, InitialState);
    }

    InitialState.prototype.loadInitialState = function () {
        var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
            var currencyFriendlyID, currentCurrency;
            return _regeneratorRuntime.wrap(function _callee$(_context) {
                while (1) {
                    switch (_context.prev = _context.next) {
                        case 0:
                            _context.next = 2;
                            return store.loadCurrentStore();

                        case 2:
                            _context.next = 4;
                            return store.loadStoreCultures();

                        case 4:

                            culture.setCurrentCultureByLanguage(contextService.getValue('languageCode'));

                            _context.next = 7;
                            return store.loadStoreCurrencies();

                        case 7:
                            currencyFriendlyID = contextService.getValue('currencyFriendlyID');
                            currentCurrency = providerState.get().currencies.filter(function (c) {
                                return c.FriendlyID === parseInt(currencyFriendlyID);
                            })[0];

                            culture.setCurrentCurrency(currentCurrency);

                            _context.next = 12;
                            return store.loadCurrentUser();

                        case 12:
                        case 'end':
                            return _context.stop();
                    }
                }
            }, _callee, this);
        }));

        function loadInitialState() {
            return _ref.apply(this, arguments);
        }

        return loadInitialState;
    }();

    return InitialState;
}();

var initialStateService = new InitialState();

var newState = {
  culture: culture,
  store: store,
  categories: categories,
  products: products,
  get: function get() {
    return providerState.get();
  },
  set: function set(state) {
    return providerState.set(state);
  },
  dispatch: providerState.dispatch,
  subscribe: providerState.subscribe,
  customState: {
    set: function set(name, value) {
      return providerState.setCustomState(name, value);
    },
    setBulk: function setBulk(obj) {
      return providerState.setBulkCustomState(obj);
    },
    get: function get(name) {
      return name ? providerState.get().customState[name] : providerState.get().customState;
    },
    delete: function _delete(name) {
      return providerState.deleteCustomState(name);
    },
    merge: function merge(customState) {
      return providerState.mergeCustomState(customState);
    }
  }
};

/**
 * UStoreProvider - This is the uStore provider - the entry point to all ustore API's
 */

var Provider = function () {
  function Provider() {
    _classCallCheck(this, Provider);

    this.stateService = providerState;
    this.binding = bindingService;
    this.initialState = initialStateService;
    this.configService = config;
    this.contextService = contextService;
  }

  Provider.prototype.init = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(runtimeConfig, params) {
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (runtimeConfig) {
                this.configService.set(runtimeConfig);
              }

              if (!params) {
                _context.next = 6;
                break;
              }

              this.contextService.set(params);

              if (!this.stateService.get().initState) {
                _context.next = 6;
                break;
              }

              _context.next = 6;
              return this.initialState.loadInitialState();

            case 6:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function init(_x, _x2) {
      return _ref.apply(this, arguments);
    }

    return init;
  }();

  _createClass(Provider, [{
    key: 'api',
    get: function get$$1() {
      return api;
    }
  }, {
    key: 'state',
    get: function get$$1() {
      return newState;
    }
  }]);

  return Provider;
}();

var UStoreProvider = new Provider();
//expose UStoreProvider on window so standalone component will have access to it
//which will allow them to register and let the provider add model binding and
//action changing
if (typeof window !== 'undefined') {
  window.UStoreProvider = UStoreProvider;
}

export { http, UStoreProvider };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
