/*!
 *
 */
import _Object$assign from 'babel-runtime/core-js/object/assign';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _JSON$stringify from 'babel-runtime/core-js/json/stringify';
import _regeneratorRuntime from 'babel-runtime/regenerator';
import _asyncToGenerator from 'babel-runtime/helpers/asyncToGenerator';
import 'isomorphic-fetch';
import _typeof from 'babel-runtime/helpers/typeof';
import _Object$entries from 'babel-runtime/core-js/object/entries';
import deepcopy from 'deepcopy';
import { createStore, applyMiddleware } from 'redux';
import { composeWithDevTools } from 'redux-devtools-extension';
import thunkMiddleware from 'redux-thunk';
import _Object$values from 'babel-runtime/core-js/object/values';

var Context = function () {
  function Context() {
    _classCallCheck(this, Context);

    this.context = {};
  }

  Context.prototype.set = function set$$1(obj) {
    this.context = _Object$assign({}, this.context, obj);
  };

  Context.prototype.getValue = function getValue(key) {
    return this.context[key];
  };

  Context.prototype.setValue = function setValue(key, value) {
    this.context[key] = value;
  };

  Context.prototype.clear = function clear() {
    this.context = {};
  };

  Context.prototype.get = function get$$1() {
    return this.context;
  };

  return Context;
}();

var contextService = new Context();

var Logger = function () {
  function Logger() {
    _classCallCheck(this, Logger);
  }

  Logger.prototype.log = function log() {
    var _logger;

    (_logger = this.logger).log.apply(_logger, arguments);
  };

  Logger.prototype.warn = function warn() {
    var _logger2;

    (_logger2 = this.logger).warn.apply(_logger2, arguments);
  };

  Logger.prototype.info = function info() {
    var _logger3;

    (_logger3 = this.logger).info.apply(_logger3, arguments);
  };

  Logger.prototype.error = function error() {
    var _logger4;

    (_logger4 = this.logger).error.apply(_logger4, arguments);
  };

  _createClass(Logger, [{
    key: 'logger',
    get: function get$$1() {
      if (!this._logger) {
        this._logger = require('logdown')('ustore');
        this._logger.isEnabled = process.env.NODE_ENV !== "production";
      }
      return this._logger;
    }
  }]);

  return Logger;
}();

var logger = new Logger();

var formatResponse = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(callOptions, response) {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;

            if (!callOptions.json) {
              _context.next = 5;
              break;
            }

            _context.next = 4;
            return response.json();

          case 4:
            return _context.abrupt('return', _context.sent);

          case 5:
            _context.next = 7;
            return response.text();

          case 7:
            return _context.abrupt('return', _context.sent);

          case 10:
            _context.prev = 10;
            _context.t0 = _context['catch'](0);

            logger.error('Error on formatting response : ', callOptions, response);
            return _context.abrupt('return', response);

          case 14:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this, [[0, 10]]);
  }));

  return function formatResponse(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

function createHeaders(options) {
  //get parameters from coreStateParams to init data in header
  var token = contextService.getValue('securityToken');
  var contentLanguage = contextService.getValue('languageCode');

  if (!options.static) {
    var headers = _Object$assign({}, {
      'Accept': 'application/json',
      'Content-Type': 'application/json',
      'Accept-Language': contentLanguage
    });

    if (options.auth) {
      _Object$assign(headers, { 'Authorization': 'uStore ' + token });
    }

    return headers;
  }

  return {};
}

var http = ['get', 'post', 'put', 'delete'].reduce(function (map, method) {
  map[method] = function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(url, requestBody, options) {
      var callOptions, reqOptions, res, formatedResponse;
      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              callOptions = _Object$assign({
                auth: true,
                json: true,
                static: false
              }, options);
              reqOptions = {
                headers: createHeaders(callOptions),
                method: method,
                body: requestBody ? _JSON$stringify(requestBody) : undefined
              };
              _context2.next = 4;
              return fetch('' + url, reqOptions);

            case 4:
              res = _context2.sent;

              logger.info('Request to API : ', url, reqOptions);

              _context2.next = 8;
              return formatResponse(callOptions, res);

            case 8:
              formatedResponse = _context2.sent;

              logger.info('Response from API : ', _JSON$stringify(formatedResponse));

              if (res.ok) {
                _context2.next = 21;
                break;
              }

              _context2.prev = 11;

              logger.error('Error in request : ', url, reqOptions);

              if (formatedResponse.TypeName === 'AccessDenied') {
                contextService.getValue('onAccessDenied')();
              } else if (formatedResponse.TypeName === 'ResourceNotAvailable.Store') {
                contextService.getValue('onStoreNotAvailable')();
              } else contextService.getValue('onGeneralError')();
              throw formatedResponse;

            case 17:
              _context2.prev = 17;
              _context2.t0 = _context2['catch'](11);

              // logger.info('General Error')
              if (!_context2.t0 || !_context2.t0.TypeName) contextService.getValue('onGeneralError')();

              throw formatedResponse;

            case 21:
              return _context2.abrupt('return', formatedResponse);

            case 22:
            case 'end':
              return _context2.stop();
          }
        }
      }, _callee2, this, [[11, 17]]);
    }));

    return function (_x3, _x4, _x5) {
      return _ref2.apply(this, arguments);
    };
  }();

  return map;
}, {});

var defaultState = {
  currentStore: null,
  currentUser: null,
  initState: true,
  customState: {},
  cultures: [],
  currentCulture: null,
  currencies: [],
  currentCurrency: null
};

var LOAD_CURRENT_STORE = 'LOAD_CURRENT_STORE';
var LOAD_CURRENT_USER = 'LOAD_CURRENT_USER';
var LOAD_USER_ORDERS_SUMMARY = 'LOAD_USER_ORDERS_SUMMARY';
var LOAD_PRODUCTS = 'LOAD_PRODUCTS';
var SET_CUSTOM_VAR = 'SET_CUSTOM_VAR';
var DELETE_CUSTOM_VAR = 'DELETE_CUSTOM_VAR';
var MERGE_CUSTOM_STATE = 'MERGE_CUSTOM_STATE';
var LOAD_CATEGORIES = 'LOAD_CATEGORIES';
var LOAD_CATEGORIES_TREE = 'LOAD_CATEGORIES_TREE';
var LOAD_SUB_CATEGORIES = 'LOAD_SUB_CATEGORIES';
var LOAD_CULTURES = 'LOAD_CULTURES';
var LOAD_CURRENT_CATEGORY = 'LOAD_CURRENT_CATEGORY';

var LOAD_CURRENCIES = 'LOAD_CURRENCIES';
var SET_CURRENT_CURRENCY = 'SET_CURRENT_CURRENCY';
var SET_CURRENT_CULTURE = 'SET_CURRENT_CULTURE';
var SET_CURRENT_CULTURE_BY_LANGUAGE = 'SET_CURRENT_CULTURE_BY_LANGUAGE';
var CLEAR_STATE = 'CLEAR_STATE';

var convertObjectToQueryString = function convertObjectToQueryString(obj) {
  return _Object$entries(obj).map(function (_ref) {
    var key = _ref[0],
        value = _ref[1];
    return key && value ? key + '=' + encodeURIComponent(value) : '';
  }).filter(function (s) {
    return !!s;
  }).join('&');
};

var merge = function merge(o1, o2) {
  var o = deepcopy(o1);
  for (var n in o2) {
    if (_typeof(o2[n]) !== 'object' || o2[n] === null) {
      o[n] = o2[n];
    } else if (Array.isArray(o2[n])) {
      o[n] = [].concat(o2[n]);
    } else {
      o[n] = o[n] ? merge(o[n], o2[n]) : merge({}, o2[n]);
    }
  }
  return o;
};

// REDUCERS
var reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultState;
  var action = arguments[1];


  switch (action.type) {
    case '@@INIT_STATE':
      return _Object$assign({}, state, action.data, { initState: false });
    case LOAD_CURRENT_STORE:
      return _Object$assign({}, state, { currentStore: action.data });
    case LOAD_CURRENT_USER:
      return _Object$assign({}, state, { currentUser: action.data });
    case LOAD_USER_ORDERS_SUMMARY:
      return _Object$assign({}, state, { userOrdersSummary: action.data });
    case LOAD_CATEGORIES:
      return _Object$assign({}, state, { categories: action.data });
    case LOAD_CATEGORIES_TREE:
      var categoriesTree = action.data;
      var firstLevelCategories = categoriesTree.map(function (node) {
        return node.Category;
      });
      return _Object$assign({}, state, { categoriesTree: categoriesTree, categories: firstLevelCategories });
    case LOAD_SUB_CATEGORIES:
      return _Object$assign({}, state, { subCategories: action.data });
    case LOAD_CULTURES:
      return _Object$assign({}, state, { cultures: action.data });
    case LOAD_CURRENCIES:
      return _Object$assign({}, state, { currencies: action.data });
    case SET_CURRENT_CULTURE:
      return _Object$assign({}, state, { currentCulture: action.data });
    case SET_CURRENT_CULTURE_BY_LANGUAGE:
      var culture = action.data && state.cultures.length > 0 ? state.cultures.filter(function (c) {
        return c.LanguageCode === action.data;
      })[0] : null;
      return _Object$assign({}, state, { currentCulture: culture });
    case SET_CURRENT_CURRENCY:
      var currency = action.data ? action.data : state.currencies.length > 0 ? state.currencies.filter(function (c) {
        return c.ID === state.currentStore.PrimaryCurrencyID;
      })[0] : null;
      return _Object$assign({}, state, { currentCurrency: currency });
    case LOAD_CURRENT_CATEGORY:
      return _Object$assign({}, state, { currentCategory: action.data, subCategories: null });
    case LOAD_PRODUCTS:
      return _Object$assign({}, state, { products: action.data.products });
    case SET_CUSTOM_VAR:
      var mergedCustomState = _Object$assign(state.customState, action.data);
      return _Object$assign({}, state, { customState: mergedCustomState });
    case DELETE_CUSTOM_VAR:
      var customStateDup = _Object$assign({}, state.customState);
      delete customStateDup[action.data.name];
      return _Object$assign({}, state, { customState: customStateDup });
    case MERGE_CUSTOM_STATE:
      return _Object$assign({}, state, { customState: merge(state.customState, action.data) });
    case CLEAR_STATE:
      return _Object$assign({}, state, defaultState);
  }

  return state;
});

var initStore = function initStore() {
  var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultState;


  // the following lines are not duplicate
  // the build will select the correct line according to the type of the build
  // ==== DO NOT DELETE ====
  return createStore(reducer, initialState, composeWithDevTools(applyMiddleware(thunkMiddleware)));
  return createStore(reducer, initialState, applyMiddleware(thunkMiddleware));
};

var ProviderState = function () {
  function ProviderState() {
    _classCallCheck(this, ProviderState);

    this.store = initStore();
  }

  ProviderState.prototype.get = function get$$1() {
    return this.store.getState();
  };

  ProviderState.prototype.set = function set$$1(state) {
    this.store.dispatch({ type: '@@INIT_STATE', data: state });
  };

  ProviderState.prototype.setCustomState = function setCustomState(name, value) {
    var _data;

    this.store.dispatch({ type: SET_CUSTOM_VAR, data: (_data = {}, _data[name] = value, _data) });
  };

  ProviderState.prototype.setBulkCustomState = function setBulkCustomState(obj) {
    this.store.dispatch({ type: SET_CUSTOM_VAR, data: obj });
  };

  ProviderState.prototype.deleteCustomState = function deleteCustomState(name) {
    this.store.dispatch({ type: DELETE_CUSTOM_VAR, data: { name: name } });
  };

  ProviderState.prototype.mergeCustomState = function mergeCustomState(newState) {
    this.store.dispatch({ type: MERGE_CUSTOM_STATE, data: newState });
  };

  ProviderState.prototype.clear = function clear() {
    this.store.dispatch({ type: CLEAR_STATE, data: {} });
  };

  _createClass(ProviderState, [{
    key: 'dispatch',
    get: function get$$1() {
      return this.store.dispatch;
    }
  }, {
    key: 'subscribe',
    get: function get$$1() {
      return this.store.subscribe;
    }
  }]);

  return ProviderState;
}();

var providerState = new ProviderState();

var Config = function () {
  function Config() {
    _classCallCheck(this, Config);
  }

  Config.prototype.set = function set$$1(obj) {
    this.config = obj;
    this.configInit = true;
  };

  Config.prototype.getValue = function getValue(key) {
    return this.config[key];
  };

  Config.prototype.isInit = function isInit() {
    return this.configInit;
  };

  Config.prototype.get = function get$$1() {
    return this.config;
  };

  return Config;
}();

var config = new Config();

var _this = undefined;

var getTopCategories = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories' + (params.length ? '?' + params : ''));

          case 3:
            return _context.abrupt('return', _context.sent);

          case 4:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, _this);
  }));

  return function getTopCategories(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

var getSubCategories = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryID, pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context2.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID + '/categories' + (params.length ? '?' + params : ''));

          case 3:
            return _context2.abrupt('return', _context2.sent);

          case 4:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, _this);
  }));

  return function getSubCategories(_x3, _x4, _x5) {
    return _ref2.apply(this, arguments);
  };
}();

var getCategoryIDByFriendlyID = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(categoryFriendlyID) {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/id?friendlyID=' + categoryFriendlyID);

          case 2:
            return _context3.abrupt('return', _context3.sent);

          case 3:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, _this);
  }));

  return function getCategoryIDByFriendlyID(_x6) {
    return _ref3.apply(this, arguments);
  };
}();

var getCategory = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(categoryID) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID);

          case 2:
            return _context4.abrupt('return', _context4.sent);

          case 3:
          case 'end':
            return _context4.stop();
        }
      }
    }, _callee4, _this);
  }));

  return function getCategory(_x7) {
    return _ref4.apply(this, arguments);
  };
}();

var getCategoryTree = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(depth) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/tree?depth=' + depth);

          case 2:
            return _context5.abrupt('return', _context5.sent);

          case 3:
          case 'end':
            return _context5.stop();
        }
      }
    }, _callee5, _this);
  }));

  return function getCategoryTree(_x8) {
    return _ref5.apply(this, arguments);
  };
}();

/**
 * Represent the categories logic and API in the system
 */

var Categories = function () {
  function Categories() {
    _classCallCheck(this, Categories);
  }

  /**
   * Set **state.categoriesTree** with the categories tree.
   * Set **state.categories** with the first level categories group.
   * @param {number} [depth] - Indicates the maximum depth of the tree to return. By default (1), returns root categories only.
   * @returns {CategoryTreeModel} - The tree of categories
   */
  Categories.prototype.loadCategoriesTree = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var depth = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

      var _ref2, Categories;

      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return getCategoryTree(depth);

            case 2:
              _ref2 = _context.sent;
              Categories = _ref2.Categories;

              providerState.dispatch({ type: LOAD_CATEGORIES_TREE, data: Categories });
              return _context.abrupt('return', Categories);

            case 6:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadCategoriesTree() {
      return _ref.apply(this, arguments);
    }

    return loadCategoriesTree;
  }();

  /**
   * Set **state.subCategories** with the sub-categories of the given category in the store, using paging.
   * Sub-categories without online product(s) on any level of their branch - are not included.
   * @param {string} categoryFriendlyID - the category friendly ID
   * @param {number} [pageNumber] - The 1-based number of the page.
   * @param {number} [pageSize] - The amount of the categories in one page.
   * @returns Array of sub categories in a specific page
   */


  Categories.prototype.loadSubCategories = function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryFriendlyID) {
      var pageNumber = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var pageSize = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      var categoryID, _ref4, Categories;

      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return getCategoryIDByFriendlyID(categoryFriendlyID);

            case 2:
              categoryID = _context2.sent;
              _context2.next = 5;
              return getSubCategories(categoryID, pageNumber, pageSize);

            case 5:
              _ref4 = _context2.sent;
              Categories = _ref4.Categories;

              providerState.dispatch({ type: LOAD_SUB_CATEGORIES, data: Categories });
              return _context2.abrupt('return', Categories);

            case 9:
            case 'end':
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));

    function loadSubCategories(_x4) {
      return _ref3.apply(this, arguments);
    }

    return loadSubCategories;
  }();

  /**
   * Set state.currentCategory with the requested category by friendlyID.
   * @param {string} categoryFriendlyID - the category friendly ID
   * @returns {CategoryModel} - A category model
   */


  Categories.prototype.loadCurrentCategory = function () {
    var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(categoryFriendlyID) {
      var categoryID, currentCategory;
      return _regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return getCategoryIDByFriendlyID(categoryFriendlyID);

            case 2:
              categoryID = _context3.sent;
              _context3.next = 5;
              return getCategory(categoryID);

            case 5:
              currentCategory = _context3.sent;

              providerState.dispatch({ type: LOAD_CURRENT_CATEGORY, data: currentCategory });
              return _context3.abrupt('return', currentCategory);

            case 8:
            case 'end':
              return _context3.stop();
          }
        }
      }, _callee3, this);
    }));

    function loadCurrentCategory(_x5) {
      return _ref5.apply(this, arguments);
    }

    return loadCurrentCategory;
  }();

  return Categories;
}();

var categories = new Categories();

/**
 * Represent the products logic and API in the system
 */
var Products = function Products() {
  _classCallCheck(this, Products);
};

var products = new Products();

var Binding = function () {
  function Binding() {
    var _this = this;

    _classCallCheck(this, Binding);

    this.webComponents = {};
    this.componentId = 1;
    this.state = providerState;

    //subscribe to store changes and set model attribute on all
    //connected components
    this.state.store.subscribe(function () {
      setTimeout(function () {
        var model = _JSON$stringify(_this.state.get());
        _Object$values(_this.webComponents).forEach(function (c) {
          return c.setAttribute('model', model);
        });
      }, 0);
    });
  }

  //register a new component set an binding id to allow removing the
  //component when unregistering
  //listening to the action event and dispatching it to redux store.


  Binding.prototype.register = function register(component) {
    var _this2 = this;

    var model = _JSON$stringify(this.state.get());
    component.ustoreBindingId = this.componentId;
    component.addEventListener('action', function (_ref) {
      var data = _ref.data;
      return _this2.state.dispatch(data);
    });
    this.webComponents[this.componentId] = component;
    component.setAttribute('model', model);
    this.componentId++;
  };

  Binding.prototype.unregister = function unregister(ustoreBindingId) {
    delete this.webComponents[ustoreBindingId];
  };

  return Binding;
}();

var bindingService = new Binding();

/**
 * Represents the culture logic in the system
 */

var Culture = function () {
  function Culture() {
    _classCallCheck(this, Culture);
  }

  /**
   * Set **state.currentCurrency** with the requested currency model
   * @param {CurrencyModel} currentCurrency - the requested currency to set as the current currency
   */
  Culture.prototype.setCurrentCurrency = function setCurrentCurrency(currentCurrency) {
    providerState.dispatch({ type: SET_CURRENT_CURRENCY, data: currentCurrency });
  };

  /**
   * Set **state.currentCurrency** according the the language code requested
   * @param {string} languageCode - the requested language code
   */


  Culture.prototype.setCurrentCultureByLanguage = function setCurrentCultureByLanguage(languageCode) {
    providerState.dispatch({ type: SET_CURRENT_CULTURE_BY_LANGUAGE, data: languageCode });
  };

  /**
   * Get the converted price according to the current currency in the state
   * @param {ProductPriceModel} priceModel - the price model to be converted
   * @returns {json} - price, tax and priceIncludingTax that are converted by the current currency
   */


  Culture.prototype.getConvertedPrices = function getConvertedPrices(priceModel) {
    var _providerState$get = providerState.get(),
        currentCurrency = _providerState$get.currentCurrency;

    return {
      price: priceModel.Price * currentCurrency.ConversionRate,
      tax: priceModel.Tax * currentCurrency.ConversionRate,
      priceIncludingTax: (priceModel.Price + priceModel.Tax) * currentCurrency.ConversionRate
    };
  };

  return Culture;
}();

var culture = new Culture();

var _this$1 = undefined;

var getCurrentStore = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store");

          case 2:
            return _context.abrupt("return", _context.sent);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, _this$1);
  }));

  return function getCurrentStore() {
    return _ref.apply(this, arguments);
  };
}();

var getCurrentUser = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user");

          case 2:
            return _context2.abrupt("return", _context2.sent);

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, _this$1);
  }));

  return function getCurrentUser() {
    return _ref2.apply(this, arguments);
  };
}();

var getCultures = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3() {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/cultures", null);

          case 2:
            return _context3.abrupt("return", _context3.sent);

          case 3:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, _this$1);
  }));

  return function getCultures() {
    return _ref3.apply(this, arguments);
  };
}();

var getCurrencies = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4() {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/currencies");

          case 2:
            return _context4.abrupt("return", _context4.sent);

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, _this$1);
  }));

  return function getCurrencies() {
    return _ref4.apply(this, arguments);
  };
}();

/**
 * Represent the store logic and API in the system
 */

var Store = function () {
  function Store() {
    _classCallCheck(this, Store);
  }

  /**
   * Set **state.currentStore** with the data of the store, that is associated with the security token and culture
   * in the request headers.
   * @returns {StoreModel} - the store data
   */
  Store.prototype.loadCurrentStore = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var currentStore;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return getCurrentStore();

            case 2:
              currentStore = _context.sent;

              providerState.dispatch({ type: LOAD_CURRENT_STORE, data: currentStore });
              return _context.abrupt("return", currentStore);

            case 5:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadCurrentStore() {
      return _ref.apply(this, arguments);
    }

    return loadCurrentStore;
  }();

  /**
   * Set **state.currentUser** with the user, that is logged-in to the store
   * @returns {UserModel} - the user data
   */


  Store.prototype.loadCurrentUser = function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
      var currentUser;
      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return getCurrentUser();

            case 2:
              currentUser = _context2.sent;

              providerState.dispatch({ type: LOAD_CURRENT_USER, data: currentUser });
              return _context2.abrupt("return", currentUser);

            case 5:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));

    function loadCurrentUser() {
      return _ref2.apply(this, arguments);
    }

    return loadCurrentUser;
  }();

  /**
   * Set **state.cultures** with the list of the cultures, that are set for the store.
   * @returns {CultureModel[]} - list of the cultures
   */


  Store.prototype.loadStoreCultures = function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3() {
      var cultures;
      return _regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return getCultures();

            case 2:
              cultures = _context3.sent;

              providerState.dispatch({ type: LOAD_CULTURES, data: cultures });
              return _context3.abrupt("return", cultures);

            case 5:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3, this);
    }));

    function loadStoreCultures() {
      return _ref3.apply(this, arguments);
    }

    return loadStoreCultures;
  }();

  /**
   * Set **state.currencies** with the list of the currencies, that are set for the store.
   * @returns {CurrencyModel[]} - list of the currencies
   */


  Store.prototype.loadStoreCurrencies = function () {
    var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4() {
      var currencies;
      return _regeneratorRuntime.wrap(function _callee4$(_context4) {
        while (1) {
          switch (_context4.prev = _context4.next) {
            case 0:
              _context4.next = 2;
              return getCurrencies();

            case 2:
              currencies = _context4.sent;

              providerState.dispatch({ type: LOAD_CURRENCIES, data: currencies });
              return _context4.abrupt("return", currencies);

            case 5:
            case "end":
              return _context4.stop();
          }
        }
      }, _callee4, this);
    }));

    function loadStoreCurrencies() {
      return _ref4.apply(this, arguments);
    }

    return loadStoreCurrencies;
  }();

  return Store;
}();

var store = new Store();

var _this$2 = undefined;

var getUserOrdersSummary = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/summary");

          case 2:
            return _context.abrupt("return", _context.sent);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, _this$2);
  }));

  return function getUserOrdersSummary() {
    return _ref.apply(this, arguments);
  };
}();

var addOrderItem = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(productID) {
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/draft/items?productID=" + productID);

          case 2:
            return _context2.abrupt("return", _context2.sent);

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, _this$2);
  }));

  return function addOrderItem(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var getOrderItem = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID);

          case 2:
            return _context3.abrupt("return", _context3.sent);

          case 3:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, _this$2);
  }));

  return function getOrderItem(_x2) {
    return _ref3.apply(this, arguments);
  };
}();

var updateOrderItem = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(orderItemID, orderItem) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.put(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID, orderItem);

          case 2:
            return _context4.abrupt("return", _context4.sent);

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, _this$2);
  }));

  return function updateOrderItem(_x3, _x4) {
    return _ref4.apply(this, arguments);
  };
}();

var getPriceOrderItem = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(orderItemID, orderItem) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/price/calculate", orderItem);

          case 2:
            return _context5.abrupt("return", _context5.sent);

          case 3:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5, _this$2);
  }));

  return function getPriceOrderItem(_x5, _x6) {
    return _ref5.apply(this, arguments);
  };
}();

var reorder = function () {
  var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee6(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            _context6.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/submitted/items/" + orderItemID + "/reorder");

          case 2:
            return _context6.abrupt("return", _context6.sent);

          case 3:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6, _this$2);
  }));

  return function reorder(_x7) {
    return _ref6.apply(this, arguments);
  };
}();

var getLastOrder = function () {
  var _ref7 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee7(productID) {
    return _regeneratorRuntime.wrap(function _callee7$(_context7) {
      while (1) {
        switch (_context7.prev = _context7.next) {
          case 0:
            _context7.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/submitted/items/last/status?productID=" + productID);

          case 2:
            return _context7.abrupt("return", _context7.sent);

          case 3:
          case "end":
            return _context7.stop();
        }
      }
    }, _callee7, _this$2);
  }));

  return function getLastOrder(_x8) {
    return _ref7.apply(this, arguments);
  };
}();

var addToCart = function () {
  var _ref8 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee8(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee8$(_context8) {
      while (1) {
        switch (_context8.prev = _context8.next) {
          case 0:
            _context8.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/addToCart");

          case 2:
            return _context8.abrupt("return", _context8.sent);

          case 3:
          case "end":
            return _context8.stop();
        }
      }
    }, _callee8, _this$2);
  }));

  return function addToCart(_x9) {
    return _ref8.apply(this, arguments);
  };
}();

var saveForLater = function () {
  var _ref9 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee9(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee9$(_context9) {
      while (1) {
        switch (_context9.prev = _context9.next) {
          case 0:
            _context9.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/saveForLater");

          case 2:
            return _context9.abrupt("return", _context9.sent);

          case 3:
          case "end":
            return _context9.stop();
        }
      }
    }, _callee9, _this$2);
  }));

  return function saveForLater(_x10) {
    return _ref9.apply(this, arguments);
  };
}();

var getDeliveryServices = function () {
  var _ref10 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee10(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee10$(_context10) {
      while (1) {
        switch (_context10.prev = _context10.next) {
          case 0:
            _context10.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/deliveryServices");

          case 2:
            return _context10.abrupt("return", _context10.sent);

          case 3:
          case "end":
            return _context10.stop();
        }
      }
    }, _callee10, _this$2);
  }));

  return function getDeliveryServices(_x11) {
    return _ref10.apply(this, arguments);
  };
}();

var _this$3 = undefined;

var getProductIDByFriendlyID = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(friendlyID) {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/products/id?friendlyID=" + friendlyID);

          case 2:
            return _context.abrupt("return", _context.sent);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, _this$3);
  }));

  return function getProductIDByFriendlyID(_x) {
    return _ref.apply(this, arguments);
  };
}();

var getProducts = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryID, pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context2.next = 3;
            return http.get(config.getValue('apiUrl') + "/v1/store/categories/" + categoryID + "/products" + (params.length ? "?" + params : ''));

          case 3:
            return _context2.abrupt("return", _context2.sent);

          case 4:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, _this$3);
  }));

  return function getProducts(_x2, _x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();

var getProductsByIDs = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(IDs) {
    var sIDs;
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            sIDs = IDs.map(function (val, ind) {
              return "productIDs[" + ind + "]=" + val;
            }).join('&');
            _context3.next = 3;
            return http.get(config.getValue('apiUrl') + "/v1/store/products?" + sIDs);

          case 3:
            return _context3.abrupt("return", _context3.sent);

          case 4:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, _this$3);
  }));

  return function getProductsByIDs(_x5) {
    return _ref3.apply(this, arguments);
  };
}();

var getProductByID = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(productID, retrieveTypeSpecificData) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/products/" + productID + "?retrieveTypeSpecificData=" + retrieveTypeSpecificData);

          case 2:
            return _context4.abrupt("return", _context4.sent);

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, _this$3);
  }));

  return function getProductByID(_x6, _x7) {
    return _ref4.apply(this, arguments);
  };
}();

var getProductThumbnails = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(productID) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/products/" + productID + "/thumbnails");

          case 2:
            return _context5.abrupt("return", _context5.sent);

          case 3:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5, _this$3);
  }));

  return function getProductThumbnails(_x8) {
    return _ref5.apply(this, arguments);
  };
}();

var productType = {
  Undefined: -1,
  Dynamic: 1,
  Static: 2,
  Email: 3,
  Uploaded: 4,
  Composite: 5,
  DynamicWithPurl: 6,
  EmailWithPurl: 7,
  CircleProject: 8,
  PrintTouchPoint: 9,
  EmailTouchPoint: 10,
  WebTouchPoint: 11,
  PdfOnDemandTouchPoint: 12,
  TriggeredEmailTouchPoint: 13,
  Kit: 14
};

var api = {

  categories: {
    getTopCategories: getTopCategories,
    getSubCategories: getSubCategories,
    getCategoryIDByFriendlyID: getCategoryIDByFriendlyID,
    getCategory: getCategory,
    getCategoryTree: getCategoryTree
  },
  orders: {
    getUserOrdersSummary: getUserOrdersSummary,
    addOrderItem: addOrderItem,
    getOrderItem: getOrderItem,
    updateOrderItem: updateOrderItem,
    getPriceOrderItem: getPriceOrderItem,
    reorder: reorder,
    getLastOrder: getLastOrder,
    addToCart: addToCart,
    saveForLater: saveForLater,
    getDeliveryServices: getDeliveryServices
  },
  products: {
    getProductIDByFriendlyID: getProductIDByFriendlyID,
    getProducts: getProducts,
    getProductByID: getProductByID,
    productType: productType,
    getProductsByIDs: getProductsByIDs,
    getProductThumbnails: getProductThumbnails
  },
  store: {
    getCurrentStore: getCurrentStore,
    getCurrentUser: getCurrentUser,
    getCultures: getCultures,
    getCurrencies: getCurrencies
  }

};

var InitialState = function () {
  function InitialState() {
    _classCallCheck(this, InitialState);
  }

  InitialState.prototype.loadInitialState = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var currencyFriendlyID, currentCurrency, currencyID;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return store.loadCurrentStore();

            case 2:
              _context.next = 4;
              return store.loadStoreCultures();

            case 4:

              culture.setCurrentCultureByLanguage(contextService.getValue('languageCode'));

              _context.next = 7;
              return store.loadStoreCurrencies();

            case 7:
              currencyFriendlyID = contextService.getValue('currencyFriendlyID');
              currentCurrency = providerState.get().currencies.filter(function (c) {
                return c.FriendlyID === parseInt(currencyFriendlyID);
              })[0];
              currencyID = contextService.getValue('currencyID');


              if (currencyID) {
                currentCurrency = providerState.get().currencies.filter(function (c) {
                  return c.ID === currencyID;
                })[0];
              }
              culture.setCurrentCurrency(currentCurrency);

              _context.next = 14;
              return store.loadCurrentUser();

            case 14:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadInitialState() {
      return _ref.apply(this, arguments);
    }

    return loadInitialState;
  }();

  return InitialState;
}();

var initialStateService = new InitialState();

var newState = {
  culture: culture,
  store: store,
  categories: categories,
  products: products,
  get: function get() {
    return providerState.get();
  },
  set: function set(state) {
    return providerState.set(state);
  },
  dispatch: providerState.dispatch,
  subscribe: providerState.subscribe,
  customState: {
    set: function set(name, value) {
      return providerState.setCustomState(name, value);
    },
    setBulk: function setBulk(obj) {
      return providerState.setBulkCustomState(obj);
    },
    get: function get(name) {
      return name ? providerState.get().customState[name] : providerState.get().customState;
    },
    delete: function _delete(name) {
      return providerState.deleteCustomState(name);
    },
    merge: function merge(customState) {
      return providerState.mergeCustomState(customState);
    }
  }
};

/**
 * UStoreProvider - This is the uStore provider - the entry point to all ustore API's
 */

var Provider = function () {
  function Provider() {
    _classCallCheck(this, Provider);

    this.stateService = providerState;
    this.binding = bindingService;
    this.initialState = initialStateService;
    this.configService = config;
    this.contextService = contextService;
  }

  Provider.prototype.init = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(runtimeConfig, params) {
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (runtimeConfig) {
                this.configService.set(runtimeConfig);
              }

              if (!params) {
                _context.next = 6;
                break;
              }

              this.contextService.set(params);

              if (!this.stateService.get().initState) {
                _context.next = 6;
                break;
              }

              _context.next = 6;
              return this.initialState.loadInitialState();

            case 6:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function init(_x, _x2) {
      return _ref.apply(this, arguments);
    }

    return init;
  }();

  _createClass(Provider, [{
    key: 'api',
    get: function get$$1() {
      return api;
    }
  }, {
    key: 'state',
    get: function get$$1() {
      return newState;
    }
  }]);

  return Provider;
}();

var UStoreProvider = new Provider();
//expose UStoreProvider on window so standalone component will have access to it
//which will allow them to register and let the provider add model binding and
//action changing
if (typeof window !== 'undefined') {
  window.UStoreProvider = UStoreProvider;
}

export { http, UStoreProvider };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
