import Layout from '../components/Layout'
import './AboutUs.scss'

const AboutUs = (props) => {
    return (
      <Layout {...props} className="about-us">
        <div>
            <h2>About Us</h2>
            <p>Piece of Cake is a fictional franchise bakery. Any similarity to cake shops or bakeries in the real world is purely co-incidental.</p>
            <p>The samples cooked up in this store demonstrate the capabilites of XMPie StoreFlow and StoreFlow Pro.</p>
            <p>XMPie is your recipe for success in Web-to-print, marketing collateral portals, omni-channel marketing, marketing automation, 
                cross media, variable data print and much more.</p>
            <p>For more information about XMPie, please visit <a href="http://www.xmpie.com" title="www.xmpie.com">www.xmpie.com</a>.</p>         
            
            <h2>Locations</h2>
            <p>Piece of Cake stores are located all over the globe with head quarters in USA at:</p>
            <p>485 Lexington Ave, 10th floor, <br/>
            New York, NY 10017, <br/>
            United States</p>

            <h2>Careers</h2>
            <p>Piece of Cake is hiring!</p>
            <p>We're always on the look out for talented staff who can cook up gorgeous and tasty treats for our customers.</p>
            <p>If this sounds like you, send your resume to: <a href="mailto:noreply@xmpie.net" title="noreply@xmpie.net">noreply@xmpie.net</a></p>

            <h2>Problems with your orders</h2>
            <p>If you encounter any problems using this storefront, please contact the store admin team at: <a href="mailto:noreply@xmpie.net" title="noreply@xmpie.net">noreply@xmpie.net</a></p>
        </div>
      </Layout>
    )
}
  
export default AboutUs