"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const webpack_1 = __importDefault(require("webpack"));
function runCompiler(config) {
    return new Promise(async (resolve, reject) => {
        const compiler = webpack_1.default(config);
        compiler.run((err, multiStats) => {
            if (err) {
                return reject(err);
            }
            const result = multiStats.stats.reduce((result, stat) => {
                const { errors, warnings } = stat.toJson({
                    all: false,
                    warnings: true,
                    errors: true,
                });
                if (errors.length > 0) {
                    result.errors.push(...errors);
                }
                if (warnings.length > 0) {
                    result.warnings.push(...warnings);
                }
                return result;
            }, { errors: [], warnings: [] });
            resolve(result);
        });
    });
}
exports.runCompiler = runCompiler;
