"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// This plugin mirrors webpack 3 `filename` and `chunkfilename` behavior
// This fixes https://github.com/webpack/webpack/issues/6598
// This plugin is based on https://github.com/researchgate/webpack/commit/2f28947fa0c63ccbb18f39c0098bd791a2c37090
class ChunkNamesPlugin {
    apply(compiler) {
        compiler.hooks.compilation.tap('NextJsChunkNamesPlugin', (compilation) => {
            compilation.chunkTemplate.hooks.renderManifest.intercept({
                register(tapInfo) {
                    if (tapInfo.name === 'JavascriptModulesPlugin') {
                        const originalMethod = tapInfo.fn;
                        tapInfo.fn = (result, options) => {
                            let filenameTemplate;
                            const chunk = options.chunk;
                            const outputOptions = options.outputOptions;
                            if (chunk.filenameTemplate) {
                                filenameTemplate = chunk.filenameTemplate;
                            }
                            else if (chunk.hasEntryModule()) {
                                filenameTemplate = outputOptions.filename;
                            }
                            else {
                                filenameTemplate = outputOptions.chunkFilename;
                            }
                            options.chunk.filenameTemplate = filenameTemplate;
                            return originalMethod(result, options);
                        };
                    }
                    return tapInfo;
                }
            });
        });
    }
}
exports.default = ChunkNamesPlugin;
