import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { KnobControlConfig, KnobControlProps } from './types';
declare type TextTypeKnobValue = string;
export declare type TextTypeKnob = KnobControlConfig<TextTypeKnobValue>;
declare type TextTypeProps = KnobControlProps<TextTypeKnobValue>;
export default class TextType extends Component<TextTypeProps> {
    static defaultProps: TextTypeProps;
    static propTypes: {
        knob: PropTypes.Validator<KnobControlConfig<string>>;
        onChange: PropTypes.Validator<(value: string) => string>;
    };
    static serialize: (value: string) => string;
    static deserialize: (value: string) => string;
    shouldComponentUpdate(nextProps: TextTypeProps): boolean;
    handleChange: (event: React.ChangeEvent<HTMLTextAreaElement>) => void;
    render(): JSX.Element;
}
export {};
