"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
class AllModulesIdentifiedPlugin {
    apply(compiler) {
        compiler.hooks.compilation.tap('AllModulesIdentifiedPlugin', compilation => {
            compilation.hooks.beforeModuleIds.tap('AllModulesIdentifiedPlugin', modules => {
                ;
                modules.forEach(m => {
                    if (m.id != null || !m.identifier) {
                        return;
                    }
                    const identifier = m.identifier();
                    // This hashing algorithm is consistent with how the rest of
                    // webpack does it (n.b. HashedModuleIdsPlugin)
                    m.id = crypto_1.createHash('md4')
                        .update(identifier)
                        .digest('hex')
                        .substr(0, 4);
                });
            });
        });
    }
}
exports.AllModulesIdentifiedPlugin = AllModulesIdentifiedPlugin;
