"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
// This plugin modifies the require-ensure code generated by Webpack
// to work with Next.js SSR
class NextJsSsrImportPlugin {
    apply(compiler) {
        compiler.hooks.compilation.tap('NextJsSSRImport', (compilation) => {
            compilation.mainTemplate.hooks.requireEnsure.tap('NextJsSSRImport', (code, chunk) => {
                // Update to load chunks from our custom chunks directory
                const outputPath = path_1.resolve('/');
                const pagePath = path_1.join('/', path_1.dirname(chunk.name));
                const relativePathToBaseDir = path_1.relative(pagePath, outputPath);
                // Make sure even in windows, the path looks like in unix
                // Node.js require system will convert it accordingly
                const relativePathToBaseDirNormalized = relativePathToBaseDir.replace(/\\/g, '/');
                return code.replace('require("./"', `require("${relativePathToBaseDirNormalized}/"`).replace('readFile(join(__dirname', `readFile(join(__dirname, "${relativePathToBaseDirNormalized}"`);
            });
        });
    }
}
exports.default = NextJsSsrImportPlugin;
