/*!
 *
 */
import _Object$assign from 'babel-runtime/core-js/object/assign';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _JSON$stringify from 'babel-runtime/core-js/json/stringify';
import _regeneratorRuntime from 'babel-runtime/regenerator';
import _asyncToGenerator from 'babel-runtime/helpers/asyncToGenerator';
import 'isomorphic-fetch';
import _typeof from 'babel-runtime/helpers/typeof';
import _Object$entries from 'babel-runtime/core-js/object/entries';
import deepcopy from 'deepcopy';
import { createStore, applyMiddleware } from 'redux';
import { composeWithDevTools } from 'redux-devtools-extension';
import thunkMiddleware from 'redux-thunk';
import _Object$values from 'babel-runtime/core-js/object/values';

var Context = function () {
  function Context() {
    _classCallCheck(this, Context);

    this.context = {};
  }

  Context.prototype.set = function set$$1(obj) {
    this.context = _Object$assign({}, this.context, obj);
  };

  Context.prototype.getValue = function getValue(key) {
    return this.context[key];
  };

  Context.prototype.setValue = function setValue(key, value) {
    this.context[key] = value;
  };

  Context.prototype.clear = function clear() {
    this.context = {};
  };

  Context.prototype.get = function get$$1() {
    return this.context;
  };

  return Context;
}();

var contextService = new Context();

var Logger = function () {
  function Logger() {
    _classCallCheck(this, Logger);
  }

  Logger.prototype.log = function log() {
    var _logger;

    (_logger = this.logger).log.apply(_logger, arguments);
  };

  Logger.prototype.warn = function warn() {
    var _logger2;

    (_logger2 = this.logger).warn.apply(_logger2, arguments);
  };

  Logger.prototype.info = function info() {
    var _logger3;

    (_logger3 = this.logger).info.apply(_logger3, arguments);
  };

  Logger.prototype.error = function error() {
    var _logger4;

    (_logger4 = this.logger).error.apply(_logger4, arguments);
  };

  _createClass(Logger, [{
    key: 'logger',
    get: function get$$1() {
      if (!this._logger) {
        this._logger = require('logdown')('ustore');
        this._logger.isEnabled = process.env.NODE_ENV !== "production";
      }
      return this._logger;
    }
  }]);

  return Logger;
}();

var logger = new Logger();

var formatResponse = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(callOptions, response) {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;

            if (!callOptions.json) {
              _context.next = 5;
              break;
            }

            _context.next = 4;
            return response.json();

          case 4:
            return _context.abrupt('return', _context.sent);

          case 5:
            _context.next = 7;
            return response.text();

          case 7:
            return _context.abrupt('return', _context.sent);

          case 10:
            _context.prev = 10;
            _context.t0 = _context['catch'](0);

            logger.error('Error on formatting response : ', callOptions, response);
            return _context.abrupt('return', response);

          case 14:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this, [[0, 10]]);
  }));

  return function formatResponse(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

function createHeaders(options) {
  //get parameters from coreStateParams to init data in header
  var token = contextService.getValue('securityToken');
  var contentLanguage = contextService.getValue('languageCode');

  if (!options.static) {
    var headers = _Object$assign({}, {
      'Accept': 'application/json',
      'Content-Type': 'application/json',
      'Accept-Language': contentLanguage
    });

    if (options.auth) {
      _Object$assign(headers, { 'Authorization': 'uStore ' + token });
    }

    return headers;
  }

  return {};
}

var http = ['get', 'post', 'put', 'delete'].reduce(function (map, method) {
  map[method] = function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(url, requestBody, options) {
      var callOptions, reqOptions, res, formatedResponse;
      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              callOptions = _Object$assign({
                auth: true,
                json: true,
                static: false
              }, options);
              reqOptions = {
                headers: createHeaders(callOptions),
                method: method,
                body: requestBody ? _JSON$stringify(requestBody) : undefined
              };
              _context2.next = 4;
              return fetch('' + url, reqOptions);

            case 4:
              res = _context2.sent;

              logger.info('Request to API : ', url, reqOptions);

              _context2.next = 8;
              return formatResponse(callOptions, res);

            case 8:
              formatedResponse = _context2.sent;

              logger.info('Response from API : ', _JSON$stringify(formatedResponse));

              if (res.ok) {
                _context2.next = 21;
                break;
              }

              _context2.prev = 11;

              logger.error('Error in request : ', url, reqOptions);

              if (formatedResponse.TypeName === 'AccessDenied') {
                contextService.getValue('onAccessDenied')();
              } else if (formatedResponse.TypeName === 'ResourceNotAvailable.Store') {
                contextService.getValue('onStoreNotAvailable')();
              } else contextService.getValue('onGeneralError')();
              throw formatedResponse;

            case 17:
              _context2.prev = 17;
              _context2.t0 = _context2['catch'](11);

              // logger.info('General Error')
              if (!_context2.t0 || !_context2.t0.TypeName) contextService.getValue('onGeneralError')();

              throw formatedResponse;

            case 21:
              return _context2.abrupt('return', formatedResponse);

            case 22:
            case 'end':
              return _context2.stop();
          }
        }
      }, _callee2, this, [[11, 17]]);
    }));

    return function (_x3, _x4, _x5) {
      return _ref2.apply(this, arguments);
    };
  }();

  return map;
}, {});

var defaultState = {
  currentStore: null,
  currentUser: null,
  initState: true,
  customState: {},
  cultures: [],
  currentCulture: null,
  currencies: [],
  currentCurrency: null
};

var LOAD_CURRENT_STORE = 'LOAD_CURRENT_STORE';
var LOAD_CURRENT_USER = 'LOAD_CURRENT_USER';
var LOAD_USER_ORDERS_SUMMARY = 'LOAD_USER_ORDERS_SUMMARY';
var LOAD_PRODUCTS = 'LOAD_PRODUCTS';
var SET_CUSTOM_VAR = 'SET_CUSTOM_VAR';
var DELETE_CUSTOM_VAR = 'DELETE_CUSTOM_VAR';
var MERGE_CUSTOM_STATE = 'MERGE_CUSTOM_STATE';
var LOAD_CATEGORIES = 'LOAD_CATEGORIES';
var LOAD_CATEGORIES_TREE = 'LOAD_CATEGORIES_TREE';
var LOAD_SUB_CATEGORIES = 'LOAD_SUB_CATEGORIES';
var LOAD_CULTURES = 'LOAD_CULTURES';
var LOAD_CURRENT_CATEGORY = 'LOAD_CURRENT_CATEGORY';

var LOAD_CURRENCIES = 'LOAD_CURRENCIES';
var SET_CURRENT_CURRENCY = 'SET_CURRENT_CURRENCY';
var SET_CURRENT_CULTURE = 'SET_CURRENT_CULTURE';
var SET_CURRENT_CULTURE_BY_LANGUAGE = 'SET_CURRENT_CULTURE_BY_LANGUAGE';
var CLEAR_STATE = 'CLEAR_STATE';

var convertObjectToQueryString = function convertObjectToQueryString(obj) {
  return _Object$entries(obj).map(function (_ref) {
    var key = _ref[0],
        value = _ref[1];
    return key && value ? key + '=' + encodeURIComponent(value) : '';
  }).filter(function (s) {
    return !!s;
  }).join('&');
};

var merge = function merge(o1, o2) {
  var o = deepcopy(o1);
  for (var n in o2) {
    if (_typeof(o2[n]) !== 'object' || o2[n] === null) {
      o[n] = o2[n];
    } else if (Array.isArray(o2[n])) {
      o[n] = [].concat(o2[n]);
    } else {
      o[n] = o[n] ? merge(o[n], o2[n]) : merge({}, o2[n]);
    }
  }
  return o;
};

// REDUCERS
var reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultState;
  var action = arguments[1];


  switch (action.type) {
    case '@@INIT_STATE':
      return _Object$assign({}, state, action.data, { initState: false });
    case LOAD_CURRENT_STORE:
      return _Object$assign({}, state, { currentStore: action.data });
    case LOAD_CURRENT_USER:
      return _Object$assign({}, state, { currentUser: action.data });
    case LOAD_USER_ORDERS_SUMMARY:
      return _Object$assign({}, state, { userOrdersSummary: action.data });
    case LOAD_CATEGORIES:
      return _Object$assign({}, state, { categories: action.data });
    case LOAD_CATEGORIES_TREE:
      var categoriesTree = action.data;
      var firstLevelCategories = categoriesTree.map(function (node) {
        return node.Category;
      });
      return _Object$assign({}, state, { categoriesTree: categoriesTree, categories: firstLevelCategories });
    case LOAD_SUB_CATEGORIES:
      return _Object$assign({}, state, { subCategories: action.data });
    case LOAD_CULTURES:
      return _Object$assign({}, state, { cultures: action.data });
    case LOAD_CURRENCIES:
      return _Object$assign({}, state, { currencies: action.data });
    case SET_CURRENT_CULTURE:
      return _Object$assign({}, state, { currentCulture: action.data });
    case SET_CURRENT_CULTURE_BY_LANGUAGE:
      var culture = action.data && state.cultures.length > 0 ? state.cultures.filter(function (c) {
        return c.LanguageCode === action.data;
      })[0] : null;
      return _Object$assign({}, state, { currentCulture: culture });
    case SET_CURRENT_CURRENCY:
      var currency = action.data ? action.data : state.currencies.length > 0 ? state.currencies.filter(function (c) {
        return c.ID === state.currentStore.PrimaryCurrencyID;
      })[0] : null;
      return _Object$assign({}, state, { currentCurrency: currency });
    case LOAD_CURRENT_CATEGORY:
      return _Object$assign({}, state, { currentCategory: action.data, subCategories: null });
    case LOAD_PRODUCTS:
      return _Object$assign({}, state, { products: action.data.products });
    case SET_CUSTOM_VAR:
      var mergedCustomState = _Object$assign(state.customState, action.data);
      return _Object$assign({}, state, { customState: mergedCustomState });
    case DELETE_CUSTOM_VAR:
      var customStateDup = _Object$assign({}, state.customState);
      delete customStateDup[action.data.name];
      return _Object$assign({}, state, { customState: customStateDup });
    case MERGE_CUSTOM_STATE:
      return _Object$assign({}, state, { customState: merge(state.customState, action.data) });
    case CLEAR_STATE:
      return _Object$assign({}, state, defaultState);
  }

  return state;
});

var initStore = function initStore() {
  var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultState;


  // the following lines are not duplicate
  // the build will select the correct line according to the type of the build
  // ==== DO NOT DELETE ====
  return createStore(reducer, initialState, composeWithDevTools(applyMiddleware(thunkMiddleware)));
  return createStore(reducer, initialState, applyMiddleware(thunkMiddleware));
};

var ProviderState = function () {
  function ProviderState() {
    _classCallCheck(this, ProviderState);

    this.store = initStore();
  }

  ProviderState.prototype.get = function get$$1() {
    return this.store.getState();
  };

  ProviderState.prototype.set = function set$$1(state) {
    this.store.dispatch({ type: '@@INIT_STATE', data: state });
  };

  ProviderState.prototype.setInitState = function setInitState() {
    this.store.dispatch({ type: '@@INIT_STATE' });
  };

  ProviderState.prototype.setCustomState = function setCustomState(name, value) {
    var _data;

    this.store.dispatch({ type: SET_CUSTOM_VAR, data: (_data = {}, _data[name] = value, _data) });
  };

  ProviderState.prototype.setBulkCustomState = function setBulkCustomState(obj) {
    this.store.dispatch({ type: SET_CUSTOM_VAR, data: obj });
  };

  ProviderState.prototype.deleteCustomState = function deleteCustomState(name) {
    this.store.dispatch({ type: DELETE_CUSTOM_VAR, data: { name: name } });
  };

  ProviderState.prototype.mergeCustomState = function mergeCustomState(newState) {
    this.store.dispatch({ type: MERGE_CUSTOM_STATE, data: newState });
  };

  ProviderState.prototype.clear = function clear() {
    this.store.dispatch({ type: CLEAR_STATE, data: {} });
  };

  _createClass(ProviderState, [{
    key: 'dispatch',
    get: function get$$1() {
      return this.store.dispatch;
    }
  }, {
    key: 'subscribe',
    get: function get$$1() {
      return this.store.subscribe;
    }
  }]);

  return ProviderState;
}();

var providerState = new ProviderState();

var Config = function () {
  function Config() {
    _classCallCheck(this, Config);
  }

  Config.prototype.set = function set$$1(obj) {
    this.config = obj;
    this.configInit = true;
  };

  Config.prototype.getValue = function getValue(key) {
    return this.config[key];
  };

  Config.prototype.isInit = function isInit() {
    return this.configInit;
  };

  Config.prototype.get = function get$$1() {
    return this.config;
  };

  return Config;
}();

var config = new Config();

var _this = undefined;

var getTopCategories = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories' + (params.length ? '?' + params : ''));

          case 3:
            return _context.abrupt('return', _context.sent);

          case 4:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, _this);
  }));

  return function getTopCategories(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

var getSubCategories = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryID, pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context2.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID + '/categories' + (params.length ? '?' + params : ''));

          case 3:
            return _context2.abrupt('return', _context2.sent);

          case 4:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, _this);
  }));

  return function getSubCategories(_x3, _x4, _x5) {
    return _ref2.apply(this, arguments);
  };
}();

var getCategoryIDByFriendlyID = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(categoryFriendlyID) {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/id?friendlyID=' + categoryFriendlyID);

          case 2:
            return _context3.abrupt('return', _context3.sent);

          case 3:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, _this);
  }));

  return function getCategoryIDByFriendlyID(_x6) {
    return _ref3.apply(this, arguments);
  };
}();

var getCategory = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(categoryID) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID);

          case 2:
            return _context4.abrupt('return', _context4.sent);

          case 3:
          case 'end':
            return _context4.stop();
        }
      }
    }, _callee4, _this);
  }));

  return function getCategory(_x7) {
    return _ref4.apply(this, arguments);
  };
}();

var getCategoryTree = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(depth) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/tree?depth=' + depth);

          case 2:
            return _context5.abrupt('return', _context5.sent);

          case 3:
          case 'end':
            return _context5.stop();
        }
      }
    }, _callee5, _this);
  }));

  return function getCategoryTree(_x8) {
    return _ref5.apply(this, arguments);
  };
}();

/**
 * Represent the categories logic and API in the system
 */

var Categories = function () {
  function Categories() {
    _classCallCheck(this, Categories);
  }

  /**
   * Set **state.categoriesTree** with the categories tree.
   * Set **state.categories** with the first level categories group.
   * @param {number} [depth] - Indicates the maximum depth of the tree to return. By default (1), returns root categories only.
   * @returns {CategoryTreeModel} - The tree of categories
   */
  Categories.prototype.loadCategoriesTree = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var depth = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

      var _ref2, Categories;

      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return getCategoryTree(depth);

            case 2:
              _ref2 = _context.sent;
              Categories = _ref2.Categories;

              providerState.dispatch({ type: LOAD_CATEGORIES_TREE, data: Categories });
              return _context.abrupt('return', Categories);

            case 6:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadCategoriesTree() {
      return _ref.apply(this, arguments);
    }

    return loadCategoriesTree;
  }();

  /**
   * Set **state.subCategories** with the sub-categories of the given category in the store, using paging.
   * Sub-categories without online product(s) on any level of their branch - are not included.
   * @param {string} categoryFriendlyID - the category friendly ID
   * @param {number} [pageNumber] - The 1-based number of the page.
   * @param {number} [pageSize] - The amount of the categories in one page.
   * @returns Array of sub categories in a specific page
   */


  Categories.prototype.loadSubCategories = function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryFriendlyID) {
      var pageNumber = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var pageSize = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      var categoryID, _ref4, Categories;

      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return getCategoryIDByFriendlyID(categoryFriendlyID);

            case 2:
              categoryID = _context2.sent;
              _context2.next = 5;
              return getSubCategories(categoryID, pageNumber, pageSize);

            case 5:
              _ref4 = _context2.sent;
              Categories = _ref4.Categories;

              providerState.dispatch({ type: LOAD_SUB_CATEGORIES, data: Categories });
              return _context2.abrupt('return', Categories);

            case 9:
            case 'end':
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));

    function loadSubCategories(_x4) {
      return _ref3.apply(this, arguments);
    }

    return loadSubCategories;
  }();

  /**
   * Set state.currentCategory with the requested category by friendlyID.
   * @param {string} categoryFriendlyID - the category friendly ID
   * @returns {CategoryModel} - A category model
   */


  Categories.prototype.loadCurrentCategory = function () {
    var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(categoryFriendlyID) {
      var categoryID, currentCategory;
      return _regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return getCategoryIDByFriendlyID(categoryFriendlyID);

            case 2:
              categoryID = _context3.sent;
              _context3.next = 5;
              return getCategory(categoryID);

            case 5:
              currentCategory = _context3.sent;

              providerState.dispatch({ type: LOAD_CURRENT_CATEGORY, data: currentCategory });
              return _context3.abrupt('return', currentCategory);

            case 8:
            case 'end':
              return _context3.stop();
          }
        }
      }, _callee3, this);
    }));

    function loadCurrentCategory(_x5) {
      return _ref5.apply(this, arguments);
    }

    return loadCurrentCategory;
  }();

  return Categories;
}();

var categories = new Categories();

/**
 * Represent the products logic and API in the system
 */
var Products = function Products() {
  _classCallCheck(this, Products);
};

var products = new Products();

var Binding = function () {
  function Binding() {
    var _this = this;

    _classCallCheck(this, Binding);

    this.webComponents = {};
    this.componentId = 1;
    this.state = providerState;

    //subscribe to store changes and set model attribute on all
    //connected components
    this.state.store.subscribe(function () {
      setTimeout(function () {
        var model = _JSON$stringify(_this.state.get());
        _Object$values(_this.webComponents).forEach(function (c) {
          return c.setAttribute('model', model);
        });
      }, 0);
    });
  }

  //register a new component set an binding id to allow removing the
  //component when unregistering
  //listening to the action event and dispatching it to redux store.


  Binding.prototype.register = function register(component) {
    var _this2 = this;

    var model = _JSON$stringify(this.state.get());
    component.ustoreBindingId = this.componentId;
    component.addEventListener('action', function (_ref) {
      var data = _ref.data;
      return _this2.state.dispatch(data);
    });
    this.webComponents[this.componentId] = component;
    component.setAttribute('model', model);
    this.componentId++;
  };

  Binding.prototype.unregister = function unregister(ustoreBindingId) {
    delete this.webComponents[ustoreBindingId];
  };

  return Binding;
}();

var bindingService = new Binding();

/**
 * Represents the culture logic in the system
 */

var Culture = function () {
  function Culture() {
    _classCallCheck(this, Culture);
  }

  /**
   * Set **state.currentCurrency** with the requested currency model
   * @param {CurrencyModel} currentCurrency - the requested currency to set as the current currency
   */
  Culture.prototype.setCurrentCurrency = function setCurrentCurrency(currentCurrency) {
    providerState.dispatch({ type: SET_CURRENT_CURRENCY, data: currentCurrency });
  };

  /**
   * Set **state.currentCurrency** according the the language code requested
   * @param {string} languageCode - the requested language code
   */


  Culture.prototype.setCurrentCultureByLanguage = function setCurrentCultureByLanguage(languageCode) {
    providerState.dispatch({ type: SET_CURRENT_CULTURE_BY_LANGUAGE, data: languageCode });
  };

  /**
   * Get the converted price according to the current currency in the state
   * @param {ProductPriceModel} priceModel - the price model to be converted
   * @returns {json} - price, tax and priceIncludingTax that are converted by the current currency
   */


  Culture.prototype.getConvertedPrices = function getConvertedPrices(priceModel) {
    var _providerState$get = providerState.get(),
        currentCurrency = _providerState$get.currentCurrency;

    return {
      price: priceModel.Price * currentCurrency.ConversionRate,
      tax: priceModel.Tax * currentCurrency.ConversionRate,
      priceIncludingTax: (priceModel.Price + priceModel.Tax) * currentCurrency.ConversionRate
    };
  };

  return Culture;
}();

var cultureService = new Culture();

var _this$1 = undefined;

var getCurrentStore = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store");

          case 2:
            return _context.abrupt("return", _context.sent);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, _this$1);
  }));

  return function getCurrentStore() {
    return _ref.apply(this, arguments);
  };
}();

var getCurrentUser = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user");

          case 2:
            return _context2.abrupt("return", _context2.sent);

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, _this$1);
  }));

  return function getCurrentUser() {
    return _ref2.apply(this, arguments);
  };
}();

var getCultures = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3() {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/cultures", null);

          case 2:
            return _context3.abrupt("return", _context3.sent);

          case 3:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, _this$1);
  }));

  return function getCultures() {
    return _ref3.apply(this, arguments);
  };
}();

var getCurrencies = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4() {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/currencies");

          case 2:
            return _context4.abrupt("return", _context4.sent);

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, _this$1);
  }));

  return function getCurrencies() {
    return _ref4.apply(this, arguments);
  };
}();

var renewToken = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5() {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/renew");

          case 2:
            return _context5.abrupt("return", _context5.sent);

          case 3:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5, _this$1);
  }));

  return function renewToken() {
    return _ref5.apply(this, arguments);
  };
}();

/**
 * Represent the store logic and API in the system
 */

var Store = function () {
  function Store() {
    _classCallCheck(this, Store);
  }

  /**
   * Set **state.currentStore** with the data of the store, that is associated with the security token and culture
   * in the request headers.
   * @returns {StoreModel} - the store data
   */
  Store.prototype.loadCurrentStore = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var currentStore;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return getCurrentStore();

            case 2:
              currentStore = _context.sent;

              providerState.dispatch({ type: LOAD_CURRENT_STORE, data: currentStore });
              return _context.abrupt("return", currentStore);

            case 5:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadCurrentStore() {
      return _ref.apply(this, arguments);
    }

    return loadCurrentStore;
  }();

  /**
   * Set **state.currentUser** with the user, that is logged-in to the store
   * @returns {UserModel} - the user data
   */


  Store.prototype.loadCurrentUser = function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
      var currentUser;
      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return getCurrentUser();

            case 2:
              currentUser = _context2.sent;

              providerState.dispatch({ type: LOAD_CURRENT_USER, data: currentUser });
              return _context2.abrupt("return", currentUser);

            case 5:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));

    function loadCurrentUser() {
      return _ref2.apply(this, arguments);
    }

    return loadCurrentUser;
  }();

  /**
   * Set **state.cultures** with the list of the cultures, that are set for the store.
   * @returns {CultureModel[]} - list of the cultures
   */


  Store.prototype.loadStoreCultures = function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3() {
      var cultures;
      return _regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return getCultures();

            case 2:
              cultures = _context3.sent;

              providerState.dispatch({ type: LOAD_CULTURES, data: cultures });
              return _context3.abrupt("return", cultures);

            case 5:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3, this);
    }));

    function loadStoreCultures() {
      return _ref3.apply(this, arguments);
    }

    return loadStoreCultures;
  }();

  /**
   * Set **state.currencies** with the list of the currencies, that are set for the store.
   * @returns {CurrencyModel[]} - list of the currencies
   */


  Store.prototype.loadStoreCurrencies = function () {
    var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4() {
      var currencies;
      return _regeneratorRuntime.wrap(function _callee4$(_context4) {
        while (1) {
          switch (_context4.prev = _context4.next) {
            case 0:
              _context4.next = 2;
              return getCurrencies();

            case 2:
              currencies = _context4.sent;

              providerState.dispatch({ type: LOAD_CURRENCIES, data: currencies });
              return _context4.abrupt("return", currencies);

            case 5:
            case "end":
              return _context4.stop();
          }
        }
      }, _callee4, this);
    }));

    function loadStoreCurrencies() {
      return _ref4.apply(this, arguments);
    }

    return loadStoreCurrencies;
  }();

  return Store;
}();

var storeService = new Store();

var _this$2 = undefined;

var getUserOrdersSummary = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/summary");

          case 2:
            return _context.abrupt("return", _context.sent);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, _this$2);
  }));

  return function getUserOrdersSummary() {
    return _ref.apply(this, arguments);
  };
}();

var addOrderItem = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(productID) {
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/draft/items?productID=" + productID);

          case 2:
            return _context2.abrupt("return", _context2.sent);

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, _this$2);
  }));

  return function addOrderItem(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var getOrderItem = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID);

          case 2:
            return _context3.abrupt("return", _context3.sent);

          case 3:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, _this$2);
  }));

  return function getOrderItem(_x2) {
    return _ref3.apply(this, arguments);
  };
}();

var updateOrderItem = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(orderItemID, orderItem) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.put(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID, orderItem);

          case 2:
            return _context4.abrupt("return", _context4.sent);

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, _this$2);
  }));

  return function updateOrderItem(_x3, _x4) {
    return _ref4.apply(this, arguments);
  };
}();

var getPriceOrderItem = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(orderItemID, orderItem) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/price/calculate", orderItem);

          case 2:
            return _context5.abrupt("return", _context5.sent);

          case 3:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5, _this$2);
  }));

  return function getPriceOrderItem(_x5, _x6) {
    return _ref5.apply(this, arguments);
  };
}();

var reorder = function () {
  var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee6(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            _context6.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/submitted/items/" + orderItemID + "/reorder");

          case 2:
            return _context6.abrupt("return", _context6.sent);

          case 3:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6, _this$2);
  }));

  return function reorder(_x7) {
    return _ref6.apply(this, arguments);
  };
}();

var getLastOrder = function () {
  var _ref7 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee7(productID) {
    return _regeneratorRuntime.wrap(function _callee7$(_context7) {
      while (1) {
        switch (_context7.prev = _context7.next) {
          case 0:
            _context7.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/submitted/items/last/status?productID=" + productID);

          case 2:
            return _context7.abrupt("return", _context7.sent);

          case 3:
          case "end":
            return _context7.stop();
        }
      }
    }, _callee7, _this$2);
  }));

  return function getLastOrder(_x8) {
    return _ref7.apply(this, arguments);
  };
}();

var addToCart = function () {
  var _ref8 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee8(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee8$(_context8) {
      while (1) {
        switch (_context8.prev = _context8.next) {
          case 0:
            _context8.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/addToCart");

          case 2:
            return _context8.abrupt("return", _context8.sent);

          case 3:
          case "end":
            return _context8.stop();
        }
      }
    }, _callee8, _this$2);
  }));

  return function addToCart(_x9) {
    return _ref8.apply(this, arguments);
  };
}();

var saveForLater = function () {
  var _ref9 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee9(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee9$(_context9) {
      while (1) {
        switch (_context9.prev = _context9.next) {
          case 0:
            _context9.next = 2;
            return http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/saveForLater");

          case 2:
            return _context9.abrupt("return", _context9.sent);

          case 3:
          case "end":
            return _context9.stop();
        }
      }
    }, _callee9, _this$2);
  }));

  return function saveForLater(_x10) {
    return _ref9.apply(this, arguments);
  };
}();

var getDeliveryServices = function () {
  var _ref10 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee10(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee10$(_context10) {
      while (1) {
        switch (_context10.prev = _context10.next) {
          case 0:
            _context10.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/deliveryServices");

          case 2:
            return _context10.abrupt("return", _context10.sent);

          case 3:
          case "end":
            return _context10.stop();
        }
      }
    }, _callee10, _this$2);
  }));

  return function getDeliveryServices(_x11) {
    return _ref10.apply(this, arguments);
  };
}();

var _this$3 = undefined;

var getProductIDByFriendlyID = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(friendlyID) {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/products/id?friendlyID=" + friendlyID);

          case 2:
            return _context.abrupt("return", _context.sent);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, _this$3);
  }));

  return function getProductIDByFriendlyID(_x) {
    return _ref.apply(this, arguments);
  };
}();

var getProducts = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryID, pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context2.next = 3;
            return http.get(config.getValue('apiUrl') + "/v1/store/categories/" + categoryID + "/products" + (params.length ? "?" + params : ''));

          case 3:
            return _context2.abrupt("return", _context2.sent);

          case 4:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, _this$3);
  }));

  return function getProducts(_x2, _x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();

var getProductsByIDs = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(IDs) {
    var sIDs;
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            sIDs = IDs.map(function (val, ind) {
              return "productIDs[" + ind + "]=" + val;
            }).join('&');
            _context3.next = 3;
            return http.get(config.getValue('apiUrl') + "/v1/store/products?" + sIDs);

          case 3:
            return _context3.abrupt("return", _context3.sent);

          case 4:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, _this$3);
  }));

  return function getProductsByIDs(_x5) {
    return _ref3.apply(this, arguments);
  };
}();

var getProductByID = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(productID, retrieveTypeSpecificData) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/products/" + productID + "?retrieveTypeSpecificData=" + retrieveTypeSpecificData);

          case 2:
            return _context4.abrupt("return", _context4.sent);

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, _this$3);
  }));

  return function getProductByID(_x6, _x7) {
    return _ref4.apply(this, arguments);
  };
}();

var getProductThumbnails = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(productID) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.get(config.getValue('apiUrl') + "/v1/store/products/" + productID + "/thumbnails");

          case 2:
            return _context5.abrupt("return", _context5.sent);

          case 3:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5, _this$3);
  }));

  return function getProductThumbnails(_x8) {
    return _ref5.apply(this, arguments);
  };
}();

var search = function () {
  var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee6(_search, pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            params = convertObjectToQueryString({ search: _search, pageNumber: pageNumber, pageSize: pageSize });
            _context6.next = 3;
            return http.get(config.getValue('apiUrl') + "/v1/store/products/search" + (params.length ? "?" + params : ''));

          case 3:
            return _context6.abrupt("return", _context6.sent);

          case 4:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6, _this$3);
  }));

  return function search(_x9, _x10, _x11) {
    return _ref6.apply(this, arguments);
  };
}();

var productType = {
  Undefined: -1,
  Dynamic: 1,
  Static: 2,
  Email: 3,
  Uploaded: 4,
  Composite: 5,
  DynamicWithPurl: 6,
  EmailWithPurl: 7,
  CircleProject: 8,
  PrintTouchPoint: 9,
  EmailTouchPoint: 10,
  WebTouchPoint: 11,
  PdfOnDemandTouchPoint: 12,
  TriggeredEmailTouchPoint: 13,
  Kit: 14
};

var api = {

  categories: {
    getTopCategories: getTopCategories,
    getSubCategories: getSubCategories,
    getCategoryIDByFriendlyID: getCategoryIDByFriendlyID,
    getCategory: getCategory,
    getCategoryTree: getCategoryTree
  },
  orders: {
    getUserOrdersSummary: getUserOrdersSummary,
    addOrderItem: addOrderItem,
    getOrderItem: getOrderItem,
    updateOrderItem: updateOrderItem,
    getPriceOrderItem: getPriceOrderItem,
    reorder: reorder,
    getLastOrder: getLastOrder,
    addToCart: addToCart,
    saveForLater: saveForLater,
    getDeliveryServices: getDeliveryServices
  },
  products: {
    getProductIDByFriendlyID: getProductIDByFriendlyID,
    getProducts: getProducts,
    getProductByID: getProductByID,
    productType: productType,
    getProductsByIDs: getProductsByIDs,
    getProductThumbnails: getProductThumbnails,
    search: search
  },
  store: {
    getCurrentStore: getCurrentStore,
    getCurrentUser: getCurrentUser,
    getCultures: getCultures,
    getCurrencies: getCurrencies,
    renewToken: renewToken
  }

};

var InitialState = function () {
  function InitialState() {
    _classCallCheck(this, InitialState);
  }

  InitialState.prototype.loadInitialState = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var currencyFriendlyID, currentCurrency, currencyID;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return storeService.loadCurrentStore();

            case 2:
              _context.next = 4;
              return storeService.loadStoreCultures();

            case 4:

              cultureService.setCurrentCultureByLanguage(contextService.getValue('languageCode'));

              _context.next = 7;
              return storeService.loadStoreCurrencies();

            case 7:
              currencyFriendlyID = contextService.getValue('currencyFriendlyID');
              currentCurrency = providerState.get().currencies.filter(function (c) {
                return c.FriendlyID === parseInt(currencyFriendlyID);
              })[0];
              currencyID = contextService.getValue('currencyID');


              if (currencyID) {
                currentCurrency = providerState.get().currencies.filter(function (c) {
                  return c.ID === currencyID;
                })[0];
              }
              cultureService.setCurrentCurrency(currentCurrency);

              _context.next = 14;
              return storeService.loadCurrentUser();

            case 14:

              //raise flag that initial state was loaded in order not to do it again
              providerState.setInitState();

            case 15:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadInitialState() {
      return _ref.apply(this, arguments);
    }

    return loadInitialState;
  }();

  return InitialState;
}();

var initialStateService = new InitialState();

var newState = {
  culture: cultureService,
  store: storeService,
  categories: categories,
  products: products,
  get: function get() {
    return providerState.get();
  },
  set: function set(state) {
    return providerState.set(state);
  },
  dispatch: providerState.dispatch,
  subscribe: providerState.subscribe,
  customState: {
    set: function set(name, value) {
      return providerState.setCustomState(name, value);
    },
    setBulk: function setBulk(obj) {
      return providerState.setBulkCustomState(obj);
    },
    get: function get(name) {
      return name ? providerState.get().customState[name] : providerState.get().customState;
    },
    delete: function _delete(name) {
      return providerState.deleteCustomState(name);
    },
    merge: function merge(customState) {
      return providerState.mergeCustomState(customState);
    }
  }
};

/**
 * UStoreProvider - This is the uStore provider - the entry point to all ustore API's
 */

var Provider = function () {
  function Provider() {
    _classCallCheck(this, Provider);

    this.stateService = providerState;
    this.binding = bindingService;
    this.initialState = initialStateService;
    this.configService = config;
    this.contextService = contextService;
  }

  Provider.prototype.init = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(runtimeConfig, params) {
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (runtimeConfig) {
                this.configService.set(runtimeConfig);
              }

              if (!params) {
                _context.next = 6;
                break;
              }

              this.contextService.set(params);

              if (!this.stateService.get().initState) {
                _context.next = 6;
                break;
              }

              _context.next = 6;
              return this.initialState.loadInitialState();

            case 6:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function init(_x, _x2) {
      return _ref.apply(this, arguments);
    }

    return init;
  }();

  _createClass(Provider, [{
    key: 'api',
    get: function get$$1() {
      return api;
    }
  }, {
    key: 'state',
    get: function get$$1() {
      return newState;
    }
  }]);

  return Provider;
}();

var UStoreProvider = new Provider();
//expose UStoreProvider on window so standalone component will have access to it
//which will allow them to register and let the provider add model binding and
//action changing
if (typeof window !== 'undefined') {
  window.UStoreProvider = UStoreProvider;
}

export { http, UStoreProvider };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
