'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _object = require('object.assign');

var _object2 = _interopRequireDefault(_object);

var _cheerio = require('cheerio');

var _cheerio2 = _interopRequireDefault(_cheerio);

var _arrayPrototype = require('array.prototype.flat');

var _arrayPrototype2 = _interopRequireDefault(_arrayPrototype);

var _has = require('has');

var _has2 = _interopRequireDefault(_has);

var _Utils = require('./Utils');

var _getAdapter = require('./getAdapter');

var _getAdapter2 = _interopRequireDefault(_getAdapter);

var _Debug = require('./Debug');

var _RSTTraversal = require('./RSTTraversal');

var _selectors = require('./selectors');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var NODE = (0, _Utils.sym)('__node__');
var NODES = (0, _Utils.sym)('__nodes__');
var RENDERER = (0, _Utils.sym)('__renderer__');
var UNRENDERED = (0, _Utils.sym)('__unrendered__');
var ROOT = (0, _Utils.sym)('__root__');
var OPTIONS = (0, _Utils.sym)('__options__');
var ROOT_NODES = (0, _Utils.sym)('__rootNodes__');
var WRAPPING_COMPONENT = (0, _Utils.sym)('__wrappingComponent__');
var LINKED_ROOTS = (0, _Utils.sym)('__linkedRoots__');
var UPDATED_BY = (0, _Utils.sym)('__updatedBy__');

/**
 * Finds all nodes in the current wrapper nodes' render trees that match the provided predicate
 * function.
 *
 * @param {ReactWrapper} wrapper
 * @param {Function} predicate
 * @param {Function} filter
 * @returns {ReactWrapper}
 */
function findWhereUnwrapped(wrapper, predicate) {
  var filter = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _RSTTraversal.treeFilter;

  return wrapper.flatMap(function (n) {
    return filter(n.getNodeInternal(), predicate);
  });
}

/**
 * Returns a new wrapper instance with only the nodes of the current wrapper instance that match
 * the provided predicate function.
 *
 * @param {ReactWrapper} wrapper
 * @param {Function} predicate
 * @returns {ReactWrapper}
 */
function filterWhereUnwrapped(wrapper, predicate) {
  return wrapper.wrap(wrapper.getNodesInternal().filter(predicate).filter(Boolean));
}

function getRootNodeInternal(wrapper) {
  if (wrapper[ROOT].length !== 1) {
    throw new Error('getRootNodeInternal(wrapper) can only be called when wrapper wraps one node');
  }
  if (wrapper[ROOT] !== wrapper) {
    return wrapper[ROOT_NODES][0];
  }
  return wrapper[ROOT][NODE];
}

function nodeParents(wrapper, node) {
  return (0, _RSTTraversal.parentsOfNode)(node, getRootNodeInternal(wrapper));
}

function privateSetNodes(wrapper, nodes) {
  if (!nodes) {
    (0, _Utils.privateSet)(wrapper, NODE, null);
    (0, _Utils.privateSet)(wrapper, NODES, []);
  } else if (!Array.isArray(nodes)) {
    (0, _Utils.privateSet)(wrapper, NODE, nodes);
    (0, _Utils.privateSet)(wrapper, NODES, [nodes]);
  } else {
    (0, _Utils.privateSet)(wrapper, NODE, nodes[0]);
    (0, _Utils.privateSet)(wrapper, NODES, nodes);
  }
  (0, _Utils.privateSet)(wrapper, 'length', wrapper[NODES].length);
}

/**
 * @class ReactWrapper
 */

var ReactWrapper = function () {
  function ReactWrapper(nodes, root) {
    var passedOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    _classCallCheck(this, ReactWrapper);

    if (!global.window && !global.document) {
      throw new Error('It looks like you called `mount()` without a global document being loaded.');
    }
    var options = (0, _Utils.makeOptions)(passedOptions);

    if (!root) {
      var adapter = (0, _getAdapter2['default'])(options);
      if (!adapter.isValidElement(nodes)) {
        throw new TypeError('ReactWrapper can only wrap valid elements');
      }

      var renderer = adapter.createRenderer((0, _object2['default'])({ mode: 'mount' }, options));
      (0, _Utils.privateSet)(this, RENDERER, renderer);
      renderer.render(nodes, options.context);
      (0, _Utils.privateSet)(this, ROOT, this);
      privateSetNodes(this, this[RENDERER].getNode());
      (0, _Utils.privateSet)(this, OPTIONS, options);
      (0, _Utils.privateSet)(this, LINKED_ROOTS, []);

      if ((0, _Utils.isCustomComponent)(options.wrappingComponent, adapter)) {
        if (typeof this[RENDERER].getWrappingComponentRenderer !== 'function') {
          throw new TypeError('your adapter does not support `wrappingComponent`. Try upgrading it!');
        }

        // eslint-disable-next-line no-use-before-define
        (0, _Utils.privateSet)(this, WRAPPING_COMPONENT, new WrappingComponentWrapper(this, this[RENDERER].getWrappingComponentRenderer()));
        this[LINKED_ROOTS].push(this[WRAPPING_COMPONENT]);
      }
    } else {
      (0, _Utils.privateSet)(this, RENDERER, root[RENDERER]);
      (0, _Utils.privateSet)(this, ROOT, root);
      privateSetNodes(this, nodes);
      (0, _Utils.privateSet)(this, ROOT_NODES, root[NODES]);
      (0, _Utils.privateSet)(this, OPTIONS, root[OPTIONS]);
      (0, _Utils.privateSet)(this, LINKED_ROOTS, []);
    }
    (0, _Utils.privateSet)(this, UNRENDERED, nodes);
    (0, _Utils.privateSet)(this, UPDATED_BY, null);
  }

  /**
   * Returns the root wrapper
   *
   * @return {ReactWrapper}
   */


  _createClass(ReactWrapper, [{
    key: 'root',
    value: function () {
      function root() {
        return this[ROOT];
      }

      return root;
    }()

    /**
     * Returns the wrapped component.
     *
     * @return {ReactComponent}
     */

  }, {
    key: 'getNodeInternal',
    value: function () {
      function getNodeInternal() {
        if (this.length !== 1) {
          throw new Error('ReactWrapper::getNode() can only be called when wrapping one node');
        }
        return this[NODES][0];
      }

      return getNodeInternal;
    }()

    /**
     * Returns the the wrapped components.
     *
     * @return {Array<ReactComponent>}
     */

  }, {
    key: 'getNodesInternal',
    value: function () {
      function getNodesInternal() {
        return this[NODES];
      }

      return getNodesInternal;
    }()

    /**
     * Returns the wrapped ReactElement.
     *
     * @return {ReactElement}
     */

  }, {
    key: 'getElement',
    value: function () {
      function getElement() {
        var _this = this;

        return this.single('getElement', function () {
          return (0, _getAdapter2['default'])(_this[OPTIONS]).nodeToElement(_this[NODE]);
        });
      }

      return getElement;
    }()

    /**
     * Returns the wrapped ReactElements.
     *
     * @return {Array<ReactElement>}
     */

  }, {
    key: 'getElements',
    value: function () {
      function getElements() {
        var _this2 = this;

        return this[NODES].map(function (n) {
          return (0, _getAdapter2['default'])(_this2[OPTIONS]).nodeToElement(n);
        });
      }

      return getElements;
    }()

    // eslint-disable-next-line class-methods-use-this

  }, {
    key: 'getNode',
    value: function () {
      function getNode() {
        throw new Error('ReactWrapper::getNode() is no longer supported. Use ReactWrapper::instance() instead');
      }

      return getNode;
    }()

    // eslint-disable-next-line class-methods-use-this

  }, {
    key: 'getNodes',
    value: function () {
      function getNodes() {
        throw new Error('ReactWrapper::getNodes() is no longer supported.');
      }

      return getNodes;
    }()

    /**
     * Returns the outer most DOMComponent of the current wrapper.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @returns {DOMComponent}
     */

  }, {
    key: 'getDOMNode',
    value: function () {
      function getDOMNode() {
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        return this.single('getDOMNode', function (n) {
          return adapter.nodeToHostNode(n, true);
        });
      }

      return getDOMNode;
    }()

    /**
     * If the root component contained a ref, you can access it here and get the relevant
     * react component instance or HTML element instance.
     *
     * NOTE: can only be called on a wrapper instance that is also the root instance.
     *
     * @param {String} refname
     * @returns {ReactComponent | HTMLElement}
     */

  }, {
    key: 'ref',
    value: function () {
      function ref(refname) {
        if (this[ROOT] !== this) {
          throw new Error('ReactWrapper::ref(refname) can only be called on the root');
        }
        return this.instance().refs[refname];
      }

      return ref;
    }()

    /**
     * Returns the wrapper's underlying instance.
     *
     * Example:
     * ```
     * const wrapper = mount(<MyComponent />);
     * const inst = wrapper.instance();
     * expect(inst).to.be.instanceOf(MyComponent);
     * ```
     * @returns {ReactComponent|DOMComponent}
     */

  }, {
    key: 'instance',
    value: function () {
      function instance() {
        var _this3 = this;

        return this.single('instance', function () {
          return _this3[NODE].instance;
        });
      }

      return instance;
    }()

    /**
     * If a `wrappingComponent` was passed in `options`, this methods returns a `ReactWrapper` around
     * the rendered `wrappingComponent`. This `ReactWrapper` can be used to update the
     * `wrappingComponent`'s props, state, etc.
     *
     * @returns ReactWrapper
     */

  }, {
    key: 'getWrappingComponent',
    value: function () {
      function getWrappingComponent() {
        if (this[ROOT] !== this) {
          throw new Error('ReactWrapper::getWrappingComponent() can only be called on the root');
        }
        if (!this[OPTIONS].wrappingComponent) {
          throw new Error('ReactWrapper::getWrappingComponent() can only be called on a wrapper that was originally passed a `wrappingComponent` option');
        }
        return this[WRAPPING_COMPONENT];
      }

      return getWrappingComponent;
    }()

    /**
     * Forces a re-render. Useful to run before checking the render output if something external
     * may be updating the state of the component somewhere.
     *
     * NOTE: no matter what instance this is called on, it will always update the root.
     *
     * @returns {ReactWrapper}
     */

  }, {
    key: 'update',
    value: function () {
      function update() {
        var _this4 = this;

        var root = this[ROOT];
        if (this !== root) {
          return root.update();
        }
        privateSetNodes(this, this[RENDERER].getNode());
        this[LINKED_ROOTS].forEach(function (linkedRoot) {
          if (linkedRoot !== _this4[UPDATED_BY]) {
            /* eslint-disable no-param-reassign */
            // Only update a linked it root if it is not the originator of our update().
            // This is needed to prevent infinite recursion when there is a bi-directional
            // link between two roots.
            linkedRoot[UPDATED_BY] = _this4;
            try {
              linkedRoot.update();
            } finally {
              linkedRoot[UPDATED_BY] = null;
            }
          }
        });
        return this;
      }

      return update;
    }()

    /**
     * A method that unmounts the component. This can be used to simulate a component going through
     * and unmount/mount lifecycle.
     *
     * @returns {ReactWrapper}
     */

  }, {
    key: 'unmount',
    value: function () {
      function unmount() {
        var _this5 = this;

        if (this[ROOT] !== this) {
          throw new Error('ReactWrapper::unmount() can only be called on the root');
        }
        this.single('unmount', function () {
          _this5[RENDERER].unmount();
          _this5.update();
        });
        return this;
      }

      return unmount;
    }()

    /**
     * A method that re-mounts the component, if it is not currently mounted.
     * This can be used to simulate a component going through
     * an unmount/mount lifecycle.
     *
     * @returns {ReactWrapper}
     */

  }, {
    key: 'mount',
    value: function () {
      function mount() {
        var _this6 = this;

        if (this[ROOT] !== this) {
          throw new Error('ReactWrapper::mount() can only be called on the root');
        }
        this[RENDERER].render(this[UNRENDERED], this[OPTIONS].context, function () {
          return _this6.update();
        });
        return this;
      }

      return mount;
    }()

    /**
     * A method that sets the props of the root component, and re-renders. Useful for when you are
     * wanting to test how the component behaves over time with changing props. Calling this, for
     * instance, will call the `componentWillReceiveProps` lifecycle method.
     *
     * Similar to `setState`, this method accepts a props object and will merge it in with the already
     * existing props.
     *
     * NOTE: can only be called on a wrapper instance that is also the root instance.
     *
     * @param {Object} props object
     * @param {Function} cb - callback function
     * @returns {ReactWrapper}
     */

  }, {
    key: 'setProps',
    value: function () {
      function setProps(props) {
        var _this7 = this;

        var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

        if (this[ROOT] !== this) {
          throw new Error('ReactWrapper::setProps() can only be called on the root');
        }
        if (arguments.length > 1 && typeof callback !== 'function') {
          throw new TypeError('ReactWrapper::setProps() expects a function as its second argument');
        }
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        this[UNRENDERED] = (0, _Utils.cloneElement)(adapter, this[UNRENDERED], props);
        this[RENDERER].render(this[UNRENDERED], null, function () {
          _this7.update();
          if (callback) {
            callback();
          }
        });
        return this;
      }

      return setProps;
    }()

    /**
     * A method to invoke `setState` on the root component instance similar to how you might in the
     * definition of the component, and re-renders.  This method is useful for testing your component
     * in hard to achieve states, however should be used sparingly. If possible, you should utilize
     * your component's external API in order to get it into whatever state you want to test, in order
     * to be as accurate of a test as possible. This is not always practical, however.
     *
     * NOTE: can only be called on a wrapper instance that is also the root instance.
     *
     * @param {Object} state to merge
     * @param {Function} cb - callback function
     * @returns {ReactWrapper}
     */

  }, {
    key: 'setState',
    value: function () {
      function setState(state) {
        var _this8 = this;

        var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

        if (this.instance() === null || this.getNodeInternal().nodeType !== 'class') {
          throw new Error('ReactWrapper::setState() can only be called on class components');
        }
        if (arguments.length > 1 && typeof callback !== 'function') {
          throw new TypeError('ReactWrapper::setState() expects a function as its second argument');
        }
        this.instance().setState(state, function () {
          _this8.update();
          if (callback) {
            var adapter = (0, _getAdapter2['default'])(_this8[OPTIONS]);
            var instance = _this8.instance();
            if (adapter.invokeSetStateCallback) {
              adapter.invokeSetStateCallback(instance, callback);
            } else {
              callback.call(instance);
            }
          }
        });
        return this;
      }

      return setState;
    }()

    /**
     * A method that sets the context of the root component, and re-renders. Useful for when you are
     * wanting to test how the component behaves over time with changing contexts.
     *
     * NOTE: can only be called on a wrapper instance that is also the root instance.
     *
     * @param {Object} context object
     * @returns {ReactWrapper}
     */

  }, {
    key: 'setContext',
    value: function () {
      function setContext(context) {
        var _this9 = this;

        if (this[ROOT] !== this) {
          throw new Error('ReactWrapper::setContext() can only be called on the root');
        }
        if (!this[OPTIONS].context) {
          throw new Error('ReactWrapper::setContext() can only be called on a wrapper that was originally passed a context option');
        }
        this[RENDERER].render(this[UNRENDERED], context, function () {
          return _this9.update();
        });
        return this;
      }

      return setContext;
    }()

    /**
     * Whether or not a given react element exists in the mount render tree.
     *
     * Example:
     * ```
     * const wrapper = mount(<MyComponent />);
     * expect(wrapper.contains(<div className="foo bar" />)).to.equal(true);
     * ```
     *
     * @param {ReactElement|Array<ReactElement>} nodeOrNodes
     * @returns {Boolean}
     */

  }, {
    key: 'contains',
    value: function () {
      function contains(nodeOrNodes) {
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);

        var predicate = Array.isArray(nodeOrNodes) ? function (other) {
          return (0, _Utils.containsChildrenSubArray)(_Utils.nodeEqual, other, nodeOrNodes.map(function (node) {
            return adapter.elementToNode(node);
          }));
        } : function (other) {
          return (0, _Utils.nodeEqual)(adapter.elementToNode(nodeOrNodes), other);
        };

        return findWhereUnwrapped(this, predicate).length > 0;
      }

      return contains;
    }()

    /**
     * Whether or not a given react element exists in the current render tree.
     * It will determine if one of the wrappers element "looks like" the expected
     * element by checking if all props of the expected element are present
     * on the wrappers element and equals to each other.
     *
     * Example:
     * ```
     * // MyComponent outputs <div><div class="foo">Hello</div></div>
     * const wrapper = mount(<MyComponent />);
     * expect(wrapper.containsMatchingElement(<div>Hello</div>)).to.equal(true);
     * ```
     *
     * @param {ReactElement} node
     * @returns {Boolean}
     */

  }, {
    key: 'containsMatchingElement',
    value: function () {
      function containsMatchingElement(node) {
        var rstNode = (0, _getAdapter2['default'])(this[OPTIONS]).elementToNode(node);
        var predicate = function () {
          function predicate(other) {
            return (0, _Utils.nodeMatches)(rstNode, other, function (a, b) {
              return a <= b;
            });
          }

          return predicate;
        }();
        return findWhereUnwrapped(this, predicate).length > 0;
      }

      return containsMatchingElement;
    }()

    /**
     * Whether or not all the given react elements exists in the current render tree.
     * It will determine if one of the wrappers element "looks like" the expected
     * element by checking if all props of the expected element are present
     * on the wrappers element and equals to each other.
     *
     * Example:
     * ```
     * const wrapper = mount(<MyComponent />);
     * expect(wrapper.containsAllMatchingElements([
     *   <div>Hello</div>,
     *   <div>Goodbye</div>,
     * ])).to.equal(true);
     * ```
     *
     * @param {Array<ReactElement>} nodes
     * @returns {Boolean}
     */

  }, {
    key: 'containsAllMatchingElements',
    value: function () {
      function containsAllMatchingElements(nodes) {
        var _this10 = this;

        if (!Array.isArray(nodes)) {
          throw new TypeError('nodes should be an Array');
        }

        return nodes.every(function (node) {
          return _this10.containsMatchingElement(node);
        });
      }

      return containsAllMatchingElements;
    }()

    /**
     * Whether or not one of the given react elements exists in the current render tree.
     * It will determine if one of the wrappers element "looks like" the expected
     * element by checking if all props of the expected element are present
     * on the wrappers element and equals to each other.
     *
     * Example:
     * ```
     * const wrapper = mount(<MyComponent />);
     * expect(wrapper.containsAnyMatchingElements([
     *   <div>Hello</div>,
     *   <div>Goodbye</div>,
     * ])).to.equal(true);
     * ```
     *
     * @param {Array<ReactElement>} nodes
     * @returns {Boolean}
     */

  }, {
    key: 'containsAnyMatchingElements',
    value: function () {
      function containsAnyMatchingElements(nodes) {
        var _this11 = this;

        return Array.isArray(nodes) && nodes.some(function (node) {
          return _this11.containsMatchingElement(node);
        });
      }

      return containsAnyMatchingElements;
    }()

    /**
     * Whether or not a given react element exists in the render tree.
     *
     * Example:
     * ```
     * const wrapper = mount(<MyComponent />);
     * expect(wrapper.contains(<div className="foo bar" />)).to.equal(true);
     * ```
     *
     * @param {ReactElement} node
     * @returns {Boolean}
     */

  }, {
    key: 'equals',
    value: function () {
      function equals(node) {
        var _this12 = this;

        return this.single('equals', function () {
          return (0, _Utils.nodeEqual)(_this12.getNodeInternal(), node);
        });
      }

      return equals;
    }()

    /**
     * Whether or not a given react element matches the render tree.
     * Match is based on the expected element and not on wrapper root node.
     * It will determine if the wrapper root node "looks like" the expected
     * element by checking if all props of the expected element are present
     * on the wrapper root node and equals to each other.
     *
     * Example:
     * ```
     * // MyComponent outputs <div class="foo">Hello</div>
     * const wrapper = mount(<MyComponent />);
     * expect(wrapper.matchesElement(<div>Hello</div>)).to.equal(true);
     * ```
     *
     * @param {ReactElement} node
     * @returns {Boolean}
     */

  }, {
    key: 'matchesElement',
    value: function () {
      function matchesElement(node) {
        var _this13 = this;

        return this.single('matchesElement', function () {
          var adapter = (0, _getAdapter2['default'])(_this13[OPTIONS]);
          var rstNode = adapter.elementToNode(node);
          return (0, _Utils.nodeMatches)(rstNode, _this13.getNodeInternal(), function (a, b) {
            return a <= b;
          });
        });
      }

      return matchesElement;
    }()

    /**
     * Finds every node in the render tree of the current wrapper that matches the provided selector.
     *
     * @param {EnzymeSelector} selector
     * @returns {ReactWrapper}
     */

  }, {
    key: 'find',
    value: function () {
      function find(selector) {
        return this.wrap((0, _selectors.reduceTreesBySelector)(selector, this.getNodesInternal()));
      }

      return find;
    }()

    /**
     * Returns whether or not current node matches a provided selector.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @param {EnzymeSelector} selector
     * @returns {boolean}
     */

  }, {
    key: 'is',
    value: function () {
      function is(selector) {
        var predicate = (0, _selectors.buildPredicate)(selector);
        return this.single('is', function (n) {
          return predicate(n);
        });
      }

      return is;
    }()

    /**
     * Returns true if the component rendered nothing, i.e., null or false.
     *
     * @returns {boolean}
     */

  }, {
    key: 'isEmptyRender',
    value: function () {
      function isEmptyRender() {
        var nodes = this.getNodeInternal();

        return (0, _Utils.renderedDive)(nodes);
      }

      return isEmptyRender;
    }()

    /**
     * Returns a new wrapper instance with only the nodes of the current wrapper instance that match
     * the provided predicate function.
     *
     * @param {Function} predicate
     * @returns {ReactWrapper}
     */

  }, {
    key: 'filterWhere',
    value: function () {
      function filterWhere(predicate) {
        var _this14 = this;

        return filterWhereUnwrapped(this, function (n) {
          return predicate(_this14.wrap(n));
        });
      }

      return filterWhere;
    }()

    /**
     * Returns a new wrapper instance with only the nodes of the current wrapper instance that match
     * the provided selector.
     *
     * @param {EnzymeSelector} selector
     * @returns {ReactWrapper}
     */

  }, {
    key: 'filter',
    value: function () {
      function filter(selector) {
        var predicate = (0, _selectors.buildPredicate)(selector);
        return filterWhereUnwrapped(this, predicate);
      }

      return filter;
    }()

    /**
     * Returns a new wrapper instance with only the nodes of the current wrapper that did not match
     * the provided selector. Essentially the inverse of `filter`.
     *
     * @param {EnzymeSelector} selector
     * @returns {ReactWrapper}
     */

  }, {
    key: 'not',
    value: function () {
      function not(selector) {
        var predicate = (0, _selectors.buildPredicate)(selector);
        return filterWhereUnwrapped(this, function (n) {
          return !predicate(n);
        });
      }

      return not;
    }()

    /**
     * Returns a string of the rendered text of the current render tree.  This function should be
     * looked at with skepticism if being used to test what the actual HTML output of the component
     * will be. If that is what you would like to test, use enzyme's `render` function instead.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @returns {String}
     */

  }, {
    key: 'text',
    value: function () {
      function text() {
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        return this.single('text', function (n) {
          return (0, _RSTTraversal.getTextFromHostNodes)(n, adapter);
        });
      }

      return text;
    }()

    /**
     * Returns the HTML of the node.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @returns {String}
     */

  }, {
    key: 'html',
    value: function () {
      function html() {
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        return this.single('html', function (n) {
          return (0, _RSTTraversal.getHTMLFromHostNodes)(n, adapter);
        });
      }

      return html;
    }()

    /**
     * Returns the current node rendered to HTML and wrapped in a CheerioWrapper.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @returns {CheerioWrapper}
     */

  }, {
    key: 'render',
    value: function () {
      function render() {
        var html = this.html();
        return html === null ? (0, _cheerio2['default'])() : _cheerio2['default'].load('')(html);
      }

      return render;
    }()

    /**
     * Used to simulate events. Pass an eventname and (optionally) event arguments. This method of
     * testing events should be met with some skepticism.
     *
     * @param {String} event
     * @param {Object} mock (optional)
     * @returns {ReactWrapper}
     */

  }, {
    key: 'simulate',
    value: function () {
      function simulate(event) {
        var _this15 = this;

        var mock = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        return this.single('simulate', function (n) {
          _this15[RENDERER].simulateEvent(n, event, mock);
          _this15[ROOT].update();
          return _this15;
        });
      }

      return simulate;
    }()

    /**
     * Used to simulate throwing a rendering error. Pass an error to throw.
     *
     * @param {String} error
     * @returns {ReactWrapper}
     */

  }, {
    key: 'simulateError',
    value: function () {
      function simulateError(error) {
        var _this16 = this;

        if (this[ROOT] === this) {
          throw new Error('ReactWrapper::simulateError() may not be called on the root');
        }

        return this.single('simulateError', function (thisNode) {
          if (thisNode.nodeType === 'host') {
            throw new Error('ReactWrapper::simulateError() can only be called on custom components');
          }

          var renderer = _this16[RENDERER];
          if (typeof renderer.simulateError !== 'function') {
            throw new TypeError('your adapter does not support `simulateError`. Try upgrading it!');
          }

          var rootNode = getRootNodeInternal(_this16);
          var nodeHierarchy = [thisNode].concat(nodeParents(_this16, thisNode));
          renderer.simulateError(nodeHierarchy, rootNode, error);

          _this16[ROOT].update();
          return _this16;
        });
      }

      return simulateError;
    }()

    /**
     * Returns the props hash for the root node of the wrapper.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @returns {Object}
     */

  }, {
    key: 'props',
    value: function () {
      function props() {
        return this.single('props', _RSTTraversal.propsOfNode);
      }

      return props;
    }()

    /**
     * Returns the state hash for the root node of the wrapper. Optionally pass in a prop name and it
     * will return just that value.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @param {String} name (optional)
     * @returns {*}
     */

  }, {
    key: 'state',
    value: function () {
      function state(name) {
        var _this17 = this;

        var thisNode = this[ROOT] === this ? this[RENDERER].getNode() : this.getNodeInternal();
        if (this.instance() === null || thisNode.nodeType !== 'class') {
          throw new Error('ReactWrapper::state() can only be called on class components');
        }
        var _state = this.single('state', function () {
          return _this17.instance().state;
        });
        if (typeof name !== 'undefined') {
          if (_state == null) {
            throw new TypeError('ReactWrapper::state("' + String(name) + '") requires that `state` not be `null` or `undefined`');
          }
          return _state[name];
        }
        return _state;
      }

      return state;
    }()

    /**
     * Returns the context hash for the root node of the wrapper.
     * Optionally pass in a prop name and it will return just that value.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @param {String} name (optional)
     * @returns {*}
     */

  }, {
    key: 'context',
    value: function () {
      function context(name) {
        var _this18 = this;

        if (this[ROOT] !== this) {
          throw new Error('ReactWrapper::context() can only be called on the root');
        }
        var instance = this.single('context', function () {
          return _this18.instance();
        });
        if (instance === null) {
          throw new Error('ReactWrapper::context() can only be called on components with instances');
        }
        var _context = instance.context;
        if (typeof name !== 'undefined') {
          return _context[name];
        }
        return _context;
      }

      return context;
    }()

    /**
     * Returns a new wrapper with all of the children of the current wrapper.
     *
     * @param {EnzymeSelector} [selector]
     * @returns {ReactWrapper}
     */

  }, {
    key: 'children',
    value: function () {
      function children(selector) {
        var allChildren = this.flatMap(function (n) {
          return (0, _RSTTraversal.childrenOfNode)(n.getNodeInternal()).filter(function (x) {
            return (typeof x === 'undefined' ? 'undefined' : _typeof(x)) === 'object';
          });
        });
        return selector ? allChildren.filter(selector) : allChildren;
      }

      return children;
    }()

    /**
     * Returns a new wrapper with a specific child
     *
     * @param {Number} [index]
     * @returns {ReactWrapper}
     */

  }, {
    key: 'childAt',
    value: function () {
      function childAt(index) {
        var _this19 = this;

        return this.single('childAt', function () {
          return _this19.children().at(index);
        });
      }

      return childAt;
    }()

    /**
     * Returns a wrapper around all of the parents/ancestors of the wrapper. Does not include the node
     * in the current wrapper.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @param {EnzymeSelector} [selector]
     * @returns {ReactWrapper}
     */

  }, {
    key: 'parents',
    value: function () {
      function parents(selector) {
        var _this20 = this;

        return this.single('parents', function (n) {
          var allParents = _this20.wrap(nodeParents(_this20, n));
          return selector ? allParents.filter(selector) : allParents;
        });
      }

      return parents;
    }()

    /**
     * Returns a wrapper around the immediate parent of the current node.
     *
     * @returns {ReactWrapper}
     */

  }, {
    key: 'parent',
    value: function () {
      function parent() {
        return this.flatMap(function (n) {
          return [n.parents().get(0)];
        });
      }

      return parent;
    }()

    /**
     *
     * @param {EnzymeSelector} selector
     * @returns {ReactWrapper}
     */

  }, {
    key: 'closest',
    value: function () {
      function closest(selector) {
        if (this.is(selector)) {
          return this;
        }
        var matchingAncestors = this.parents().filter(selector);
        return matchingAncestors.length > 0 ? matchingAncestors.first() : this.findWhere(function () {
          return false;
        });
      }

      return closest;
    }()

    /**
     * Returns the value of  prop with the given name of the root node.
     *
     * @param {String} propName
     * @returns {*}
     */

  }, {
    key: 'prop',
    value: function () {
      function prop(propName) {
        return this.props()[propName];
      }

      return prop;
    }()

    /**
     * Used to invoke a function prop.
     * Will invoke an function prop and return its value.
     *
     * @param {String} propName
     * @returns {Any}
     */

  }, {
    key: 'invoke',
    value: function () {
      function invoke(propName) {
        var _this21 = this;

        return this.single('invoke', function () {
          var handler = _this21.prop(propName);
          if (typeof handler !== 'function') {
            throw new TypeError('ReactWrapper::invoke() requires the name of a prop whose value is a function');
          }
          return function () {
            var response = handler.apply(undefined, arguments);
            _this21[ROOT].update();
            return response;
          };
        });
      }

      return invoke;
    }()

    /**
     * Returns a wrapper of the node rendered by the provided render prop.
     *
     * @param {String} propName
     * @returns {Function}
     */

  }, {
    key: 'renderProp',
    value: function () {
      function renderProp(propName) {
        var _this22 = this;

        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        if (typeof adapter.wrap !== 'function') {
          throw new RangeError('your adapter does not support `wrap`. Try upgrading it!');
        }

        return this.single('renderProp', function (n) {
          if (n.nodeType === 'host') {
            throw new TypeError('ReactWrapper::renderProp() can only be called on custom components');
          }
          if (typeof propName !== 'string') {
            throw new TypeError('ReactWrapper::renderProp(): `propName` must be a string');
          }
          var props = _this22.props();
          if (!(0, _has2['default'])(props, propName)) {
            throw new Error('ReactWrapper::renderProp(): no prop called \u201C' + String(propName) + '\u201C found');
          }
          var propValue = props[propName];
          if (typeof propValue !== 'function') {
            throw new TypeError('ReactWrapper::renderProp(): expected prop \u201C' + String(propName) + '\u201C to contain a function, but it holds \u201C' + (typeof propValue === 'undefined' ? 'undefined' : _typeof(propValue)) + '\u201C');
          }

          return function () {
            var element = propValue.apply(undefined, arguments);
            var wrapped = adapter.wrap(element);
            return _this22.wrap(wrapped, null, _this22[OPTIONS]);
          };
        });
      }

      return renderProp;
    }()

    /**
     * Returns the key assigned to the current node.
     *
     * @returns {String}
     */

  }, {
    key: 'key',
    value: function () {
      function key() {
        return this.single('key', function (n) {
          return n.key === undefined ? null : n.key;
        });
      }

      return key;
    }()

    /**
     * Returns the type of the root node of this wrapper. If it's a composite component, this will be
     * the component constructor. If it's native DOM node, it will be a string.
     *
     * @returns {String|Function}
     */

  }, {
    key: 'type',
    value: function () {
      function type() {
        return this.single('type', function (n) {
          return (0, _Utils.typeOfNode)(n);
        });
      }

      return type;
    }()

    /**
     * Returns the name of the root node of this wrapper.
     *
     * In order of precedence => type.displayName -> type.name -> type.
     *
     * @returns {String}
     */

  }, {
    key: 'name',
    value: function () {
      function name() {
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        return this.single('name', function (n) {
          return adapter.displayNameOfNode ? adapter.displayNameOfNode(n) : (0, _Utils.displayNameOfNode)(n);
        });
      }

      return name;
    }()

    /**
     * Returns whether or not the current root node has the given class name or not.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @param {String} className
     * @returns {Boolean}
     */

  }, {
    key: 'hasClass',
    value: function () {
      function hasClass(className) {
        if (typeof className === 'string' && className.indexOf('.') !== -1) {
          // eslint-disable-next-line no-console
          console.warn('It looks like you\'re calling `ReactWrapper::hasClass()` with a CSS selector. hasClass() expects a class name, not a CSS selector.');
        }
        return this.single('hasClass', function (n) {
          return (0, _RSTTraversal.hasClassName)(n, className);
        });
      }

      return hasClass;
    }()

    /**
     * Iterates through each node of the current wrapper and executes the provided function with a
     * wrapper around the corresponding node passed in as the first argument.
     *
     * @param {Function} fn
     * @returns {ReactWrapper}
     */

  }, {
    key: 'forEach',
    value: function () {
      function forEach(fn) {
        var _this23 = this;

        this.getNodesInternal().forEach(function (n, i) {
          return fn.call(_this23, _this23.wrap(n), i);
        });
        return this;
      }

      return forEach;
    }()

    /**
     * Maps the current array of nodes to another array. Each node is passed in as a `ReactWrapper`
     * to the map function.
     *
     * @param {Function} fn
     * @returns {Array}
     */

  }, {
    key: 'map',
    value: function () {
      function map(fn) {
        var _this24 = this;

        return this.getNodesInternal().map(function (n, i) {
          return fn.call(_this24, _this24.wrap(n), i);
        });
      }

      return map;
    }()

    /**
     * Reduces the current array of nodes to another array.
     * Each node is passed in as a `ShallowWrapper` to the reducer function.
     *
     * @param {Function} fn - the reducer function
     * @param {*} initialValue - the initial value
     * @returns {*}
     */

  }, {
    key: 'reduce',
    value: function () {
      function reduce(fn) {
        var _this25 = this;

        var initialValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

        if (arguments.length > 1) {
          return this.getNodesInternal().reduce(function (accum, n, i) {
            return fn.call(_this25, accum, _this25.wrap(n), i);
          }, initialValue);
        }
        return this.getNodesInternal().reduce(function (accum, n, i) {
          return fn.call(_this25, i === 1 ? _this25.wrap(accum) : accum, _this25.wrap(n), i);
        });
      }

      return reduce;
    }()

    /**
     * Reduces the current array of nodes to another array, from right to left. Each node is passed
     * in as a `ShallowWrapper` to the reducer function.
     *
     * @param {Function} fn - the reducer function
     * @param {*} initialValue - the initial value
     * @returns {*}
     */

  }, {
    key: 'reduceRight',
    value: function () {
      function reduceRight(fn) {
        var _this26 = this;

        var initialValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

        if (arguments.length > 1) {
          return this.getNodesInternal().reduceRight(function (accum, n, i) {
            return fn.call(_this26, accum, _this26.wrap(n), i);
          }, initialValue);
        }
        return this.getNodesInternal().reduceRight(function (accum, n, i) {
          return fn.call(_this26, i === 1 ? _this26.wrap(accum) : accum, _this26.wrap(n), i);
        });
      }

      return reduceRight;
    }()

    /**
     * Returns a new wrapper with a subset of the nodes of the original wrapper, according to the
     * rules of `Array#slice`.
     *
     * @param {Number} begin
     * @param {Number} end
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'slice',
    value: function () {
      function slice(begin, end) {
        return this.wrap(this.getNodesInternal().slice(begin, end));
      }

      return slice;
    }()

    /**
     * Returns whether or not any of the nodes in the wrapper match the provided selector.
     *
     * @param {EnzymeSelector} selector
     * @returns {Boolean}
     */

  }, {
    key: 'some',
    value: function () {
      function some(selector) {
        if (this[ROOT] === this) {
          throw new Error('ReactWrapper::some() can not be called on the root');
        }
        var predicate = (0, _selectors.buildPredicate)(selector);
        return this.getNodesInternal().some(predicate);
      }

      return some;
    }()

    /**
     * Returns whether or not any of the nodes in the wrapper pass the provided predicate function.
     *
     * @param {Function} predicate
     * @returns {Boolean}
     */

  }, {
    key: 'someWhere',
    value: function () {
      function someWhere(predicate) {
        var _this27 = this;

        return this.getNodesInternal().some(function (n, i) {
          return predicate.call(_this27, _this27.wrap(n), i);
        });
      }

      return someWhere;
    }()

    /**
     * Returns whether or not all of the nodes in the wrapper match the provided selector.
     *
     * @param {EnzymeSelector} selector
     * @returns {Boolean}
     */

  }, {
    key: 'every',
    value: function () {
      function every(selector) {
        var predicate = (0, _selectors.buildPredicate)(selector);
        return this.getNodesInternal().every(predicate);
      }

      return every;
    }()

    /**
     * Returns whether or not any of the nodes in the wrapper pass the provided predicate function.
     *
     * @param {Function} predicate
     * @returns {Boolean}
     */

  }, {
    key: 'everyWhere',
    value: function () {
      function everyWhere(predicate) {
        var _this28 = this;

        return this.getNodesInternal().every(function (n, i) {
          return predicate.call(_this28, _this28.wrap(n), i);
        });
      }

      return everyWhere;
    }()

    /**
     * Utility method used to create new wrappers with a mapping function that returns an array of
     * nodes in response to a single node wrapper. The returned wrapper is a single wrapper around
     * all of the mapped nodes flattened (and de-duplicated).
     *
     * @param {Function} fn
     * @returns {ReactWrapper}
     */

  }, {
    key: 'flatMap',
    value: function () {
      function flatMap(fn) {
        var _this29 = this;

        var nodes = this.getNodesInternal().map(function (n, i) {
          return fn.call(_this29, _this29.wrap(n), i);
        });
        var flattened = (0, _arrayPrototype2['default'])(nodes, 1);
        return this.wrap(flattened.filter(Boolean));
      }

      return flatMap;
    }()

    /**
     * Finds all nodes in the current wrapper nodes' render trees that match the provided predicate
     * function.
     *
     * @param {Function} predicate
     * @returns {ReactWrapper}
     */

  }, {
    key: 'findWhere',
    value: function () {
      function findWhere(predicate) {
        var _this30 = this;

        return findWhereUnwrapped(this, function (n) {
          var node = _this30.wrap(n);
          return node.length > 0 && predicate(node);
        });
      }

      return findWhere;
    }()

    /**
     * Returns the node at a given index of the current wrapper.
     *
     * @param {Number} index
     * @returns {ReactElement}
     */

  }, {
    key: 'get',
    value: function () {
      function get(index) {
        return this.getElements()[index];
      }

      return get;
    }()

    /**
     * Returns a wrapper around the node at a given index of the current wrapper.
     *
     * @param {Number} index
     * @returns {ReactWrapper}
     */

  }, {
    key: 'at',
    value: function () {
      function at(index) {
        var nodes = this.getNodesInternal();
        if (index < nodes.length) {
          return this.wrap(nodes[index]);
        }
        return this.wrap([]);
      }

      return at;
    }()

    /**
     * Returns a wrapper around the first node of the current wrapper.
     *
     * @returns {ReactWrapper}
     */

  }, {
    key: 'first',
    value: function () {
      function first() {
        return this.at(0);
      }

      return first;
    }()

    /**
     * Returns a wrapper around the last node of the current wrapper.
     *
     * @returns {ReactWrapper}
     */

  }, {
    key: 'last',
    value: function () {
      function last() {
        return this.at(this.length - 1);
      }

      return last;
    }()

    /**
     * Delegates to exists()
     *
     * @returns {boolean}
     */

  }, {
    key: 'isEmpty',
    value: function () {
      function isEmpty() {
        // eslint-disable-next-line no-console
        console.warn('Enzyme::Deprecated method isEmpty() called, use exists() instead.');
        return !this.exists();
      }

      return isEmpty;
    }()

    /**
     * Returns true if the current wrapper has nodes. False otherwise.
     * If called with a selector it returns `.find(selector).exists()` instead.
     *
     * @param {EnzymeSelector} selector (optional)
     * @returns {boolean}
     */

  }, {
    key: 'exists',
    value: function () {
      function exists() {
        var selector = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

        return arguments.length > 0 ? this.find(selector).exists() : this.length > 0;
      }

      return exists;
    }()

    /**
     * Utility method that throws an error if the current instance has a length other than one.
     * This is primarily used to enforce that certain methods are only run on a wrapper when it is
     * wrapping a single node.
     *
     * @param {Function} fn
     * @returns {*}
     */

  }, {
    key: 'single',
    value: function () {
      function single(name, fn) {
        var fnName = typeof name === 'string' ? name : 'unknown';
        var callback = typeof fn === 'function' ? fn : name;
        if (this.length !== 1) {
          throw new Error('Method \u201C' + fnName + '\u201D is meant to be run on 1 node. ' + String(this.length) + ' found instead.');
        }
        return callback.call(this, this.getNodeInternal());
      }

      return single;
    }()

    /**
     * Helpful utility method to create a new wrapper with the same root as the current wrapper, with
     * any nodes passed in as the first parameter automatically wrapped.
     *
     * @param {ReactWrapper|ReactElement|Array<ReactElement>} node
     * @returns {ReactWrapper}
     */

  }, {
    key: 'wrap',
    value: function () {
      function wrap(node) {
        var root = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this[ROOT];

        if (node instanceof ReactWrapper) {
          return node;
        }

        for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        return new (Function.prototype.bind.apply(ReactWrapper, [null].concat([node, root], args)))();
      }

      return wrap;
    }()

    /**
     * Returns an HTML-like string of the shallow render for debugging purposes.
     *
     * @param {Object} [options] - Property bag of additional options.
     * @param {boolean} [options.ignoreProps] - if true, props are omitted from the string.
     * @param {boolean} [options.verbose] - if true, arrays and objects to be verbosely printed.
     * @returns {String}
     */

  }, {
    key: 'debug',
    value: function () {
      function debug() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        return (0, _Debug.debugNodes)(this.getNodesInternal(), options);
      }

      return debug;
    }()

    /**
     * Invokes intercepter and returns itself. intercepter is called with itself.
     * This is helpful when debugging nodes in method chains.
     * @param fn
     * @returns {ReactWrapper}
     */

  }, {
    key: 'tap',
    value: function () {
      function tap(intercepter) {
        intercepter(this);
        return this;
      }

      return tap;
    }()

    /**
     * Detaches the react tree from the DOM. Runs `ReactDOM.unmountComponentAtNode()` under the hood.
     *
     * This method will most commonly be used as a "cleanup" method if you decide to use the
     * `attachTo` option in `mount(node, options)`.
     *
     * The method is intentionally not "fluent" (in that it doesn't return `this`) because you should
     * not be doing anything with this wrapper after this method is called.
     */

  }, {
    key: 'detach',
    value: function () {
      function detach() {
        if (this[ROOT] !== this) {
          throw new Error('ReactWrapper::detach() can only be called on the root');
        }
        if (!this[OPTIONS].attachTo) {
          throw new Error('ReactWrapper::detach() can only be called on when the `attachTo` option was passed into `mount()`.');
        }
        this[RENDERER].unmount();
      }

      return detach;
    }()

    /**
     * Strips out all the not host-nodes from the list of nodes
     *
     * This method is useful if you want to check for the presence of host nodes
     * (actually rendered HTML elements) ignoring the React nodes.
     */

  }, {
    key: 'hostNodes',
    value: function () {
      function hostNodes() {
        return this.filterWhere(function (n) {
          return typeof n.type() === 'string';
        });
      }

      return hostNodes;
    }()
  }]);

  return ReactWrapper;
}();

/**
 * A *special* "root" wrapper that represents the component passed as `wrappingComponent`.
 * It is linked to the primary root such that updates to it will update the primary,
 * and vice versa.
 *
 * @class WrappingComponentWrapper
 */


var WrappingComponentWrapper = function (_ReactWrapper) {
  _inherits(WrappingComponentWrapper, _ReactWrapper);

  /* eslint-disable class-methods-use-this */
  function WrappingComponentWrapper(root, renderer) {
    _classCallCheck(this, WrappingComponentWrapper);

    var _this31 = _possibleConstructorReturn(this, (WrappingComponentWrapper.__proto__ || Object.getPrototypeOf(WrappingComponentWrapper)).call(this, renderer.getNode(), root));

    (0, _Utils.privateSet)(_this31, ROOT, _this31);
    (0, _Utils.privateSet)(_this31, RENDERER, renderer);
    _this31[LINKED_ROOTS].push(root);
    return _this31;
  }

  _createClass(WrappingComponentWrapper, [{
    key: 'getWrappingComponent',
    value: function () {
      function getWrappingComponent() {
        throw new TypeError('ReactWrapper::getWrappingComponent() can only be called on the root');
      }

      return getWrappingComponent;
    }()
  }]);

  return WrappingComponentWrapper;
}(ReactWrapper);

if (_Utils.ITERATOR_SYMBOL) {
  Object.defineProperty(ReactWrapper.prototype, _Utils.ITERATOR_SYMBOL, {
    configurable: true,
    value: function () {
      function iterator() {
        var _ref;

        var iter = this[NODES][_Utils.ITERATOR_SYMBOL]();
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        return _ref = {}, _defineProperty(_ref, _Utils.ITERATOR_SYMBOL, function () {
          return this;
        }), _defineProperty(_ref, 'next', function () {
          function next() {
            var next = iter.next();
            if (next.done) {
              return { done: true };
            }
            return {
              done: false,
              value: adapter.nodeToElement(next.value)
            };
          }

          return next;
        }()), _ref;
      }

      return iterator;
    }()
  });
}

function privateWarning(prop, extraMessage) {
  Object.defineProperty(ReactWrapper.prototype, prop, {
    get: function () {
      function get() {
        throw new Error('\n        Attempted to access ReactWrapper::' + String(prop) + ', which was previously a private property on\n        Enzyme ReactWrapper instances, but is no longer and should not be relied upon.\n        ' + String(extraMessage) + '\n      ');
      }

      return get;
    }(),

    enumerable: false,
    configurable: false
  });
}

privateWarning('node', 'Consider using the getElement() method instead.');
privateWarning('nodes', 'Consider using the getElements() method instead.');
privateWarning('renderer', '');
privateWarning('options', '');
privateWarning('complexSelector', '');

exports['default'] = ReactWrapper;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=ReactWrapper.js.map