'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _get = function () {
  function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } }

  return get;
}();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _object = require('object.assign');

var _object2 = _interopRequireDefault(_object);

var _arrayPrototype = require('array.prototype.flat');

var _arrayPrototype2 = _interopRequireDefault(_arrayPrototype);

var _cheerio = require('cheerio');

var _cheerio2 = _interopRequireDefault(_cheerio);

var _has = require('has');

var _has2 = _interopRequireDefault(_has);

var _Utils = require('./Utils');

var _getAdapter = require('./getAdapter');

var _getAdapter2 = _interopRequireDefault(_getAdapter);

var _Debug = require('./Debug');

var _RSTTraversal = require('./RSTTraversal');

var _selectors = require('./selectors');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var NODE = (0, _Utils.sym)('__node__');
var NODES = (0, _Utils.sym)('__nodes__');
var RENDERER = (0, _Utils.sym)('__renderer__');
var UNRENDERED = (0, _Utils.sym)('__unrendered__');
var ROOT = (0, _Utils.sym)('__root__');
var OPTIONS = (0, _Utils.sym)('__options__');
var SET_STATE = (0, _Utils.sym)('__setState__');
var ROOT_NODES = (0, _Utils.sym)('__rootNodes__');
var CHILD_CONTEXT = (0, _Utils.sym)('__childContext__');
var WRAPPING_COMPONENT = (0, _Utils.sym)('__wrappingComponent__');
var PRIMARY_WRAPPER = (0, _Utils.sym)('__primaryWrapper__');
var ROOT_FINDER = (0, _Utils.sym)('__rootFinder__');
var PROVIDER_VALUES = (0, _Utils.sym)('__providerValues__');

/**
 * Finds all nodes in the current wrapper nodes' render trees that match the provided predicate
 * function.
 *
 * @param {ShallowWrapper} wrapper
 * @param {Function} predicate
 * @param {Function} filter
 * @returns {ShallowWrapper}
 */
function findWhereUnwrapped(wrapper, predicate) {
  var filter = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _RSTTraversal.treeFilter;

  return wrapper.flatMap(function (n) {
    return filter(n.getNodeInternal(), predicate);
  });
}

/**
 * Returns a new wrapper instance with only the nodes of the current wrapper instance that match
 * the provided predicate function.
 *
 * @param {ShallowWrapper} wrapper
 * @param {Function} predicate
 * @returns {ShallowWrapper}
 */
function filterWhereUnwrapped(wrapper, predicate) {
  return wrapper.wrap(wrapper.getNodesInternal().filter(predicate).filter(Boolean));
}

/**
 * Ensure options passed to ShallowWrapper are valid. Throws otherwise.
 * @param {Object} options
 */
function validateOptions(options) {
  var lifecycleExperimental = options.lifecycleExperimental,
      disableLifecycleMethods = options.disableLifecycleMethods,
      enableComponentDidUpdateOnSetState = options.enableComponentDidUpdateOnSetState,
      supportPrevContextArgumentOfComponentDidUpdate = options.supportPrevContextArgumentOfComponentDidUpdate,
      lifecycles = options.lifecycles;

  if (typeof lifecycleExperimental !== 'undefined' && typeof lifecycleExperimental !== 'boolean') {
    throw new Error('lifecycleExperimental must be either true or false if provided');
  }

  if (typeof disableLifecycleMethods !== 'undefined' && typeof disableLifecycleMethods !== 'boolean') {
    throw new Error('disableLifecycleMethods must be either true or false if provided');
  }

  if (lifecycleExperimental != null && disableLifecycleMethods != null && lifecycleExperimental === disableLifecycleMethods) {
    throw new Error('lifecycleExperimental and disableLifecycleMethods cannot be set to the same value');
  }

  if (typeof enableComponentDidUpdateOnSetState !== 'undefined' && lifecycles.componentDidUpdate && lifecycles.componentDidUpdate.onSetState !== enableComponentDidUpdateOnSetState) {
    throw new TypeError('the legacy enableComponentDidUpdateOnSetState option should be matched by `lifecycles: { componentDidUpdate: { onSetState: true } }`, for compatibility');
  }

  if (typeof supportPrevContextArgumentOfComponentDidUpdate !== 'undefined' && lifecycles.componentDidUpdate && lifecycles.componentDidUpdate.prevContext !== supportPrevContextArgumentOfComponentDidUpdate) {
    throw new TypeError('the legacy supportPrevContextArgumentOfComponentDidUpdate option should be matched by `lifecycles: { componentDidUpdate: { prevContext: true } }`, for compatibility');
  }
}

function getAdapterLifecycles(_ref) {
  var options = _ref.options;
  var _options$lifecycles = options.lifecycles,
      lifecycles = _options$lifecycles === undefined ? {} : _options$lifecycles,
      enableComponentDidUpdateOnSetState = options.enableComponentDidUpdateOnSetState,
      supportPrevContextArgumentOfComponentDidUpdate = options.supportPrevContextArgumentOfComponentDidUpdate;


  var hasLegacySetStateArg = typeof enableComponentDidUpdateOnSetState !== 'undefined';
  var hasLegacyPrevContextArg = typeof supportPrevContextArgumentOfComponentDidUpdate !== 'undefined';
  var componentDidUpdate = hasLegacySetStateArg || hasLegacyPrevContextArg ? (0, _object2['default'])({}, hasLegacySetStateArg && {
    onSetState: !!enableComponentDidUpdateOnSetState
  }, hasLegacyPrevContextArg && {
    prevContext: !!supportPrevContextArgumentOfComponentDidUpdate
  }) : null;
  var originalGDSFP = lifecycles.getDerivedStateFromProps;

  var getDerivedStateFromProps = originalGDSFP ? {
    hasShouldComponentUpdateBug: !!originalGDSFP.hasShouldComponentUpdateBug
  } : false;

  return (0, _object2['default'])({}, lifecycles, {
    setState: (0, _object2['default'])({}, lifecycles.setState),
    getChildContext: (0, _object2['default'])({
      calledByRenderer: true
    }, lifecycles.getChildContext)
  }, componentDidUpdate && { componentDidUpdate: componentDidUpdate }, {
    getDerivedStateFromProps: getDerivedStateFromProps
  });
}

function getRootNode(node) {
  if (node.nodeType === 'host') {
    return node;
  }
  return node.rendered;
}

function getRootNodeInternal(wrapper) {
  if (wrapper[ROOT].length !== 1) {
    throw new Error('getRootNodeInternal(wrapper) can only be called when wrapper wraps one node');
  }
  if (wrapper[ROOT] !== wrapper) {
    return wrapper[ROOT_NODES][0];
  }
  return wrapper[ROOT][NODE];
}

function nodeParents(wrapper, node) {
  return (0, _RSTTraversal.parentsOfNode)(node, getRootNodeInternal(wrapper));
}

function privateSetNodes(wrapper, nodes) {
  if (!Array.isArray(nodes)) {
    (0, _Utils.privateSet)(wrapper, NODE, nodes);
    (0, _Utils.privateSet)(wrapper, NODES, [nodes]);
  } else {
    (0, _Utils.privateSet)(wrapper, NODE, nodes[0]);
    (0, _Utils.privateSet)(wrapper, NODES, nodes);
  }
  (0, _Utils.privateSet)(wrapper, 'length', wrapper[NODES].length);
}

function pureComponentShouldComponentUpdate(prevProps, props, prevState, state) {
  return !(0, _Utils.shallowEqual)(prevProps, props) || !(0, _Utils.shallowEqual)(prevState, state);
}

function isPureComponent(instance) {
  return instance && instance.isPureReactComponent;
}

function getChildContext(node, hierarchy, renderer) {
  var instance = node.instance,
      Component = node.type;

  var componentName = (0, _Utils.displayNameOfNode)(node);
  // Warn like react if childContextTypes is not defined:
  // https://github.com/facebook/react/blob/1454a8be03794f5e0b23a7e7696cbbbdcf8b0f5d/packages/react-dom/src/server/ReactPartialRenderer.js#L639-L646
  if (_typeof(Component.childContextTypes) !== 'object') {
    // eslint-disable-next-line no-console
    console.warn(String(componentName) + '.getChildContext(): childContextTypes must be defined in order to use getChildContext().');
    return {};
  }
  // Check childContextTypes like react:
  // https://github.com/facebook/react/blob/1454a8be03794f5e0b23a7e7696cbbbdcf8b0f5d/packages/react-dom/src/server/ReactPartialRenderer.js#L630-L637
  var childContext = instance.getChildContext();
  Object.keys(childContext).forEach(function (key) {
    if (!(key in Component.childContextTypes)) {
      throw new Error(String(componentName) + '.getChildContext(): key "' + String(key) + '" is not defined in childContextTypes.');
    }
  });
  if (typeof renderer.checkPropTypes === 'function') {
    renderer.checkPropTypes(Component.childContextTypes, childContext, 'child context', hierarchy);
  }
  return childContext;
}

function spyOnGetChildContextInitialRender(nodes, adapter) {
  if (!(0, _Utils.isCustomComponentElement)(nodes, adapter) || !nodes.type.prototype || typeof nodes.type.prototype.getChildContext !== 'function') {
    return null;
  }

  return (0, _Utils.spyMethod)(nodes.type.prototype, 'getChildContext');
}

function privateSetChildContext(adapter, wrapper, instance, renderedNode, getChildContextSpy) {
  var renderer = wrapper[RENDERER];
  // We only support parent-based context.
  if (adapter.options.legacyContextMode !== 'parent') {
    return;
  }
  if (getChildContextSpy) {
    (0, _Utils.privateSet)(wrapper, CHILD_CONTEXT, getChildContextSpy.getLastReturnValue());
    getChildContextSpy.restore();
  } else if (typeof instance.getChildContext === 'function') {
    // If there's no spy but getChildContext is a function, that means our renderer
    // is not going to call it for us, so we need to call it ourselves.
    var nodeHierarchy = [wrapper[NODE]].concat(nodeParents(wrapper, wrapper[NODE]));
    var childContext = getChildContext(renderedNode, nodeHierarchy, renderer);
    (0, _Utils.privateSet)(wrapper, CHILD_CONTEXT, childContext);
  } else {
    (0, _Utils.privateSet)(wrapper, CHILD_CONTEXT, null);
  }
}

function mockSCUIfgDSFPReturnNonNull(node, state) {
  var getDerivedStateFromProps = node.type.getDerivedStateFromProps;


  if (typeof getDerivedStateFromProps === 'function') {
    // we try to fix a React shallow renderer bug here.
    // (facebook/react#14607, which has been fixed in react 16.8):
    // when gDSFP return derived state, it will set instance state in shallow renderer before SCU,
    // this will cause `this.state` in sCU be the updated state, which is wrong behavior.
    // so we have to wrap sCU to pass the old state to original sCU.
    var instance = node.instance;

    var _spyMethod = (0, _Utils.spyMethod)(instance, 'shouldComponentUpdate', function (originalSCU) {
      return function () {
        function shouldComponentUpdate() {
          instance.state = state;

          for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          var sCUResult = originalSCU.apply(instance, args);
          var nextState = args[1];

          instance.state = nextState;
          restore();
          return sCUResult;
        }

        return shouldComponentUpdate;
      }();
    }),
        restore = _spyMethod.restore;
  }
}

/**
 * Recursively dive()s every custom component in a wrapper until
 * the target component is found.
 *
 * @param {ShallowWrapper} wrapper A ShallowWrapper to search
 * @param {ComponentType} target A react custom component that, when found, will end recursion
 * @param {Adapter} adapter An Enzyme adapter
 * @returns {ShallowWrapper|undefined} A ShallowWrapper for the target, or
 *  undefined if it can't be found
 */
function deepRender(wrapper, target, adapter) {
  var node = wrapper[NODE];
  var element = node && adapter.nodeToElement(node);
  if (wrapper.type() === target) {
    return wrapper.dive();
  }
  if (element && (0, _Utils.isCustomComponentElement)(element, adapter)) {
    return deepRender(wrapper.dive(), target, adapter);
  }
  var children = wrapper.children();
  for (var i = 0; i < children.length; i += 1) {
    var found = deepRender(children.at(i), target, adapter);
    if (typeof found !== 'undefined') {
      return found;
    }
  }
  return undefined;
}

/**
 * Deep-renders the `wrappingComponent` and returns the context that should
 * be accessible to the primary wrapper.
 *
 * @param {WrappingComponentWrapper} wrapper The `WrappingComponentWrapper` for a
 *  `wrappingComponent`
 * @param {Adapter} adapter An Enzyme adapter
 * @returns {object} An object containing an object of legacy context values and a Map of
 *  `createContext()` Provider values.
 */
function getContextFromWrappingComponent(wrapper, adapter) {
  var rootFinder = deepRender(wrapper, wrapper[ROOT_FINDER], adapter);
  if (!rootFinder) {
    throw new Error('`wrappingComponent` must render its children!');
  }
  return {
    legacyContext: rootFinder[OPTIONS].context,
    providerValues: rootFinder[PROVIDER_VALUES]
  };
}

/**
 * Makes options specifically for `ShallowWrapper`. Most of the logic here is around rendering
 * a `wrappingComponent` (if one was provided) and adding the child context of that component
 * to `options.context`.
 *
 * @param {ReactElement} nodes the nodes passed to `ShallowWrapper`
 * @param {ShallowWrapper} root this `ShallowWrapper`'s parent. If this is passed, options are
 *  not transformed.
 * @param {*} passedOptions the options passed to `ShallowWrapper`.
 * @param {*} wrapper the `ShallowWrapper` itself
 * @returns {Object} the decorated and transformed options
 */
function makeShallowOptions(nodes, root, passedOptions, wrapper) {
  var options = (0, _Utils.makeOptions)(passedOptions);
  var adapter = (0, _getAdapter2['default'])(passedOptions);
  (0, _Utils.privateSet)(options, PROVIDER_VALUES, passedOptions[PROVIDER_VALUES]);
  if (root || !(0, _Utils.isCustomComponent)(options.wrappingComponent, adapter)) {
    return options;
  }
  if (typeof adapter.wrapWithWrappingComponent !== 'function') {
    throw new TypeError('your adapter does not support `wrappingComponent`. Try upgrading it!');
  }

  var _adapter$wrapWithWrap = adapter.wrapWithWrappingComponent(nodes, options),
      wrappedNode = _adapter$wrapWithWrap.node,
      RootFinder = _adapter$wrapWithWrap.RootFinder;
  // eslint-disable-next-line no-use-before-define


  var wrappingComponent = new WrappingComponentWrapper(wrappedNode, wrapper, RootFinder);

  var _getContextFromWrappi = getContextFromWrappingComponent(wrappingComponent, adapter),
      wrappingComponentLegacyContext = _getContextFromWrappi.legacyContext,
      wrappingComponentProviderValues = _getContextFromWrappi.providerValues;

  (0, _Utils.privateSet)(wrapper, WRAPPING_COMPONENT, wrappingComponent);
  return (0, _object2['default'])({}, options, _defineProperty({
    context: (0, _object2['default'])({}, options.context, wrappingComponentLegacyContext)
  }, PROVIDER_VALUES, wrappingComponentProviderValues));
}

/**
 * @class ShallowWrapper
 */

var ShallowWrapper = function () {
  function ShallowWrapper(nodes, root) {
    var _this = this;

    var passedOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    _classCallCheck(this, ShallowWrapper);

    validateOptions(passedOptions);

    var options = makeShallowOptions(nodes, root, passedOptions, this);
    var adapter = (0, _getAdapter2['default'])(options);
    var lifecycles = getAdapterLifecycles(adapter);

    // mounting a ShallowRender component
    if (!root) {
      if (!adapter.isValidElement(nodes)) {
        throw new TypeError('ShallowWrapper can only wrap valid elements');
      }

      var getChildContextSpy = lifecycles.getChildContext.calledByRenderer ? spyOnGetChildContextInitialRender(nodes, adapter) : null;
      (0, _Utils.privateSet)(this, ROOT, this);
      (0, _Utils.privateSet)(this, UNRENDERED, nodes);
      var renderer = adapter.createRenderer((0, _object2['default'])({ mode: 'shallow' }, options));
      (0, _Utils.privateSet)(this, RENDERER, renderer);
      var providerValues = new Map(options[PROVIDER_VALUES] || []);
      this[RENDERER].render(nodes, options.context, { providerValues: providerValues });
      var renderedNode = this[RENDERER].getNode();
      privateSetNodes(this, getRootNode(renderedNode));
      (0, _Utils.privateSet)(this, OPTIONS, options);
      (0, _Utils.privateSet)(this, PROVIDER_VALUES, providerValues);

      var instance = renderedNode.instance;

      if (instance && !options.disableLifecycleMethods) {
        // Ensure to call componentDidUpdate when instance.setState is called
        if (lifecycles.componentDidUpdate.onSetState && !instance[SET_STATE]) {
          (0, _Utils.privateSet)(instance, SET_STATE, instance.setState);
          instance.setState = function (updater) {
            var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;
            return _this.setState.apply(_this, _toConsumableArray(callback == null ? [updater] : [updater, callback]));
          };
        }

        if (typeof instance.componentDidMount === 'function') {
          this[RENDERER].batchedUpdates(function () {
            instance.componentDidMount();
          });
        }
        privateSetChildContext(adapter, this, instance, renderedNode, getChildContextSpy);
      }
      // creating a child component through enzyme's ShallowWrapper APIs.
    } else {
      (0, _Utils.privateSet)(this, ROOT, root);
      (0, _Utils.privateSet)(this, UNRENDERED, null);
      (0, _Utils.privateSet)(this, RENDERER, root[RENDERER]);
      privateSetNodes(this, nodes);
      (0, _Utils.privateSet)(this, OPTIONS, root[OPTIONS]);
      (0, _Utils.privateSet)(this, ROOT_NODES, root[NODES]);
      (0, _Utils.privateSet)(this, PROVIDER_VALUES, null);
    }
  }

  /**
   * Returns the root wrapper
   *
   * @return {ShallowWrapper}
   */


  _createClass(ShallowWrapper, [{
    key: 'root',
    value: function () {
      function root() {
        return this[ROOT];
      }

      return root;
    }()

    /**
     * Returns the wrapped component.
     *
     * @return {ReactComponent}
     */

  }, {
    key: 'getNodeInternal',
    value: function () {
      function getNodeInternal() {
        if (this.length !== 1) {
          throw new Error('ShallowWrapper::getNode() can only be called when wrapping one node');
        }
        if (this[ROOT] === this) {
          this.update();
        }
        return this[NODE];
      }

      return getNodeInternal;
    }()

    /**
     * Returns the the wrapped components.
     *
     * @return {Array<ReactComponent>}
     */

  }, {
    key: 'getNodesInternal',
    value: function () {
      function getNodesInternal() {
        if (this[ROOT] === this && this.length === 1) {
          this.update();
        }
        return this[NODES];
      }

      return getNodesInternal;
    }()

    /**
     * Returns the wrapped ReactElement.
     *
     * @return {ReactElement}
     */

  }, {
    key: 'getElement',
    value: function () {
      function getElement() {
        var _this2 = this;

        return this.single('getElement', function (n) {
          return (0, _getAdapter2['default'])(_this2[OPTIONS]).nodeToElement(n);
        });
      }

      return getElement;
    }()

    /**
     * Returns the wrapped ReactElements.
     *
     * @return {Array<ReactElement>}
     */

  }, {
    key: 'getElements',
    value: function () {
      function getElements() {
        var _this3 = this;

        return this.getNodesInternal().map(function (n) {
          return (0, _getAdapter2['default'])(_this3[OPTIONS]).nodeToElement(n);
        });
      }

      return getElements;
    }()

    // eslint-disable-next-line class-methods-use-this

  }, {
    key: 'getNode',
    value: function () {
      function getNode() {
        throw new Error('ShallowWrapper::getNode() is no longer supported. Use ShallowWrapper::getElement() instead');
      }

      return getNode;
    }()

    // eslint-disable-next-line class-methods-use-this

  }, {
    key: 'getNodes',
    value: function () {
      function getNodes() {
        throw new Error('ShallowWrapper::getNodes() is no longer supported. Use ShallowWrapper::getElements() instead');
      }

      return getNodes;
    }()

    /**
     * Gets the instance of the component being rendered as the root node passed into `shallow()`.
     *
     * NOTE: can only be called on a wrapper instance that is also the root instance.
     *
     * Example:
     * ```
     * const wrapper = shallow(<MyComponent />);
     * const inst = wrapper.instance();
     * expect(inst).to.be.instanceOf(MyComponent);
     * ```
     * @returns {ReactComponent}
     */

  }, {
    key: 'instance',
    value: function () {
      function instance() {
        if (this[ROOT] !== this) {
          throw new Error('ShallowWrapper::instance() can only be called on the root');
        }
        return this[RENDERER].getNode().instance;
      }

      return instance;
    }()

    /**
     * If a `wrappingComponent` was passed in `options`, this methods returns a `ShallowWrapper`
     * around the rendered `wrappingComponent`. This `ShallowWrapper` can be used to update the
     * `wrappingComponent`'s props, state, etc.
     *
     * @returns ShallowWrapper
     */

  }, {
    key: 'getWrappingComponent',
    value: function () {
      function getWrappingComponent() {
        if (this[ROOT] !== this) {
          throw new Error('ShallowWrapper::getWrappingComponent() can only be called on the root');
        }
        if (!this[OPTIONS].wrappingComponent) {
          throw new Error('ShallowWrapper::getWrappingComponent() can only be called on a wrapper that was originally passed a `wrappingComponent` option');
        }
        return this[WRAPPING_COMPONENT];
      }

      return getWrappingComponent;
    }()

    /**
     * Forces a re-render. Useful to run before checking the render output if something external
     * may be updating the state of the component somewhere.
     *
     * NOTE: can only be called on a wrapper instance that is also the root instance.
     *
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'update',
    value: function () {
      function update() {
        if (this[ROOT] !== this) {
          throw new Error('ShallowWrapper::update() can only be called on the root');
        }
        if (this.length !== 1) {
          throw new Error('ShallowWrapper::update() can only be called when wrapping one node');
        }
        privateSetNodes(this, getRootNode(this[RENDERER].getNode()));
        return this;
      }

      return update;
    }()

    /**
     * A method that unmounts the component. This can be used to simulate a component going through
     * and unmount/mount lifecycle.
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'unmount',
    value: function () {
      function unmount() {
        this[RENDERER].unmount();
        if (this[ROOT][WRAPPING_COMPONENT]) {
          this[ROOT][WRAPPING_COMPONENT].unmount();
        }
        return this;
      }

      return unmount;
    }()

    /**
     * A method is for re-render with new props and context.
     * This calls componentDidUpdate method if disableLifecycleMethods is not enabled.
     *
     * NOTE: can only be called on a wrapper instance that is also the root instance.
     *
     * @param {Object} props
     * @param {Object} context
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'rerender',
    value: function () {
      function rerender(props, context) {
        var _this4 = this;

        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        this.single('rerender', function () {
          (0, _Utils.withSetStateAllowed)(function () {
            // NOTE(lmr): In react 16, instances will be null for SFCs, but
            // rerendering with props/context is still a valid thing to do. In
            // this case, state will be undefined, but props/context will exist.
            var node = _this4[RENDERER].getNode();
            var instance = node.instance || {};
            var type = node.type || {};
            var state = instance.state;

            var prevProps = instance.props || _this4[UNRENDERED].props;
            var prevContext = instance.context || _this4[OPTIONS].context;
            var nextContext = context || prevContext;
            if (context) {
              _this4[OPTIONS] = (0, _object2['default'])({}, _this4[OPTIONS], { context: nextContext });
            }
            _this4[RENDERER].batchedUpdates(function () {
              // When shouldComponentUpdate returns false we shouldn't call componentDidUpdate.
              // so we spy shouldComponentUpdate to get the result.
              var lifecycles = getAdapterLifecycles(adapter);
              var shouldRender = true;
              var shouldComponentUpdateSpy = void 0;
              var getChildContextSpy = void 0;
              if (!_this4[OPTIONS].disableLifecycleMethods && instance) {
                if (typeof instance.shouldComponentUpdate === 'function') {
                  var gDSFP = lifecycles.getDerivedStateFromProps;

                  if (gDSFP && gDSFP.hasShouldComponentUpdateBug) {
                    mockSCUIfgDSFPReturnNonNull(node, state);
                  }
                  shouldComponentUpdateSpy = (0, _Utils.spyMethod)(instance, 'shouldComponentUpdate');
                }
                if (lifecycles.getChildContext.calledByRenderer && typeof instance.getChildContext === 'function') {
                  getChildContextSpy = (0, _Utils.spyMethod)(instance, 'getChildContext');
                }
              }
              if (!shouldComponentUpdateSpy && isPureComponent(instance)) {
                shouldRender = pureComponentShouldComponentUpdate(prevProps, props, state, instance.state);
              }
              if (props) _this4[UNRENDERED] = (0, _Utils.cloneElement)(adapter, _this4[UNRENDERED], props);
              _this4[RENDERER].render(_this4[UNRENDERED], nextContext, {
                providerValues: _this4[PROVIDER_VALUES]
              });
              if (shouldComponentUpdateSpy) {
                shouldRender = shouldComponentUpdateSpy.getLastReturnValue();
                shouldComponentUpdateSpy.restore();
              }
              if (shouldRender && !_this4[OPTIONS].disableLifecycleMethods && instance) {
                privateSetChildContext(adapter, _this4, instance, node, getChildContextSpy);
                if (lifecycles.getSnapshotBeforeUpdate) {
                  var snapshot = void 0;
                  if (typeof instance.getSnapshotBeforeUpdate === 'function') {
                    snapshot = instance.getSnapshotBeforeUpdate(prevProps, state);
                  }
                  if (lifecycles.componentDidUpdate && typeof instance.componentDidUpdate === 'function' && (!state || (0, _Utils.shallowEqual)(state, _this4.instance().state) || typeof type.getDerivedStateFromProps === 'function')) {
                    instance.componentDidUpdate(prevProps, state, snapshot);
                  }
                } else if (lifecycles.componentDidUpdate && typeof instance.componentDidUpdate === 'function') {
                  if (lifecycles.componentDidUpdate.prevContext) {
                    instance.componentDidUpdate(prevProps, state, prevContext);
                  } else if (!state || (0, _Utils.shallowEqual)(_this4.instance().state, state)) {
                    instance.componentDidUpdate(prevProps, state);
                  }
                }
                // If it doesn't need to rerender, update only its props.
              } else if (!(0, _Utils.shallowEqual)(props, instance.props)) {
                instance.props = (Object.freeze || Object)((0, _object2['default'])({}, instance.props, props));
              }
              _this4.update();
            });
          });
        });
        return this;
      }

      return rerender;
    }()

    /**
     * A method that sets the props of the root component, and re-renders. Useful for when you are
     * wanting to test how the component behaves over time with changing props. Calling this, for
     * instance, will call the `componentWillReceiveProps` lifecycle method.
     *
     * Similar to `setState`, this method accepts a props object and will merge it in with the already
     * existing props.
     *
     * NOTE: can only be called on a wrapper instance that is also the root instance.
     *
     * @param {Object} props object
     * @param {Function} cb - callback function
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'setProps',
    value: function () {
      function setProps(props) {
        var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

        if (this[ROOT] !== this) {
          throw new Error('ShallowWrapper::setProps() can only be called on the root');
        }
        if (arguments.length > 1 && typeof callback !== 'function') {
          throw new TypeError('ReactWrapper::setProps() expects a function as its second argument');
        }
        this.rerender(props);
        if (callback) {
          callback();
        }
        return this;
      }

      return setProps;
    }()

    /**
     * A method to invoke `setState` on the root component instance similar to how you might in the
     * definition of the component, and re-renders.  This method is useful for testing your component
     * in hard to achieve states, however should be used sparingly. If possible, you should utilize
     * your component's external API in order to get it into whatever state you want to test, in order
     * to be as accurate of a test as possible. This is not always practical, however.
     *
     * NOTE: can only be called on a wrapper instance that is also the root instance.
     *
     * @param {Object} state to merge
     * @param {Function} cb - callback function
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'setState',
    value: function () {
      function setState(state) {
        var _this5 = this;

        var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

        if (this[ROOT] !== this) {
          throw new Error('ShallowWrapper::setState() can only be called on the root');
        }
        if (this.instance() === null || this[RENDERER].getNode().nodeType !== 'class') {
          throw new Error('ShallowWrapper::setState() can only be called on class components');
        }
        if (arguments.length > 1 && typeof callback !== 'function') {
          throw new TypeError('ReactWrapper::setState() expects a function as its second argument');
        }

        this.single('setState', function () {
          (0, _Utils.withSetStateAllowed)(function () {
            var adapter = (0, _getAdapter2['default'])(_this5[OPTIONS]);

            var lifecycles = getAdapterLifecycles(adapter);

            var node = _this5[RENDERER].getNode();
            var instance = node.instance;

            var prevProps = instance.props;
            var prevState = instance.state;
            var prevContext = instance.context;

            var statePayload = typeof state === 'function' ? state.call(instance, prevState, prevProps) : state;

            // returning null or undefined prevents the update in React 16+
            // https://github.com/facebook/react/pull/12756
            var maybeHasUpdate = !lifecycles.setState.skipsComponentDidUpdateOnNullish || statePayload != null;

            // When shouldComponentUpdate returns false we shouldn't call componentDidUpdate.
            // so we spy shouldComponentUpdate to get the result.
            var shouldComponentUpdateSpy = void 0;
            var getChildContextSpy = void 0;
            var shouldRender = true;
            if (!_this5[OPTIONS].disableLifecycleMethods && instance) {
              if (lifecycles.componentDidUpdate && lifecycles.componentDidUpdate.onSetState && typeof instance.shouldComponentUpdate === 'function') {
                var gDSFP = lifecycles.getDerivedStateFromProps;

                if (gDSFP && gDSFP.hasShouldComponentUpdateBug) {
                  mockSCUIfgDSFPReturnNonNull(node, state);
                }
                shouldComponentUpdateSpy = (0, _Utils.spyMethod)(instance, 'shouldComponentUpdate');
              }
              if (lifecycles.getChildContext.calledByRenderer && typeof instance.getChildContext === 'function') {
                getChildContextSpy = (0, _Utils.spyMethod)(instance, 'getChildContext');
              }
            }
            if (!shouldComponentUpdateSpy && isPureComponent(instance)) {
              shouldRender = pureComponentShouldComponentUpdate(prevProps, instance.props, prevState, (0, _object2['default'])({}, prevState, statePayload));
            }

            // We don't pass the setState callback here
            // to guarantee to call the callback after finishing the render
            if (instance[SET_STATE]) {
              instance[SET_STATE](statePayload);
            } else {
              instance.setState(statePayload);
            }
            if (shouldComponentUpdateSpy) {
              shouldRender = shouldComponentUpdateSpy.getLastReturnValue();
              shouldComponentUpdateSpy.restore();
            }
            if (maybeHasUpdate && shouldRender && !_this5[OPTIONS].disableLifecycleMethods) {
              privateSetChildContext(adapter, _this5, instance, node, getChildContextSpy);
              if (lifecycles.componentDidUpdate && lifecycles.componentDidUpdate.onSetState) {
                if (lifecycles.getSnapshotBeforeUpdate && typeof instance.getSnapshotBeforeUpdate === 'function') {
                  var snapshot = instance.getSnapshotBeforeUpdate(prevProps, prevState);
                  if (typeof instance.componentDidUpdate === 'function') {
                    instance.componentDidUpdate(prevProps, prevState, snapshot);
                  }
                } else if (typeof instance.componentDidUpdate === 'function') {
                  if (lifecycles.componentDidUpdate.prevContext) {
                    instance.componentDidUpdate(prevProps, prevState, prevContext);
                  } else {
                    instance.componentDidUpdate(prevProps, prevState);
                  }
                }
              }
            }
            _this5.update();
            // call the setState callback
            if (callback) {
              if (adapter.invokeSetStateCallback) {
                adapter.invokeSetStateCallback(instance, callback);
              } else {
                callback.call(instance);
              }
            }
          });
        });
        return this;
      }

      return setState;
    }()

    /**
     * A method that sets the context of the root component, and re-renders. Useful for when you are
     * wanting to test how the component behaves over time with changing contexts.
     *
     * NOTE: can only be called on a wrapper instance that is also the root instance.
     *
     * @param {Object} context object
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'setContext',
    value: function () {
      function setContext(context) {
        if (this[ROOT] !== this) {
          throw new Error('ShallowWrapper::setContext() can only be called on the root');
        }
        if (!this[OPTIONS].context) {
          throw new Error('ShallowWrapper::setContext() can only be called on a wrapper that was originally passed a context option');
        }
        return this.rerender(null, context);
      }

      return setContext;
    }()

    /**
     * Whether or not a given react element exists in the shallow render tree.
     *
     * Example:
     * ```
     * const wrapper = shallow(<MyComponent />);
     * expect(wrapper.contains(<div className="foo bar" />)).to.equal(true);
     * ```
     *
     * @param {ReactElement|Array<ReactElement>} nodeOrNodes
     * @returns {Boolean}
     */

  }, {
    key: 'contains',
    value: function () {
      function contains(nodeOrNodes) {
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        if (!(0, _Utils.isReactElementAlike)(nodeOrNodes, adapter)) {
          throw new Error('ShallowWrapper::contains() can only be called with a ReactElement (or an array of them), a string, or a number as an argument.');
        }
        var predicate = Array.isArray(nodeOrNodes) ? function (other) {
          return (0, _Utils.containsChildrenSubArray)(_Utils.nodeEqual, other, nodeOrNodes.map(function (node) {
            return adapter.elementToNode(node);
          }));
        } : function (other) {
          return (0, _Utils.nodeEqual)(adapter.elementToNode(nodeOrNodes), other);
        };

        return findWhereUnwrapped(this, predicate).length > 0;
      }

      return contains;
    }()

    /**
     * Whether or not a given react element exists in the shallow render tree.
     * Match is based on the expected element and not on wrappers element.
     * It will determine if one of the wrappers element "looks like" the expected
     * element by checking if all props of the expected element are present
     * on the wrappers element and equals to each other.
     *
     * Example:
     * ```
     * // MyComponent outputs <div><div class="foo">Hello</div></div>
     * const wrapper = shallow(<MyComponent />);
     * expect(wrapper.containsMatchingElement(<div>Hello</div>)).to.equal(true);
     * ```
     *
     * @param {ReactElement} node
     * @returns {Boolean}
     */

  }, {
    key: 'containsMatchingElement',
    value: function () {
      function containsMatchingElement(node) {
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        var rstNode = adapter.elementToNode(node);
        var predicate = function () {
          function predicate(other) {
            return (0, _Utils.nodeMatches)(rstNode, other, function (a, b) {
              return a <= b;
            });
          }

          return predicate;
        }();
        return findWhereUnwrapped(this, predicate).length > 0;
      }

      return containsMatchingElement;
    }()

    /**
     * Whether or not all the given react elements exists in the shallow render tree.
     * Match is based on the expected element and not on wrappers element.
     * It will determine if one of the wrappers element "looks like" the expected
     * element by checking if all props of the expected element are present
     * on the wrappers element and equals to each other.
     *
     * Example:
     * ```
     * const wrapper = shallow(<MyComponent />);
     * expect(wrapper.containsAllMatchingElements([
     *   <div>Hello</div>,
     *   <div>Goodbye</div>,
     * ])).to.equal(true);
     * ```
     *
     * @param {Array<ReactElement>} nodes
     * @returns {Boolean}
     */

  }, {
    key: 'containsAllMatchingElements',
    value: function () {
      function containsAllMatchingElements(nodes) {
        var _this6 = this;

        if (!Array.isArray(nodes)) {
          throw new TypeError('nodes should be an Array');
        }

        return nodes.every(function (node) {
          return _this6.containsMatchingElement(node);
        });
      }

      return containsAllMatchingElements;
    }()

    /**
     * Whether or not one of the given react elements exists in the shallow render tree.
     * Match is based on the expected element and not on wrappers element.
     * It will determine if one of the wrappers element "looks like" the expected
     * element by checking if all props of the expected element are present
     * on the wrappers element and equals to each other.
     *
     * Example:
     * ```
     * const wrapper = shallow(<MyComponent />);
     * expect(wrapper.containsAnyMatchingElements([
     *   <div>Hello</div>,
     *   <div>Goodbye</div>,
     * ])).to.equal(true);
     * ```
     *
     * @param {Array<ReactElement>} nodes
     * @returns {Boolean}
     */

  }, {
    key: 'containsAnyMatchingElements',
    value: function () {
      function containsAnyMatchingElements(nodes) {
        var _this7 = this;

        return Array.isArray(nodes) && nodes.some(function (node) {
          return _this7.containsMatchingElement(node);
        });
      }

      return containsAnyMatchingElements;
    }()

    /**
     * Whether or not a given react element exists in the render tree.
     *
     * Example:
     * ```
     * const wrapper = shallow(<MyComponent />);
     * expect(wrapper.contains(<div className="foo bar" />)).to.equal(true);
     * ```
     *
     * @param {ReactElement} node
     * @returns {Boolean}
     */

  }, {
    key: 'equals',
    value: function () {
      function equals(node) {
        var _this8 = this;

        return this.single('equals', function () {
          return (0, _Utils.nodeEqual)(_this8.getNodeInternal(), node);
        });
      }

      return equals;
    }()

    /**
     * Whether or not a given react element matches the render tree.
     * Match is based on the expected element and not on wrapper root node.
     * It will determine if the wrapper root node "looks like" the expected
     * element by checking if all props of the expected element are present
     * on the wrapper root node and equals to each other.
     *
     * Example:
     * ```
     * // MyComponent outputs <div class="foo">Hello</div>
     * const wrapper = shallow(<MyComponent />);
     * expect(wrapper.matchesElement(<div>Hello</div>)).to.equal(true);
     * ```
     *
     * @param {ReactElement} node
     * @returns {Boolean}
     */

  }, {
    key: 'matchesElement',
    value: function () {
      function matchesElement(node) {
        var _this9 = this;

        return this.single('matchesElement', function () {
          var adapter = (0, _getAdapter2['default'])(_this9[OPTIONS]);
          var rstNode = adapter.elementToNode(node);
          return (0, _Utils.nodeMatches)(rstNode, _this9.getNodeInternal(), function (a, b) {
            return a <= b;
          });
        });
      }

      return matchesElement;
    }()

    /**
     * Finds every node in the render tree of the current wrapper that matches the provided selector.
     *
     * @param {EnzymeSelector} selector
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'find',
    value: function () {
      function find(selector) {
        return this.wrap((0, _selectors.reduceTreesBySelector)(selector, this.getNodesInternal()));
      }

      return find;
    }()

    /**
     * Returns whether or not current node matches a provided selector.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @param {EnzymeSelector} selector
     * @returns {boolean}
     */

  }, {
    key: 'is',
    value: function () {
      function is(selector) {
        var predicate = (0, _selectors.buildPredicate)(selector);
        return this.single('is', function (n) {
          return predicate(n);
        });
      }

      return is;
    }()

    /**
     * Returns true if the component rendered nothing, i.e., null or false.
     *
     * @returns {boolean}
     */

  }, {
    key: 'isEmptyRender',
    value: function () {
      function isEmptyRender() {
        var nodes = this.getNodesInternal();

        return nodes.every(function (n) {
          return (0, _Utils.isEmptyValue)(n);
        });
      }

      return isEmptyRender;
    }()

    /**
     * Returns a new wrapper instance with only the nodes of the current wrapper instance that match
     * the provided predicate function. The predicate should receive a wrapped node as its first
     * argument.
     *
     * @param {Function} predicate
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'filterWhere',
    value: function () {
      function filterWhere(predicate) {
        var _this10 = this;

        return filterWhereUnwrapped(this, function (n) {
          return predicate(_this10.wrap(n));
        });
      }

      return filterWhere;
    }()

    /**
     * Returns a new wrapper instance with only the nodes of the current wrapper instance that match
     * the provided selector.
     *
     * @param {EnzymeSelector} selector
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'filter',
    value: function () {
      function filter(selector) {
        var predicate = (0, _selectors.buildPredicate)(selector);
        return filterWhereUnwrapped(this, predicate);
      }

      return filter;
    }()

    /**
     * Returns a new wrapper instance with only the nodes of the current wrapper that did not match
     * the provided selector. Essentially the inverse of `filter`.
     *
     * @param {EnzymeSelector} selector
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'not',
    value: function () {
      function not(selector) {
        var predicate = (0, _selectors.buildPredicate)(selector);
        return filterWhereUnwrapped(this, function (n) {
          return !predicate(n);
        });
      }

      return not;
    }()

    /**
     * Returns a string of the rendered text of the current render tree.  This function should be
     * looked at with skepticism if being used to test what the actual HTML output of the component
     * will be. If that is what you would like to test, use enzyme's `render` function instead.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @returns {String}
     */

  }, {
    key: 'text',
    value: function () {
      function text() {
        return this.single('text', _RSTTraversal.getTextFromNode);
      }

      return text;
    }()

    /**
     * Returns the HTML of the node.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @returns {String}
     */

  }, {
    key: 'html',
    value: function () {
      function html() {
        var _this11 = this;

        return this.single('html', function (n) {
          if (_this11.type() === null) return null;
          var adapter = (0, _getAdapter2['default'])(_this11[OPTIONS]);
          var renderer = adapter.createRenderer((0, _object2['default'])({}, _this11[OPTIONS], { mode: 'string' }));
          return renderer.render(adapter.nodeToElement(n));
        });
      }

      return html;
    }()

    /**
     * Returns the current node rendered to HTML and wrapped in a CheerioWrapper.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @returns {CheerioWrapper}
     */

  }, {
    key: 'render',
    value: function () {
      function render() {
        return this.type() === null ? (0, _cheerio2['default'])() : _cheerio2['default'].load('')(this.html());
      }

      return render;
    }()

    /**
     * Used to simulate events. Pass an eventname and (optionally) event arguments. This method of
     * testing events should be met with some skepticism.
     *
     * @param {String} event
     * @param {Array} args
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'simulate',
    value: function () {
      function simulate(event) {
        var _this12 = this;

        for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }

        return this.single('simulate', function (n) {
          var _RENDERER;

          (_RENDERER = _this12[RENDERER]).simulateEvent.apply(_RENDERER, [n, event].concat(args));
          _this12[ROOT].update();
          return _this12;
        });
      }

      return simulate;
    }()

    /**
     * Used to simulate throwing a rendering error. Pass an error to throw.
     *
     * @param {String} error
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'simulateError',
    value: function () {
      function simulateError(error) {
        var _this13 = this;

        // in shallow, the "root" is the "rendered" thing.

        return this.single('simulateError', function (thisNode) {
          if (thisNode.nodeType === 'host') {
            throw new TypeError('ShallowWrapper::simulateError() can only be called on custom components');
          }

          var renderer = _this13[RENDERER];
          if (typeof renderer.simulateError !== 'function') {
            throw new TypeError('your adapter does not support `simulateError`. Try upgrading it!');
          }

          var rootNode = getRootNodeInternal(_this13);
          var nodeHierarchy = [thisNode].concat(nodeParents(_this13, thisNode));
          renderer.simulateError(nodeHierarchy, rootNode, error);

          return _this13;
        });
      }

      return simulateError;
    }()

    /**
     * Returns the props hash for the current node of the wrapper.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @returns {Object}
     */

  }, {
    key: 'props',
    value: function () {
      function props() {
        return this.single('props', _RSTTraversal.propsOfNode);
      }

      return props;
    }()

    /**
     * Returns the state hash for the root node of the wrapper. Optionally pass in a prop name and it
     * will return just that value.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @param {String} name (optional)
     * @returns {*}
     */

  }, {
    key: 'state',
    value: function () {
      function state(name) {
        var _this14 = this;

        if (this[ROOT] !== this) {
          throw new Error('ShallowWrapper::state() can only be called on the root');
        }
        if (this.instance() === null || this[RENDERER].getNode().nodeType !== 'class') {
          throw new Error('ShallowWrapper::state() can only be called on class components');
        }
        var _state = this.single('state', function () {
          return _this14.instance().state;
        });
        if (typeof name !== 'undefined') {
          if (_state == null) {
            throw new TypeError('ShallowWrapper::state("' + String(name) + '") requires that `state` not be `null` or `undefined`');
          }
          return _state[name];
        }
        return _state;
      }

      return state;
    }()

    /**
     * Returns the context hash for the root node of the wrapper.
     * Optionally pass in a prop name and it will return just that value.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @param {String} name (optional)
     * @returns {*}
     */

  }, {
    key: 'context',
    value: function () {
      function context(name) {
        var _this15 = this;

        if (this[ROOT] !== this) {
          throw new Error('ShallowWrapper::context() can only be called on the root');
        }
        if (!this[OPTIONS].context) {
          throw new Error('ShallowWrapper::context() can only be called on a wrapper that was originally passed a context option');
        }
        if (this.instance() === null) {
          throw new Error('ShallowWrapper::context() can only be called on wrapped nodes that have a non-null instance');
        }
        var _context = this.single('context', function () {
          return _this15.instance().context;
        });
        if (name) {
          return _context[name];
        }
        return _context;
      }

      return context;
    }()

    /**
     * Returns a new wrapper with all of the children of the current wrapper.
     *
     * @param {EnzymeSelector} [selector]
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'children',
    value: function () {
      function children(selector) {
        var allChildren = this.flatMap(function (n) {
          return (0, _RSTTraversal.childrenOfNode)(n.getNodeInternal());
        });
        return selector ? allChildren.filter(selector) : allChildren;
      }

      return children;
    }()

    /**
     * Returns a new wrapper with a specific child
     *
     * @param {Number} [index]
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'childAt',
    value: function () {
      function childAt(index) {
        var _this16 = this;

        return this.single('childAt', function () {
          return _this16.children().at(index);
        });
      }

      return childAt;
    }()

    /**
     * Returns a wrapper around all of the parents/ancestors of the wrapper. Does not include the node
     * in the current wrapper.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @param {EnzymeSelector} [selector]
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'parents',
    value: function () {
      function parents(selector) {
        var _this17 = this;

        return this.single('parents', function (n) {
          var allParents = _this17.wrap(nodeParents(_this17, n));
          return selector ? allParents.filter(selector) : allParents;
        });
      }

      return parents;
    }()

    /**
     * Returns a wrapper around the immediate parent of the current node.
     *
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'parent',
    value: function () {
      function parent() {
        return this.flatMap(function (n) {
          return [n.parents().get(0)];
        });
      }

      return parent;
    }()

    /**
     *
     * @param {EnzymeSelector} selector
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'closest',
    value: function () {
      function closest(selector) {
        if (this.is(selector)) {
          return this;
        }
        var matchingAncestors = this.parents().filter(selector);
        return matchingAncestors.length > 0 ? matchingAncestors.first() : this.findWhere(function () {
          return false;
        });
      }

      return closest;
    }()

    /**
     * Shallow renders the current node and returns a shallow wrapper around it.
     *
     * NOTE: can only be called on wrapper of a single node.
     *
     * @param {Object} options
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'shallow',
    value: function () {
      function shallow(options) {
        var _this18 = this;

        return this.single('shallow', function (n) {
          return _this18.wrap((0, _getAdapter2['default'])(_this18[OPTIONS]).nodeToElement(n), null, options);
        });
      }

      return shallow;
    }()

    /**
     * Returns the value of prop with the given name of the current node.
     *
     * @param propName
     * @returns {*}
     */

  }, {
    key: 'prop',
    value: function () {
      function prop(propName) {
        return this.props()[propName];
      }

      return prop;
    }()

    /**
     * Used to invoke a function prop.
     * Will invoke an function prop and return its value.
     *
     * @param {String} propName
     * @returns {Any}
     */

  }, {
    key: 'invoke',
    value: function () {
      function invoke(propName) {
        var _this19 = this;

        return this.single('invoke', function () {
          var handler = _this19.prop(propName);
          if (typeof handler !== 'function') {
            throw new TypeError('ShallowWrapper::invoke() requires the name of a prop whose value is a function');
          }
          return function () {
            var response = handler.apply(undefined, arguments);
            _this19[ROOT].update();
            return response;
          };
        });
      }

      return invoke;
    }()

    /**
     * Returns a wrapper of the node rendered by the provided render prop.
     *
     * @param {String} propName
     * @returns {Function}
     */

  }, {
    key: 'renderProp',
    value: function () {
      function renderProp(propName) {
        var _this20 = this;

        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        if (typeof adapter.wrap !== 'function') {
          throw new RangeError('your adapter does not support `wrap`. Try upgrading it!');
        }

        return this.single('renderProp', function (n) {
          if (n.nodeType === 'host') {
            throw new TypeError('ShallowWrapper::renderProp() can only be called on custom components');
          }
          if (typeof propName !== 'string') {
            throw new TypeError('ShallowWrapper::renderProp(): `propName` must be a string');
          }
          var props = _this20.props();
          if (!(0, _has2['default'])(props, propName)) {
            throw new Error('ShallowWrapper::renderProp(): no prop called \u201C' + String(propName) + '\u201C found');
          }
          var propValue = props[propName];
          if (typeof propValue !== 'function') {
            throw new TypeError('ShallowWrapper::renderProp(): expected prop \u201C' + String(propName) + '\u201C to contain a function, but it holds \u201C' + (typeof propValue === 'undefined' ? 'undefined' : _typeof(propValue)) + '\u201C');
          }

          return function () {
            var element = propValue.apply(undefined, arguments);
            var wrapped = adapter.wrap(element);
            return _this20.wrap(wrapped, null, _this20[OPTIONS]);
          };
        });
      }

      return renderProp;
    }()

    /**
     * Returns the key assigned to the current node.
     *
     * @returns {String}
     */

  }, {
    key: 'key',
    value: function () {
      function key() {
        return this.single('key', function (n) {
          return n.key === undefined ? null : n.key;
        });
      }

      return key;
    }()

    /**
     * Returns the type of the current node of this wrapper. If it's a composite component, this will
     * be the component constructor. If it's a native DOM node, it will be a string of the tag name.
     * If it's null, it will be null.
     *
     * @returns {String|Function|null}
     */

  }, {
    key: 'type',
    value: function () {
      function type() {
        return this.single('type', function (n) {
          return (0, _Utils.typeOfNode)(n);
        });
      }

      return type;
    }()

    /**
     * Returns the name of the current node of this wrapper.
     *
     * In order of precedence => type.displayName -> type.name -> type.
     *
     * @returns {String}
     */

  }, {
    key: 'name',
    value: function () {
      function name() {
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        return this.single('name', function (n) {
          return adapter.displayNameOfNode ? adapter.displayNameOfNode(n) : (0, _Utils.displayNameOfNode)(n);
        });
      }

      return name;
    }()

    /**
     * Returns whether or not the current node has the given class name or not.
     *
     * NOTE: can only be called on a wrapper of a single node.
     *
     * @param className
     * @returns {Boolean}
     */

  }, {
    key: 'hasClass',
    value: function () {
      function hasClass(className) {
        if (typeof className === 'string' && className.indexOf('.') !== -1) {
          // eslint-disable-next-line no-console
          console.warn('It looks like you\'re calling `ShallowWrapper::hasClass()` with a CSS selector. hasClass() expects a class name, not a CSS selector.');
        }
        return this.single('hasClass', function (n) {
          return (0, _RSTTraversal.hasClassName)(n, className);
        });
      }

      return hasClass;
    }()

    /**
     * Iterates through each node of the current wrapper and executes the provided function with a
     * wrapper around the corresponding node passed in as the first argument.
     *
     * @param {Function} fn
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'forEach',
    value: function () {
      function forEach(fn) {
        var _this21 = this;

        this.getNodesInternal().forEach(function (n, i) {
          return fn.call(_this21, _this21.wrap(n), i);
        });
        return this;
      }

      return forEach;
    }()

    /**
     * Maps the current array of nodes to another array. Each node is passed in as a `ShallowWrapper`
     * to the map function.
     *
     * @param {Function} fn
     * @returns {Array}
     */

  }, {
    key: 'map',
    value: function () {
      function map(fn) {
        var _this22 = this;

        return this.getNodesInternal().map(function (n, i) {
          return fn.call(_this22, _this22.wrap(n), i);
        });
      }

      return map;
    }()

    /**
     * Reduces the current array of nodes to a value. Each node is passed in as a `ShallowWrapper`
     * to the reducer function.
     *
     * @param {Function} fn - the reducer function
     * @param {*} initialValue - the initial value
     * @returns {*}
     */

  }, {
    key: 'reduce',
    value: function () {
      function reduce(fn) {
        var _this23 = this;

        var initialValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

        if (arguments.length > 1) {
          return this.getNodesInternal().reduce(function (accum, n, i) {
            return fn.call(_this23, accum, _this23.wrap(n), i);
          }, initialValue);
        }
        return this.getNodesInternal().reduce(function (accum, n, i) {
          return fn.call(_this23, i === 1 ? _this23.wrap(accum) : accum, _this23.wrap(n), i);
        });
      }

      return reduce;
    }()

    /**
     * Reduces the current array of nodes to another array, from right to left. Each node is passed
     * in as a `ShallowWrapper` to the reducer function.
     *
     * @param {Function} fn - the reducer function
     * @param {*} initialValue - the initial value
     * @returns {*}
     */

  }, {
    key: 'reduceRight',
    value: function () {
      function reduceRight(fn) {
        var _this24 = this;

        var initialValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

        if (arguments.length > 1) {
          return this.getNodesInternal().reduceRight(function (accum, n, i) {
            return fn.call(_this24, accum, _this24.wrap(n), i);
          }, initialValue);
        }
        return this.getNodesInternal().reduceRight(function (accum, n, i) {
          return fn.call(_this24, i === 1 ? _this24.wrap(accum) : accum, _this24.wrap(n), i);
        });
      }

      return reduceRight;
    }()

    /**
     * Returns a new wrapper with a subset of the nodes of the original wrapper, according to the
     * rules of `Array#slice`.
     *
     * @param {Number} begin
     * @param {Number} end
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'slice',
    value: function () {
      function slice(begin, end) {
        return this.wrap(this.getNodesInternal().slice(begin, end));
      }

      return slice;
    }()

    /**
     * Returns whether or not any of the nodes in the wrapper match the provided selector.
     *
     * @param {EnzymeSelector} selector
     * @returns {Boolean}
     */

  }, {
    key: 'some',
    value: function () {
      function some(selector) {
        if (this[ROOT] === this) {
          throw new Error('ShallowWrapper::some() can not be called on the root');
        }
        var predicate = (0, _selectors.buildPredicate)(selector);
        return this.getNodesInternal().some(predicate);
      }

      return some;
    }()

    /**
     * Returns whether or not any of the nodes in the wrapper pass the provided predicate function.
     *
     * @param {Function} predicate
     * @returns {Boolean}
     */

  }, {
    key: 'someWhere',
    value: function () {
      function someWhere(predicate) {
        var _this25 = this;

        return this.getNodesInternal().some(function (n, i) {
          return predicate.call(_this25, _this25.wrap(n), i);
        });
      }

      return someWhere;
    }()

    /**
     * Returns whether or not all of the nodes in the wrapper match the provided selector.
     *
     * @param {EnzymeSelector} selector
     * @returns {Boolean}
     */

  }, {
    key: 'every',
    value: function () {
      function every(selector) {
        var predicate = (0, _selectors.buildPredicate)(selector);
        return this.getNodesInternal().every(predicate);
      }

      return every;
    }()

    /**
     * Returns whether or not any of the nodes in the wrapper pass the provided predicate function.
     *
     * @param {Function} predicate
     * @returns {Boolean}
     */

  }, {
    key: 'everyWhere',
    value: function () {
      function everyWhere(predicate) {
        var _this26 = this;

        return this.getNodesInternal().every(function (n, i) {
          return predicate.call(_this26, _this26.wrap(n), i);
        });
      }

      return everyWhere;
    }()

    /**
     * Utility method used to create new wrappers with a mapping function that returns an array of
     * nodes in response to a single node wrapper. The returned wrapper is a single wrapper around
     * all of the mapped nodes flattened (and de-duplicated).
     *
     * @param {Function} fn
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'flatMap',
    value: function () {
      function flatMap(fn) {
        var _this27 = this;

        var nodes = this.getNodesInternal().map(function (n, i) {
          return fn.call(_this27, _this27.wrap(n), i);
        });
        var flattened = (0, _arrayPrototype2['default'])(nodes, 1);
        return this.wrap(flattened.filter(Boolean));
      }

      return flatMap;
    }()

    /**
     * Finds all nodes in the current wrapper nodes' render trees that match the provided predicate
     * function. The predicate function will receive the nodes inside a ShallowWrapper as its
     * first argument.
     *
     * @param {Function} predicate
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'findWhere',
    value: function () {
      function findWhere(predicate) {
        var _this28 = this;

        return findWhereUnwrapped(this, function (n) {
          var node = _this28.wrap(n);
          return node.length > 0 && predicate(node);
        });
      }

      return findWhere;
    }()

    /**
     * Returns the node at a given index of the current wrapper.
     *
     * @param index
     * @returns {ReactElement}
     */

  }, {
    key: 'get',
    value: function () {
      function get(index) {
        return this.getElements()[index];
      }

      return get;
    }()

    /**
     * Returns a wrapper around the node at a given index of the current wrapper.
     *
     * @param index
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'at',
    value: function () {
      function at(index) {
        var nodes = this.getNodesInternal();
        if (index < nodes.length) {
          return this.wrap(nodes[index]);
        }
        return this.wrap([]);
      }

      return at;
    }()

    /**
     * Returns a wrapper around the first node of the current wrapper.
     *
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'first',
    value: function () {
      function first() {
        return this.at(0);
      }

      return first;
    }()

    /**
     * Returns a wrapper around the last node of the current wrapper.
     *
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'last',
    value: function () {
      function last() {
        return this.at(this.length - 1);
      }

      return last;
    }()

    /**
     * Delegates to exists()
     *
     * @returns {boolean}
     */

  }, {
    key: 'isEmpty',
    value: function () {
      function isEmpty() {
        // eslint-disable-next-line no-console
        console.warn('Enzyme::Deprecated method isEmpty() called, use exists() instead.');
        return !this.exists();
      }

      return isEmpty;
    }()

    /**
     * Returns true if the current wrapper has nodes. False otherwise.
     * If called with a selector it returns `.find(selector).exists()` instead.
     *
     * @param {EnzymeSelector} selector (optional)
     * @returns {boolean}
     */

  }, {
    key: 'exists',
    value: function () {
      function exists() {
        var selector = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

        return arguments.length > 0 ? this.find(selector).exists() : this.length > 0;
      }

      return exists;
    }()

    /**
     * Utility method that throws an error if the current instance has a length other than one.
     * This is primarily used to enforce that certain methods are only run on a wrapper when it is
     * wrapping a single node.
     *
     * @param fn
     * @returns {*}
     */

  }, {
    key: 'single',
    value: function () {
      function single(name, fn) {
        var fnName = typeof name === 'string' ? name : 'unknown';
        var callback = typeof fn === 'function' ? fn : name;
        if (this.length !== 1) {
          throw new Error('Method \u201C' + fnName + '\u201D is meant to be run on 1 node. ' + String(this.length) + ' found instead.');
        }
        return callback.call(this, this.getNodeInternal());
      }

      return single;
    }()

    /**
     * Helpful utility method to create a new wrapper with the same root as the current wrapper, with
     * any nodes passed in as the first parameter automatically wrapped.
     *
     * @param node
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'wrap',
    value: function () {
      function wrap(node) {
        var root = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this[ROOT];

        if (node instanceof ShallowWrapper) {
          return node;
        }

        for (var _len3 = arguments.length, args = Array(_len3 > 2 ? _len3 - 2 : 0), _key3 = 2; _key3 < _len3; _key3++) {
          args[_key3 - 2] = arguments[_key3];
        }

        return new (Function.prototype.bind.apply(ShallowWrapper, [null].concat([node, root], args)))();
      }

      return wrap;
    }()

    /**
     * Returns an HTML-like string of the shallow render for debugging purposes.
     *
     * @param {Object} [options] - Property bag of additional options.
     * @param {boolean} [options.ignoreProps] - if true, props are omitted from the string.
     * @param {boolean} [options.verbose] - if true, arrays and objects to be verbosely printed.
     * @returns {String}
     */

  }, {
    key: 'debug',
    value: function () {
      function debug() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        return (0, _Debug.debugNodes)(this.getNodesInternal(), options);
      }

      return debug;
    }()

    /**
     * Invokes intercepter and returns itself. intercepter is called with itself.
     * This is helpful when debugging nodes in method chains.
     * @param fn
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'tap',
    value: function () {
      function tap(intercepter) {
        intercepter(this);
        return this;
      }

      return tap;
    }()

    /**
     * Primarily useful for HOCs (higher-order components), this method may only be
     * run on a single, non-DOM node, and will return the node, shallow-rendered.
     *
     * @param {Object} options
     * @returns {ShallowWrapper}
     */

  }, {
    key: 'dive',
    value: function () {
      function dive() {
        var _this29 = this;

        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        var name = 'dive';
        return this.single(name, function (n) {
          if (n && n.nodeType === 'host') {
            throw new TypeError('ShallowWrapper::' + name + '() can not be called on Host Components');
          }
          var el = (0, _getAdapter2['default'])(_this29[OPTIONS]).nodeToElement(n);
          if (!(0, _Utils.isCustomComponentElement)(el, adapter)) {
            throw new TypeError('ShallowWrapper::' + name + '() can only be called on components');
          }
          var childOptions = (0, _object2['default'])({}, _this29[OPTIONS], options, {
            context: options.context || (0, _object2['default'])({}, _this29[OPTIONS].context, _this29[ROOT][CHILD_CONTEXT])
          });
          (0, _Utils.privateSet)(childOptions, PROVIDER_VALUES, _this29[ROOT][PROVIDER_VALUES]);
          return _this29.wrap(el, null, childOptions);
        });
      }

      return dive;
    }()

    /**
     * Strips out all the not host-nodes from the list of nodes
     *
     * This method is useful if you want to check for the presence of host nodes
     * (actually rendered HTML elements) ignoring the React nodes.
     */

  }, {
    key: 'hostNodes',
    value: function () {
      function hostNodes() {
        return this.filterWhere(function (n) {
          return typeof n.type() === 'string';
        });
      }

      return hostNodes;
    }()
  }]);

  return ShallowWrapper;
}();

/**
 * Updates the context of the primary wrapper when the
 * `wrappingComponent` re-renders.
 */


function updatePrimaryRootContext(wrappingComponent) {
  var adapter = (0, _getAdapter2['default'])(wrappingComponent[OPTIONS]);
  var primaryWrapper = wrappingComponent[PRIMARY_WRAPPER];
  var primaryRenderer = primaryWrapper[RENDERER];
  var primaryNode = primaryRenderer.getNode();

  var _getContextFromWrappi2 = getContextFromWrappingComponent(wrappingComponent, adapter),
      legacyContext = _getContextFromWrappi2.legacyContext,
      providerValues = _getContextFromWrappi2.providerValues;

  var prevProviderValues = primaryWrapper[PROVIDER_VALUES];

  primaryWrapper.setContext((0, _object2['default'])({}, wrappingComponent[PRIMARY_WRAPPER][OPTIONS].context, legacyContext));
  primaryWrapper[PROVIDER_VALUES] = new Map([].concat(_toConsumableArray(prevProviderValues), _toConsumableArray(providerValues)));

  if (typeof adapter.isContextConsumer === 'function' && adapter.isContextConsumer(primaryNode.type)) {
    var Consumer = primaryNode.type;
    // Adapters with an `isContextConsumer` method will definitely have a `getProviderFromConsumer`
    // method.
    var Provider = adapter.getProviderFromConsumer(Consumer);
    var newValue = providerValues.get(Provider);
    var oldValue = prevProviderValues.get(Provider);

    // Use referential comparison like React
    if (newValue !== oldValue) {
      primaryWrapper.rerender();
    }
  }
}

/**
 * A *special* "root" wrapper that represents the component passed as `wrappingComponent`.
 * It is linked to the primary root such that updates to it will update the primary.
 *
 * @class WrappingComponentWrapper
 */

var WrappingComponentWrapper = function (_ShallowWrapper) {
  _inherits(WrappingComponentWrapper, _ShallowWrapper);

  function WrappingComponentWrapper(nodes, root, RootFinder) {
    _classCallCheck(this, WrappingComponentWrapper);

    var _this30 = _possibleConstructorReturn(this, (WrappingComponentWrapper.__proto__ || Object.getPrototypeOf(WrappingComponentWrapper)).call(this, nodes));

    (0, _Utils.privateSet)(_this30, PRIMARY_WRAPPER, root);
    (0, _Utils.privateSet)(_this30, ROOT_FINDER, RootFinder);
    return _this30;
  }

  /**
   * Like rerender() on ShallowWrapper, except it also does a "full render" of
   * itself and updates the primary ShallowWrapper's context.
   */


  _createClass(WrappingComponentWrapper, [{
    key: 'rerender',
    value: function () {
      function rerender() {
        var _get2;

        for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
          args[_key4] = arguments[_key4];
        }

        var result = (_get2 = _get(WrappingComponentWrapper.prototype.__proto__ || Object.getPrototypeOf(WrappingComponentWrapper.prototype), 'rerender', this)).call.apply(_get2, [this].concat(args));
        updatePrimaryRootContext(this);
        return result;
      }

      return rerender;
    }()

    /**
     * Like setState() on ShallowWrapper, except it also does a "full render" of
     * itself and updates the primary ShallowWrapper's context.
     */

  }, {
    key: 'setState',
    value: function () {
      function setState() {
        var _get3;

        for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
          args[_key5] = arguments[_key5];
        }

        var result = (_get3 = _get(WrappingComponentWrapper.prototype.__proto__ || Object.getPrototypeOf(WrappingComponentWrapper.prototype), 'setState', this)).call.apply(_get3, [this].concat(args));
        updatePrimaryRootContext(this);
        return result;
      }

      return setState;
    }()

    // eslint-disable-next-line class-methods-use-this

  }, {
    key: 'getWrappingComponent',
    value: function () {
      function getWrappingComponent() {
        throw new Error('ShallowWrapper::getWrappingComponent() can only be called on the root');
      }

      return getWrappingComponent;
    }()
  }]);

  return WrappingComponentWrapper;
}(ShallowWrapper);

if (_Utils.ITERATOR_SYMBOL) {
  Object.defineProperty(ShallowWrapper.prototype, _Utils.ITERATOR_SYMBOL, {
    configurable: true,
    value: function () {
      function iterator() {
        var _ref2;

        var iter = this.getNodesInternal()[_Utils.ITERATOR_SYMBOL]();
        var adapter = (0, _getAdapter2['default'])(this[OPTIONS]);
        return _ref2 = {}, _defineProperty(_ref2, _Utils.ITERATOR_SYMBOL, function () {
          return this;
        }), _defineProperty(_ref2, 'next', function () {
          function next() {
            var next = iter.next();
            if (next.done) {
              return { done: true };
            }
            return {
              done: false,
              value: adapter.nodeToElement(next.value)
            };
          }

          return next;
        }()), _ref2;
      }

      return iterator;
    }()
  });
}

function privateWarning(prop, extraMessage) {
  Object.defineProperty(ShallowWrapper.prototype, prop, {
    get: function () {
      function get() {
        throw new Error('\n        Attempted to access ShallowWrapper::' + String(prop) + ', which was previously a private property on\n        Enzyme ShallowWrapper instances, but is no longer and should not be relied upon.\n        ' + String(extraMessage) + '\n      ');
      }

      return get;
    }(),

    enumerable: false,
    configurable: false
  });
}

privateWarning('node', 'Consider using the getElement() method instead.');
privateWarning('nodes', 'Consider using the getElements() method instead.');
privateWarning('renderer', '');
privateWarning('options', '');
privateWarning('complexSelector', '');

exports['default'] = ShallowWrapper;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9TaGFsbG93V3JhcHBlci5qcyJdLCJuYW1lcyI6WyJOT0RFIiwiTk9ERVMiLCJSRU5ERVJFUiIsIlVOUkVOREVSRUQiLCJST09UIiwiT1BUSU9OUyIsIlNFVF9TVEFURSIsIlJPT1RfTk9ERVMiLCJDSElMRF9DT05URVhUIiwiV1JBUFBJTkdfQ09NUE9ORU5UIiwiUFJJTUFSWV9XUkFQUEVSIiwiUk9PVF9GSU5ERVIiLCJQUk9WSURFUl9WQUxVRVMiLCJmaW5kV2hlcmVVbndyYXBwZWQiLCJ3cmFwcGVyIiwicHJlZGljYXRlIiwiZmlsdGVyIiwidHJlZUZpbHRlciIsImZsYXRNYXAiLCJuIiwiZ2V0Tm9kZUludGVybmFsIiwiZmlsdGVyV2hlcmVVbndyYXBwZWQiLCJ3cmFwIiwiZ2V0Tm9kZXNJbnRlcm5hbCIsIkJvb2xlYW4iLCJ2YWxpZGF0ZU9wdGlvbnMiLCJvcHRpb25zIiwibGlmZWN5Y2xlRXhwZXJpbWVudGFsIiwiZGlzYWJsZUxpZmVjeWNsZU1ldGhvZHMiLCJlbmFibGVDb21wb25lbnREaWRVcGRhdGVPblNldFN0YXRlIiwic3VwcG9ydFByZXZDb250ZXh0QXJndW1lbnRPZkNvbXBvbmVudERpZFVwZGF0ZSIsImxpZmVjeWNsZXMiLCJFcnJvciIsImNvbXBvbmVudERpZFVwZGF0ZSIsIm9uU2V0U3RhdGUiLCJUeXBlRXJyb3IiLCJwcmV2Q29udGV4dCIsImdldEFkYXB0ZXJMaWZlY3ljbGVzIiwiaGFzTGVnYWN5U2V0U3RhdGVBcmciLCJoYXNMZWdhY3lQcmV2Q29udGV4dEFyZyIsIm9yaWdpbmFsR0RTRlAiLCJnZXREZXJpdmVkU3RhdGVGcm9tUHJvcHMiLCJoYXNTaG91bGRDb21wb25lbnRVcGRhdGVCdWciLCJzZXRTdGF0ZSIsImdldENoaWxkQ29udGV4dCIsImNhbGxlZEJ5UmVuZGVyZXIiLCJnZXRSb290Tm9kZSIsIm5vZGUiLCJub2RlVHlwZSIsInJlbmRlcmVkIiwiZ2V0Um9vdE5vZGVJbnRlcm5hbCIsImxlbmd0aCIsIm5vZGVQYXJlbnRzIiwicHJpdmF0ZVNldE5vZGVzIiwibm9kZXMiLCJBcnJheSIsImlzQXJyYXkiLCJwdXJlQ29tcG9uZW50U2hvdWxkQ29tcG9uZW50VXBkYXRlIiwicHJldlByb3BzIiwicHJvcHMiLCJwcmV2U3RhdGUiLCJzdGF0ZSIsImlzUHVyZUNvbXBvbmVudCIsImluc3RhbmNlIiwiaXNQdXJlUmVhY3RDb21wb25lbnQiLCJoaWVyYXJjaHkiLCJyZW5kZXJlciIsIkNvbXBvbmVudCIsInR5cGUiLCJjb21wb25lbnROYW1lIiwiY2hpbGRDb250ZXh0VHlwZXMiLCJjb25zb2xlIiwid2FybiIsImNoaWxkQ29udGV4dCIsIk9iamVjdCIsImtleXMiLCJmb3JFYWNoIiwia2V5IiwiY2hlY2tQcm9wVHlwZXMiLCJzcHlPbkdldENoaWxkQ29udGV4dEluaXRpYWxSZW5kZXIiLCJhZGFwdGVyIiwicHJvdG90eXBlIiwicHJpdmF0ZVNldENoaWxkQ29udGV4dCIsInJlbmRlcmVkTm9kZSIsImdldENoaWxkQ29udGV4dFNweSIsImxlZ2FjeUNvbnRleHRNb2RlIiwiZ2V0TGFzdFJldHVyblZhbHVlIiwicmVzdG9yZSIsIm5vZGVIaWVyYXJjaHkiLCJjb25jYXQiLCJtb2NrU0NVSWZnRFNGUFJldHVybk5vbk51bGwiLCJzaG91bGRDb21wb25lbnRVcGRhdGUiLCJhcmdzIiwic0NVUmVzdWx0Iiwib3JpZ2luYWxTQ1UiLCJhcHBseSIsIm5leHRTdGF0ZSIsImRlZXBSZW5kZXIiLCJ0YXJnZXQiLCJlbGVtZW50Iiwibm9kZVRvRWxlbWVudCIsImRpdmUiLCJjaGlsZHJlbiIsImkiLCJmb3VuZCIsImF0IiwidW5kZWZpbmVkIiwiZ2V0Q29udGV4dEZyb21XcmFwcGluZ0NvbXBvbmVudCIsInJvb3RGaW5kZXIiLCJsZWdhY3lDb250ZXh0IiwiY29udGV4dCIsInByb3ZpZGVyVmFsdWVzIiwibWFrZVNoYWxsb3dPcHRpb25zIiwicm9vdCIsInBhc3NlZE9wdGlvbnMiLCJ3cmFwcGluZ0NvbXBvbmVudCIsIndyYXBXaXRoV3JhcHBpbmdDb21wb25lbnQiLCJ3cmFwcGVkTm9kZSIsIlJvb3RGaW5kZXIiLCJXcmFwcGluZ0NvbXBvbmVudFdyYXBwZXIiLCJ3cmFwcGluZ0NvbXBvbmVudExlZ2FjeUNvbnRleHQiLCJ3cmFwcGluZ0NvbXBvbmVudFByb3ZpZGVyVmFsdWVzIiwiU2hhbGxvd1dyYXBwZXIiLCJpc1ZhbGlkRWxlbWVudCIsImNyZWF0ZVJlbmRlcmVyIiwibW9kZSIsIk1hcCIsInJlbmRlciIsImdldE5vZGUiLCJ1cGRhdGVyIiwiY2FsbGJhY2siLCJjb21wb25lbnREaWRNb3VudCIsImJhdGNoZWRVcGRhdGVzIiwidXBkYXRlIiwic2luZ2xlIiwibWFwIiwidW5tb3VudCIsIm5leHRDb250ZXh0Iiwic2hvdWxkUmVuZGVyIiwic2hvdWxkQ29tcG9uZW50VXBkYXRlU3B5IiwiZ0RTRlAiLCJnZXRTbmFwc2hvdEJlZm9yZVVwZGF0ZSIsInNuYXBzaG90IiwiZnJlZXplIiwiYXJndW1lbnRzIiwicmVyZW5kZXIiLCJzdGF0ZVBheWxvYWQiLCJjYWxsIiwibWF5YmVIYXNVcGRhdGUiLCJza2lwc0NvbXBvbmVudERpZFVwZGF0ZU9uTnVsbGlzaCIsImludm9rZVNldFN0YXRlQ2FsbGJhY2siLCJub2RlT3JOb2RlcyIsIm5vZGVFcXVhbCIsIm90aGVyIiwiZWxlbWVudFRvTm9kZSIsInJzdE5vZGUiLCJhIiwiYiIsImV2ZXJ5IiwiY29udGFpbnNNYXRjaGluZ0VsZW1lbnQiLCJzb21lIiwic2VsZWN0b3IiLCJnZXRUZXh0RnJvbU5vZGUiLCJjaGVlcmlvIiwibG9hZCIsImh0bWwiLCJldmVudCIsInNpbXVsYXRlRXZlbnQiLCJlcnJvciIsInRoaXNOb2RlIiwic2ltdWxhdGVFcnJvciIsInJvb3ROb2RlIiwicHJvcHNPZk5vZGUiLCJuYW1lIiwiX3N0YXRlIiwiX2NvbnRleHQiLCJhbGxDaGlsZHJlbiIsImluZGV4IiwiYWxsUGFyZW50cyIsInBhcmVudHMiLCJnZXQiLCJpcyIsIm1hdGNoaW5nQW5jZXN0b3JzIiwiZmlyc3QiLCJmaW5kV2hlcmUiLCJwcm9wTmFtZSIsImhhbmRsZXIiLCJwcm9wIiwicmVzcG9uc2UiLCJSYW5nZUVycm9yIiwicHJvcFZhbHVlIiwid3JhcHBlZCIsImRpc3BsYXlOYW1lT2ZOb2RlIiwiY2xhc3NOYW1lIiwiaW5kZXhPZiIsImZuIiwiaW5pdGlhbFZhbHVlIiwicmVkdWNlIiwiYWNjdW0iLCJyZWR1Y2VSaWdodCIsImJlZ2luIiwiZW5kIiwic2xpY2UiLCJmbGF0dGVuZWQiLCJnZXRFbGVtZW50cyIsImV4aXN0cyIsImZpbmQiLCJmbk5hbWUiLCJpbnRlcmNlcHRlciIsImVsIiwiY2hpbGRPcHRpb25zIiwiZmlsdGVyV2hlcmUiLCJ1cGRhdGVQcmltYXJ5Um9vdENvbnRleHQiLCJwcmltYXJ5V3JhcHBlciIsInByaW1hcnlSZW5kZXJlciIsInByaW1hcnlOb2RlIiwicHJldlByb3ZpZGVyVmFsdWVzIiwic2V0Q29udGV4dCIsImlzQ29udGV4dENvbnN1bWVyIiwiQ29uc3VtZXIiLCJQcm92aWRlciIsImdldFByb3ZpZGVyRnJvbUNvbnN1bWVyIiwibmV3VmFsdWUiLCJvbGRWYWx1ZSIsInJlc3VsdCIsIklURVJBVE9SX1NZTUJPTCIsImRlZmluZVByb3BlcnR5IiwiY29uZmlndXJhYmxlIiwidmFsdWUiLCJpdGVyYXRvciIsIml0ZXIiLCJuZXh0IiwiZG9uZSIsInByaXZhdGVXYXJuaW5nIiwiZXh0cmFNZXNzYWdlIiwiZW51bWVyYWJsZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFFQTs7QUFtQkE7Ozs7QUFDQTs7QUFDQTs7QUFRQTs7Ozs7Ozs7Ozs7Ozs7QUFFQSxJQUFNQSxPQUFPLGdCQUFJLFVBQUosQ0FBYjtBQUNBLElBQU1DLFFBQVEsZ0JBQUksV0FBSixDQUFkO0FBQ0EsSUFBTUMsV0FBVyxnQkFBSSxjQUFKLENBQWpCO0FBQ0EsSUFBTUMsYUFBYSxnQkFBSSxnQkFBSixDQUFuQjtBQUNBLElBQU1DLE9BQU8sZ0JBQUksVUFBSixDQUFiO0FBQ0EsSUFBTUMsVUFBVSxnQkFBSSxhQUFKLENBQWhCO0FBQ0EsSUFBTUMsWUFBWSxnQkFBSSxjQUFKLENBQWxCO0FBQ0EsSUFBTUMsYUFBYSxnQkFBSSxlQUFKLENBQW5CO0FBQ0EsSUFBTUMsZ0JBQWdCLGdCQUFJLGtCQUFKLENBQXRCO0FBQ0EsSUFBTUMscUJBQXFCLGdCQUFJLHVCQUFKLENBQTNCO0FBQ0EsSUFBTUMsa0JBQWtCLGdCQUFJLG9CQUFKLENBQXhCO0FBQ0EsSUFBTUMsY0FBYyxnQkFBSSxnQkFBSixDQUFwQjtBQUNBLElBQU1DLGtCQUFrQixnQkFBSSxvQkFBSixDQUF4Qjs7QUFFQTs7Ozs7Ozs7O0FBU0EsU0FBU0Msa0JBQVQsQ0FBNEJDLE9BQTVCLEVBQXFDQyxTQUFyQyxFQUFxRTtBQUFBLE1BQXJCQyxNQUFxQix1RUFBWkMsd0JBQVk7O0FBQ25FLFNBQU9ILFFBQVFJLE9BQVIsQ0FBZ0I7QUFBQSxXQUFLRixPQUFPRyxFQUFFQyxlQUFGLEVBQVAsRUFBNEJMLFNBQTVCLENBQUw7QUFBQSxHQUFoQixDQUFQO0FBQ0Q7O0FBRUQ7Ozs7Ozs7O0FBUUEsU0FBU00sb0JBQVQsQ0FBOEJQLE9BQTlCLEVBQXVDQyxTQUF2QyxFQUFrRDtBQUNoRCxTQUFPRCxRQUFRUSxJQUFSLENBQWFSLFFBQVFTLGdCQUFSLEdBQTJCUCxNQUEzQixDQUFrQ0QsU0FBbEMsRUFBNkNDLE1BQTdDLENBQW9EUSxPQUFwRCxDQUFiLENBQVA7QUFDRDs7QUFFRDs7OztBQUlBLFNBQVNDLGVBQVQsQ0FBeUJDLE9BQXpCLEVBQWtDO0FBQUEsTUFFOUJDLHFCQUY4QixHQU81QkQsT0FQNEIsQ0FFOUJDLHFCQUY4QjtBQUFBLE1BRzlCQyx1QkFIOEIsR0FPNUJGLE9BUDRCLENBRzlCRSx1QkFIOEI7QUFBQSxNQUk5QkMsa0NBSjhCLEdBTzVCSCxPQVA0QixDQUk5Qkcsa0NBSjhCO0FBQUEsTUFLOUJDLDhDQUw4QixHQU81QkosT0FQNEIsQ0FLOUJJLDhDQUw4QjtBQUFBLE1BTTlCQyxVQU44QixHQU81QkwsT0FQNEIsQ0FNOUJLLFVBTjhCOztBQVFoQyxNQUFJLE9BQU9KLHFCQUFQLEtBQWlDLFdBQWpDLElBQWdELE9BQU9BLHFCQUFQLEtBQWlDLFNBQXJGLEVBQWdHO0FBQzlGLFVBQU0sSUFBSUssS0FBSixDQUFVLGdFQUFWLENBQU47QUFDRDs7QUFFRCxNQUFJLE9BQU9KLHVCQUFQLEtBQW1DLFdBQW5DLElBQWtELE9BQU9BLHVCQUFQLEtBQW1DLFNBQXpGLEVBQW9HO0FBQ2xHLFVBQU0sSUFBSUksS0FBSixDQUFVLGtFQUFWLENBQU47QUFDRDs7QUFFRCxNQUNFTCx5QkFBeUIsSUFBekIsSUFDR0MsMkJBQTJCLElBRDlCLElBRUdELDBCQUEwQkMsdUJBSC9CLEVBSUU7QUFDQSxVQUFNLElBQUlJLEtBQUosQ0FBVSxtRkFBVixDQUFOO0FBQ0Q7O0FBRUQsTUFDRSxPQUFPSCxrQ0FBUCxLQUE4QyxXQUE5QyxJQUNHRSxXQUFXRSxrQkFEZCxJQUVHRixXQUFXRSxrQkFBWCxDQUE4QkMsVUFBOUIsS0FBNkNMLGtDQUhsRCxFQUlFO0FBQ0EsVUFBTSxJQUFJTSxTQUFKLENBQWMseUpBQWQsQ0FBTjtBQUNEOztBQUVELE1BQ0UsT0FBT0wsOENBQVAsS0FBMEQsV0FBMUQsSUFDR0MsV0FBV0Usa0JBRGQsSUFFR0YsV0FBV0Usa0JBQVgsQ0FBOEJHLFdBQTlCLEtBQThDTiw4Q0FIbkQsRUFJRTtBQUNBLFVBQU0sSUFBSUssU0FBSixDQUFjLHNLQUFkLENBQU47QUFDRDtBQUNGOztBQUVELFNBQVNFLG9CQUFULE9BQTJDO0FBQUEsTUFBWFgsT0FBVyxRQUFYQSxPQUFXO0FBQUEsNEJBS3JDQSxPQUxxQyxDQUV2Q0ssVUFGdUM7QUFBQSxNQUV2Q0EsVUFGdUMsdUNBRTFCLEVBRjBCO0FBQUEsTUFHdkNGLGtDQUh1QyxHQUtyQ0gsT0FMcUMsQ0FHdkNHLGtDQUh1QztBQUFBLE1BSXZDQyw4Q0FKdUMsR0FLckNKLE9BTHFDLENBSXZDSSw4Q0FKdUM7OztBQU96QyxNQUFNUSx1QkFBdUIsT0FBT1Qsa0NBQVAsS0FBOEMsV0FBM0U7QUFDQSxNQUFNVSwwQkFBMEIsT0FBT1QsOENBQVAsS0FBMEQsV0FBMUY7QUFDQSxNQUFNRyxxQkFBcUJLLHdCQUF3QkMsdUJBQXhCLGdDQUVuQkQsd0JBQXdCO0FBQzFCSixnQkFBWSxDQUFDLENBQUNMO0FBRFksR0FGTCxFQUtuQlUsMkJBQTJCO0FBQzdCSCxpQkFBYSxDQUFDLENBQUNOO0FBRGMsR0FMUixJQVN2QixJQVRKO0FBVHlDLE1BbUJQVSxhQW5CTyxHQW1CV1QsVUFuQlgsQ0FtQmpDVSx3QkFuQmlDOztBQW9CekMsTUFBTUEsMkJBQTJCRCxnQkFBZ0I7QUFDL0NFLGlDQUE2QixDQUFDLENBQUNGLGNBQWNFO0FBREUsR0FBaEIsR0FFN0IsS0FGSjs7QUFJQSxzQ0FDS1gsVUFETDtBQUVFWSwyQ0FDS1osV0FBV1ksUUFEaEIsQ0FGRjtBQUtFQztBQUNFQyx3QkFBa0I7QUFEcEIsT0FFS2QsV0FBV2EsZUFGaEI7QUFMRixLQVNNWCxzQkFBc0IsRUFBRUEsc0NBQUYsRUFUNUI7QUFVRVE7QUFWRjtBQVlEOztBQUVELFNBQVNLLFdBQVQsQ0FBcUJDLElBQXJCLEVBQTJCO0FBQ3pCLE1BQUlBLEtBQUtDLFFBQUwsS0FBa0IsTUFBdEIsRUFBOEI7QUFDNUIsV0FBT0QsSUFBUDtBQUNEO0FBQ0QsU0FBT0EsS0FBS0UsUUFBWjtBQUNEOztBQUVELFNBQVNDLG1CQUFULENBQTZCcEMsT0FBN0IsRUFBc0M7QUFDcEMsTUFBSUEsUUFBUVYsSUFBUixFQUFjK0MsTUFBZCxLQUF5QixDQUE3QixFQUFnQztBQUM5QixVQUFNLElBQUluQixLQUFKLENBQVUsNkVBQVYsQ0FBTjtBQUNEO0FBQ0QsTUFBSWxCLFFBQVFWLElBQVIsTUFBa0JVLE9BQXRCLEVBQStCO0FBQzdCLFdBQU9BLFFBQVFQLFVBQVIsRUFBb0IsQ0FBcEIsQ0FBUDtBQUNEO0FBQ0QsU0FBT08sUUFBUVYsSUFBUixFQUFjSixJQUFkLENBQVA7QUFDRDs7QUFFRCxTQUFTb0QsV0FBVCxDQUFxQnRDLE9BQXJCLEVBQThCaUMsSUFBOUIsRUFBb0M7QUFDbEMsU0FBTyxpQ0FBY0EsSUFBZCxFQUFvQkcsb0JBQW9CcEMsT0FBcEIsQ0FBcEIsQ0FBUDtBQUNEOztBQUVELFNBQVN1QyxlQUFULENBQXlCdkMsT0FBekIsRUFBa0N3QyxLQUFsQyxFQUF5QztBQUN2QyxNQUFJLENBQUNDLE1BQU1DLE9BQU4sQ0FBY0YsS0FBZCxDQUFMLEVBQTJCO0FBQ3pCLDJCQUFXeEMsT0FBWCxFQUFvQmQsSUFBcEIsRUFBMEJzRCxLQUExQjtBQUNBLDJCQUFXeEMsT0FBWCxFQUFvQmIsS0FBcEIsRUFBMkIsQ0FBQ3FELEtBQUQsQ0FBM0I7QUFDRCxHQUhELE1BR087QUFDTCwyQkFBV3hDLE9BQVgsRUFBb0JkLElBQXBCLEVBQTBCc0QsTUFBTSxDQUFOLENBQTFCO0FBQ0EsMkJBQVd4QyxPQUFYLEVBQW9CYixLQUFwQixFQUEyQnFELEtBQTNCO0FBQ0Q7QUFDRCx5QkFBV3hDLE9BQVgsRUFBb0IsUUFBcEIsRUFBOEJBLFFBQVFiLEtBQVIsRUFBZWtELE1BQTdDO0FBQ0Q7O0FBRUQsU0FBU00sa0NBQVQsQ0FBNENDLFNBQTVDLEVBQXVEQyxLQUF2RCxFQUE4REMsU0FBOUQsRUFBeUVDLEtBQXpFLEVBQWdGO0FBQzlFLFNBQU8sQ0FBQyx5QkFBYUgsU0FBYixFQUF3QkMsS0FBeEIsQ0FBRCxJQUFtQyxDQUFDLHlCQUFhQyxTQUFiLEVBQXdCQyxLQUF4QixDQUEzQztBQUNEOztBQUVELFNBQVNDLGVBQVQsQ0FBeUJDLFFBQXpCLEVBQW1DO0FBQ2pDLFNBQU9BLFlBQVlBLFNBQVNDLG9CQUE1QjtBQUNEOztBQUVELFNBQVNwQixlQUFULENBQXlCRyxJQUF6QixFQUErQmtCLFNBQS9CLEVBQTBDQyxRQUExQyxFQUFvRDtBQUFBLE1BQzFDSCxRQUQwQyxHQUNaaEIsSUFEWSxDQUMxQ2dCLFFBRDBDO0FBQUEsTUFDMUJJLFNBRDBCLEdBQ1pwQixJQURZLENBQ2hDcUIsSUFEZ0M7O0FBRWxELE1BQU1DLGdCQUFnQiw4QkFBa0J0QixJQUFsQixDQUF0QjtBQUNBO0FBQ0E7QUFDQSxNQUFJLFFBQU9vQixVQUFVRyxpQkFBakIsTUFBdUMsUUFBM0MsRUFBcUQ7QUFDbkQ7QUFDQUMsWUFBUUMsSUFBUixRQUNLSCxhQURMO0FBR0EsV0FBTyxFQUFQO0FBQ0Q7QUFDRDtBQUNBO0FBQ0EsTUFBTUksZUFBZVYsU0FBU25CLGVBQVQsRUFBckI7QUFDQThCLFNBQU9DLElBQVAsQ0FBWUYsWUFBWixFQUEwQkcsT0FBMUIsQ0FBa0MsVUFBQ0MsR0FBRCxFQUFTO0FBQ3pDLFFBQUksRUFBRUEsT0FBT1YsVUFBVUcsaUJBQW5CLENBQUosRUFBMkM7QUFDekMsWUFBTSxJQUFJdEMsS0FBSixRQUNEcUMsYUFEQyx5Q0FDd0NRLEdBRHhDLDZDQUFOO0FBR0Q7QUFDRixHQU5EO0FBT0EsTUFBSSxPQUFPWCxTQUFTWSxjQUFoQixLQUFtQyxVQUF2QyxFQUFtRDtBQUNqRFosYUFBU1ksY0FBVCxDQUF3QlgsVUFBVUcsaUJBQWxDLEVBQXFERyxZQUFyRCxFQUFtRSxlQUFuRSxFQUFvRlIsU0FBcEY7QUFDRDtBQUNELFNBQU9RLFlBQVA7QUFDRDs7QUFFRCxTQUFTTSxpQ0FBVCxDQUEyQ3pCLEtBQTNDLEVBQWtEMEIsT0FBbEQsRUFBMkQ7QUFDekQsTUFDRSxDQUFDLHFDQUF5QjFCLEtBQXpCLEVBQWdDMEIsT0FBaEMsQ0FBRCxJQUNHLENBQUMxQixNQUFNYyxJQUFOLENBQVdhLFNBRGYsSUFFRyxPQUFPM0IsTUFBTWMsSUFBTixDQUFXYSxTQUFYLENBQXFCckMsZUFBNUIsS0FBZ0QsVUFIckQsRUFJRTtBQUNBLFdBQU8sSUFBUDtBQUNEOztBQUVELFNBQU8sc0JBQVVVLE1BQU1jLElBQU4sQ0FBV2EsU0FBckIsRUFBZ0MsaUJBQWhDLENBQVA7QUFDRDs7QUFFRCxTQUFTQyxzQkFBVCxDQUFnQ0YsT0FBaEMsRUFBeUNsRSxPQUF6QyxFQUFrRGlELFFBQWxELEVBQTREb0IsWUFBNUQsRUFBMEVDLGtCQUExRSxFQUE4RjtBQUM1RixNQUFNbEIsV0FBV3BELFFBQVFaLFFBQVIsQ0FBakI7QUFDQTtBQUNBLE1BQUk4RSxRQUFRdEQsT0FBUixDQUFnQjJELGlCQUFoQixLQUFzQyxRQUExQyxFQUFvRDtBQUFFO0FBQVM7QUFDL0QsTUFBSUQsa0JBQUosRUFBd0I7QUFDdEIsMkJBQVd0RSxPQUFYLEVBQW9CTixhQUFwQixFQUFtQzRFLG1CQUFtQkUsa0JBQW5CLEVBQW5DO0FBQ0FGLHVCQUFtQkcsT0FBbkI7QUFDRCxHQUhELE1BR08sSUFBSSxPQUFPeEIsU0FBU25CLGVBQWhCLEtBQW9DLFVBQXhDLEVBQW9EO0FBQ3pEO0FBQ0E7QUFDQSxRQUFNNEMsZ0JBQWdCLENBQUMxRSxRQUFRZCxJQUFSLENBQUQsRUFBZ0J5RixNQUFoQixDQUF1QnJDLFlBQVl0QyxPQUFaLEVBQXFCQSxRQUFRZCxJQUFSLENBQXJCLENBQXZCLENBQXRCO0FBQ0EsUUFBTXlFLGVBQWU3QixnQkFBZ0J1QyxZQUFoQixFQUE4QkssYUFBOUIsRUFBNkN0QixRQUE3QyxDQUFyQjtBQUNBLDJCQUFXcEQsT0FBWCxFQUFvQk4sYUFBcEIsRUFBbUNpRSxZQUFuQztBQUNELEdBTk0sTUFNQTtBQUNMLDJCQUFXM0QsT0FBWCxFQUFvQk4sYUFBcEIsRUFBbUMsSUFBbkM7QUFDRDtBQUNGOztBQUVELFNBQVNrRiwyQkFBVCxDQUFxQzNDLElBQXJDLEVBQTJDYyxLQUEzQyxFQUFrRDtBQUFBLE1BQ3hDcEIsd0JBRHdDLEdBQ1hNLEtBQUtxQixJQURNLENBQ3hDM0Isd0JBRHdDOzs7QUFHaEQsTUFBSSxPQUFPQSx3QkFBUCxLQUFvQyxVQUF4QyxFQUFvRDtBQUNsRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBTGtELFFBTTFDc0IsUUFOMEMsR0FNN0JoQixJQU42QixDQU0xQ2dCLFFBTjBDOztBQUFBLHFCQU85QixzQkFDbEJBLFFBRGtCLEVBRWxCLHVCQUZrQixFQUdsQjtBQUFBO0FBQWUsaUJBQVM0QixxQkFBVCxHQUF3QztBQUNyRDVCLG1CQUFTRixLQUFULEdBQWlCQSxLQUFqQjs7QUFEcUQsNENBQU4rQixJQUFNO0FBQU5BLGdCQUFNO0FBQUE7O0FBRXJELGNBQU1DLFlBQVlDLFlBQVlDLEtBQVosQ0FBa0JoQyxRQUFsQixFQUE0QjZCLElBQTVCLENBQWxCO0FBRnFELGNBRzVDSSxTQUg0QyxHQUcvQkosSUFIK0I7O0FBSXJEN0IsbUJBQVNGLEtBQVQsR0FBaUJtQyxTQUFqQjtBQUNBVDtBQUNBLGlCQUFPTSxTQUFQO0FBQ0Q7O0FBUEQsZUFBd0JGLHFCQUF4QjtBQUFBO0FBQUEsS0FIa0IsQ0FQOEI7QUFBQSxRQU8xQ0osT0FQMEMsY0FPMUNBLE9BUDBDO0FBbUJuRDtBQUNGOztBQUVEOzs7Ozs7Ozs7O0FBVUEsU0FBU1UsVUFBVCxDQUFvQm5GLE9BQXBCLEVBQTZCb0YsTUFBN0IsRUFBcUNsQixPQUFyQyxFQUE4QztBQUM1QyxNQUFNakMsT0FBT2pDLFFBQVFkLElBQVIsQ0FBYjtBQUNBLE1BQU1tRyxVQUFVcEQsUUFBUWlDLFFBQVFvQixhQUFSLENBQXNCckQsSUFBdEIsQ0FBeEI7QUFDQSxNQUFJakMsUUFBUXNELElBQVIsT0FBbUI4QixNQUF2QixFQUErQjtBQUM3QixXQUFPcEYsUUFBUXVGLElBQVIsRUFBUDtBQUNEO0FBQ0QsTUFBSUYsV0FBVyxxQ0FBeUJBLE9BQXpCLEVBQWtDbkIsT0FBbEMsQ0FBZixFQUEyRDtBQUN6RCxXQUFPaUIsV0FBV25GLFFBQVF1RixJQUFSLEVBQVgsRUFBMkJILE1BQTNCLEVBQW1DbEIsT0FBbkMsQ0FBUDtBQUNEO0FBQ0QsTUFBTXNCLFdBQVd4RixRQUFRd0YsUUFBUixFQUFqQjtBQUNBLE9BQUssSUFBSUMsSUFBSSxDQUFiLEVBQWdCQSxJQUFJRCxTQUFTbkQsTUFBN0IsRUFBcUNvRCxLQUFLLENBQTFDLEVBQTZDO0FBQzNDLFFBQU1DLFFBQVFQLFdBQVdLLFNBQVNHLEVBQVQsQ0FBWUYsQ0FBWixDQUFYLEVBQTJCTCxNQUEzQixFQUFtQ2xCLE9BQW5DLENBQWQ7QUFDQSxRQUFJLE9BQU93QixLQUFQLEtBQWlCLFdBQXJCLEVBQWtDO0FBQ2hDLGFBQU9BLEtBQVA7QUFDRDtBQUNGO0FBQ0QsU0FBT0UsU0FBUDtBQUNEOztBQUVEOzs7Ozs7Ozs7O0FBVUEsU0FBU0MsK0JBQVQsQ0FBeUM3RixPQUF6QyxFQUFrRGtFLE9BQWxELEVBQTJEO0FBQ3pELE1BQU00QixhQUFhWCxXQUFXbkYsT0FBWCxFQUFvQkEsUUFBUUgsV0FBUixDQUFwQixFQUEwQ3FFLE9BQTFDLENBQW5CO0FBQ0EsTUFBSSxDQUFDNEIsVUFBTCxFQUFpQjtBQUNmLFVBQU0sSUFBSTVFLEtBQUosQ0FBVSwrQ0FBVixDQUFOO0FBQ0Q7QUFDRCxTQUFPO0FBQ0w2RSxtQkFBZUQsV0FBV3ZHLE9BQVgsRUFBb0J5RyxPQUQ5QjtBQUVMQyxvQkFBZ0JILFdBQVdoRyxlQUFYO0FBRlgsR0FBUDtBQUlEOztBQUVEOzs7Ozs7Ozs7Ozs7QUFZQSxTQUFTb0csa0JBQVQsQ0FBNEIxRCxLQUE1QixFQUFtQzJELElBQW5DLEVBQXlDQyxhQUF6QyxFQUF3RHBHLE9BQXhELEVBQWlFO0FBQy9ELE1BQU1ZLFVBQVUsd0JBQVl3RixhQUFaLENBQWhCO0FBQ0EsTUFBTWxDLFVBQVUsNkJBQVdrQyxhQUFYLENBQWhCO0FBQ0EseUJBQVd4RixPQUFYLEVBQW9CZCxlQUFwQixFQUFxQ3NHLGNBQWN0RyxlQUFkLENBQXJDO0FBQ0EsTUFBSXFHLFFBQVEsQ0FBQyw4QkFBa0J2RixRQUFReUYsaUJBQTFCLEVBQTZDbkMsT0FBN0MsQ0FBYixFQUFvRTtBQUNsRSxXQUFPdEQsT0FBUDtBQUNEO0FBQ0QsTUFBSSxPQUFPc0QsUUFBUW9DLHlCQUFmLEtBQTZDLFVBQWpELEVBQTZEO0FBQzNELFVBQU0sSUFBSWpGLFNBQUosQ0FBYyxzRUFBZCxDQUFOO0FBQ0Q7O0FBVDhELDhCQVVyQjZDLFFBQVFvQyx5QkFBUixDQUFrQzlELEtBQWxDLEVBQXlDNUIsT0FBekMsQ0FWcUI7QUFBQSxNQVVqRDJGLFdBVmlELHlCQVV2RHRFLElBVnVEO0FBQUEsTUFVcEN1RSxVQVZvQyx5QkFVcENBLFVBVm9DO0FBVy9EOzs7QUFDQSxNQUFNSCxvQkFBb0IsSUFBSUksd0JBQUosQ0FBNkJGLFdBQTdCLEVBQTBDdkcsT0FBMUMsRUFBbUR3RyxVQUFuRCxDQUExQjs7QUFaK0QsOEJBZ0IzRFgsZ0NBQWdDUSxpQkFBaEMsRUFBbURuQyxPQUFuRCxDQWhCMkQ7QUFBQSxNQWM5Q3dDLDhCQWQ4Qyx5QkFjN0RYLGFBZDZEO0FBQUEsTUFlN0NZLCtCQWY2Qyx5QkFlN0RWLGNBZjZEOztBQWlCL0QseUJBQVdqRyxPQUFYLEVBQW9CTCxrQkFBcEIsRUFBd0MwRyxpQkFBeEM7QUFDQSxzQ0FDS3pGLE9BREw7QUFFRW9GLDBDQUNLcEYsUUFBUW9GLE9BRGIsRUFFS1UsOEJBRkw7QUFGRixLQU1HNUcsZUFOSCxFQU1xQjZHLCtCQU5yQjtBQVFEOztBQUdEOzs7O0lBR01DLGM7QUFDSiwwQkFBWXBFLEtBQVosRUFBbUIyRCxJQUFuQixFQUE2QztBQUFBOztBQUFBLFFBQXBCQyxhQUFvQix1RUFBSixFQUFJOztBQUFBOztBQUMzQ3pGLG9CQUFnQnlGLGFBQWhCOztBQUVBLFFBQU14RixVQUFVc0YsbUJBQW1CMUQsS0FBbkIsRUFBMEIyRCxJQUExQixFQUFnQ0MsYUFBaEMsRUFBK0MsSUFBL0MsQ0FBaEI7QUFDQSxRQUFNbEMsVUFBVSw2QkFBV3RELE9BQVgsQ0FBaEI7QUFDQSxRQUFNSyxhQUFhTSxxQkFBcUIyQyxPQUFyQixDQUFuQjs7QUFFQTtBQUNBLFFBQUksQ0FBQ2lDLElBQUwsRUFBVztBQUNULFVBQUksQ0FBQ2pDLFFBQVEyQyxjQUFSLENBQXVCckUsS0FBdkIsQ0FBTCxFQUFvQztBQUNsQyxjQUFNLElBQUluQixTQUFKLENBQWMsNkNBQWQsQ0FBTjtBQUNEOztBQUVELFVBQU1pRCxxQkFBcUJyRCxXQUFXYSxlQUFYLENBQTJCQyxnQkFBM0IsR0FDdkJrQyxrQ0FBa0N6QixLQUFsQyxFQUF5QzBCLE9BQXpDLENBRHVCLEdBRXZCLElBRko7QUFHQSw2QkFBVyxJQUFYLEVBQWlCNUUsSUFBakIsRUFBdUIsSUFBdkI7QUFDQSw2QkFBVyxJQUFYLEVBQWlCRCxVQUFqQixFQUE2Qm1ELEtBQTdCO0FBQ0EsVUFBTVksV0FBV2MsUUFBUTRDLGNBQVIsNEJBQXlCQyxNQUFNLFNBQS9CLElBQTZDbkcsT0FBN0MsRUFBakI7QUFDQSw2QkFBVyxJQUFYLEVBQWlCeEIsUUFBakIsRUFBMkJnRSxRQUEzQjtBQUNBLFVBQU02QyxpQkFBaUIsSUFBSWUsR0FBSixDQUFRcEcsUUFBUWQsZUFBUixLQUE0QixFQUFwQyxDQUF2QjtBQUNBLFdBQUtWLFFBQUwsRUFBZTZILE1BQWYsQ0FBc0J6RSxLQUF0QixFQUE2QjVCLFFBQVFvRixPQUFyQyxFQUE4QyxFQUFFQyw4QkFBRixFQUE5QztBQUNBLFVBQU01QixlQUFlLEtBQUtqRixRQUFMLEVBQWU4SCxPQUFmLEVBQXJCO0FBQ0EzRSxzQkFBZ0IsSUFBaEIsRUFBc0JQLFlBQVlxQyxZQUFaLENBQXRCO0FBQ0EsNkJBQVcsSUFBWCxFQUFpQjlFLE9BQWpCLEVBQTBCcUIsT0FBMUI7QUFDQSw2QkFBVyxJQUFYLEVBQWlCZCxlQUFqQixFQUFrQ21HLGNBQWxDOztBQWpCUyxVQW1CRGhELFFBbkJDLEdBbUJZb0IsWUFuQlosQ0FtQkRwQixRQW5CQzs7QUFvQlQsVUFBSUEsWUFBWSxDQUFDckMsUUFBUUUsdUJBQXpCLEVBQWtEO0FBQ2hEO0FBQ0EsWUFBSUcsV0FBV0Usa0JBQVgsQ0FBOEJDLFVBQTlCLElBQTRDLENBQUM2QixTQUFTekQsU0FBVCxDQUFqRCxFQUFzRTtBQUNwRSxpQ0FBV3lELFFBQVgsRUFBcUJ6RCxTQUFyQixFQUFnQ3lELFNBQVNwQixRQUF6QztBQUNBb0IsbUJBQVNwQixRQUFULEdBQW9CLFVBQUNzRixPQUFEO0FBQUEsZ0JBQVVDLFFBQVYsdUVBQXFCeEIsU0FBckI7QUFBQSxtQkFBbUMsTUFBSy9ELFFBQUwsaUNBQ2pEdUYsWUFBWSxJQUFaLEdBQW1CLENBQUNELE9BQUQsQ0FBbkIsR0FBK0IsQ0FBQ0EsT0FBRCxFQUFVQyxRQUFWLENBRGtCLEVBQW5DO0FBQUEsV0FBcEI7QUFHRDs7QUFFRCxZQUFJLE9BQU9uRSxTQUFTb0UsaUJBQWhCLEtBQXNDLFVBQTFDLEVBQXNEO0FBQ3BELGVBQUtqSSxRQUFMLEVBQWVrSSxjQUFmLENBQThCLFlBQU07QUFDbENyRSxxQkFBU29FLGlCQUFUO0FBQ0QsV0FGRDtBQUdEO0FBQ0RqRCwrQkFBdUJGLE9BQXZCLEVBQWdDLElBQWhDLEVBQXNDakIsUUFBdEMsRUFBZ0RvQixZQUFoRCxFQUE4REMsa0JBQTlEO0FBQ0Q7QUFDSDtBQUNDLEtBckNELE1BcUNPO0FBQ0wsNkJBQVcsSUFBWCxFQUFpQmhGLElBQWpCLEVBQXVCNkcsSUFBdkI7QUFDQSw2QkFBVyxJQUFYLEVBQWlCOUcsVUFBakIsRUFBNkIsSUFBN0I7QUFDQSw2QkFBVyxJQUFYLEVBQWlCRCxRQUFqQixFQUEyQitHLEtBQUsvRyxRQUFMLENBQTNCO0FBQ0FtRCxzQkFBZ0IsSUFBaEIsRUFBc0JDLEtBQXRCO0FBQ0EsNkJBQVcsSUFBWCxFQUFpQmpELE9BQWpCLEVBQTBCNEcsS0FBSzVHLE9BQUwsQ0FBMUI7QUFDQSw2QkFBVyxJQUFYLEVBQWlCRSxVQUFqQixFQUE2QjBHLEtBQUtoSCxLQUFMLENBQTdCO0FBQ0EsNkJBQVcsSUFBWCxFQUFpQlcsZUFBakIsRUFBa0MsSUFBbEM7QUFDRDtBQUNGOztBQUVEOzs7Ozs7Ozs7O3NCQUtPO0FBQ0wsZUFBTyxLQUFLUixJQUFMLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7O2lDQUtrQjtBQUNoQixZQUFJLEtBQUsrQyxNQUFMLEtBQWdCLENBQXBCLEVBQXVCO0FBQ3JCLGdCQUFNLElBQUluQixLQUFKLENBQVUscUVBQVYsQ0FBTjtBQUNEO0FBQ0QsWUFBSSxLQUFLNUIsSUFBTCxNQUFlLElBQW5CLEVBQXlCO0FBQ3ZCLGVBQUtpSSxNQUFMO0FBQ0Q7QUFDRCxlQUFPLEtBQUtySSxJQUFMLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7O2tDQUttQjtBQUNqQixZQUFJLEtBQUtJLElBQUwsTUFBZSxJQUFmLElBQXVCLEtBQUsrQyxNQUFMLEtBQWdCLENBQTNDLEVBQThDO0FBQzVDLGVBQUtrRixNQUFMO0FBQ0Q7QUFDRCxlQUFPLEtBQUtwSSxLQUFMLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7OzRCQUthO0FBQUE7O0FBQ1gsZUFBTyxLQUFLcUksTUFBTCxDQUFZLFlBQVosRUFBMEI7QUFBQSxpQkFBSyw2QkFBVyxPQUFLakksT0FBTCxDQUFYLEVBQTBCK0YsYUFBMUIsQ0FBd0NqRixDQUF4QyxDQUFMO0FBQUEsU0FBMUIsQ0FBUDtBQUNEOzs7OztBQUVEOzs7Ozs7Ozs7NkJBS2M7QUFBQTs7QUFDWixlQUFPLEtBQUtJLGdCQUFMLEdBQXdCZ0gsR0FBeEIsQ0FBNEI7QUFBQSxpQkFBSyw2QkFBVyxPQUFLbEksT0FBTCxDQUFYLEVBQTBCK0YsYUFBMUIsQ0FBd0NqRixDQUF4QyxDQUFMO0FBQUEsU0FBNUIsQ0FBUDtBQUNEOzs7OztBQUVEOzs7Ozt5QkFDVTtBQUNSLGNBQU0sSUFBSWEsS0FBSixDQUFVLDRGQUFWLENBQU47QUFDRDs7Ozs7QUFFRDs7Ozs7MEJBQ1c7QUFDVCxjQUFNLElBQUlBLEtBQUosQ0FBVSw4RkFBVixDQUFOO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7OzBCQWFXO0FBQ1QsWUFBSSxLQUFLNUIsSUFBTCxNQUFlLElBQW5CLEVBQXlCO0FBQ3ZCLGdCQUFNLElBQUk0QixLQUFKLENBQVUsMkRBQVYsQ0FBTjtBQUNEO0FBQ0QsZUFBTyxLQUFLOUIsUUFBTCxFQUFlOEgsT0FBZixHQUF5QmpFLFFBQWhDO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7O3NDQU91QjtBQUNyQixZQUFJLEtBQUszRCxJQUFMLE1BQWUsSUFBbkIsRUFBeUI7QUFDdkIsZ0JBQU0sSUFBSTRCLEtBQUosQ0FBVSx1RUFBVixDQUFOO0FBQ0Q7QUFDRCxZQUFJLENBQUMsS0FBSzNCLE9BQUwsRUFBYzhHLGlCQUFuQixFQUFzQztBQUNwQyxnQkFBTSxJQUFJbkYsS0FBSixDQUFVLGdJQUFWLENBQU47QUFDRDtBQUNELGVBQU8sS0FBS3ZCLGtCQUFMLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7O3dCQVFTO0FBQ1AsWUFBSSxLQUFLTCxJQUFMLE1BQWUsSUFBbkIsRUFBeUI7QUFDdkIsZ0JBQU0sSUFBSTRCLEtBQUosQ0FBVSx5REFBVixDQUFOO0FBQ0Q7QUFDRCxZQUFJLEtBQUttQixNQUFMLEtBQWdCLENBQXBCLEVBQXVCO0FBQ3JCLGdCQUFNLElBQUluQixLQUFKLENBQVUsb0VBQVYsQ0FBTjtBQUNEO0FBQ0RxQix3QkFBZ0IsSUFBaEIsRUFBc0JQLFlBQVksS0FBSzVDLFFBQUwsRUFBZThILE9BQWYsRUFBWixDQUF0QjtBQUNBLGVBQU8sSUFBUDtBQUNEOzs7OztBQUVEOzs7Ozs7Ozs7eUJBS1U7QUFDUixhQUFLOUgsUUFBTCxFQUFlc0ksT0FBZjtBQUNBLFlBQUksS0FBS3BJLElBQUwsRUFBV0ssa0JBQVgsQ0FBSixFQUFvQztBQUNsQyxlQUFLTCxJQUFMLEVBQVdLLGtCQUFYLEVBQStCK0gsT0FBL0I7QUFDRDtBQUNELGVBQU8sSUFBUDtBQUNEOzs7OztBQUVEOzs7Ozs7Ozs7Ozs7Ozt3QkFVUzdFLEssRUFBT21ELE8sRUFBUztBQUFBOztBQUN2QixZQUFNOUIsVUFBVSw2QkFBVyxLQUFLM0UsT0FBTCxDQUFYLENBQWhCO0FBQ0EsYUFBS2lJLE1BQUwsQ0FBWSxVQUFaLEVBQXdCLFlBQU07QUFDNUIsMENBQW9CLFlBQU07QUFDeEI7QUFDQTtBQUNBO0FBQ0EsZ0JBQU12RixPQUFPLE9BQUs3QyxRQUFMLEVBQWU4SCxPQUFmLEVBQWI7QUFDQSxnQkFBTWpFLFdBQVdoQixLQUFLZ0IsUUFBTCxJQUFpQixFQUFsQztBQUNBLGdCQUFNSyxPQUFPckIsS0FBS3FCLElBQUwsSUFBYSxFQUExQjtBQU53QixnQkFPaEJQLEtBUGdCLEdBT05FLFFBUE0sQ0FPaEJGLEtBUGdCOztBQVF4QixnQkFBTUgsWUFBWUssU0FBU0osS0FBVCxJQUFrQixPQUFLeEQsVUFBTCxFQUFpQndELEtBQXJEO0FBQ0EsZ0JBQU12QixjQUFjMkIsU0FBUytDLE9BQVQsSUFBb0IsT0FBS3pHLE9BQUwsRUFBY3lHLE9BQXREO0FBQ0EsZ0JBQU0yQixjQUFjM0IsV0FBVzFFLFdBQS9CO0FBQ0EsZ0JBQUkwRSxPQUFKLEVBQWE7QUFDWCxxQkFBS3pHLE9BQUwsaUNBQXFCLE9BQUtBLE9BQUwsQ0FBckIsSUFBb0N5RyxTQUFTMkIsV0FBN0M7QUFDRDtBQUNELG1CQUFLdkksUUFBTCxFQUFla0ksY0FBZixDQUE4QixZQUFNO0FBQ2xDO0FBQ0E7QUFDQSxrQkFBTXJHLGFBQWFNLHFCQUFxQjJDLE9BQXJCLENBQW5CO0FBQ0Esa0JBQUkwRCxlQUFlLElBQW5CO0FBQ0Esa0JBQUlDLGlDQUFKO0FBQ0Esa0JBQUl2RCwyQkFBSjtBQUNBLGtCQUNFLENBQUMsT0FBSy9FLE9BQUwsRUFBY3VCLHVCQUFmLElBQ0dtQyxRQUZMLEVBR0U7QUFDQSxvQkFBSSxPQUFPQSxTQUFTNEIscUJBQWhCLEtBQTBDLFVBQTlDLEVBQTBEO0FBQUEsc0JBQ3RCaUQsS0FEc0IsR0FDWjdHLFVBRFksQ0FDaERVLHdCQURnRDs7QUFFeEQsc0JBQUltRyxTQUFTQSxNQUFNbEcsMkJBQW5CLEVBQWdEO0FBQzlDZ0QsZ0RBQTRCM0MsSUFBNUIsRUFBa0NjLEtBQWxDO0FBQ0Q7QUFDRDhFLDZDQUEyQixzQkFBVTVFLFFBQVYsRUFBb0IsdUJBQXBCLENBQTNCO0FBQ0Q7QUFDRCxvQkFDRWhDLFdBQVdhLGVBQVgsQ0FBMkJDLGdCQUEzQixJQUNHLE9BQU9rQixTQUFTbkIsZUFBaEIsS0FBb0MsVUFGekMsRUFHRTtBQUNBd0MsdUNBQXFCLHNCQUFVckIsUUFBVixFQUFvQixpQkFBcEIsQ0FBckI7QUFDRDtBQUNGO0FBQ0Qsa0JBQUksQ0FBQzRFLHdCQUFELElBQTZCN0UsZ0JBQWdCQyxRQUFoQixDQUFqQyxFQUE0RDtBQUMxRDJFLCtCQUFlakYsbUNBQ2JDLFNBRGEsRUFFYkMsS0FGYSxFQUdiRSxLQUhhLEVBSWJFLFNBQVNGLEtBSkksQ0FBZjtBQU1EO0FBQ0Qsa0JBQUlGLEtBQUosRUFBVyxPQUFLeEQsVUFBTCxJQUFtQix5QkFBYTZFLE9BQWIsRUFBc0IsT0FBSzdFLFVBQUwsQ0FBdEIsRUFBd0N3RCxLQUF4QyxDQUFuQjtBQUNYLHFCQUFLekQsUUFBTCxFQUFlNkgsTUFBZixDQUFzQixPQUFLNUgsVUFBTCxDQUF0QixFQUF3Q3NJLFdBQXhDLEVBQXFEO0FBQ25EMUIsZ0NBQWdCLE9BQUtuRyxlQUFMO0FBRG1DLGVBQXJEO0FBR0Esa0JBQUkrSCx3QkFBSixFQUE4QjtBQUM1QkQsK0JBQWVDLHlCQUF5QnJELGtCQUF6QixFQUFmO0FBQ0FxRCx5Q0FBeUJwRCxPQUF6QjtBQUNEO0FBQ0Qsa0JBQ0VtRCxnQkFDRyxDQUFDLE9BQUtySSxPQUFMLEVBQWN1Qix1QkFEbEIsSUFFR21DLFFBSEwsRUFJRTtBQUNBbUIsdUNBQXVCRixPQUF2QixFQUFnQyxNQUFoQyxFQUFzQ2pCLFFBQXRDLEVBQWdEaEIsSUFBaEQsRUFBc0RxQyxrQkFBdEQ7QUFDQSxvQkFBSXJELFdBQVc4Ryx1QkFBZixFQUF3QztBQUN0QyxzQkFBSUMsaUJBQUo7QUFDQSxzQkFBSSxPQUFPL0UsU0FBUzhFLHVCQUFoQixLQUE0QyxVQUFoRCxFQUE0RDtBQUMxREMsK0JBQVcvRSxTQUFTOEUsdUJBQVQsQ0FBaUNuRixTQUFqQyxFQUE0Q0csS0FBNUMsQ0FBWDtBQUNEO0FBQ0Qsc0JBQ0U5QixXQUFXRSxrQkFBWCxJQUNHLE9BQU84QixTQUFTOUIsa0JBQWhCLEtBQXVDLFVBRDFDLEtBR0UsQ0FBQzRCLEtBQUQsSUFDRyx5QkFBYUEsS0FBYixFQUFvQixPQUFLRSxRQUFMLEdBQWdCRixLQUFwQyxDQURILElBRUcsT0FBT08sS0FBSzNCLHdCQUFaLEtBQXlDLFVBTDlDLENBREYsRUFRRTtBQUNBc0IsNkJBQVM5QixrQkFBVCxDQUE0QnlCLFNBQTVCLEVBQXVDRyxLQUF2QyxFQUE4Q2lGLFFBQTlDO0FBQ0Q7QUFDRixpQkFoQkQsTUFnQk8sSUFDTC9HLFdBQVdFLGtCQUFYLElBQ0csT0FBTzhCLFNBQVM5QixrQkFBaEIsS0FBdUMsVUFGckMsRUFHTDtBQUNBLHNCQUFJRixXQUFXRSxrQkFBWCxDQUE4QkcsV0FBbEMsRUFBK0M7QUFDN0MyQiw2QkFBUzlCLGtCQUFULENBQTRCeUIsU0FBNUIsRUFBdUNHLEtBQXZDLEVBQThDekIsV0FBOUM7QUFDRCxtQkFGRCxNQUVPLElBQUksQ0FBQ3lCLEtBQUQsSUFBVSx5QkFBYSxPQUFLRSxRQUFMLEdBQWdCRixLQUE3QixFQUFvQ0EsS0FBcEMsQ0FBZCxFQUEwRDtBQUMvREUsNkJBQVM5QixrQkFBVCxDQUE0QnlCLFNBQTVCLEVBQXVDRyxLQUF2QztBQUNEO0FBQ0Y7QUFDSDtBQUNDLGVBakNELE1BaUNPLElBQUksQ0FBQyx5QkFBYUYsS0FBYixFQUFvQkksU0FBU0osS0FBN0IsQ0FBTCxFQUEwQztBQUMvQ0kseUJBQVNKLEtBQVQsR0FBaUIsQ0FBQ2UsT0FBT3FFLE1BQVAsSUFBaUJyRSxNQUFsQiwrQkFBK0JYLFNBQVNKLEtBQXhDLEVBQWtEQSxLQUFsRCxFQUFqQjtBQUNEO0FBQ0QscUJBQUswRSxNQUFMO0FBQ0QsYUE5RUQ7QUErRUQsV0E3RkQ7QUE4RkQsU0EvRkQ7QUFnR0EsZUFBTyxJQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozt3QkFjUzFFLEssRUFBNkI7QUFBQSxZQUF0QnVFLFFBQXNCLHVFQUFYeEIsU0FBVzs7QUFDcEMsWUFBSSxLQUFLdEcsSUFBTCxNQUFlLElBQW5CLEVBQXlCO0FBQ3ZCLGdCQUFNLElBQUk0QixLQUFKLENBQVUsMkRBQVYsQ0FBTjtBQUNEO0FBQ0QsWUFBSWdILFVBQVU3RixNQUFWLEdBQW1CLENBQW5CLElBQXdCLE9BQU8rRSxRQUFQLEtBQW9CLFVBQWhELEVBQTREO0FBQzFELGdCQUFNLElBQUkvRixTQUFKLENBQWMsb0VBQWQsQ0FBTjtBQUNEO0FBQ0QsYUFBSzhHLFFBQUwsQ0FBY3RGLEtBQWQ7QUFDQSxZQUFJdUUsUUFBSixFQUFjO0FBQ1pBO0FBQ0Q7QUFDRCxlQUFPLElBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7d0JBYVNyRSxLLEVBQTZCO0FBQUE7O0FBQUEsWUFBdEJxRSxRQUFzQix1RUFBWHhCLFNBQVc7O0FBQ3BDLFlBQUksS0FBS3RHLElBQUwsTUFBZSxJQUFuQixFQUF5QjtBQUN2QixnQkFBTSxJQUFJNEIsS0FBSixDQUFVLDJEQUFWLENBQU47QUFDRDtBQUNELFlBQUksS0FBSytCLFFBQUwsT0FBb0IsSUFBcEIsSUFBNEIsS0FBSzdELFFBQUwsRUFBZThILE9BQWYsR0FBeUJoRixRQUF6QixLQUFzQyxPQUF0RSxFQUErRTtBQUM3RSxnQkFBTSxJQUFJaEIsS0FBSixDQUFVLG1FQUFWLENBQU47QUFDRDtBQUNELFlBQUlnSCxVQUFVN0YsTUFBVixHQUFtQixDQUFuQixJQUF3QixPQUFPK0UsUUFBUCxLQUFvQixVQUFoRCxFQUE0RDtBQUMxRCxnQkFBTSxJQUFJL0YsU0FBSixDQUFjLG9FQUFkLENBQU47QUFDRDs7QUFFRCxhQUFLbUcsTUFBTCxDQUFZLFVBQVosRUFBd0IsWUFBTTtBQUM1QiwwQ0FBb0IsWUFBTTtBQUN4QixnQkFBTXRELFVBQVUsNkJBQVcsT0FBSzNFLE9BQUwsQ0FBWCxDQUFoQjs7QUFFQSxnQkFBTTBCLGFBQWFNLHFCQUFxQjJDLE9BQXJCLENBQW5COztBQUVBLGdCQUFNakMsT0FBTyxPQUFLN0MsUUFBTCxFQUFlOEgsT0FBZixFQUFiO0FBTHdCLGdCQU1oQmpFLFFBTmdCLEdBTUhoQixJQU5HLENBTWhCZ0IsUUFOZ0I7O0FBT3hCLGdCQUFNTCxZQUFZSyxTQUFTSixLQUEzQjtBQUNBLGdCQUFNQyxZQUFZRyxTQUFTRixLQUEzQjtBQUNBLGdCQUFNekIsY0FBYzJCLFNBQVMrQyxPQUE3Qjs7QUFFQSxnQkFBTW9DLGVBQWUsT0FBT3JGLEtBQVAsS0FBaUIsVUFBakIsR0FDakJBLE1BQU1zRixJQUFOLENBQVdwRixRQUFYLEVBQXFCSCxTQUFyQixFQUFnQ0YsU0FBaEMsQ0FEaUIsR0FFakJHLEtBRko7O0FBSUE7QUFDQTtBQUNBLGdCQUFNdUYsaUJBQWlCLENBQUNySCxXQUFXWSxRQUFYLENBQW9CMEcsZ0NBQXJCLElBQ2xCSCxnQkFBZ0IsSUFEckI7O0FBR0E7QUFDQTtBQUNBLGdCQUFJUCxpQ0FBSjtBQUNBLGdCQUFJdkQsMkJBQUo7QUFDQSxnQkFBSXNELGVBQWUsSUFBbkI7QUFDQSxnQkFDRSxDQUFDLE9BQUtySSxPQUFMLEVBQWN1Qix1QkFBZixJQUNHbUMsUUFGTCxFQUdFO0FBQ0Esa0JBQ0VoQyxXQUFXRSxrQkFBWCxJQUNHRixXQUFXRSxrQkFBWCxDQUE4QkMsVUFEakMsSUFFRyxPQUFPNkIsU0FBUzRCLHFCQUFoQixLQUEwQyxVQUgvQyxFQUlFO0FBQUEsb0JBQ2tDaUQsS0FEbEMsR0FDNEM3RyxVQUQ1QyxDQUNRVSx3QkFEUjs7QUFFQSxvQkFBSW1HLFNBQVNBLE1BQU1sRywyQkFBbkIsRUFBZ0Q7QUFDOUNnRCw4Q0FBNEIzQyxJQUE1QixFQUFrQ2MsS0FBbEM7QUFDRDtBQUNEOEUsMkNBQTJCLHNCQUFVNUUsUUFBVixFQUFvQix1QkFBcEIsQ0FBM0I7QUFDRDtBQUNELGtCQUNFaEMsV0FBV2EsZUFBWCxDQUEyQkMsZ0JBQTNCLElBQ0csT0FBT2tCLFNBQVNuQixlQUFoQixLQUFvQyxVQUZ6QyxFQUdFO0FBQ0F3QyxxQ0FBcUIsc0JBQVVyQixRQUFWLEVBQW9CLGlCQUFwQixDQUFyQjtBQUNEO0FBQ0Y7QUFDRCxnQkFBSSxDQUFDNEUsd0JBQUQsSUFBNkI3RSxnQkFBZ0JDLFFBQWhCLENBQWpDLEVBQTREO0FBQzFEMkUsNkJBQWVqRixtQ0FDYkMsU0FEYSxFQUViSyxTQUFTSixLQUZJLEVBR2JDLFNBSGEsK0JBSVJBLFNBSlEsRUFJTXNGLFlBSk4sRUFBZjtBQU1EOztBQUVEO0FBQ0E7QUFDQSxnQkFBSW5GLFNBQVN6RCxTQUFULENBQUosRUFBeUI7QUFDdkJ5RCx1QkFBU3pELFNBQVQsRUFBb0I0SSxZQUFwQjtBQUNELGFBRkQsTUFFTztBQUNMbkYsdUJBQVNwQixRQUFULENBQWtCdUcsWUFBbEI7QUFDRDtBQUNELGdCQUFJUCx3QkFBSixFQUE4QjtBQUM1QkQsNkJBQWVDLHlCQUF5QnJELGtCQUF6QixFQUFmO0FBQ0FxRCx1Q0FBeUJwRCxPQUF6QjtBQUNEO0FBQ0QsZ0JBQ0U2RCxrQkFDR1YsWUFESCxJQUVHLENBQUMsT0FBS3JJLE9BQUwsRUFBY3VCLHVCQUhwQixFQUlFO0FBQ0FzRCxxQ0FBdUJGLE9BQXZCLEVBQWdDLE1BQWhDLEVBQXNDakIsUUFBdEMsRUFBZ0RoQixJQUFoRCxFQUFzRHFDLGtCQUF0RDtBQUNBLGtCQUNFckQsV0FBV0Usa0JBQVgsSUFDR0YsV0FBV0Usa0JBQVgsQ0FBOEJDLFVBRm5DLEVBR0U7QUFDQSxvQkFDRUgsV0FBVzhHLHVCQUFYLElBQ0csT0FBTzlFLFNBQVM4RSx1QkFBaEIsS0FBNEMsVUFGakQsRUFHRTtBQUNBLHNCQUFNQyxXQUFXL0UsU0FBUzhFLHVCQUFULENBQWlDbkYsU0FBakMsRUFBNENFLFNBQTVDLENBQWpCO0FBQ0Esc0JBQUksT0FBT0csU0FBUzlCLGtCQUFoQixLQUF1QyxVQUEzQyxFQUF1RDtBQUNyRDhCLDZCQUFTOUIsa0JBQVQsQ0FBNEJ5QixTQUE1QixFQUF1Q0UsU0FBdkMsRUFBa0RrRixRQUFsRDtBQUNEO0FBQ0YsaUJBUkQsTUFRTyxJQUFJLE9BQU8vRSxTQUFTOUIsa0JBQWhCLEtBQXVDLFVBQTNDLEVBQXVEO0FBQzVELHNCQUFJRixXQUFXRSxrQkFBWCxDQUE4QkcsV0FBbEMsRUFBK0M7QUFDN0MyQiw2QkFBUzlCLGtCQUFULENBQTRCeUIsU0FBNUIsRUFBdUNFLFNBQXZDLEVBQWtEeEIsV0FBbEQ7QUFDRCxtQkFGRCxNQUVPO0FBQ0wyQiw2QkFBUzlCLGtCQUFULENBQTRCeUIsU0FBNUIsRUFBdUNFLFNBQXZDO0FBQ0Q7QUFDRjtBQUNGO0FBQ0Y7QUFDRCxtQkFBS3lFLE1BQUw7QUFDQTtBQUNBLGdCQUFJSCxRQUFKLEVBQWM7QUFDWixrQkFBSWxELFFBQVFzRSxzQkFBWixFQUFvQztBQUNsQ3RFLHdCQUFRc0Usc0JBQVIsQ0FBK0J2RixRQUEvQixFQUF5Q21FLFFBQXpDO0FBQ0QsZUFGRCxNQUVPO0FBQ0xBLHlCQUFTaUIsSUFBVCxDQUFjcEYsUUFBZDtBQUNEO0FBQ0Y7QUFDRixXQXZHRDtBQXdHRCxTQXpHRDtBQTBHQSxlQUFPLElBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7OzswQkFTVytDLE8sRUFBUztBQUNsQixZQUFJLEtBQUsxRyxJQUFMLE1BQWUsSUFBbkIsRUFBeUI7QUFDdkIsZ0JBQU0sSUFBSTRCLEtBQUosQ0FBVSw2REFBVixDQUFOO0FBQ0Q7QUFDRCxZQUFJLENBQUMsS0FBSzNCLE9BQUwsRUFBY3lHLE9BQW5CLEVBQTRCO0FBQzFCLGdCQUFNLElBQUk5RSxLQUFKLENBQVUsMEdBQVYsQ0FBTjtBQUNEO0FBQ0QsZUFBTyxLQUFLaUgsUUFBTCxDQUFjLElBQWQsRUFBb0JuQyxPQUFwQixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7d0JBWVN5QyxXLEVBQWE7QUFDcEIsWUFBTXZFLFVBQVUsNkJBQVcsS0FBSzNFLE9BQUwsQ0FBWCxDQUFoQjtBQUNBLFlBQUksQ0FBQyxnQ0FBb0JrSixXQUFwQixFQUFpQ3ZFLE9BQWpDLENBQUwsRUFBZ0Q7QUFDOUMsZ0JBQU0sSUFBSWhELEtBQUosQ0FBVSxnSUFBVixDQUFOO0FBQ0Q7QUFDRCxZQUFNakIsWUFBWXdDLE1BQU1DLE9BQU4sQ0FBYytGLFdBQWQsSUFDZDtBQUFBLGlCQUFTLHFDQUNUQyxnQkFEUyxFQUVUQyxLQUZTLEVBR1RGLFlBQVloQixHQUFaLENBQWdCO0FBQUEsbUJBQVF2RCxRQUFRMEUsYUFBUixDQUFzQjNHLElBQXRCLENBQVI7QUFBQSxXQUFoQixDQUhTLENBQVQ7QUFBQSxTQURjLEdBTWQ7QUFBQSxpQkFBUyxzQkFBVWlDLFFBQVEwRSxhQUFSLENBQXNCSCxXQUF0QixDQUFWLEVBQThDRSxLQUE5QyxDQUFUO0FBQUEsU0FOSjs7QUFRQSxlQUFPNUksbUJBQW1CLElBQW5CLEVBQXlCRSxTQUF6QixFQUFvQ29DLE1BQXBDLEdBQTZDLENBQXBEO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozt1Q0FpQndCSixJLEVBQU07QUFDNUIsWUFBTWlDLFVBQVUsNkJBQVcsS0FBSzNFLE9BQUwsQ0FBWCxDQUFoQjtBQUNBLFlBQU1zSixVQUFVM0UsUUFBUTBFLGFBQVIsQ0FBc0IzRyxJQUF0QixDQUFoQjtBQUNBLFlBQU1oQztBQUFZLG1CQUFaQSxTQUFZO0FBQUEsbUJBQVMsd0JBQVk0SSxPQUFaLEVBQXFCRixLQUFyQixFQUE0QixVQUFDRyxDQUFELEVBQUlDLENBQUo7QUFBQSxxQkFBVUQsS0FBS0MsQ0FBZjtBQUFBLGFBQTVCLENBQVQ7QUFBQTs7QUFBWjtBQUFBLFdBQU47QUFDQSxlQUFPaEosbUJBQW1CLElBQW5CLEVBQXlCRSxTQUF6QixFQUFvQ29DLE1BQXBDLEdBQTZDLENBQXBEO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OzJDQW1CNEJHLEssRUFBTztBQUFBOztBQUNqQyxZQUFJLENBQUNDLE1BQU1DLE9BQU4sQ0FBY0YsS0FBZCxDQUFMLEVBQTJCO0FBQ3pCLGdCQUFNLElBQUluQixTQUFKLENBQWMsMEJBQWQsQ0FBTjtBQUNEOztBQUVELGVBQU9tQixNQUFNd0csS0FBTixDQUFZO0FBQUEsaUJBQVEsT0FBS0MsdUJBQUwsQ0FBNkJoSCxJQUE3QixDQUFSO0FBQUEsU0FBWixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OzJDQW1CNEJPLEssRUFBTztBQUFBOztBQUNqQyxlQUFPQyxNQUFNQyxPQUFOLENBQWNGLEtBQWQsS0FBd0JBLE1BQU0wRyxJQUFOLENBQVc7QUFBQSxpQkFBUSxPQUFLRCx1QkFBTCxDQUE2QmhILElBQTdCLENBQVI7QUFBQSxTQUFYLENBQS9CO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7c0JBWU9BLEksRUFBTTtBQUFBOztBQUNYLGVBQU8sS0FBS3VGLE1BQUwsQ0FBWSxRQUFaLEVBQXNCO0FBQUEsaUJBQU0sc0JBQVUsT0FBS2xILGVBQUwsRUFBVixFQUFrQzJCLElBQWxDLENBQU47QUFBQSxTQUF0QixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs4QkFpQmVBLEksRUFBTTtBQUFBOztBQUNuQixlQUFPLEtBQUt1RixNQUFMLENBQVksZ0JBQVosRUFBOEIsWUFBTTtBQUN6QyxjQUFNdEQsVUFBVSw2QkFBVyxPQUFLM0UsT0FBTCxDQUFYLENBQWhCO0FBQ0EsY0FBTXNKLFVBQVUzRSxRQUFRMEUsYUFBUixDQUFzQjNHLElBQXRCLENBQWhCO0FBQ0EsaUJBQU8sd0JBQVk0RyxPQUFaLEVBQXFCLE9BQUt2SSxlQUFMLEVBQXJCLEVBQTZDLFVBQUN3SSxDQUFELEVBQUlDLENBQUo7QUFBQSxtQkFBVUQsS0FBS0MsQ0FBZjtBQUFBLFdBQTdDLENBQVA7QUFDRCxTQUpNLENBQVA7QUFLRDs7Ozs7QUFFRDs7Ozs7Ozs7OztvQkFNS0ksUSxFQUFVO0FBQ2IsZUFBTyxLQUFLM0ksSUFBTCxDQUFVLHNDQUFzQjJJLFFBQXRCLEVBQWdDLEtBQUsxSSxnQkFBTCxFQUFoQyxDQUFWLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7O2tCQVFHMEksUSxFQUFVO0FBQ1gsWUFBTWxKLFlBQVksK0JBQWVrSixRQUFmLENBQWxCO0FBQ0EsZUFBTyxLQUFLM0IsTUFBTCxDQUFZLElBQVosRUFBa0I7QUFBQSxpQkFBS3ZILFVBQVVJLENBQVYsQ0FBTDtBQUFBLFNBQWxCLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7OytCQUtnQjtBQUNkLFlBQU1tQyxRQUFRLEtBQUsvQixnQkFBTCxFQUFkOztBQUVBLGVBQU8rQixNQUFNd0csS0FBTixDQUFZO0FBQUEsaUJBQUsseUJBQWEzSSxDQUFiLENBQUw7QUFBQSxTQUFaLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7OzJCQVFZSixTLEVBQVc7QUFBQTs7QUFDckIsZUFBT00scUJBQXFCLElBQXJCLEVBQTJCO0FBQUEsaUJBQUtOLFVBQVUsUUFBS08sSUFBTCxDQUFVSCxDQUFWLENBQVYsQ0FBTDtBQUFBLFNBQTNCLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7c0JBT084SSxRLEVBQVU7QUFDZixZQUFNbEosWUFBWSwrQkFBZWtKLFFBQWYsQ0FBbEI7QUFDQSxlQUFPNUkscUJBQXFCLElBQXJCLEVBQTJCTixTQUEzQixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7O21CQU9Ja0osUSxFQUFVO0FBQ1osWUFBTWxKLFlBQVksK0JBQWVrSixRQUFmLENBQWxCO0FBQ0EsZUFBTzVJLHFCQUFxQixJQUFyQixFQUEyQjtBQUFBLGlCQUFLLENBQUNOLFVBQVVJLENBQVYsQ0FBTjtBQUFBLFNBQTNCLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7OztzQkFTTztBQUNMLGVBQU8sS0FBS21ILE1BQUwsQ0FBWSxNQUFaLEVBQW9CNEIsNkJBQXBCLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7c0JBT087QUFBQTs7QUFDTCxlQUFPLEtBQUs1QixNQUFMLENBQVksTUFBWixFQUFvQixVQUFDbkgsQ0FBRCxFQUFPO0FBQ2hDLGNBQUksUUFBS2lELElBQUwsT0FBZ0IsSUFBcEIsRUFBMEIsT0FBTyxJQUFQO0FBQzFCLGNBQU1ZLFVBQVUsNkJBQVcsUUFBSzNFLE9BQUwsQ0FBWCxDQUFoQjtBQUNBLGNBQU02RCxXQUFXYyxRQUFRNEMsY0FBUiw4QkFBNEIsUUFBS3ZILE9BQUwsQ0FBNUIsSUFBMkN3SCxNQUFNLFFBQWpELElBQWpCO0FBQ0EsaUJBQU8zRCxTQUFTNkQsTUFBVCxDQUFnQi9DLFFBQVFvQixhQUFSLENBQXNCakYsQ0FBdEIsQ0FBaEIsQ0FBUDtBQUNELFNBTE0sQ0FBUDtBQU1EOzs7OztBQUVEOzs7Ozs7Ozs7Ozt3QkFPUztBQUNQLGVBQU8sS0FBS2lELElBQUwsT0FBZ0IsSUFBaEIsR0FBdUIsMkJBQXZCLEdBQW1DK0YscUJBQVFDLElBQVIsQ0FBYSxFQUFiLEVBQWlCLEtBQUtDLElBQUwsRUFBakIsQ0FBMUM7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7O3dCQVFTQyxLLEVBQWdCO0FBQUE7O0FBQUEsMkNBQU4xRSxJQUFNO0FBQU5BLGNBQU07QUFBQTs7QUFDdkIsZUFBTyxLQUFLMEMsTUFBTCxDQUFZLFVBQVosRUFBd0IsVUFBQ25ILENBQUQsRUFBTztBQUFBOztBQUNwQywrQkFBS2pCLFFBQUwsR0FBZXFLLGFBQWYsbUJBQTZCcEosQ0FBN0IsRUFBZ0NtSixLQUFoQyxTQUEwQzFFLElBQTFDO0FBQ0Esa0JBQUt4RixJQUFMLEVBQVdpSSxNQUFYO0FBQ0EsaUJBQU8sT0FBUDtBQUNELFNBSk0sQ0FBUDtBQUtEOzs7OztBQUVEOzs7Ozs7Ozs7OzZCQU1jbUMsSyxFQUFPO0FBQUE7O0FBQ25COztBQUVBLGVBQU8sS0FBS2xDLE1BQUwsQ0FBWSxlQUFaLEVBQTZCLFVBQUNtQyxRQUFELEVBQWM7QUFDaEQsY0FBSUEsU0FBU3pILFFBQVQsS0FBc0IsTUFBMUIsRUFBa0M7QUFDaEMsa0JBQU0sSUFBSWIsU0FBSixDQUFjLHlFQUFkLENBQU47QUFDRDs7QUFFRCxjQUFNK0IsV0FBVyxRQUFLaEUsUUFBTCxDQUFqQjtBQUNBLGNBQUksT0FBT2dFLFNBQVN3RyxhQUFoQixLQUFrQyxVQUF0QyxFQUFrRDtBQUNoRCxrQkFBTSxJQUFJdkksU0FBSixDQUFjLGtFQUFkLENBQU47QUFDRDs7QUFFRCxjQUFNd0ksV0FBV3pILG9CQUFvQixPQUFwQixDQUFqQjtBQUNBLGNBQU1zQyxnQkFBZ0IsQ0FBQ2lGLFFBQUQsRUFBV2hGLE1BQVgsQ0FBa0JyQyxZQUFZLE9BQVosRUFBa0JxSCxRQUFsQixDQUFsQixDQUF0QjtBQUNBdkcsbUJBQVN3RyxhQUFULENBQXVCbEYsYUFBdkIsRUFBc0NtRixRQUF0QyxFQUFnREgsS0FBaEQ7O0FBRUEsaUJBQU8sT0FBUDtBQUNELFNBZk0sQ0FBUDtBQWdCRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7dUJBT1E7QUFDTixlQUFPLEtBQUtsQyxNQUFMLENBQVksT0FBWixFQUFxQnNDLHlCQUFyQixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7cUJBU01DLEksRUFBTTtBQUFBOztBQUNWLFlBQUksS0FBS3pLLElBQUwsTUFBZSxJQUFuQixFQUF5QjtBQUN2QixnQkFBTSxJQUFJNEIsS0FBSixDQUFVLHdEQUFWLENBQU47QUFDRDtBQUNELFlBQUksS0FBSytCLFFBQUwsT0FBb0IsSUFBcEIsSUFBNEIsS0FBSzdELFFBQUwsRUFBZThILE9BQWYsR0FBeUJoRixRQUF6QixLQUFzQyxPQUF0RSxFQUErRTtBQUM3RSxnQkFBTSxJQUFJaEIsS0FBSixDQUFVLGdFQUFWLENBQU47QUFDRDtBQUNELFlBQU04SSxTQUFTLEtBQUt4QyxNQUFMLENBQVksT0FBWixFQUFxQjtBQUFBLGlCQUFNLFFBQUt2RSxRQUFMLEdBQWdCRixLQUF0QjtBQUFBLFNBQXJCLENBQWY7QUFDQSxZQUFJLE9BQU9nSCxJQUFQLEtBQWdCLFdBQXBCLEVBQWlDO0FBQy9CLGNBQUlDLFVBQVUsSUFBZCxFQUFvQjtBQUNsQixrQkFBTSxJQUFJM0ksU0FBSixvQ0FBd0MwSSxJQUF4Qyw0REFBTjtBQUNEO0FBQ0QsaUJBQU9DLE9BQU9ELElBQVAsQ0FBUDtBQUNEO0FBQ0QsZUFBT0MsTUFBUDtBQUNEOzs7OztBQUVEOzs7Ozs7Ozs7Ozs7O3VCQVNRRCxJLEVBQU07QUFBQTs7QUFDWixZQUFJLEtBQUt6SyxJQUFMLE1BQWUsSUFBbkIsRUFBeUI7QUFDdkIsZ0JBQU0sSUFBSTRCLEtBQUosQ0FBVSwwREFBVixDQUFOO0FBQ0Q7QUFDRCxZQUFJLENBQUMsS0FBSzNCLE9BQUwsRUFBY3lHLE9BQW5CLEVBQTRCO0FBQzFCLGdCQUFNLElBQUk5RSxLQUFKLENBQVUsdUdBQVYsQ0FBTjtBQUNEO0FBQ0QsWUFBSSxLQUFLK0IsUUFBTCxPQUFvQixJQUF4QixFQUE4QjtBQUM1QixnQkFBTSxJQUFJL0IsS0FBSixDQUFVLDZGQUFWLENBQU47QUFDRDtBQUNELFlBQU0rSSxXQUFXLEtBQUt6QyxNQUFMLENBQVksU0FBWixFQUF1QjtBQUFBLGlCQUFNLFFBQUt2RSxRQUFMLEdBQWdCK0MsT0FBdEI7QUFBQSxTQUF2QixDQUFqQjtBQUNBLFlBQUkrRCxJQUFKLEVBQVU7QUFDUixpQkFBT0UsU0FBU0YsSUFBVCxDQUFQO0FBQ0Q7QUFDRCxlQUFPRSxRQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7d0JBTVNkLFEsRUFBVTtBQUNqQixZQUFNZSxjQUFjLEtBQUs5SixPQUFMLENBQWE7QUFBQSxpQkFBSyxrQ0FBZUMsRUFBRUMsZUFBRixFQUFmLENBQUw7QUFBQSxTQUFiLENBQXBCO0FBQ0EsZUFBTzZJLFdBQVdlLFlBQVloSyxNQUFaLENBQW1CaUosUUFBbkIsQ0FBWCxHQUEwQ2UsV0FBakQ7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozt1QkFNUUMsSyxFQUFPO0FBQUE7O0FBQ2IsZUFBTyxLQUFLM0MsTUFBTCxDQUFZLFNBQVosRUFBdUI7QUFBQSxpQkFBTSxRQUFLaEMsUUFBTCxHQUFnQkcsRUFBaEIsQ0FBbUJ3RSxLQUFuQixDQUFOO0FBQUEsU0FBdkIsQ0FBUDtBQUNEOzs7OztBQUVEOzs7Ozs7Ozs7Ozs7O3VCQVNRaEIsUSxFQUFVO0FBQUE7O0FBQ2hCLGVBQU8sS0FBSzNCLE1BQUwsQ0FBWSxTQUFaLEVBQXVCLFVBQUNuSCxDQUFELEVBQU87QUFDbkMsY0FBTStKLGFBQWEsUUFBSzVKLElBQUwsQ0FBVThCLFlBQVksT0FBWixFQUFrQmpDLENBQWxCLENBQVYsQ0FBbkI7QUFDQSxpQkFBTzhJLFdBQVdpQixXQUFXbEssTUFBWCxDQUFrQmlKLFFBQWxCLENBQVgsR0FBeUNpQixVQUFoRDtBQUNELFNBSE0sQ0FBUDtBQUlEOzs7OztBQUVEOzs7Ozs7Ozs7d0JBS1M7QUFDUCxlQUFPLEtBQUtoSyxPQUFMLENBQWE7QUFBQSxpQkFBSyxDQUFDQyxFQUFFZ0ssT0FBRixHQUFZQyxHQUFaLENBQWdCLENBQWhCLENBQUQsQ0FBTDtBQUFBLFNBQWIsQ0FBUDtBQUNEOzs7OztBQUVEOzs7Ozs7Ozs7dUJBS1FuQixRLEVBQVU7QUFDaEIsWUFBSSxLQUFLb0IsRUFBTCxDQUFRcEIsUUFBUixDQUFKLEVBQXVCO0FBQ3JCLGlCQUFPLElBQVA7QUFDRDtBQUNELFlBQU1xQixvQkFBb0IsS0FBS0gsT0FBTCxHQUFlbkssTUFBZixDQUFzQmlKLFFBQXRCLENBQTFCO0FBQ0EsZUFBT3FCLGtCQUFrQm5JLE1BQWxCLEdBQTJCLENBQTNCLEdBQStCbUksa0JBQWtCQyxLQUFsQixFQUEvQixHQUEyRCxLQUFLQyxTQUFMLENBQWU7QUFBQSxpQkFBTSxLQUFOO0FBQUEsU0FBZixDQUFsRTtBQUNEOzs7OztBQUVEOzs7Ozs7Ozs7Ozs7dUJBUVE5SixPLEVBQVM7QUFBQTs7QUFDZixlQUFPLEtBQUs0RyxNQUFMLENBQVksU0FBWixFQUF1QjtBQUFBLGlCQUM1QixRQUFLaEgsSUFBTCxDQUFVLDZCQUFXLFFBQUtqQixPQUFMLENBQVgsRUFBMEIrRixhQUExQixDQUF3Q2pGLENBQXhDLENBQVYsRUFBc0QsSUFBdEQsRUFBNERPLE9BQTVELENBRDRCO0FBQUEsU0FBdkIsQ0FBUDtBQUdEOzs7OztBQUVEOzs7Ozs7Ozs7O29CQU1LK0osUSxFQUFVO0FBQ2IsZUFBTyxLQUFLOUgsS0FBTCxHQUFhOEgsUUFBYixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7O3NCQU9PQSxRLEVBQVU7QUFBQTs7QUFDZixlQUFPLEtBQUtuRCxNQUFMLENBQVksUUFBWixFQUFzQixZQUFNO0FBQ2pDLGNBQU1vRCxVQUFVLFFBQUtDLElBQUwsQ0FBVUYsUUFBVixDQUFoQjtBQUNBLGNBQUksT0FBT0MsT0FBUCxLQUFtQixVQUF2QixFQUFtQztBQUNqQyxrQkFBTSxJQUFJdkosU0FBSixDQUFjLGdGQUFkLENBQU47QUFDRDtBQUNELGlCQUFPLFlBQWE7QUFDbEIsZ0JBQU15SixXQUFXRixtQ0FBakI7QUFDQSxvQkFBS3RMLElBQUwsRUFBV2lJLE1BQVg7QUFDQSxtQkFBT3VELFFBQVA7QUFDRCxXQUpEO0FBS0QsU0FWTSxDQUFQO0FBV0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7MEJBTVdILFEsRUFBVTtBQUFBOztBQUNuQixZQUFNekcsVUFBVSw2QkFBVyxLQUFLM0UsT0FBTCxDQUFYLENBQWhCO0FBQ0EsWUFBSSxPQUFPMkUsUUFBUTFELElBQWYsS0FBd0IsVUFBNUIsRUFBd0M7QUFDdEMsZ0JBQU0sSUFBSXVLLFVBQUosQ0FBZSx5REFBZixDQUFOO0FBQ0Q7O0FBRUQsZUFBTyxLQUFLdkQsTUFBTCxDQUFZLFlBQVosRUFBMEIsVUFBQ25ILENBQUQsRUFBTztBQUN0QyxjQUFJQSxFQUFFNkIsUUFBRixLQUFlLE1BQW5CLEVBQTJCO0FBQ3pCLGtCQUFNLElBQUliLFNBQUosQ0FBYyxzRUFBZCxDQUFOO0FBQ0Q7QUFDRCxjQUFJLE9BQU9zSixRQUFQLEtBQW9CLFFBQXhCLEVBQWtDO0FBQ2hDLGtCQUFNLElBQUl0SixTQUFKLENBQWMsMkRBQWQsQ0FBTjtBQUNEO0FBQ0QsY0FBTXdCLFFBQVEsUUFBS0EsS0FBTCxFQUFkO0FBQ0EsY0FBSSxDQUFDLHNCQUFJQSxLQUFKLEVBQVc4SCxRQUFYLENBQUwsRUFBMkI7QUFDekIsa0JBQU0sSUFBSXpKLEtBQUosZ0VBQTJEeUosUUFBM0QsbUJBQU47QUFDRDtBQUNELGNBQU1LLFlBQVluSSxNQUFNOEgsUUFBTixDQUFsQjtBQUNBLGNBQUksT0FBT0ssU0FBUCxLQUFxQixVQUF6QixFQUFxQztBQUNuQyxrQkFBTSxJQUFJM0osU0FBSiwrREFBOERzSixRQUE5RCxrRUFBdUhLLFNBQXZILHlDQUF1SEEsU0FBdkgsY0FBTjtBQUNEOztBQUVELGlCQUFPLFlBQWE7QUFDbEIsZ0JBQU0zRixVQUFVMkYscUNBQWhCO0FBQ0EsZ0JBQU1DLFVBQVUvRyxRQUFRMUQsSUFBUixDQUFhNkUsT0FBYixDQUFoQjtBQUNBLG1CQUFPLFFBQUs3RSxJQUFMLENBQVV5SyxPQUFWLEVBQW1CLElBQW5CLEVBQXlCLFFBQUsxTCxPQUFMLENBQXpCLENBQVA7QUFDRCxXQUpEO0FBS0QsU0FyQk0sQ0FBUDtBQXNCRDs7Ozs7QUFFRDs7Ozs7Ozs7O3FCQUtNO0FBQ0osZUFBTyxLQUFLaUksTUFBTCxDQUFZLEtBQVosRUFBbUI7QUFBQSxpQkFBTW5ILEVBQUUwRCxHQUFGLEtBQVU2QixTQUFWLEdBQXNCLElBQXRCLEdBQTZCdkYsRUFBRTBELEdBQXJDO0FBQUEsU0FBbkIsQ0FBUDtBQUNEOzs7OztBQUVEOzs7Ozs7Ozs7OztzQkFPTztBQUNMLGVBQU8sS0FBS3lELE1BQUwsQ0FBWSxNQUFaLEVBQW9CO0FBQUEsaUJBQUssdUJBQVduSCxDQUFYLENBQUw7QUFBQSxTQUFwQixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7O3NCQU9PO0FBQ0wsWUFBTTZELFVBQVUsNkJBQVcsS0FBSzNFLE9BQUwsQ0FBWCxDQUFoQjtBQUNBLGVBQU8sS0FBS2lJLE1BQUwsQ0FBWSxNQUFaLEVBQW9CO0FBQUEsaUJBQ3pCdEQsUUFBUWdILGlCQUFSLEdBQTRCaEgsUUFBUWdILGlCQUFSLENBQTBCN0ssQ0FBMUIsQ0FBNUIsR0FBMkQsOEJBQWtCQSxDQUFsQixDQURsQztBQUFBLFNBQXBCLENBQVA7QUFHRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7O3dCQVFTOEssUyxFQUFXO0FBQ2xCLFlBQUksT0FBT0EsU0FBUCxLQUFxQixRQUFyQixJQUFpQ0EsVUFBVUMsT0FBVixDQUFrQixHQUFsQixNQUEyQixDQUFDLENBQWpFLEVBQW9FO0FBQ2xFO0FBQ0EzSCxrQkFBUUMsSUFBUixDQUFhLHNJQUFiO0FBQ0Q7QUFDRCxlQUFPLEtBQUs4RCxNQUFMLENBQVksVUFBWixFQUF3QjtBQUFBLGlCQUFLLGdDQUFhbkgsQ0FBYixFQUFnQjhLLFNBQWhCLENBQUw7QUFBQSxTQUF4QixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7O3VCQU9RRSxFLEVBQUk7QUFBQTs7QUFDVixhQUFLNUssZ0JBQUwsR0FBd0JxRCxPQUF4QixDQUFnQyxVQUFDekQsQ0FBRCxFQUFJb0YsQ0FBSjtBQUFBLGlCQUFVNEYsR0FBR2hELElBQUgsQ0FBUSxPQUFSLEVBQWMsUUFBSzdILElBQUwsQ0FBVUgsQ0FBVixDQUFkLEVBQTRCb0YsQ0FBNUIsQ0FBVjtBQUFBLFNBQWhDO0FBQ0EsZUFBTyxJQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7O21CQU9JNEYsRSxFQUFJO0FBQUE7O0FBQ04sZUFBTyxLQUFLNUssZ0JBQUwsR0FBd0JnSCxHQUF4QixDQUE0QixVQUFDcEgsQ0FBRCxFQUFJb0YsQ0FBSjtBQUFBLGlCQUFVNEYsR0FBR2hELElBQUgsQ0FBUSxPQUFSLEVBQWMsUUFBSzdILElBQUwsQ0FBVUgsQ0FBVixDQUFkLEVBQTRCb0YsQ0FBNUIsQ0FBVjtBQUFBLFNBQTVCLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7O3NCQVFPNEYsRSxFQUE4QjtBQUFBOztBQUFBLFlBQTFCQyxZQUEwQix1RUFBWDFGLFNBQVc7O0FBQ25DLFlBQUlzQyxVQUFVN0YsTUFBVixHQUFtQixDQUF2QixFQUEwQjtBQUN4QixpQkFBTyxLQUFLNUIsZ0JBQUwsR0FBd0I4SyxNQUF4QixDQUNMLFVBQUNDLEtBQUQsRUFBUW5MLENBQVIsRUFBV29GLENBQVg7QUFBQSxtQkFBaUI0RixHQUFHaEQsSUFBSCxDQUFRLE9BQVIsRUFBY21ELEtBQWQsRUFBcUIsUUFBS2hMLElBQUwsQ0FBVUgsQ0FBVixDQUFyQixFQUFtQ29GLENBQW5DLENBQWpCO0FBQUEsV0FESyxFQUVMNkYsWUFGSyxDQUFQO0FBSUQ7QUFDRCxlQUFPLEtBQUs3SyxnQkFBTCxHQUF3QjhLLE1BQXhCLENBQStCLFVBQUNDLEtBQUQsRUFBUW5MLENBQVIsRUFBV29GLENBQVg7QUFBQSxpQkFBaUI0RixHQUFHaEQsSUFBSCxDQUNyRCxPQURxRCxFQUVyRDVDLE1BQU0sQ0FBTixHQUFVLFFBQUtqRixJQUFMLENBQVVnTCxLQUFWLENBQVYsR0FBNkJBLEtBRndCLEVBR3JELFFBQUtoTCxJQUFMLENBQVVILENBQVYsQ0FIcUQsRUFJckRvRixDQUpxRCxDQUFqQjtBQUFBLFNBQS9CLENBQVA7QUFNRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7OzJCQVFZNEYsRSxFQUE4QjtBQUFBOztBQUFBLFlBQTFCQyxZQUEwQix1RUFBWDFGLFNBQVc7O0FBQ3hDLFlBQUlzQyxVQUFVN0YsTUFBVixHQUFtQixDQUF2QixFQUEwQjtBQUN4QixpQkFBTyxLQUFLNUIsZ0JBQUwsR0FBd0JnTCxXQUF4QixDQUNMLFVBQUNELEtBQUQsRUFBUW5MLENBQVIsRUFBV29GLENBQVg7QUFBQSxtQkFBaUI0RixHQUFHaEQsSUFBSCxDQUFRLE9BQVIsRUFBY21ELEtBQWQsRUFBcUIsUUFBS2hMLElBQUwsQ0FBVUgsQ0FBVixDQUFyQixFQUFtQ29GLENBQW5DLENBQWpCO0FBQUEsV0FESyxFQUVMNkYsWUFGSyxDQUFQO0FBSUQ7QUFDRCxlQUFPLEtBQUs3SyxnQkFBTCxHQUF3QmdMLFdBQXhCLENBQW9DLFVBQUNELEtBQUQsRUFBUW5MLENBQVIsRUFBV29GLENBQVg7QUFBQSxpQkFBaUI0RixHQUFHaEQsSUFBSCxDQUMxRCxPQUQwRCxFQUUxRDVDLE1BQU0sQ0FBTixHQUFVLFFBQUtqRixJQUFMLENBQVVnTCxLQUFWLENBQVYsR0FBNkJBLEtBRjZCLEVBRzFELFFBQUtoTCxJQUFMLENBQVVILENBQVYsQ0FIMEQsRUFJMURvRixDQUowRCxDQUFqQjtBQUFBLFNBQXBDLENBQVA7QUFNRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7O3FCQVFNaUcsSyxFQUFPQyxHLEVBQUs7QUFDaEIsZUFBTyxLQUFLbkwsSUFBTCxDQUFVLEtBQUtDLGdCQUFMLEdBQXdCbUwsS0FBeEIsQ0FBOEJGLEtBQTlCLEVBQXFDQyxHQUFyQyxDQUFWLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7OztvQkFNS3hDLFEsRUFBVTtBQUNiLFlBQUksS0FBSzdKLElBQUwsTUFBZSxJQUFuQixFQUF5QjtBQUN2QixnQkFBTSxJQUFJNEIsS0FBSixDQUFVLHNEQUFWLENBQU47QUFDRDtBQUNELFlBQU1qQixZQUFZLCtCQUFla0osUUFBZixDQUFsQjtBQUNBLGVBQU8sS0FBSzFJLGdCQUFMLEdBQXdCeUksSUFBeEIsQ0FBNkJqSixTQUE3QixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7eUJBTVVBLFMsRUFBVztBQUFBOztBQUNuQixlQUFPLEtBQUtRLGdCQUFMLEdBQXdCeUksSUFBeEIsQ0FBNkIsVUFBQzdJLENBQUQsRUFBSW9GLENBQUo7QUFBQSxpQkFBVXhGLFVBQVVvSSxJQUFWLENBQWUsT0FBZixFQUFxQixRQUFLN0gsSUFBTCxDQUFVSCxDQUFWLENBQXJCLEVBQW1Db0YsQ0FBbkMsQ0FBVjtBQUFBLFNBQTdCLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7OztxQkFNTTBELFEsRUFBVTtBQUNkLFlBQU1sSixZQUFZLCtCQUFla0osUUFBZixDQUFsQjtBQUNBLGVBQU8sS0FBSzFJLGdCQUFMLEdBQXdCdUksS0FBeEIsQ0FBOEIvSSxTQUE5QixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7MEJBTVdBLFMsRUFBVztBQUFBOztBQUNwQixlQUFPLEtBQUtRLGdCQUFMLEdBQXdCdUksS0FBeEIsQ0FBOEIsVUFBQzNJLENBQUQsRUFBSW9GLENBQUo7QUFBQSxpQkFBVXhGLFVBQVVvSSxJQUFWLENBQWUsT0FBZixFQUFxQixRQUFLN0gsSUFBTCxDQUFVSCxDQUFWLENBQXJCLEVBQW1Db0YsQ0FBbkMsQ0FBVjtBQUFBLFNBQTlCLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7O3VCQVFRNEYsRSxFQUFJO0FBQUE7O0FBQ1YsWUFBTTdJLFFBQVEsS0FBSy9CLGdCQUFMLEdBQXdCZ0gsR0FBeEIsQ0FBNEIsVUFBQ3BILENBQUQsRUFBSW9GLENBQUo7QUFBQSxpQkFBVTRGLEdBQUdoRCxJQUFILENBQVEsT0FBUixFQUFjLFFBQUs3SCxJQUFMLENBQVVILENBQVYsQ0FBZCxFQUE0Qm9GLENBQTVCLENBQVY7QUFBQSxTQUE1QixDQUFkO0FBQ0EsWUFBTW9HLFlBQVksaUNBQUtySixLQUFMLEVBQVksQ0FBWixDQUFsQjtBQUNBLGVBQU8sS0FBS2hDLElBQUwsQ0FBVXFMLFVBQVUzTCxNQUFWLENBQWlCUSxPQUFqQixDQUFWLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7O3lCQVFVVCxTLEVBQVc7QUFBQTs7QUFDbkIsZUFBT0YsbUJBQW1CLElBQW5CLEVBQXlCLFVBQUNNLENBQUQsRUFBTztBQUNyQyxjQUFNNEIsT0FBTyxRQUFLekIsSUFBTCxDQUFVSCxDQUFWLENBQWI7QUFDQSxpQkFBTzRCLEtBQUtJLE1BQUwsR0FBYyxDQUFkLElBQW1CcEMsVUFBVWdDLElBQVYsQ0FBMUI7QUFDRCxTQUhNLENBQVA7QUFJRDs7Ozs7QUFFRDs7Ozs7Ozs7OzttQkFNSWtJLEssRUFBTztBQUNULGVBQU8sS0FBSzJCLFdBQUwsR0FBbUIzQixLQUFuQixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7a0JBTUdBLEssRUFBTztBQUNSLFlBQU0zSCxRQUFRLEtBQUsvQixnQkFBTCxFQUFkO0FBQ0EsWUFBSTBKLFFBQVEzSCxNQUFNSCxNQUFsQixFQUEwQjtBQUN4QixpQkFBTyxLQUFLN0IsSUFBTCxDQUFVZ0MsTUFBTTJILEtBQU4sQ0FBVixDQUFQO0FBQ0Q7QUFDRCxlQUFPLEtBQUszSixJQUFMLENBQVUsRUFBVixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozt1QkFLUTtBQUNOLGVBQU8sS0FBS21GLEVBQUwsQ0FBUSxDQUFSLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7O3NCQUtPO0FBQ0wsZUFBTyxLQUFLQSxFQUFMLENBQVEsS0FBS3RELE1BQUwsR0FBYyxDQUF0QixDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozt5QkFLVTtBQUNSO0FBQ0FvQixnQkFBUUMsSUFBUixDQUFhLG1FQUFiO0FBQ0EsZUFBTyxDQUFDLEtBQUtxSSxNQUFMLEVBQVI7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7d0JBT3dCO0FBQUEsWUFBakI1QyxRQUFpQix1RUFBTixJQUFNOztBQUN0QixlQUFPakIsVUFBVTdGLE1BQVYsR0FBbUIsQ0FBbkIsR0FBdUIsS0FBSzJKLElBQUwsQ0FBVTdDLFFBQVYsRUFBb0I0QyxNQUFwQixFQUF2QixHQUFzRCxLQUFLMUosTUFBTCxHQUFjLENBQTNFO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7OztzQkFRTzBILEksRUFBTXNCLEUsRUFBSTtBQUNmLFlBQU1ZLFNBQVMsT0FBT2xDLElBQVAsS0FBZ0IsUUFBaEIsR0FBMkJBLElBQTNCLEdBQWtDLFNBQWpEO0FBQ0EsWUFBTTNDLFdBQVcsT0FBT2lFLEVBQVAsS0FBYyxVQUFkLEdBQTJCQSxFQUEzQixHQUFnQ3RCLElBQWpEO0FBQ0EsWUFBSSxLQUFLMUgsTUFBTCxLQUFnQixDQUFwQixFQUF1QjtBQUNyQixnQkFBTSxJQUFJbkIsS0FBSixtQkFBcUIrSyxNQUFyQixvREFBOEQsS0FBSzVKLE1BQW5FLHNCQUFOO0FBQ0Q7QUFDRCxlQUFPK0UsU0FBU2lCLElBQVQsQ0FBYyxJQUFkLEVBQW9CLEtBQUsvSCxlQUFMLEVBQXBCLENBQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7Ozs7b0JBT0syQixJLEVBQWtDO0FBQUEsWUFBNUJrRSxJQUE0Qix1RUFBckIsS0FBSzdHLElBQUwsQ0FBcUI7O0FBQ3JDLFlBQUkyQyxnQkFBZ0IyRSxjQUFwQixFQUFvQztBQUNsQyxpQkFBTzNFLElBQVA7QUFDRDs7QUFIb0MsMkNBQU42QyxJQUFNO0FBQU5BLGNBQU07QUFBQTs7QUFJckMsa0RBQVc4QixjQUFYLGlCQUEwQjNFLElBQTFCLEVBQWdDa0UsSUFBaEMsR0FBeUNyQixJQUF6QztBQUNEOzs7OztBQUVEOzs7Ozs7Ozs7Ozs7dUJBUW9CO0FBQUEsWUFBZGxFLE9BQWMsdUVBQUosRUFBSTs7QUFDbEIsZUFBTyx1QkFBVyxLQUFLSCxnQkFBTCxFQUFYLEVBQW9DRyxPQUFwQyxDQUFQO0FBQ0Q7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7bUJBTUlzTCxXLEVBQWE7QUFDZkEsb0JBQVksSUFBWjtBQUNBLGVBQU8sSUFBUDtBQUNEOzs7OztBQUVEOzs7Ozs7Ozs7OztzQkFPbUI7QUFBQTs7QUFBQSxZQUFkdEwsT0FBYyx1RUFBSixFQUFJOztBQUNqQixZQUFNc0QsVUFBVSw2QkFBVyxLQUFLM0UsT0FBTCxDQUFYLENBQWhCO0FBQ0EsWUFBTXdLLE9BQU8sTUFBYjtBQUNBLGVBQU8sS0FBS3ZDLE1BQUwsQ0FBWXVDLElBQVosRUFBa0IsVUFBQzFKLENBQUQsRUFBTztBQUM5QixjQUFJQSxLQUFLQSxFQUFFNkIsUUFBRixLQUFlLE1BQXhCLEVBQWdDO0FBQzlCLGtCQUFNLElBQUliLFNBQUosc0JBQWlDMEksSUFBakMsNkNBQU47QUFDRDtBQUNELGNBQU1vQyxLQUFLLDZCQUFXLFFBQUs1TSxPQUFMLENBQVgsRUFBMEIrRixhQUExQixDQUF3Q2pGLENBQXhDLENBQVg7QUFDQSxjQUFJLENBQUMscUNBQXlCOEwsRUFBekIsRUFBNkJqSSxPQUE3QixDQUFMLEVBQTRDO0FBQzFDLGtCQUFNLElBQUk3QyxTQUFKLHNCQUFpQzBJLElBQWpDLHlDQUFOO0FBQ0Q7QUFDRCxjQUFNcUMsNENBQ0QsUUFBSzdNLE9BQUwsQ0FEQyxFQUVEcUIsT0FGQztBQUdKb0YscUJBQVNwRixRQUFRb0YsT0FBUixpQ0FDSixRQUFLekcsT0FBTCxFQUFjeUcsT0FEVixFQUVKLFFBQUsxRyxJQUFMLEVBQVdJLGFBQVgsQ0FGSTtBQUhMLFlBQU47QUFRQSxpQ0FBVzBNLFlBQVgsRUFBeUJ0TSxlQUF6QixFQUEwQyxRQUFLUixJQUFMLEVBQVdRLGVBQVgsQ0FBMUM7QUFDQSxpQkFBTyxRQUFLVSxJQUFMLENBQVUyTCxFQUFWLEVBQWMsSUFBZCxFQUFvQkMsWUFBcEIsQ0FBUDtBQUNELFNBbEJNLENBQVA7QUFtQkQ7Ozs7O0FBRUQ7Ozs7Ozs7Ozs7MkJBTVk7QUFDVixlQUFPLEtBQUtDLFdBQUwsQ0FBaUI7QUFBQSxpQkFBSyxPQUFPaE0sRUFBRWlELElBQUYsRUFBUCxLQUFvQixRQUF6QjtBQUFBLFNBQWpCLENBQVA7QUFDRDs7Ozs7Ozs7O0FBR0g7Ozs7OztBQUlBLFNBQVNnSix3QkFBVCxDQUFrQ2pHLGlCQUFsQyxFQUFxRDtBQUNuRCxNQUFNbkMsVUFBVSw2QkFBV21DLGtCQUFrQjlHLE9BQWxCLENBQVgsQ0FBaEI7QUFDQSxNQUFNZ04saUJBQWlCbEcsa0JBQWtCekcsZUFBbEIsQ0FBdkI7QUFDQSxNQUFNNE0sa0JBQWtCRCxlQUFlbk4sUUFBZixDQUF4QjtBQUNBLE1BQU1xTixjQUFjRCxnQkFBZ0J0RixPQUFoQixFQUFwQjs7QUFKbUQsK0JBUS9DckIsZ0NBQWdDUSxpQkFBaEMsRUFBbURuQyxPQUFuRCxDQVIrQztBQUFBLE1BTWpENkIsYUFOaUQsMEJBTWpEQSxhQU5pRDtBQUFBLE1BT2pERSxjQVBpRCwwQkFPakRBLGNBUGlEOztBQVNuRCxNQUFNeUcscUJBQXFCSCxlQUFlek0sZUFBZixDQUEzQjs7QUFFQXlNLGlCQUFlSSxVQUFmLDhCQUNLdEcsa0JBQWtCekcsZUFBbEIsRUFBbUNMLE9BQW5DLEVBQTRDeUcsT0FEakQsRUFFS0QsYUFGTDtBQUlBd0csaUJBQWV6TSxlQUFmLElBQWtDLElBQUlrSCxHQUFKLDhCQUFZMEYsa0JBQVosc0JBQW1DekcsY0FBbkMsR0FBbEM7O0FBRUEsTUFBSSxPQUFPL0IsUUFBUTBJLGlCQUFmLEtBQXFDLFVBQXJDLElBQW1EMUksUUFBUTBJLGlCQUFSLENBQTBCSCxZQUFZbkosSUFBdEMsQ0FBdkQsRUFBb0c7QUFDbEcsUUFBTXVKLFdBQVdKLFlBQVluSixJQUE3QjtBQUNBO0FBQ0E7QUFDQSxRQUFNd0osV0FBVzVJLFFBQVE2SSx1QkFBUixDQUFnQ0YsUUFBaEMsQ0FBakI7QUFDQSxRQUFNRyxXQUFXL0csZUFBZXFFLEdBQWYsQ0FBbUJ3QyxRQUFuQixDQUFqQjtBQUNBLFFBQU1HLFdBQVdQLG1CQUFtQnBDLEdBQW5CLENBQXVCd0MsUUFBdkIsQ0FBakI7O0FBRUE7QUFDQSxRQUFJRSxhQUFhQyxRQUFqQixFQUEyQjtBQUN6QlYscUJBQWVwRSxRQUFmO0FBQ0Q7QUFDRjtBQUNGOztBQUVEOzs7Ozs7O0lBTU0xQix3Qjs7O0FBQ0osb0NBQVlqRSxLQUFaLEVBQW1CMkQsSUFBbkIsRUFBeUJLLFVBQXpCLEVBQXFDO0FBQUE7O0FBQUEsc0pBQzdCaEUsS0FENkI7O0FBRW5DLG9DQUFpQjVDLGVBQWpCLEVBQWtDdUcsSUFBbEM7QUFDQSxvQ0FBaUJ0RyxXQUFqQixFQUE4QjJHLFVBQTlCO0FBSG1DO0FBSXBDOztBQUVEOzs7Ozs7Ozs7MEJBSWtCO0FBQUE7O0FBQUEsMkNBQU4xQixJQUFNO0FBQU5BLGNBQU07QUFBQTs7QUFDaEIsWUFBTW9JLHFMQUEyQnBJLElBQTNCLEVBQU47QUFDQXdILGlDQUF5QixJQUF6QjtBQUNBLGVBQU9ZLE1BQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7Ozs7MEJBSWtCO0FBQUE7O0FBQUEsMkNBQU5wSSxJQUFNO0FBQU5BLGNBQU07QUFBQTs7QUFDaEIsWUFBTW9JLHFMQUEyQnBJLElBQTNCLEVBQU47QUFDQXdILGlDQUF5QixJQUF6QjtBQUNBLGVBQU9ZLE1BQVA7QUFDRDs7Ozs7QUFFRDs7Ozs7c0NBQ3VCO0FBQ3JCLGNBQU0sSUFBSWhNLEtBQUosQ0FBVSx1RUFBVixDQUFOO0FBQ0Q7Ozs7Ozs7RUE5Qm9DMEYsYzs7QUFpQ3ZDLElBQUl1RyxzQkFBSixFQUFxQjtBQUNuQnZKLFNBQU93SixjQUFQLENBQXNCeEcsZUFBZXpDLFNBQXJDLEVBQWdEZ0osc0JBQWhELEVBQWlFO0FBQy9ERSxrQkFBYyxJQURpRDtBQUUvREM7QUFBTyxlQUFTQyxRQUFULEdBQW9CO0FBQUE7O0FBQ3pCLFlBQU1DLE9BQU8sS0FBSy9NLGdCQUFMLEdBQXdCME0sc0JBQXhCLEdBQWI7QUFDQSxZQUFNakosVUFBVSw2QkFBVyxLQUFLM0UsT0FBTCxDQUFYLENBQWhCO0FBQ0Esa0RBQ0c0TixzQkFESCxjQUNzQjtBQUFFLGlCQUFPLElBQVA7QUFBYyxTQUR0QztBQUFBLDBCQUVTO0FBQ0wsZ0JBQU1NLE9BQU9ELEtBQUtDLElBQUwsRUFBYjtBQUNBLGdCQUFJQSxLQUFLQyxJQUFULEVBQWU7QUFDYixxQkFBTyxFQUFFQSxNQUFNLElBQVIsRUFBUDtBQUNEO0FBQ0QsbUJBQU87QUFDTEEsb0JBQU0sS0FERDtBQUVMSixxQkFBT3BKLFFBQVFvQixhQUFSLENBQXNCbUksS0FBS0gsS0FBM0I7QUFGRixhQUFQO0FBSUQ7O0FBWEg7QUFBQTtBQWFEOztBQWhCRCxhQUFnQkMsUUFBaEI7QUFBQTtBQUYrRCxHQUFqRTtBQW9CRDs7QUFFRCxTQUFTSSxjQUFULENBQXdCOUMsSUFBeEIsRUFBOEIrQyxZQUE5QixFQUE0QztBQUMxQ2hLLFNBQU93SixjQUFQLENBQXNCeEcsZUFBZXpDLFNBQXJDLEVBQWdEMEcsSUFBaEQsRUFBc0Q7QUFDcERQLE9BRG9EO0FBQUEscUJBQzlDO0FBQ0osY0FBTSxJQUFJcEosS0FBSiwyREFDa0MySixJQURsQyxnS0FHRitDLFlBSEUsZUFBTjtBQUtEOztBQVBtRDtBQUFBOztBQVFwREMsZ0JBQVksS0FSd0M7QUFTcERSLGtCQUFjO0FBVHNDLEdBQXREO0FBV0Q7O0FBRURNLGVBQWUsTUFBZixFQUF1QixpREFBdkI7QUFDQUEsZUFBZSxPQUFmLEVBQXdCLGtEQUF4QjtBQUNBQSxlQUFlLFVBQWYsRUFBMkIsRUFBM0I7QUFDQUEsZUFBZSxTQUFmLEVBQTBCLEVBQTFCO0FBQ0FBLGVBQWUsaUJBQWYsRUFBa0MsRUFBbEM7O3FCQUVlL0csYyIsImZpbGUiOiJTaGFsbG93V3JhcHBlci5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBmbGF0IGZyb20gJ2FycmF5LnByb3RvdHlwZS5mbGF0JztcbmltcG9ydCBjaGVlcmlvIGZyb20gJ2NoZWVyaW8nO1xuaW1wb3J0IGhhcyBmcm9tICdoYXMnO1xuXG5pbXBvcnQge1xuICBub2RlRXF1YWwsXG4gIG5vZGVNYXRjaGVzLFxuICBjb250YWluc0NoaWxkcmVuU3ViQXJyYXksXG4gIHdpdGhTZXRTdGF0ZUFsbG93ZWQsXG4gIHR5cGVPZk5vZGUsXG4gIGlzUmVhY3RFbGVtZW50QWxpa2UsXG4gIGRpc3BsYXlOYW1lT2ZOb2RlLFxuICBpc0N1c3RvbUNvbXBvbmVudCxcbiAgaXNDdXN0b21Db21wb25lbnRFbGVtZW50LFxuICBJVEVSQVRPUl9TWU1CT0wsXG4gIG1ha2VPcHRpb25zLFxuICBzeW0sXG4gIHByaXZhdGVTZXQsXG4gIGNsb25lRWxlbWVudCxcbiAgc3B5TWV0aG9kLFxuICBzaGFsbG93RXF1YWwsXG4gIGlzRW1wdHlWYWx1ZSxcbn0gZnJvbSAnLi9VdGlscyc7XG5pbXBvcnQgZ2V0QWRhcHRlciBmcm9tICcuL2dldEFkYXB0ZXInO1xuaW1wb3J0IHsgZGVidWdOb2RlcyB9IGZyb20gJy4vRGVidWcnO1xuaW1wb3J0IHtcbiAgcHJvcHNPZk5vZGUsXG4gIGdldFRleHRGcm9tTm9kZSxcbiAgaGFzQ2xhc3NOYW1lLFxuICBjaGlsZHJlbk9mTm9kZSxcbiAgcGFyZW50c09mTm9kZSxcbiAgdHJlZUZpbHRlcixcbn0gZnJvbSAnLi9SU1RUcmF2ZXJzYWwnO1xuaW1wb3J0IHsgYnVpbGRQcmVkaWNhdGUsIHJlZHVjZVRyZWVzQnlTZWxlY3RvciB9IGZyb20gJy4vc2VsZWN0b3JzJztcblxuY29uc3QgTk9ERSA9IHN5bSgnX19ub2RlX18nKTtcbmNvbnN0IE5PREVTID0gc3ltKCdfX25vZGVzX18nKTtcbmNvbnN0IFJFTkRFUkVSID0gc3ltKCdfX3JlbmRlcmVyX18nKTtcbmNvbnN0IFVOUkVOREVSRUQgPSBzeW0oJ19fdW5yZW5kZXJlZF9fJyk7XG5jb25zdCBST09UID0gc3ltKCdfX3Jvb3RfXycpO1xuY29uc3QgT1BUSU9OUyA9IHN5bSgnX19vcHRpb25zX18nKTtcbmNvbnN0IFNFVF9TVEFURSA9IHN5bSgnX19zZXRTdGF0ZV9fJyk7XG5jb25zdCBST09UX05PREVTID0gc3ltKCdfX3Jvb3ROb2Rlc19fJyk7XG5jb25zdCBDSElMRF9DT05URVhUID0gc3ltKCdfX2NoaWxkQ29udGV4dF9fJyk7XG5jb25zdCBXUkFQUElOR19DT01QT05FTlQgPSBzeW0oJ19fd3JhcHBpbmdDb21wb25lbnRfXycpO1xuY29uc3QgUFJJTUFSWV9XUkFQUEVSID0gc3ltKCdfX3ByaW1hcnlXcmFwcGVyX18nKTtcbmNvbnN0IFJPT1RfRklOREVSID0gc3ltKCdfX3Jvb3RGaW5kZXJfXycpO1xuY29uc3QgUFJPVklERVJfVkFMVUVTID0gc3ltKCdfX3Byb3ZpZGVyVmFsdWVzX18nKTtcblxuLyoqXG4gKiBGaW5kcyBhbGwgbm9kZXMgaW4gdGhlIGN1cnJlbnQgd3JhcHBlciBub2RlcycgcmVuZGVyIHRyZWVzIHRoYXQgbWF0Y2ggdGhlIHByb3ZpZGVkIHByZWRpY2F0ZVxuICogZnVuY3Rpb24uXG4gKlxuICogQHBhcmFtIHtTaGFsbG93V3JhcHBlcn0gd3JhcHBlclxuICogQHBhcmFtIHtGdW5jdGlvbn0gcHJlZGljYXRlXG4gKiBAcGFyYW0ge0Z1bmN0aW9ufSBmaWx0ZXJcbiAqIEByZXR1cm5zIHtTaGFsbG93V3JhcHBlcn1cbiAqL1xuZnVuY3Rpb24gZmluZFdoZXJlVW53cmFwcGVkKHdyYXBwZXIsIHByZWRpY2F0ZSwgZmlsdGVyID0gdHJlZUZpbHRlcikge1xuICByZXR1cm4gd3JhcHBlci5mbGF0TWFwKG4gPT4gZmlsdGVyKG4uZ2V0Tm9kZUludGVybmFsKCksIHByZWRpY2F0ZSkpO1xufVxuXG4vKipcbiAqIFJldHVybnMgYSBuZXcgd3JhcHBlciBpbnN0YW5jZSB3aXRoIG9ubHkgdGhlIG5vZGVzIG9mIHRoZSBjdXJyZW50IHdyYXBwZXIgaW5zdGFuY2UgdGhhdCBtYXRjaFxuICogdGhlIHByb3ZpZGVkIHByZWRpY2F0ZSBmdW5jdGlvbi5cbiAqXG4gKiBAcGFyYW0ge1NoYWxsb3dXcmFwcGVyfSB3cmFwcGVyXG4gKiBAcGFyYW0ge0Z1bmN0aW9ufSBwcmVkaWNhdGVcbiAqIEByZXR1cm5zIHtTaGFsbG93V3JhcHBlcn1cbiAqL1xuZnVuY3Rpb24gZmlsdGVyV2hlcmVVbndyYXBwZWQod3JhcHBlciwgcHJlZGljYXRlKSB7XG4gIHJldHVybiB3cmFwcGVyLndyYXAod3JhcHBlci5nZXROb2Rlc0ludGVybmFsKCkuZmlsdGVyKHByZWRpY2F0ZSkuZmlsdGVyKEJvb2xlYW4pKTtcbn1cblxuLyoqXG4gKiBFbnN1cmUgb3B0aW9ucyBwYXNzZWQgdG8gU2hhbGxvd1dyYXBwZXIgYXJlIHZhbGlkLiBUaHJvd3Mgb3RoZXJ3aXNlLlxuICogQHBhcmFtIHtPYmplY3R9IG9wdGlvbnNcbiAqL1xuZnVuY3Rpb24gdmFsaWRhdGVPcHRpb25zKG9wdGlvbnMpIHtcbiAgY29uc3Qge1xuICAgIGxpZmVjeWNsZUV4cGVyaW1lbnRhbCxcbiAgICBkaXNhYmxlTGlmZWN5Y2xlTWV0aG9kcyxcbiAgICBlbmFibGVDb21wb25lbnREaWRVcGRhdGVPblNldFN0YXRlLFxuICAgIHN1cHBvcnRQcmV2Q29udGV4dEFyZ3VtZW50T2ZDb21wb25lbnREaWRVcGRhdGUsXG4gICAgbGlmZWN5Y2xlcyxcbiAgfSA9IG9wdGlvbnM7XG4gIGlmICh0eXBlb2YgbGlmZWN5Y2xlRXhwZXJpbWVudGFsICE9PSAndW5kZWZpbmVkJyAmJiB0eXBlb2YgbGlmZWN5Y2xlRXhwZXJpbWVudGFsICE9PSAnYm9vbGVhbicpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ2xpZmVjeWNsZUV4cGVyaW1lbnRhbCBtdXN0IGJlIGVpdGhlciB0cnVlIG9yIGZhbHNlIGlmIHByb3ZpZGVkJyk7XG4gIH1cblxuICBpZiAodHlwZW9mIGRpc2FibGVMaWZlY3ljbGVNZXRob2RzICE9PSAndW5kZWZpbmVkJyAmJiB0eXBlb2YgZGlzYWJsZUxpZmVjeWNsZU1ldGhvZHMgIT09ICdib29sZWFuJykge1xuICAgIHRocm93IG5ldyBFcnJvcignZGlzYWJsZUxpZmVjeWNsZU1ldGhvZHMgbXVzdCBiZSBlaXRoZXIgdHJ1ZSBvciBmYWxzZSBpZiBwcm92aWRlZCcpO1xuICB9XG5cbiAgaWYgKFxuICAgIGxpZmVjeWNsZUV4cGVyaW1lbnRhbCAhPSBudWxsXG4gICAgJiYgZGlzYWJsZUxpZmVjeWNsZU1ldGhvZHMgIT0gbnVsbFxuICAgICYmIGxpZmVjeWNsZUV4cGVyaW1lbnRhbCA9PT0gZGlzYWJsZUxpZmVjeWNsZU1ldGhvZHNcbiAgKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdsaWZlY3ljbGVFeHBlcmltZW50YWwgYW5kIGRpc2FibGVMaWZlY3ljbGVNZXRob2RzIGNhbm5vdCBiZSBzZXQgdG8gdGhlIHNhbWUgdmFsdWUnKTtcbiAgfVxuXG4gIGlmIChcbiAgICB0eXBlb2YgZW5hYmxlQ29tcG9uZW50RGlkVXBkYXRlT25TZXRTdGF0ZSAhPT0gJ3VuZGVmaW5lZCdcbiAgICAmJiBsaWZlY3ljbGVzLmNvbXBvbmVudERpZFVwZGF0ZVxuICAgICYmIGxpZmVjeWNsZXMuY29tcG9uZW50RGlkVXBkYXRlLm9uU2V0U3RhdGUgIT09IGVuYWJsZUNvbXBvbmVudERpZFVwZGF0ZU9uU2V0U3RhdGVcbiAgKSB7XG4gICAgdGhyb3cgbmV3IFR5cGVFcnJvcigndGhlIGxlZ2FjeSBlbmFibGVDb21wb25lbnREaWRVcGRhdGVPblNldFN0YXRlIG9wdGlvbiBzaG91bGQgYmUgbWF0Y2hlZCBieSBgbGlmZWN5Y2xlczogeyBjb21wb25lbnREaWRVcGRhdGU6IHsgb25TZXRTdGF0ZTogdHJ1ZSB9IH1gLCBmb3IgY29tcGF0aWJpbGl0eScpO1xuICB9XG5cbiAgaWYgKFxuICAgIHR5cGVvZiBzdXBwb3J0UHJldkNvbnRleHRBcmd1bWVudE9mQ29tcG9uZW50RGlkVXBkYXRlICE9PSAndW5kZWZpbmVkJ1xuICAgICYmIGxpZmVjeWNsZXMuY29tcG9uZW50RGlkVXBkYXRlXG4gICAgJiYgbGlmZWN5Y2xlcy5jb21wb25lbnREaWRVcGRhdGUucHJldkNvbnRleHQgIT09IHN1cHBvcnRQcmV2Q29udGV4dEFyZ3VtZW50T2ZDb21wb25lbnREaWRVcGRhdGVcbiAgKSB7XG4gICAgdGhyb3cgbmV3IFR5cGVFcnJvcigndGhlIGxlZ2FjeSBzdXBwb3J0UHJldkNvbnRleHRBcmd1bWVudE9mQ29tcG9uZW50RGlkVXBkYXRlIG9wdGlvbiBzaG91bGQgYmUgbWF0Y2hlZCBieSBgbGlmZWN5Y2xlczogeyBjb21wb25lbnREaWRVcGRhdGU6IHsgcHJldkNvbnRleHQ6IHRydWUgfSB9YCwgZm9yIGNvbXBhdGliaWxpdHknKTtcbiAgfVxufVxuXG5mdW5jdGlvbiBnZXRBZGFwdGVyTGlmZWN5Y2xlcyh7IG9wdGlvbnMgfSkge1xuICBjb25zdCB7XG4gICAgbGlmZWN5Y2xlcyA9IHt9LFxuICAgIGVuYWJsZUNvbXBvbmVudERpZFVwZGF0ZU9uU2V0U3RhdGUsXG4gICAgc3VwcG9ydFByZXZDb250ZXh0QXJndW1lbnRPZkNvbXBvbmVudERpZFVwZGF0ZSxcbiAgfSA9IG9wdGlvbnM7XG5cbiAgY29uc3QgaGFzTGVnYWN5U2V0U3RhdGVBcmcgPSB0eXBlb2YgZW5hYmxlQ29tcG9uZW50RGlkVXBkYXRlT25TZXRTdGF0ZSAhPT0gJ3VuZGVmaW5lZCc7XG4gIGNvbnN0IGhhc0xlZ2FjeVByZXZDb250ZXh0QXJnID0gdHlwZW9mIHN1cHBvcnRQcmV2Q29udGV4dEFyZ3VtZW50T2ZDb21wb25lbnREaWRVcGRhdGUgIT09ICd1bmRlZmluZWQnO1xuICBjb25zdCBjb21wb25lbnREaWRVcGRhdGUgPSBoYXNMZWdhY3lTZXRTdGF0ZUFyZyB8fCBoYXNMZWdhY3lQcmV2Q29udGV4dEFyZ1xuICAgID8ge1xuICAgICAgLi4uKGhhc0xlZ2FjeVNldFN0YXRlQXJnICYmIHtcbiAgICAgICAgb25TZXRTdGF0ZTogISFlbmFibGVDb21wb25lbnREaWRVcGRhdGVPblNldFN0YXRlLFxuICAgICAgfSksXG4gICAgICAuLi4oaGFzTGVnYWN5UHJldkNvbnRleHRBcmcgJiYge1xuICAgICAgICBwcmV2Q29udGV4dDogISFzdXBwb3J0UHJldkNvbnRleHRBcmd1bWVudE9mQ29tcG9uZW50RGlkVXBkYXRlLFxuICAgICAgfSksXG4gICAgfVxuICAgIDogbnVsbDtcbiAgY29uc3QgeyBnZXREZXJpdmVkU3RhdGVGcm9tUHJvcHM6IG9yaWdpbmFsR0RTRlAgfSA9IGxpZmVjeWNsZXM7XG4gIGNvbnN0IGdldERlcml2ZWRTdGF0ZUZyb21Qcm9wcyA9IG9yaWdpbmFsR0RTRlAgPyB7XG4gICAgaGFzU2hvdWxkQ29tcG9uZW50VXBkYXRlQnVnOiAhIW9yaWdpbmFsR0RTRlAuaGFzU2hvdWxkQ29tcG9uZW50VXBkYXRlQnVnLFxuICB9IDogZmFsc2U7XG5cbiAgcmV0dXJuIHtcbiAgICAuLi5saWZlY3ljbGVzLFxuICAgIHNldFN0YXRlOiB7XG4gICAgICAuLi5saWZlY3ljbGVzLnNldFN0YXRlLFxuICAgIH0sXG4gICAgZ2V0Q2hpbGRDb250ZXh0OiB7XG4gICAgICBjYWxsZWRCeVJlbmRlcmVyOiB0cnVlLFxuICAgICAgLi4ubGlmZWN5Y2xlcy5nZXRDaGlsZENvbnRleHQsXG4gICAgfSxcbiAgICAuLi4oY29tcG9uZW50RGlkVXBkYXRlICYmIHsgY29tcG9uZW50RGlkVXBkYXRlIH0pLFxuICAgIGdldERlcml2ZWRTdGF0ZUZyb21Qcm9wcyxcbiAgfTtcbn1cblxuZnVuY3Rpb24gZ2V0Um9vdE5vZGUobm9kZSkge1xuICBpZiAobm9kZS5ub2RlVHlwZSA9PT0gJ2hvc3QnKSB7XG4gICAgcmV0dXJuIG5vZGU7XG4gIH1cbiAgcmV0dXJuIG5vZGUucmVuZGVyZWQ7XG59XG5cbmZ1bmN0aW9uIGdldFJvb3ROb2RlSW50ZXJuYWwod3JhcHBlcikge1xuICBpZiAod3JhcHBlcltST09UXS5sZW5ndGggIT09IDEpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ2dldFJvb3ROb2RlSW50ZXJuYWwod3JhcHBlcikgY2FuIG9ubHkgYmUgY2FsbGVkIHdoZW4gd3JhcHBlciB3cmFwcyBvbmUgbm9kZScpO1xuICB9XG4gIGlmICh3cmFwcGVyW1JPT1RdICE9PSB3cmFwcGVyKSB7XG4gICAgcmV0dXJuIHdyYXBwZXJbUk9PVF9OT0RFU11bMF07XG4gIH1cbiAgcmV0dXJuIHdyYXBwZXJbUk9PVF1bTk9ERV07XG59XG5cbmZ1bmN0aW9uIG5vZGVQYXJlbnRzKHdyYXBwZXIsIG5vZGUpIHtcbiAgcmV0dXJuIHBhcmVudHNPZk5vZGUobm9kZSwgZ2V0Um9vdE5vZGVJbnRlcm5hbCh3cmFwcGVyKSk7XG59XG5cbmZ1bmN0aW9uIHByaXZhdGVTZXROb2Rlcyh3cmFwcGVyLCBub2Rlcykge1xuICBpZiAoIUFycmF5LmlzQXJyYXkobm9kZXMpKSB7XG4gICAgcHJpdmF0ZVNldCh3cmFwcGVyLCBOT0RFLCBub2Rlcyk7XG4gICAgcHJpdmF0ZVNldCh3cmFwcGVyLCBOT0RFUywgW25vZGVzXSk7XG4gIH0gZWxzZSB7XG4gICAgcHJpdmF0ZVNldCh3cmFwcGVyLCBOT0RFLCBub2Rlc1swXSk7XG4gICAgcHJpdmF0ZVNldCh3cmFwcGVyLCBOT0RFUywgbm9kZXMpO1xuICB9XG4gIHByaXZhdGVTZXQod3JhcHBlciwgJ2xlbmd0aCcsIHdyYXBwZXJbTk9ERVNdLmxlbmd0aCk7XG59XG5cbmZ1bmN0aW9uIHB1cmVDb21wb25lbnRTaG91bGRDb21wb25lbnRVcGRhdGUocHJldlByb3BzLCBwcm9wcywgcHJldlN0YXRlLCBzdGF0ZSkge1xuICByZXR1cm4gIXNoYWxsb3dFcXVhbChwcmV2UHJvcHMsIHByb3BzKSB8fCAhc2hhbGxvd0VxdWFsKHByZXZTdGF0ZSwgc3RhdGUpO1xufVxuXG5mdW5jdGlvbiBpc1B1cmVDb21wb25lbnQoaW5zdGFuY2UpIHtcbiAgcmV0dXJuIGluc3RhbmNlICYmIGluc3RhbmNlLmlzUHVyZVJlYWN0Q29tcG9uZW50O1xufVxuXG5mdW5jdGlvbiBnZXRDaGlsZENvbnRleHQobm9kZSwgaGllcmFyY2h5LCByZW5kZXJlcikge1xuICBjb25zdCB7IGluc3RhbmNlLCB0eXBlOiBDb21wb25lbnQgfSA9IG5vZGU7XG4gIGNvbnN0IGNvbXBvbmVudE5hbWUgPSBkaXNwbGF5TmFtZU9mTm9kZShub2RlKTtcbiAgLy8gV2FybiBsaWtlIHJlYWN0IGlmIGNoaWxkQ29udGV4dFR5cGVzIGlzIG5vdCBkZWZpbmVkOlxuICAvLyBodHRwczovL2dpdGh1Yi5jb20vZmFjZWJvb2svcmVhY3QvYmxvYi8xNDU0YThiZTAzNzk0ZjVlMGIyM2E3ZTc2OTZjYmJiZGNmOGIwZjVkL3BhY2thZ2VzL3JlYWN0LWRvbS9zcmMvc2VydmVyL1JlYWN0UGFydGlhbFJlbmRlcmVyLmpzI0w2MzktTDY0NlxuICBpZiAodHlwZW9mIENvbXBvbmVudC5jaGlsZENvbnRleHRUeXBlcyAhPT0gJ29iamVjdCcpIHtcbiAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tY29uc29sZVxuICAgIGNvbnNvbGUud2FybihcbiAgICAgIGAke2NvbXBvbmVudE5hbWV9LmdldENoaWxkQ29udGV4dCgpOiBjaGlsZENvbnRleHRUeXBlcyBtdXN0IGJlIGRlZmluZWQgaW4gb3JkZXIgdG8gdXNlIGdldENoaWxkQ29udGV4dCgpLmAsXG4gICAgKTtcbiAgICByZXR1cm4ge307XG4gIH1cbiAgLy8gQ2hlY2sgY2hpbGRDb250ZXh0VHlwZXMgbGlrZSByZWFjdDpcbiAgLy8gaHR0cHM6Ly9naXRodWIuY29tL2ZhY2Vib29rL3JlYWN0L2Jsb2IvMTQ1NGE4YmUwMzc5NGY1ZTBiMjNhN2U3Njk2Y2JiYmRjZjhiMGY1ZC9wYWNrYWdlcy9yZWFjdC1kb20vc3JjL3NlcnZlci9SZWFjdFBhcnRpYWxSZW5kZXJlci5qcyNMNjMwLUw2MzdcbiAgY29uc3QgY2hpbGRDb250ZXh0ID0gaW5zdGFuY2UuZ2V0Q2hpbGRDb250ZXh0KCk7XG4gIE9iamVjdC5rZXlzKGNoaWxkQ29udGV4dCkuZm9yRWFjaCgoa2V5KSA9PiB7XG4gICAgaWYgKCEoa2V5IGluIENvbXBvbmVudC5jaGlsZENvbnRleHRUeXBlcykpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgICAgYCR7Y29tcG9uZW50TmFtZX0uZ2V0Q2hpbGRDb250ZXh0KCk6IGtleSBcIiR7a2V5fVwiIGlzIG5vdCBkZWZpbmVkIGluIGNoaWxkQ29udGV4dFR5cGVzLmAsXG4gICAgICApO1xuICAgIH1cbiAgfSk7XG4gIGlmICh0eXBlb2YgcmVuZGVyZXIuY2hlY2tQcm9wVHlwZXMgPT09ICdmdW5jdGlvbicpIHtcbiAgICByZW5kZXJlci5jaGVja1Byb3BUeXBlcyhDb21wb25lbnQuY2hpbGRDb250ZXh0VHlwZXMsIGNoaWxkQ29udGV4dCwgJ2NoaWxkIGNvbnRleHQnLCBoaWVyYXJjaHkpO1xuICB9XG4gIHJldHVybiBjaGlsZENvbnRleHQ7XG59XG5cbmZ1bmN0aW9uIHNweU9uR2V0Q2hpbGRDb250ZXh0SW5pdGlhbFJlbmRlcihub2RlcywgYWRhcHRlcikge1xuICBpZiAoXG4gICAgIWlzQ3VzdG9tQ29tcG9uZW50RWxlbWVudChub2RlcywgYWRhcHRlcilcbiAgICB8fCAhbm9kZXMudHlwZS5wcm90b3R5cGVcbiAgICB8fCB0eXBlb2Ygbm9kZXMudHlwZS5wcm90b3R5cGUuZ2V0Q2hpbGRDb250ZXh0ICE9PSAnZnVuY3Rpb24nXG4gICkge1xuICAgIHJldHVybiBudWxsO1xuICB9XG5cbiAgcmV0dXJuIHNweU1ldGhvZChub2Rlcy50eXBlLnByb3RvdHlwZSwgJ2dldENoaWxkQ29udGV4dCcpO1xufVxuXG5mdW5jdGlvbiBwcml2YXRlU2V0Q2hpbGRDb250ZXh0KGFkYXB0ZXIsIHdyYXBwZXIsIGluc3RhbmNlLCByZW5kZXJlZE5vZGUsIGdldENoaWxkQ29udGV4dFNweSkge1xuICBjb25zdCByZW5kZXJlciA9IHdyYXBwZXJbUkVOREVSRVJdO1xuICAvLyBXZSBvbmx5IHN1cHBvcnQgcGFyZW50LWJhc2VkIGNvbnRleHQuXG4gIGlmIChhZGFwdGVyLm9wdGlvbnMubGVnYWN5Q29udGV4dE1vZGUgIT09ICdwYXJlbnQnKSB7IHJldHVybjsgfVxuICBpZiAoZ2V0Q2hpbGRDb250ZXh0U3B5KSB7XG4gICAgcHJpdmF0ZVNldCh3cmFwcGVyLCBDSElMRF9DT05URVhULCBnZXRDaGlsZENvbnRleHRTcHkuZ2V0TGFzdFJldHVyblZhbHVlKCkpO1xuICAgIGdldENoaWxkQ29udGV4dFNweS5yZXN0b3JlKCk7XG4gIH0gZWxzZSBpZiAodHlwZW9mIGluc3RhbmNlLmdldENoaWxkQ29udGV4dCA9PT0gJ2Z1bmN0aW9uJykge1xuICAgIC8vIElmIHRoZXJlJ3Mgbm8gc3B5IGJ1dCBnZXRDaGlsZENvbnRleHQgaXMgYSBmdW5jdGlvbiwgdGhhdCBtZWFucyBvdXIgcmVuZGVyZXJcbiAgICAvLyBpcyBub3QgZ29pbmcgdG8gY2FsbCBpdCBmb3IgdXMsIHNvIHdlIG5lZWQgdG8gY2FsbCBpdCBvdXJzZWx2ZXMuXG4gICAgY29uc3Qgbm9kZUhpZXJhcmNoeSA9IFt3cmFwcGVyW05PREVdXS5jb25jYXQobm9kZVBhcmVudHMod3JhcHBlciwgd3JhcHBlcltOT0RFXSkpO1xuICAgIGNvbnN0IGNoaWxkQ29udGV4dCA9IGdldENoaWxkQ29udGV4dChyZW5kZXJlZE5vZGUsIG5vZGVIaWVyYXJjaHksIHJlbmRlcmVyKTtcbiAgICBwcml2YXRlU2V0KHdyYXBwZXIsIENISUxEX0NPTlRFWFQsIGNoaWxkQ29udGV4dCk7XG4gIH0gZWxzZSB7XG4gICAgcHJpdmF0ZVNldCh3cmFwcGVyLCBDSElMRF9DT05URVhULCBudWxsKTtcbiAgfVxufVxuXG5mdW5jdGlvbiBtb2NrU0NVSWZnRFNGUFJldHVybk5vbk51bGwobm9kZSwgc3RhdGUpIHtcbiAgY29uc3QgeyBnZXREZXJpdmVkU3RhdGVGcm9tUHJvcHMgfSA9IG5vZGUudHlwZTtcblxuICBpZiAodHlwZW9mIGdldERlcml2ZWRTdGF0ZUZyb21Qcm9wcyA9PT0gJ2Z1bmN0aW9uJykge1xuICAgIC8vIHdlIHRyeSB0byBmaXggYSBSZWFjdCBzaGFsbG93IHJlbmRlcmVyIGJ1ZyBoZXJlLlxuICAgIC8vIChmYWNlYm9vay9yZWFjdCMxNDYwNywgd2hpY2ggaGFzIGJlZW4gZml4ZWQgaW4gcmVhY3QgMTYuOCk6XG4gICAgLy8gd2hlbiBnRFNGUCByZXR1cm4gZGVyaXZlZCBzdGF0ZSwgaXQgd2lsbCBzZXQgaW5zdGFuY2Ugc3RhdGUgaW4gc2hhbGxvdyByZW5kZXJlciBiZWZvcmUgU0NVLFxuICAgIC8vIHRoaXMgd2lsbCBjYXVzZSBgdGhpcy5zdGF0ZWAgaW4gc0NVIGJlIHRoZSB1cGRhdGVkIHN0YXRlLCB3aGljaCBpcyB3cm9uZyBiZWhhdmlvci5cbiAgICAvLyBzbyB3ZSBoYXZlIHRvIHdyYXAgc0NVIHRvIHBhc3MgdGhlIG9sZCBzdGF0ZSB0byBvcmlnaW5hbCBzQ1UuXG4gICAgY29uc3QgeyBpbnN0YW5jZSB9ID0gbm9kZTtcbiAgICBjb25zdCB7IHJlc3RvcmUgfSA9IHNweU1ldGhvZChcbiAgICAgIGluc3RhbmNlLFxuICAgICAgJ3Nob3VsZENvbXBvbmVudFVwZGF0ZScsXG4gICAgICBvcmlnaW5hbFNDVSA9PiBmdW5jdGlvbiBzaG91bGRDb21wb25lbnRVcGRhdGUoLi4uYXJncykge1xuICAgICAgICBpbnN0YW5jZS5zdGF0ZSA9IHN0YXRlO1xuICAgICAgICBjb25zdCBzQ1VSZXN1bHQgPSBvcmlnaW5hbFNDVS5hcHBseShpbnN0YW5jZSwgYXJncyk7XG4gICAgICAgIGNvbnN0IFssIG5leHRTdGF0ZV0gPSBhcmdzO1xuICAgICAgICBpbnN0YW5jZS5zdGF0ZSA9IG5leHRTdGF0ZTtcbiAgICAgICAgcmVzdG9yZSgpO1xuICAgICAgICByZXR1cm4gc0NVUmVzdWx0O1xuICAgICAgfSxcbiAgICApO1xuICB9XG59XG5cbi8qKlxuICogUmVjdXJzaXZlbHkgZGl2ZSgpcyBldmVyeSBjdXN0b20gY29tcG9uZW50IGluIGEgd3JhcHBlciB1bnRpbFxuICogdGhlIHRhcmdldCBjb21wb25lbnQgaXMgZm91bmQuXG4gKlxuICogQHBhcmFtIHtTaGFsbG93V3JhcHBlcn0gd3JhcHBlciBBIFNoYWxsb3dXcmFwcGVyIHRvIHNlYXJjaFxuICogQHBhcmFtIHtDb21wb25lbnRUeXBlfSB0YXJnZXQgQSByZWFjdCBjdXN0b20gY29tcG9uZW50IHRoYXQsIHdoZW4gZm91bmQsIHdpbGwgZW5kIHJlY3Vyc2lvblxuICogQHBhcmFtIHtBZGFwdGVyfSBhZGFwdGVyIEFuIEVuenltZSBhZGFwdGVyXG4gKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ8dW5kZWZpbmVkfSBBIFNoYWxsb3dXcmFwcGVyIGZvciB0aGUgdGFyZ2V0LCBvclxuICogIHVuZGVmaW5lZCBpZiBpdCBjYW4ndCBiZSBmb3VuZFxuICovXG5mdW5jdGlvbiBkZWVwUmVuZGVyKHdyYXBwZXIsIHRhcmdldCwgYWRhcHRlcikge1xuICBjb25zdCBub2RlID0gd3JhcHBlcltOT0RFXTtcbiAgY29uc3QgZWxlbWVudCA9IG5vZGUgJiYgYWRhcHRlci5ub2RlVG9FbGVtZW50KG5vZGUpO1xuICBpZiAod3JhcHBlci50eXBlKCkgPT09IHRhcmdldCkge1xuICAgIHJldHVybiB3cmFwcGVyLmRpdmUoKTtcbiAgfVxuICBpZiAoZWxlbWVudCAmJiBpc0N1c3RvbUNvbXBvbmVudEVsZW1lbnQoZWxlbWVudCwgYWRhcHRlcikpIHtcbiAgICByZXR1cm4gZGVlcFJlbmRlcih3cmFwcGVyLmRpdmUoKSwgdGFyZ2V0LCBhZGFwdGVyKTtcbiAgfVxuICBjb25zdCBjaGlsZHJlbiA9IHdyYXBwZXIuY2hpbGRyZW4oKTtcbiAgZm9yIChsZXQgaSA9IDA7IGkgPCBjaGlsZHJlbi5sZW5ndGg7IGkgKz0gMSkge1xuICAgIGNvbnN0IGZvdW5kID0gZGVlcFJlbmRlcihjaGlsZHJlbi5hdChpKSwgdGFyZ2V0LCBhZGFwdGVyKTtcbiAgICBpZiAodHlwZW9mIGZvdW5kICE9PSAndW5kZWZpbmVkJykge1xuICAgICAgcmV0dXJuIGZvdW5kO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdW5kZWZpbmVkO1xufVxuXG4vKipcbiAqIERlZXAtcmVuZGVycyB0aGUgYHdyYXBwaW5nQ29tcG9uZW50YCBhbmQgcmV0dXJucyB0aGUgY29udGV4dCB0aGF0IHNob3VsZFxuICogYmUgYWNjZXNzaWJsZSB0byB0aGUgcHJpbWFyeSB3cmFwcGVyLlxuICpcbiAqIEBwYXJhbSB7V3JhcHBpbmdDb21wb25lbnRXcmFwcGVyfSB3cmFwcGVyIFRoZSBgV3JhcHBpbmdDb21wb25lbnRXcmFwcGVyYCBmb3IgYVxuICogIGB3cmFwcGluZ0NvbXBvbmVudGBcbiAqIEBwYXJhbSB7QWRhcHRlcn0gYWRhcHRlciBBbiBFbnp5bWUgYWRhcHRlclxuICogQHJldHVybnMge29iamVjdH0gQW4gb2JqZWN0IGNvbnRhaW5pbmcgYW4gb2JqZWN0IG9mIGxlZ2FjeSBjb250ZXh0IHZhbHVlcyBhbmQgYSBNYXAgb2ZcbiAqICBgY3JlYXRlQ29udGV4dCgpYCBQcm92aWRlciB2YWx1ZXMuXG4gKi9cbmZ1bmN0aW9uIGdldENvbnRleHRGcm9tV3JhcHBpbmdDb21wb25lbnQod3JhcHBlciwgYWRhcHRlcikge1xuICBjb25zdCByb290RmluZGVyID0gZGVlcFJlbmRlcih3cmFwcGVyLCB3cmFwcGVyW1JPT1RfRklOREVSXSwgYWRhcHRlcik7XG4gIGlmICghcm9vdEZpbmRlcikge1xuICAgIHRocm93IG5ldyBFcnJvcignYHdyYXBwaW5nQ29tcG9uZW50YCBtdXN0IHJlbmRlciBpdHMgY2hpbGRyZW4hJyk7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBsZWdhY3lDb250ZXh0OiByb290RmluZGVyW09QVElPTlNdLmNvbnRleHQsXG4gICAgcHJvdmlkZXJWYWx1ZXM6IHJvb3RGaW5kZXJbUFJPVklERVJfVkFMVUVTXSxcbiAgfTtcbn1cblxuLyoqXG4gKiBNYWtlcyBvcHRpb25zIHNwZWNpZmljYWxseSBmb3IgYFNoYWxsb3dXcmFwcGVyYC4gTW9zdCBvZiB0aGUgbG9naWMgaGVyZSBpcyBhcm91bmQgcmVuZGVyaW5nXG4gKiBhIGB3cmFwcGluZ0NvbXBvbmVudGAgKGlmIG9uZSB3YXMgcHJvdmlkZWQpIGFuZCBhZGRpbmcgdGhlIGNoaWxkIGNvbnRleHQgb2YgdGhhdCBjb21wb25lbnRcbiAqIHRvIGBvcHRpb25zLmNvbnRleHRgLlxuICpcbiAqIEBwYXJhbSB7UmVhY3RFbGVtZW50fSBub2RlcyB0aGUgbm9kZXMgcGFzc2VkIHRvIGBTaGFsbG93V3JhcHBlcmBcbiAqIEBwYXJhbSB7U2hhbGxvd1dyYXBwZXJ9IHJvb3QgdGhpcyBgU2hhbGxvd1dyYXBwZXJgJ3MgcGFyZW50LiBJZiB0aGlzIGlzIHBhc3NlZCwgb3B0aW9ucyBhcmVcbiAqICBub3QgdHJhbnNmb3JtZWQuXG4gKiBAcGFyYW0geyp9IHBhc3NlZE9wdGlvbnMgdGhlIG9wdGlvbnMgcGFzc2VkIHRvIGBTaGFsbG93V3JhcHBlcmAuXG4gKiBAcGFyYW0geyp9IHdyYXBwZXIgdGhlIGBTaGFsbG93V3JhcHBlcmAgaXRzZWxmXG4gKiBAcmV0dXJucyB7T2JqZWN0fSB0aGUgZGVjb3JhdGVkIGFuZCB0cmFuc2Zvcm1lZCBvcHRpb25zXG4gKi9cbmZ1bmN0aW9uIG1ha2VTaGFsbG93T3B0aW9ucyhub2Rlcywgcm9vdCwgcGFzc2VkT3B0aW9ucywgd3JhcHBlcikge1xuICBjb25zdCBvcHRpb25zID0gbWFrZU9wdGlvbnMocGFzc2VkT3B0aW9ucyk7XG4gIGNvbnN0IGFkYXB0ZXIgPSBnZXRBZGFwdGVyKHBhc3NlZE9wdGlvbnMpO1xuICBwcml2YXRlU2V0KG9wdGlvbnMsIFBST1ZJREVSX1ZBTFVFUywgcGFzc2VkT3B0aW9uc1tQUk9WSURFUl9WQUxVRVNdKTtcbiAgaWYgKHJvb3QgfHwgIWlzQ3VzdG9tQ29tcG9uZW50KG9wdGlvbnMud3JhcHBpbmdDb21wb25lbnQsIGFkYXB0ZXIpKSB7XG4gICAgcmV0dXJuIG9wdGlvbnM7XG4gIH1cbiAgaWYgKHR5cGVvZiBhZGFwdGVyLndyYXBXaXRoV3JhcHBpbmdDb21wb25lbnQgIT09ICdmdW5jdGlvbicpIHtcbiAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCd5b3VyIGFkYXB0ZXIgZG9lcyBub3Qgc3VwcG9ydCBgd3JhcHBpbmdDb21wb25lbnRgLiBUcnkgdXBncmFkaW5nIGl0IScpO1xuICB9XG4gIGNvbnN0IHsgbm9kZTogd3JhcHBlZE5vZGUsIFJvb3RGaW5kZXIgfSA9IGFkYXB0ZXIud3JhcFdpdGhXcmFwcGluZ0NvbXBvbmVudChub2Rlcywgb3B0aW9ucyk7XG4gIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby11c2UtYmVmb3JlLWRlZmluZVxuICBjb25zdCB3cmFwcGluZ0NvbXBvbmVudCA9IG5ldyBXcmFwcGluZ0NvbXBvbmVudFdyYXBwZXIod3JhcHBlZE5vZGUsIHdyYXBwZXIsIFJvb3RGaW5kZXIpO1xuICBjb25zdCB7XG4gICAgbGVnYWN5Q29udGV4dDogd3JhcHBpbmdDb21wb25lbnRMZWdhY3lDb250ZXh0LFxuICAgIHByb3ZpZGVyVmFsdWVzOiB3cmFwcGluZ0NvbXBvbmVudFByb3ZpZGVyVmFsdWVzLFxuICB9ID0gZ2V0Q29udGV4dEZyb21XcmFwcGluZ0NvbXBvbmVudCh3cmFwcGluZ0NvbXBvbmVudCwgYWRhcHRlcik7XG4gIHByaXZhdGVTZXQod3JhcHBlciwgV1JBUFBJTkdfQ09NUE9ORU5ULCB3cmFwcGluZ0NvbXBvbmVudCk7XG4gIHJldHVybiB7XG4gICAgLi4ub3B0aW9ucyxcbiAgICBjb250ZXh0OiB7XG4gICAgICAuLi5vcHRpb25zLmNvbnRleHQsXG4gICAgICAuLi53cmFwcGluZ0NvbXBvbmVudExlZ2FjeUNvbnRleHQsXG4gICAgfSxcbiAgICBbUFJPVklERVJfVkFMVUVTXTogd3JhcHBpbmdDb21wb25lbnRQcm92aWRlclZhbHVlcyxcbiAgfTtcbn1cblxuXG4vKipcbiAqIEBjbGFzcyBTaGFsbG93V3JhcHBlclxuICovXG5jbGFzcyBTaGFsbG93V3JhcHBlciB7XG4gIGNvbnN0cnVjdG9yKG5vZGVzLCByb290LCBwYXNzZWRPcHRpb25zID0ge30pIHtcbiAgICB2YWxpZGF0ZU9wdGlvbnMocGFzc2VkT3B0aW9ucyk7XG5cbiAgICBjb25zdCBvcHRpb25zID0gbWFrZVNoYWxsb3dPcHRpb25zKG5vZGVzLCByb290LCBwYXNzZWRPcHRpb25zLCB0aGlzKTtcbiAgICBjb25zdCBhZGFwdGVyID0gZ2V0QWRhcHRlcihvcHRpb25zKTtcbiAgICBjb25zdCBsaWZlY3ljbGVzID0gZ2V0QWRhcHRlckxpZmVjeWNsZXMoYWRhcHRlcik7XG5cbiAgICAvLyBtb3VudGluZyBhIFNoYWxsb3dSZW5kZXIgY29tcG9uZW50XG4gICAgaWYgKCFyb290KSB7XG4gICAgICBpZiAoIWFkYXB0ZXIuaXNWYWxpZEVsZW1lbnQobm9kZXMpKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ1NoYWxsb3dXcmFwcGVyIGNhbiBvbmx5IHdyYXAgdmFsaWQgZWxlbWVudHMnKTtcbiAgICAgIH1cblxuICAgICAgY29uc3QgZ2V0Q2hpbGRDb250ZXh0U3B5ID0gbGlmZWN5Y2xlcy5nZXRDaGlsZENvbnRleHQuY2FsbGVkQnlSZW5kZXJlclxuICAgICAgICA/IHNweU9uR2V0Q2hpbGRDb250ZXh0SW5pdGlhbFJlbmRlcihub2RlcywgYWRhcHRlcilcbiAgICAgICAgOiBudWxsO1xuICAgICAgcHJpdmF0ZVNldCh0aGlzLCBST09ULCB0aGlzKTtcbiAgICAgIHByaXZhdGVTZXQodGhpcywgVU5SRU5ERVJFRCwgbm9kZXMpO1xuICAgICAgY29uc3QgcmVuZGVyZXIgPSBhZGFwdGVyLmNyZWF0ZVJlbmRlcmVyKHsgbW9kZTogJ3NoYWxsb3cnLCAuLi5vcHRpb25zIH0pO1xuICAgICAgcHJpdmF0ZVNldCh0aGlzLCBSRU5ERVJFUiwgcmVuZGVyZXIpO1xuICAgICAgY29uc3QgcHJvdmlkZXJWYWx1ZXMgPSBuZXcgTWFwKG9wdGlvbnNbUFJPVklERVJfVkFMVUVTXSB8fCBbXSk7XG4gICAgICB0aGlzW1JFTkRFUkVSXS5yZW5kZXIobm9kZXMsIG9wdGlvbnMuY29udGV4dCwgeyBwcm92aWRlclZhbHVlcyB9KTtcbiAgICAgIGNvbnN0IHJlbmRlcmVkTm9kZSA9IHRoaXNbUkVOREVSRVJdLmdldE5vZGUoKTtcbiAgICAgIHByaXZhdGVTZXROb2Rlcyh0aGlzLCBnZXRSb290Tm9kZShyZW5kZXJlZE5vZGUpKTtcbiAgICAgIHByaXZhdGVTZXQodGhpcywgT1BUSU9OUywgb3B0aW9ucyk7XG4gICAgICBwcml2YXRlU2V0KHRoaXMsIFBST1ZJREVSX1ZBTFVFUywgcHJvdmlkZXJWYWx1ZXMpO1xuXG4gICAgICBjb25zdCB7IGluc3RhbmNlIH0gPSByZW5kZXJlZE5vZGU7XG4gICAgICBpZiAoaW5zdGFuY2UgJiYgIW9wdGlvbnMuZGlzYWJsZUxpZmVjeWNsZU1ldGhvZHMpIHtcbiAgICAgICAgLy8gRW5zdXJlIHRvIGNhbGwgY29tcG9uZW50RGlkVXBkYXRlIHdoZW4gaW5zdGFuY2Uuc2V0U3RhdGUgaXMgY2FsbGVkXG4gICAgICAgIGlmIChsaWZlY3ljbGVzLmNvbXBvbmVudERpZFVwZGF0ZS5vblNldFN0YXRlICYmICFpbnN0YW5jZVtTRVRfU1RBVEVdKSB7XG4gICAgICAgICAgcHJpdmF0ZVNldChpbnN0YW5jZSwgU0VUX1NUQVRFLCBpbnN0YW5jZS5zZXRTdGF0ZSk7XG4gICAgICAgICAgaW5zdGFuY2Uuc2V0U3RhdGUgPSAodXBkYXRlciwgY2FsbGJhY2sgPSB1bmRlZmluZWQpID0+IHRoaXMuc2V0U3RhdGUoXG4gICAgICAgICAgICAuLi4oY2FsbGJhY2sgPT0gbnVsbCA/IFt1cGRhdGVyXSA6IFt1cGRhdGVyLCBjYWxsYmFja10pLFxuICAgICAgICAgICk7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAodHlwZW9mIGluc3RhbmNlLmNvbXBvbmVudERpZE1vdW50ID09PSAnZnVuY3Rpb24nKSB7XG4gICAgICAgICAgdGhpc1tSRU5ERVJFUl0uYmF0Y2hlZFVwZGF0ZXMoKCkgPT4ge1xuICAgICAgICAgICAgaW5zdGFuY2UuY29tcG9uZW50RGlkTW91bnQoKTtcbiAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgICAgICBwcml2YXRlU2V0Q2hpbGRDb250ZXh0KGFkYXB0ZXIsIHRoaXMsIGluc3RhbmNlLCByZW5kZXJlZE5vZGUsIGdldENoaWxkQ29udGV4dFNweSk7XG4gICAgICB9XG4gICAgLy8gY3JlYXRpbmcgYSBjaGlsZCBjb21wb25lbnQgdGhyb3VnaCBlbnp5bWUncyBTaGFsbG93V3JhcHBlciBBUElzLlxuICAgIH0gZWxzZSB7XG4gICAgICBwcml2YXRlU2V0KHRoaXMsIFJPT1QsIHJvb3QpO1xuICAgICAgcHJpdmF0ZVNldCh0aGlzLCBVTlJFTkRFUkVELCBudWxsKTtcbiAgICAgIHByaXZhdGVTZXQodGhpcywgUkVOREVSRVIsIHJvb3RbUkVOREVSRVJdKTtcbiAgICAgIHByaXZhdGVTZXROb2Rlcyh0aGlzLCBub2Rlcyk7XG4gICAgICBwcml2YXRlU2V0KHRoaXMsIE9QVElPTlMsIHJvb3RbT1BUSU9OU10pO1xuICAgICAgcHJpdmF0ZVNldCh0aGlzLCBST09UX05PREVTLCByb290W05PREVTXSk7XG4gICAgICBwcml2YXRlU2V0KHRoaXMsIFBST1ZJREVSX1ZBTFVFUywgbnVsbCk7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIHJvb3Qgd3JhcHBlclxuICAgKlxuICAgKiBAcmV0dXJuIHtTaGFsbG93V3JhcHBlcn1cbiAgICovXG4gIHJvb3QoKSB7XG4gICAgcmV0dXJuIHRoaXNbUk9PVF07XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgd3JhcHBlZCBjb21wb25lbnQuXG4gICAqXG4gICAqIEByZXR1cm4ge1JlYWN0Q29tcG9uZW50fVxuICAgKi9cbiAgZ2V0Tm9kZUludGVybmFsKCkge1xuICAgIGlmICh0aGlzLmxlbmd0aCAhPT0gMSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdTaGFsbG93V3JhcHBlcjo6Z2V0Tm9kZSgpIGNhbiBvbmx5IGJlIGNhbGxlZCB3aGVuIHdyYXBwaW5nIG9uZSBub2RlJyk7XG4gICAgfVxuICAgIGlmICh0aGlzW1JPT1RdID09PSB0aGlzKSB7XG4gICAgICB0aGlzLnVwZGF0ZSgpO1xuICAgIH1cbiAgICByZXR1cm4gdGhpc1tOT0RFXTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSB0aGUgd3JhcHBlZCBjb21wb25lbnRzLlxuICAgKlxuICAgKiBAcmV0dXJuIHtBcnJheTxSZWFjdENvbXBvbmVudD59XG4gICAqL1xuICBnZXROb2Rlc0ludGVybmFsKCkge1xuICAgIGlmICh0aGlzW1JPT1RdID09PSB0aGlzICYmIHRoaXMubGVuZ3RoID09PSAxKSB7XG4gICAgICB0aGlzLnVwZGF0ZSgpO1xuICAgIH1cbiAgICByZXR1cm4gdGhpc1tOT0RFU107XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgd3JhcHBlZCBSZWFjdEVsZW1lbnQuXG4gICAqXG4gICAqIEByZXR1cm4ge1JlYWN0RWxlbWVudH1cbiAgICovXG4gIGdldEVsZW1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2luZ2xlKCdnZXRFbGVtZW50JywgbiA9PiBnZXRBZGFwdGVyKHRoaXNbT1BUSU9OU10pLm5vZGVUb0VsZW1lbnQobikpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIHdyYXBwZWQgUmVhY3RFbGVtZW50cy5cbiAgICpcbiAgICogQHJldHVybiB7QXJyYXk8UmVhY3RFbGVtZW50Pn1cbiAgICovXG4gIGdldEVsZW1lbnRzKCkge1xuICAgIHJldHVybiB0aGlzLmdldE5vZGVzSW50ZXJuYWwoKS5tYXAobiA9PiBnZXRBZGFwdGVyKHRoaXNbT1BUSU9OU10pLm5vZGVUb0VsZW1lbnQobikpO1xuICB9XG5cbiAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGNsYXNzLW1ldGhvZHMtdXNlLXRoaXNcbiAgZ2V0Tm9kZSgpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpnZXROb2RlKCkgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZC4gVXNlIFNoYWxsb3dXcmFwcGVyOjpnZXRFbGVtZW50KCkgaW5zdGVhZCcpO1xuICB9XG5cbiAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGNsYXNzLW1ldGhvZHMtdXNlLXRoaXNcbiAgZ2V0Tm9kZXMoKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdTaGFsbG93V3JhcHBlcjo6Z2V0Tm9kZXMoKSBpcyBubyBsb25nZXIgc3VwcG9ydGVkLiBVc2UgU2hhbGxvd1dyYXBwZXI6OmdldEVsZW1lbnRzKCkgaW5zdGVhZCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgdGhlIGluc3RhbmNlIG9mIHRoZSBjb21wb25lbnQgYmVpbmcgcmVuZGVyZWQgYXMgdGhlIHJvb3Qgbm9kZSBwYXNzZWQgaW50byBgc2hhbGxvdygpYC5cbiAgICpcbiAgICogTk9URTogY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGEgd3JhcHBlciBpbnN0YW5jZSB0aGF0IGlzIGFsc28gdGhlIHJvb3QgaW5zdGFuY2UuXG4gICAqXG4gICAqIEV4YW1wbGU6XG4gICAqIGBgYFxuICAgKiBjb25zdCB3cmFwcGVyID0gc2hhbGxvdyg8TXlDb21wb25lbnQgLz4pO1xuICAgKiBjb25zdCBpbnN0ID0gd3JhcHBlci5pbnN0YW5jZSgpO1xuICAgKiBleHBlY3QoaW5zdCkudG8uYmUuaW5zdGFuY2VPZihNeUNvbXBvbmVudCk7XG4gICAqIGBgYFxuICAgKiBAcmV0dXJucyB7UmVhY3RDb21wb25lbnR9XG4gICAqL1xuICBpbnN0YW5jZSgpIHtcbiAgICBpZiAodGhpc1tST09UXSAhPT0gdGhpcykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdTaGFsbG93V3JhcHBlcjo6aW5zdGFuY2UoKSBjYW4gb25seSBiZSBjYWxsZWQgb24gdGhlIHJvb3QnKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXNbUkVOREVSRVJdLmdldE5vZGUoKS5pbnN0YW5jZTtcbiAgfVxuXG4gIC8qKlxuICAgKiBJZiBhIGB3cmFwcGluZ0NvbXBvbmVudGAgd2FzIHBhc3NlZCBpbiBgb3B0aW9uc2AsIHRoaXMgbWV0aG9kcyByZXR1cm5zIGEgYFNoYWxsb3dXcmFwcGVyYFxuICAgKiBhcm91bmQgdGhlIHJlbmRlcmVkIGB3cmFwcGluZ0NvbXBvbmVudGAuIFRoaXMgYFNoYWxsb3dXcmFwcGVyYCBjYW4gYmUgdXNlZCB0byB1cGRhdGUgdGhlXG4gICAqIGB3cmFwcGluZ0NvbXBvbmVudGAncyBwcm9wcywgc3RhdGUsIGV0Yy5cbiAgICpcbiAgICogQHJldHVybnMgU2hhbGxvd1dyYXBwZXJcbiAgICovXG4gIGdldFdyYXBwaW5nQ29tcG9uZW50KCkge1xuICAgIGlmICh0aGlzW1JPT1RdICE9PSB0aGlzKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpnZXRXcmFwcGluZ0NvbXBvbmVudCgpIGNhbiBvbmx5IGJlIGNhbGxlZCBvbiB0aGUgcm9vdCcpO1xuICAgIH1cbiAgICBpZiAoIXRoaXNbT1BUSU9OU10ud3JhcHBpbmdDb21wb25lbnQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignU2hhbGxvd1dyYXBwZXI6OmdldFdyYXBwaW5nQ29tcG9uZW50KCkgY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGEgd3JhcHBlciB0aGF0IHdhcyBvcmlnaW5hbGx5IHBhc3NlZCBhIGB3cmFwcGluZ0NvbXBvbmVudGAgb3B0aW9uJyk7XG4gICAgfVxuICAgIHJldHVybiB0aGlzW1dSQVBQSU5HX0NPTVBPTkVOVF07XG4gIH1cblxuICAvKipcbiAgICogRm9yY2VzIGEgcmUtcmVuZGVyLiBVc2VmdWwgdG8gcnVuIGJlZm9yZSBjaGVja2luZyB0aGUgcmVuZGVyIG91dHB1dCBpZiBzb21ldGhpbmcgZXh0ZXJuYWxcbiAgICogbWF5IGJlIHVwZGF0aW5nIHRoZSBzdGF0ZSBvZiB0aGUgY29tcG9uZW50IHNvbWV3aGVyZS5cbiAgICpcbiAgICogTk9URTogY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGEgd3JhcHBlciBpbnN0YW5jZSB0aGF0IGlzIGFsc28gdGhlIHJvb3QgaW5zdGFuY2UuXG4gICAqXG4gICAqIEByZXR1cm5zIHtTaGFsbG93V3JhcHBlcn1cbiAgICovXG4gIHVwZGF0ZSgpIHtcbiAgICBpZiAodGhpc1tST09UXSAhPT0gdGhpcykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdTaGFsbG93V3JhcHBlcjo6dXBkYXRlKCkgY2FuIG9ubHkgYmUgY2FsbGVkIG9uIHRoZSByb290Jyk7XG4gICAgfVxuICAgIGlmICh0aGlzLmxlbmd0aCAhPT0gMSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdTaGFsbG93V3JhcHBlcjo6dXBkYXRlKCkgY2FuIG9ubHkgYmUgY2FsbGVkIHdoZW4gd3JhcHBpbmcgb25lIG5vZGUnKTtcbiAgICB9XG4gICAgcHJpdmF0ZVNldE5vZGVzKHRoaXMsIGdldFJvb3ROb2RlKHRoaXNbUkVOREVSRVJdLmdldE5vZGUoKSkpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEEgbWV0aG9kIHRoYXQgdW5tb3VudHMgdGhlIGNvbXBvbmVudC4gVGhpcyBjYW4gYmUgdXNlZCB0byBzaW11bGF0ZSBhIGNvbXBvbmVudCBnb2luZyB0aHJvdWdoXG4gICAqIGFuZCB1bm1vdW50L21vdW50IGxpZmVjeWNsZS5cbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgdW5tb3VudCgpIHtcbiAgICB0aGlzW1JFTkRFUkVSXS51bm1vdW50KCk7XG4gICAgaWYgKHRoaXNbUk9PVF1bV1JBUFBJTkdfQ09NUE9ORU5UXSkge1xuICAgICAgdGhpc1tST09UXVtXUkFQUElOR19DT01QT05FTlRdLnVubW91bnQoKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQSBtZXRob2QgaXMgZm9yIHJlLXJlbmRlciB3aXRoIG5ldyBwcm9wcyBhbmQgY29udGV4dC5cbiAgICogVGhpcyBjYWxscyBjb21wb25lbnREaWRVcGRhdGUgbWV0aG9kIGlmIGRpc2FibGVMaWZlY3ljbGVNZXRob2RzIGlzIG5vdCBlbmFibGVkLlxuICAgKlxuICAgKiBOT1RFOiBjYW4gb25seSBiZSBjYWxsZWQgb24gYSB3cmFwcGVyIGluc3RhbmNlIHRoYXQgaXMgYWxzbyB0aGUgcm9vdCBpbnN0YW5jZS5cbiAgICpcbiAgICogQHBhcmFtIHtPYmplY3R9IHByb3BzXG4gICAqIEBwYXJhbSB7T2JqZWN0fSBjb250ZXh0XG4gICAqIEByZXR1cm5zIHtTaGFsbG93V3JhcHBlcn1cbiAgICovXG4gIHJlcmVuZGVyKHByb3BzLCBjb250ZXh0KSB7XG4gICAgY29uc3QgYWRhcHRlciA9IGdldEFkYXB0ZXIodGhpc1tPUFRJT05TXSk7XG4gICAgdGhpcy5zaW5nbGUoJ3JlcmVuZGVyJywgKCkgPT4ge1xuICAgICAgd2l0aFNldFN0YXRlQWxsb3dlZCgoKSA9PiB7XG4gICAgICAgIC8vIE5PVEUobG1yKTogSW4gcmVhY3QgMTYsIGluc3RhbmNlcyB3aWxsIGJlIG51bGwgZm9yIFNGQ3MsIGJ1dFxuICAgICAgICAvLyByZXJlbmRlcmluZyB3aXRoIHByb3BzL2NvbnRleHQgaXMgc3RpbGwgYSB2YWxpZCB0aGluZyB0byBkby4gSW5cbiAgICAgICAgLy8gdGhpcyBjYXNlLCBzdGF0ZSB3aWxsIGJlIHVuZGVmaW5lZCwgYnV0IHByb3BzL2NvbnRleHQgd2lsbCBleGlzdC5cbiAgICAgICAgY29uc3Qgbm9kZSA9IHRoaXNbUkVOREVSRVJdLmdldE5vZGUoKTtcbiAgICAgICAgY29uc3QgaW5zdGFuY2UgPSBub2RlLmluc3RhbmNlIHx8IHt9O1xuICAgICAgICBjb25zdCB0eXBlID0gbm9kZS50eXBlIHx8IHt9O1xuICAgICAgICBjb25zdCB7IHN0YXRlIH0gPSBpbnN0YW5jZTtcbiAgICAgICAgY29uc3QgcHJldlByb3BzID0gaW5zdGFuY2UucHJvcHMgfHwgdGhpc1tVTlJFTkRFUkVEXS5wcm9wcztcbiAgICAgICAgY29uc3QgcHJldkNvbnRleHQgPSBpbnN0YW5jZS5jb250ZXh0IHx8IHRoaXNbT1BUSU9OU10uY29udGV4dDtcbiAgICAgICAgY29uc3QgbmV4dENvbnRleHQgPSBjb250ZXh0IHx8IHByZXZDb250ZXh0O1xuICAgICAgICBpZiAoY29udGV4dCkge1xuICAgICAgICAgIHRoaXNbT1BUSU9OU10gPSB7IC4uLnRoaXNbT1BUSU9OU10sIGNvbnRleHQ6IG5leHRDb250ZXh0IH07XG4gICAgICAgIH1cbiAgICAgICAgdGhpc1tSRU5ERVJFUl0uYmF0Y2hlZFVwZGF0ZXMoKCkgPT4ge1xuICAgICAgICAgIC8vIFdoZW4gc2hvdWxkQ29tcG9uZW50VXBkYXRlIHJldHVybnMgZmFsc2Ugd2Ugc2hvdWxkbid0IGNhbGwgY29tcG9uZW50RGlkVXBkYXRlLlxuICAgICAgICAgIC8vIHNvIHdlIHNweSBzaG91bGRDb21wb25lbnRVcGRhdGUgdG8gZ2V0IHRoZSByZXN1bHQuXG4gICAgICAgICAgY29uc3QgbGlmZWN5Y2xlcyA9IGdldEFkYXB0ZXJMaWZlY3ljbGVzKGFkYXB0ZXIpO1xuICAgICAgICAgIGxldCBzaG91bGRSZW5kZXIgPSB0cnVlO1xuICAgICAgICAgIGxldCBzaG91bGRDb21wb25lbnRVcGRhdGVTcHk7XG4gICAgICAgICAgbGV0IGdldENoaWxkQ29udGV4dFNweTtcbiAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAhdGhpc1tPUFRJT05TXS5kaXNhYmxlTGlmZWN5Y2xlTWV0aG9kc1xuICAgICAgICAgICAgJiYgaW5zdGFuY2VcbiAgICAgICAgICApIHtcbiAgICAgICAgICAgIGlmICh0eXBlb2YgaW5zdGFuY2Uuc2hvdWxkQ29tcG9uZW50VXBkYXRlID09PSAnZnVuY3Rpb24nKSB7XG4gICAgICAgICAgICAgIGNvbnN0IHsgZ2V0RGVyaXZlZFN0YXRlRnJvbVByb3BzOiBnRFNGUCB9ID0gbGlmZWN5Y2xlcztcbiAgICAgICAgICAgICAgaWYgKGdEU0ZQICYmIGdEU0ZQLmhhc1Nob3VsZENvbXBvbmVudFVwZGF0ZUJ1Zykge1xuICAgICAgICAgICAgICAgIG1vY2tTQ1VJZmdEU0ZQUmV0dXJuTm9uTnVsbChub2RlLCBzdGF0ZSk7XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgc2hvdWxkQ29tcG9uZW50VXBkYXRlU3B5ID0gc3B5TWV0aG9kKGluc3RhbmNlLCAnc2hvdWxkQ29tcG9uZW50VXBkYXRlJyk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgIGxpZmVjeWNsZXMuZ2V0Q2hpbGRDb250ZXh0LmNhbGxlZEJ5UmVuZGVyZXJcbiAgICAgICAgICAgICAgJiYgdHlwZW9mIGluc3RhbmNlLmdldENoaWxkQ29udGV4dCA9PT0gJ2Z1bmN0aW9uJ1xuICAgICAgICAgICAgKSB7XG4gICAgICAgICAgICAgIGdldENoaWxkQ29udGV4dFNweSA9IHNweU1ldGhvZChpbnN0YW5jZSwgJ2dldENoaWxkQ29udGV4dCcpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgICBpZiAoIXNob3VsZENvbXBvbmVudFVwZGF0ZVNweSAmJiBpc1B1cmVDb21wb25lbnQoaW5zdGFuY2UpKSB7XG4gICAgICAgICAgICBzaG91bGRSZW5kZXIgPSBwdXJlQ29tcG9uZW50U2hvdWxkQ29tcG9uZW50VXBkYXRlKFxuICAgICAgICAgICAgICBwcmV2UHJvcHMsXG4gICAgICAgICAgICAgIHByb3BzLFxuICAgICAgICAgICAgICBzdGF0ZSxcbiAgICAgICAgICAgICAgaW5zdGFuY2Uuc3RhdGUsXG4gICAgICAgICAgICApO1xuICAgICAgICAgIH1cbiAgICAgICAgICBpZiAocHJvcHMpIHRoaXNbVU5SRU5ERVJFRF0gPSBjbG9uZUVsZW1lbnQoYWRhcHRlciwgdGhpc1tVTlJFTkRFUkVEXSwgcHJvcHMpO1xuICAgICAgICAgIHRoaXNbUkVOREVSRVJdLnJlbmRlcih0aGlzW1VOUkVOREVSRURdLCBuZXh0Q29udGV4dCwge1xuICAgICAgICAgICAgcHJvdmlkZXJWYWx1ZXM6IHRoaXNbUFJPVklERVJfVkFMVUVTXSxcbiAgICAgICAgICB9KTtcbiAgICAgICAgICBpZiAoc2hvdWxkQ29tcG9uZW50VXBkYXRlU3B5KSB7XG4gICAgICAgICAgICBzaG91bGRSZW5kZXIgPSBzaG91bGRDb21wb25lbnRVcGRhdGVTcHkuZ2V0TGFzdFJldHVyblZhbHVlKCk7XG4gICAgICAgICAgICBzaG91bGRDb21wb25lbnRVcGRhdGVTcHkucmVzdG9yZSgpO1xuICAgICAgICAgIH1cbiAgICAgICAgICBpZiAoXG4gICAgICAgICAgICBzaG91bGRSZW5kZXJcbiAgICAgICAgICAgICYmICF0aGlzW09QVElPTlNdLmRpc2FibGVMaWZlY3ljbGVNZXRob2RzXG4gICAgICAgICAgICAmJiBpbnN0YW5jZVxuICAgICAgICAgICkge1xuICAgICAgICAgICAgcHJpdmF0ZVNldENoaWxkQ29udGV4dChhZGFwdGVyLCB0aGlzLCBpbnN0YW5jZSwgbm9kZSwgZ2V0Q2hpbGRDb250ZXh0U3B5KTtcbiAgICAgICAgICAgIGlmIChsaWZlY3ljbGVzLmdldFNuYXBzaG90QmVmb3JlVXBkYXRlKSB7XG4gICAgICAgICAgICAgIGxldCBzbmFwc2hvdDtcbiAgICAgICAgICAgICAgaWYgKHR5cGVvZiBpbnN0YW5jZS5nZXRTbmFwc2hvdEJlZm9yZVVwZGF0ZSA9PT0gJ2Z1bmN0aW9uJykge1xuICAgICAgICAgICAgICAgIHNuYXBzaG90ID0gaW5zdGFuY2UuZ2V0U25hcHNob3RCZWZvcmVVcGRhdGUocHJldlByb3BzLCBzdGF0ZSk7XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgIGxpZmVjeWNsZXMuY29tcG9uZW50RGlkVXBkYXRlXG4gICAgICAgICAgICAgICAgJiYgdHlwZW9mIGluc3RhbmNlLmNvbXBvbmVudERpZFVwZGF0ZSA9PT0gJ2Z1bmN0aW9uJ1xuICAgICAgICAgICAgICAgICYmIChcbiAgICAgICAgICAgICAgICAgICFzdGF0ZVxuICAgICAgICAgICAgICAgICAgfHwgc2hhbGxvd0VxdWFsKHN0YXRlLCB0aGlzLmluc3RhbmNlKCkuc3RhdGUpXG4gICAgICAgICAgICAgICAgICB8fCB0eXBlb2YgdHlwZS5nZXREZXJpdmVkU3RhdGVGcm9tUHJvcHMgPT09ICdmdW5jdGlvbidcbiAgICAgICAgICAgICAgICApXG4gICAgICAgICAgICAgICkge1xuICAgICAgICAgICAgICAgIGluc3RhbmNlLmNvbXBvbmVudERpZFVwZGF0ZShwcmV2UHJvcHMsIHN0YXRlLCBzbmFwc2hvdCk7XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gZWxzZSBpZiAoXG4gICAgICAgICAgICAgIGxpZmVjeWNsZXMuY29tcG9uZW50RGlkVXBkYXRlXG4gICAgICAgICAgICAgICYmIHR5cGVvZiBpbnN0YW5jZS5jb21wb25lbnREaWRVcGRhdGUgPT09ICdmdW5jdGlvbidcbiAgICAgICAgICAgICkge1xuICAgICAgICAgICAgICBpZiAobGlmZWN5Y2xlcy5jb21wb25lbnREaWRVcGRhdGUucHJldkNvbnRleHQpIHtcbiAgICAgICAgICAgICAgICBpbnN0YW5jZS5jb21wb25lbnREaWRVcGRhdGUocHJldlByb3BzLCBzdGF0ZSwgcHJldkNvbnRleHQpO1xuICAgICAgICAgICAgICB9IGVsc2UgaWYgKCFzdGF0ZSB8fCBzaGFsbG93RXF1YWwodGhpcy5pbnN0YW5jZSgpLnN0YXRlLCBzdGF0ZSkpIHtcbiAgICAgICAgICAgICAgICBpbnN0YW5jZS5jb21wb25lbnREaWRVcGRhdGUocHJldlByb3BzLCBzdGF0ZSk7XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAvLyBJZiBpdCBkb2Vzbid0IG5lZWQgdG8gcmVyZW5kZXIsIHVwZGF0ZSBvbmx5IGl0cyBwcm9wcy5cbiAgICAgICAgICB9IGVsc2UgaWYgKCFzaGFsbG93RXF1YWwocHJvcHMsIGluc3RhbmNlLnByb3BzKSkge1xuICAgICAgICAgICAgaW5zdGFuY2UucHJvcHMgPSAoT2JqZWN0LmZyZWV6ZSB8fCBPYmplY3QpKHsgLi4uaW5zdGFuY2UucHJvcHMsIC4uLnByb3BzIH0pO1xuICAgICAgICAgIH1cbiAgICAgICAgICB0aGlzLnVwZGF0ZSgpO1xuICAgICAgICB9KTtcbiAgICAgIH0pO1xuICAgIH0pO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEEgbWV0aG9kIHRoYXQgc2V0cyB0aGUgcHJvcHMgb2YgdGhlIHJvb3QgY29tcG9uZW50LCBhbmQgcmUtcmVuZGVycy4gVXNlZnVsIGZvciB3aGVuIHlvdSBhcmVcbiAgICogd2FudGluZyB0byB0ZXN0IGhvdyB0aGUgY29tcG9uZW50IGJlaGF2ZXMgb3ZlciB0aW1lIHdpdGggY2hhbmdpbmcgcHJvcHMuIENhbGxpbmcgdGhpcywgZm9yXG4gICAqIGluc3RhbmNlLCB3aWxsIGNhbGwgdGhlIGBjb21wb25lbnRXaWxsUmVjZWl2ZVByb3BzYCBsaWZlY3ljbGUgbWV0aG9kLlxuICAgKlxuICAgKiBTaW1pbGFyIHRvIGBzZXRTdGF0ZWAsIHRoaXMgbWV0aG9kIGFjY2VwdHMgYSBwcm9wcyBvYmplY3QgYW5kIHdpbGwgbWVyZ2UgaXQgaW4gd2l0aCB0aGUgYWxyZWFkeVxuICAgKiBleGlzdGluZyBwcm9wcy5cbiAgICpcbiAgICogTk9URTogY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGEgd3JhcHBlciBpbnN0YW5jZSB0aGF0IGlzIGFsc28gdGhlIHJvb3QgaW5zdGFuY2UuXG4gICAqXG4gICAqIEBwYXJhbSB7T2JqZWN0fSBwcm9wcyBvYmplY3RcbiAgICogQHBhcmFtIHtGdW5jdGlvbn0gY2IgLSBjYWxsYmFjayBmdW5jdGlvblxuICAgKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ9XG4gICAqL1xuICBzZXRQcm9wcyhwcm9wcywgY2FsbGJhY2sgPSB1bmRlZmluZWQpIHtcbiAgICBpZiAodGhpc1tST09UXSAhPT0gdGhpcykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdTaGFsbG93V3JhcHBlcjo6c2V0UHJvcHMoKSBjYW4gb25seSBiZSBjYWxsZWQgb24gdGhlIHJvb3QnKTtcbiAgICB9XG4gICAgaWYgKGFyZ3VtZW50cy5sZW5ndGggPiAxICYmIHR5cGVvZiBjYWxsYmFjayAhPT0gJ2Z1bmN0aW9uJykge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignUmVhY3RXcmFwcGVyOjpzZXRQcm9wcygpIGV4cGVjdHMgYSBmdW5jdGlvbiBhcyBpdHMgc2Vjb25kIGFyZ3VtZW50Jyk7XG4gICAgfVxuICAgIHRoaXMucmVyZW5kZXIocHJvcHMpO1xuICAgIGlmIChjYWxsYmFjaykge1xuICAgICAgY2FsbGJhY2soKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQSBtZXRob2QgdG8gaW52b2tlIGBzZXRTdGF0ZWAgb24gdGhlIHJvb3QgY29tcG9uZW50IGluc3RhbmNlIHNpbWlsYXIgdG8gaG93IHlvdSBtaWdodCBpbiB0aGVcbiAgICogZGVmaW5pdGlvbiBvZiB0aGUgY29tcG9uZW50LCBhbmQgcmUtcmVuZGVycy4gIFRoaXMgbWV0aG9kIGlzIHVzZWZ1bCBmb3IgdGVzdGluZyB5b3VyIGNvbXBvbmVudFxuICAgKiBpbiBoYXJkIHRvIGFjaGlldmUgc3RhdGVzLCBob3dldmVyIHNob3VsZCBiZSB1c2VkIHNwYXJpbmdseS4gSWYgcG9zc2libGUsIHlvdSBzaG91bGQgdXRpbGl6ZVxuICAgKiB5b3VyIGNvbXBvbmVudCdzIGV4dGVybmFsIEFQSSBpbiBvcmRlciB0byBnZXQgaXQgaW50byB3aGF0ZXZlciBzdGF0ZSB5b3Ugd2FudCB0byB0ZXN0LCBpbiBvcmRlclxuICAgKiB0byBiZSBhcyBhY2N1cmF0ZSBvZiBhIHRlc3QgYXMgcG9zc2libGUuIFRoaXMgaXMgbm90IGFsd2F5cyBwcmFjdGljYWwsIGhvd2V2ZXIuXG4gICAqXG4gICAqIE5PVEU6IGNhbiBvbmx5IGJlIGNhbGxlZCBvbiBhIHdyYXBwZXIgaW5zdGFuY2UgdGhhdCBpcyBhbHNvIHRoZSByb290IGluc3RhbmNlLlxuICAgKlxuICAgKiBAcGFyYW0ge09iamVjdH0gc3RhdGUgdG8gbWVyZ2VcbiAgICogQHBhcmFtIHtGdW5jdGlvbn0gY2IgLSBjYWxsYmFjayBmdW5jdGlvblxuICAgKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ9XG4gICAqL1xuICBzZXRTdGF0ZShzdGF0ZSwgY2FsbGJhY2sgPSB1bmRlZmluZWQpIHtcbiAgICBpZiAodGhpc1tST09UXSAhPT0gdGhpcykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdTaGFsbG93V3JhcHBlcjo6c2V0U3RhdGUoKSBjYW4gb25seSBiZSBjYWxsZWQgb24gdGhlIHJvb3QnKTtcbiAgICB9XG4gICAgaWYgKHRoaXMuaW5zdGFuY2UoKSA9PT0gbnVsbCB8fCB0aGlzW1JFTkRFUkVSXS5nZXROb2RlKCkubm9kZVR5cGUgIT09ICdjbGFzcycpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignU2hhbGxvd1dyYXBwZXI6OnNldFN0YXRlKCkgY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGNsYXNzIGNvbXBvbmVudHMnKTtcbiAgICB9XG4gICAgaWYgKGFyZ3VtZW50cy5sZW5ndGggPiAxICYmIHR5cGVvZiBjYWxsYmFjayAhPT0gJ2Z1bmN0aW9uJykge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignUmVhY3RXcmFwcGVyOjpzZXRTdGF0ZSgpIGV4cGVjdHMgYSBmdW5jdGlvbiBhcyBpdHMgc2Vjb25kIGFyZ3VtZW50Jyk7XG4gICAgfVxuXG4gICAgdGhpcy5zaW5nbGUoJ3NldFN0YXRlJywgKCkgPT4ge1xuICAgICAgd2l0aFNldFN0YXRlQWxsb3dlZCgoKSA9PiB7XG4gICAgICAgIGNvbnN0IGFkYXB0ZXIgPSBnZXRBZGFwdGVyKHRoaXNbT1BUSU9OU10pO1xuXG4gICAgICAgIGNvbnN0IGxpZmVjeWNsZXMgPSBnZXRBZGFwdGVyTGlmZWN5Y2xlcyhhZGFwdGVyKTtcblxuICAgICAgICBjb25zdCBub2RlID0gdGhpc1tSRU5ERVJFUl0uZ2V0Tm9kZSgpO1xuICAgICAgICBjb25zdCB7IGluc3RhbmNlIH0gPSBub2RlO1xuICAgICAgICBjb25zdCBwcmV2UHJvcHMgPSBpbnN0YW5jZS5wcm9wcztcbiAgICAgICAgY29uc3QgcHJldlN0YXRlID0gaW5zdGFuY2Uuc3RhdGU7XG4gICAgICAgIGNvbnN0IHByZXZDb250ZXh0ID0gaW5zdGFuY2UuY29udGV4dDtcblxuICAgICAgICBjb25zdCBzdGF0ZVBheWxvYWQgPSB0eXBlb2Ygc3RhdGUgPT09ICdmdW5jdGlvbidcbiAgICAgICAgICA/IHN0YXRlLmNhbGwoaW5zdGFuY2UsIHByZXZTdGF0ZSwgcHJldlByb3BzKVxuICAgICAgICAgIDogc3RhdGU7XG5cbiAgICAgICAgLy8gcmV0dXJuaW5nIG51bGwgb3IgdW5kZWZpbmVkIHByZXZlbnRzIHRoZSB1cGRhdGUgaW4gUmVhY3QgMTYrXG4gICAgICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9mYWNlYm9vay9yZWFjdC9wdWxsLzEyNzU2XG4gICAgICAgIGNvbnN0IG1heWJlSGFzVXBkYXRlID0gIWxpZmVjeWNsZXMuc2V0U3RhdGUuc2tpcHNDb21wb25lbnREaWRVcGRhdGVPbk51bGxpc2hcbiAgICAgICAgICB8fCBzdGF0ZVBheWxvYWQgIT0gbnVsbDtcblxuICAgICAgICAvLyBXaGVuIHNob3VsZENvbXBvbmVudFVwZGF0ZSByZXR1cm5zIGZhbHNlIHdlIHNob3VsZG4ndCBjYWxsIGNvbXBvbmVudERpZFVwZGF0ZS5cbiAgICAgICAgLy8gc28gd2Ugc3B5IHNob3VsZENvbXBvbmVudFVwZGF0ZSB0byBnZXQgdGhlIHJlc3VsdC5cbiAgICAgICAgbGV0IHNob3VsZENvbXBvbmVudFVwZGF0ZVNweTtcbiAgICAgICAgbGV0IGdldENoaWxkQ29udGV4dFNweTtcbiAgICAgICAgbGV0IHNob3VsZFJlbmRlciA9IHRydWU7XG4gICAgICAgIGlmIChcbiAgICAgICAgICAhdGhpc1tPUFRJT05TXS5kaXNhYmxlTGlmZWN5Y2xlTWV0aG9kc1xuICAgICAgICAgICYmIGluc3RhbmNlXG4gICAgICAgICkge1xuICAgICAgICAgIGlmIChcbiAgICAgICAgICAgIGxpZmVjeWNsZXMuY29tcG9uZW50RGlkVXBkYXRlXG4gICAgICAgICAgICAmJiBsaWZlY3ljbGVzLmNvbXBvbmVudERpZFVwZGF0ZS5vblNldFN0YXRlXG4gICAgICAgICAgICAmJiB0eXBlb2YgaW5zdGFuY2Uuc2hvdWxkQ29tcG9uZW50VXBkYXRlID09PSAnZnVuY3Rpb24nXG4gICAgICAgICAgKSB7XG4gICAgICAgICAgICBjb25zdCB7IGdldERlcml2ZWRTdGF0ZUZyb21Qcm9wczogZ0RTRlAgfSA9IGxpZmVjeWNsZXM7XG4gICAgICAgICAgICBpZiAoZ0RTRlAgJiYgZ0RTRlAuaGFzU2hvdWxkQ29tcG9uZW50VXBkYXRlQnVnKSB7XG4gICAgICAgICAgICAgIG1vY2tTQ1VJZmdEU0ZQUmV0dXJuTm9uTnVsbChub2RlLCBzdGF0ZSk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBzaG91bGRDb21wb25lbnRVcGRhdGVTcHkgPSBzcHlNZXRob2QoaW5zdGFuY2UsICdzaG91bGRDb21wb25lbnRVcGRhdGUnKTtcbiAgICAgICAgICB9XG4gICAgICAgICAgaWYgKFxuICAgICAgICAgICAgbGlmZWN5Y2xlcy5nZXRDaGlsZENvbnRleHQuY2FsbGVkQnlSZW5kZXJlclxuICAgICAgICAgICAgJiYgdHlwZW9mIGluc3RhbmNlLmdldENoaWxkQ29udGV4dCA9PT0gJ2Z1bmN0aW9uJ1xuICAgICAgICAgICkge1xuICAgICAgICAgICAgZ2V0Q2hpbGRDb250ZXh0U3B5ID0gc3B5TWV0aG9kKGluc3RhbmNlLCAnZ2V0Q2hpbGRDb250ZXh0Jyk7XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIGlmICghc2hvdWxkQ29tcG9uZW50VXBkYXRlU3B5ICYmIGlzUHVyZUNvbXBvbmVudChpbnN0YW5jZSkpIHtcbiAgICAgICAgICBzaG91bGRSZW5kZXIgPSBwdXJlQ29tcG9uZW50U2hvdWxkQ29tcG9uZW50VXBkYXRlKFxuICAgICAgICAgICAgcHJldlByb3BzLFxuICAgICAgICAgICAgaW5zdGFuY2UucHJvcHMsXG4gICAgICAgICAgICBwcmV2U3RhdGUsXG4gICAgICAgICAgICB7IC4uLnByZXZTdGF0ZSwgLi4uc3RhdGVQYXlsb2FkIH0sXG4gICAgICAgICAgKTtcbiAgICAgICAgfVxuXG4gICAgICAgIC8vIFdlIGRvbid0IHBhc3MgdGhlIHNldFN0YXRlIGNhbGxiYWNrIGhlcmVcbiAgICAgICAgLy8gdG8gZ3VhcmFudGVlIHRvIGNhbGwgdGhlIGNhbGxiYWNrIGFmdGVyIGZpbmlzaGluZyB0aGUgcmVuZGVyXG4gICAgICAgIGlmIChpbnN0YW5jZVtTRVRfU1RBVEVdKSB7XG4gICAgICAgICAgaW5zdGFuY2VbU0VUX1NUQVRFXShzdGF0ZVBheWxvYWQpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGluc3RhbmNlLnNldFN0YXRlKHN0YXRlUGF5bG9hZCk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHNob3VsZENvbXBvbmVudFVwZGF0ZVNweSkge1xuICAgICAgICAgIHNob3VsZFJlbmRlciA9IHNob3VsZENvbXBvbmVudFVwZGF0ZVNweS5nZXRMYXN0UmV0dXJuVmFsdWUoKTtcbiAgICAgICAgICBzaG91bGRDb21wb25lbnRVcGRhdGVTcHkucmVzdG9yZSgpO1xuICAgICAgICB9XG4gICAgICAgIGlmIChcbiAgICAgICAgICBtYXliZUhhc1VwZGF0ZVxuICAgICAgICAgICYmIHNob3VsZFJlbmRlclxuICAgICAgICAgICYmICF0aGlzW09QVElPTlNdLmRpc2FibGVMaWZlY3ljbGVNZXRob2RzXG4gICAgICAgICkge1xuICAgICAgICAgIHByaXZhdGVTZXRDaGlsZENvbnRleHQoYWRhcHRlciwgdGhpcywgaW5zdGFuY2UsIG5vZGUsIGdldENoaWxkQ29udGV4dFNweSk7XG4gICAgICAgICAgaWYgKFxuICAgICAgICAgICAgbGlmZWN5Y2xlcy5jb21wb25lbnREaWRVcGRhdGVcbiAgICAgICAgICAgICYmIGxpZmVjeWNsZXMuY29tcG9uZW50RGlkVXBkYXRlLm9uU2V0U3RhdGVcbiAgICAgICAgICApIHtcbiAgICAgICAgICAgIGlmIChcbiAgICAgICAgICAgICAgbGlmZWN5Y2xlcy5nZXRTbmFwc2hvdEJlZm9yZVVwZGF0ZVxuICAgICAgICAgICAgICAmJiB0eXBlb2YgaW5zdGFuY2UuZ2V0U25hcHNob3RCZWZvcmVVcGRhdGUgPT09ICdmdW5jdGlvbidcbiAgICAgICAgICAgICkge1xuICAgICAgICAgICAgICBjb25zdCBzbmFwc2hvdCA9IGluc3RhbmNlLmdldFNuYXBzaG90QmVmb3JlVXBkYXRlKHByZXZQcm9wcywgcHJldlN0YXRlKTtcbiAgICAgICAgICAgICAgaWYgKHR5cGVvZiBpbnN0YW5jZS5jb21wb25lbnREaWRVcGRhdGUgPT09ICdmdW5jdGlvbicpIHtcbiAgICAgICAgICAgICAgICBpbnN0YW5jZS5jb21wb25lbnREaWRVcGRhdGUocHJldlByb3BzLCBwcmV2U3RhdGUsIHNuYXBzaG90KTtcbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSBlbHNlIGlmICh0eXBlb2YgaW5zdGFuY2UuY29tcG9uZW50RGlkVXBkYXRlID09PSAnZnVuY3Rpb24nKSB7XG4gICAgICAgICAgICAgIGlmIChsaWZlY3ljbGVzLmNvbXBvbmVudERpZFVwZGF0ZS5wcmV2Q29udGV4dCkge1xuICAgICAgICAgICAgICAgIGluc3RhbmNlLmNvbXBvbmVudERpZFVwZGF0ZShwcmV2UHJvcHMsIHByZXZTdGF0ZSwgcHJldkNvbnRleHQpO1xuICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIGluc3RhbmNlLmNvbXBvbmVudERpZFVwZGF0ZShwcmV2UHJvcHMsIHByZXZTdGF0ZSk7XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy51cGRhdGUoKTtcbiAgICAgICAgLy8gY2FsbCB0aGUgc2V0U3RhdGUgY2FsbGJhY2tcbiAgICAgICAgaWYgKGNhbGxiYWNrKSB7XG4gICAgICAgICAgaWYgKGFkYXB0ZXIuaW52b2tlU2V0U3RhdGVDYWxsYmFjaykge1xuICAgICAgICAgICAgYWRhcHRlci5pbnZva2VTZXRTdGF0ZUNhbGxiYWNrKGluc3RhbmNlLCBjYWxsYmFjayk7XG4gICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIGNhbGxiYWNrLmNhbGwoaW5zdGFuY2UpO1xuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfSk7XG4gICAgfSk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQSBtZXRob2QgdGhhdCBzZXRzIHRoZSBjb250ZXh0IG9mIHRoZSByb290IGNvbXBvbmVudCwgYW5kIHJlLXJlbmRlcnMuIFVzZWZ1bCBmb3Igd2hlbiB5b3UgYXJlXG4gICAqIHdhbnRpbmcgdG8gdGVzdCBob3cgdGhlIGNvbXBvbmVudCBiZWhhdmVzIG92ZXIgdGltZSB3aXRoIGNoYW5naW5nIGNvbnRleHRzLlxuICAgKlxuICAgKiBOT1RFOiBjYW4gb25seSBiZSBjYWxsZWQgb24gYSB3cmFwcGVyIGluc3RhbmNlIHRoYXQgaXMgYWxzbyB0aGUgcm9vdCBpbnN0YW5jZS5cbiAgICpcbiAgICogQHBhcmFtIHtPYmplY3R9IGNvbnRleHQgb2JqZWN0XG4gICAqIEByZXR1cm5zIHtTaGFsbG93V3JhcHBlcn1cbiAgICovXG4gIHNldENvbnRleHQoY29udGV4dCkge1xuICAgIGlmICh0aGlzW1JPT1RdICE9PSB0aGlzKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpzZXRDb250ZXh0KCkgY2FuIG9ubHkgYmUgY2FsbGVkIG9uIHRoZSByb290Jyk7XG4gICAgfVxuICAgIGlmICghdGhpc1tPUFRJT05TXS5jb250ZXh0KSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpzZXRDb250ZXh0KCkgY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGEgd3JhcHBlciB0aGF0IHdhcyBvcmlnaW5hbGx5IHBhc3NlZCBhIGNvbnRleHQgb3B0aW9uJyk7XG4gICAgfVxuICAgIHJldHVybiB0aGlzLnJlcmVuZGVyKG51bGwsIGNvbnRleHQpO1xuICB9XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgb3Igbm90IGEgZ2l2ZW4gcmVhY3QgZWxlbWVudCBleGlzdHMgaW4gdGhlIHNoYWxsb3cgcmVuZGVyIHRyZWUuXG4gICAqXG4gICAqIEV4YW1wbGU6XG4gICAqIGBgYFxuICAgKiBjb25zdCB3cmFwcGVyID0gc2hhbGxvdyg8TXlDb21wb25lbnQgLz4pO1xuICAgKiBleHBlY3Qod3JhcHBlci5jb250YWlucyg8ZGl2IGNsYXNzTmFtZT1cImZvbyBiYXJcIiAvPikpLnRvLmVxdWFsKHRydWUpO1xuICAgKiBgYGBcbiAgICpcbiAgICogQHBhcmFtIHtSZWFjdEVsZW1lbnR8QXJyYXk8UmVhY3RFbGVtZW50Pn0gbm9kZU9yTm9kZXNcbiAgICogQHJldHVybnMge0Jvb2xlYW59XG4gICAqL1xuICBjb250YWlucyhub2RlT3JOb2Rlcykge1xuICAgIGNvbnN0IGFkYXB0ZXIgPSBnZXRBZGFwdGVyKHRoaXNbT1BUSU9OU10pO1xuICAgIGlmICghaXNSZWFjdEVsZW1lbnRBbGlrZShub2RlT3JOb2RlcywgYWRhcHRlcikpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignU2hhbGxvd1dyYXBwZXI6OmNvbnRhaW5zKCkgY2FuIG9ubHkgYmUgY2FsbGVkIHdpdGggYSBSZWFjdEVsZW1lbnQgKG9yIGFuIGFycmF5IG9mIHRoZW0pLCBhIHN0cmluZywgb3IgYSBudW1iZXIgYXMgYW4gYXJndW1lbnQuJyk7XG4gICAgfVxuICAgIGNvbnN0IHByZWRpY2F0ZSA9IEFycmF5LmlzQXJyYXkobm9kZU9yTm9kZXMpXG4gICAgICA/IG90aGVyID0+IGNvbnRhaW5zQ2hpbGRyZW5TdWJBcnJheShcbiAgICAgICAgbm9kZUVxdWFsLFxuICAgICAgICBvdGhlcixcbiAgICAgICAgbm9kZU9yTm9kZXMubWFwKG5vZGUgPT4gYWRhcHRlci5lbGVtZW50VG9Ob2RlKG5vZGUpKSxcbiAgICAgIClcbiAgICAgIDogb3RoZXIgPT4gbm9kZUVxdWFsKGFkYXB0ZXIuZWxlbWVudFRvTm9kZShub2RlT3JOb2RlcyksIG90aGVyKTtcblxuICAgIHJldHVybiBmaW5kV2hlcmVVbndyYXBwZWQodGhpcywgcHJlZGljYXRlKS5sZW5ndGggPiAwO1xuICB9XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgb3Igbm90IGEgZ2l2ZW4gcmVhY3QgZWxlbWVudCBleGlzdHMgaW4gdGhlIHNoYWxsb3cgcmVuZGVyIHRyZWUuXG4gICAqIE1hdGNoIGlzIGJhc2VkIG9uIHRoZSBleHBlY3RlZCBlbGVtZW50IGFuZCBub3Qgb24gd3JhcHBlcnMgZWxlbWVudC5cbiAgICogSXQgd2lsbCBkZXRlcm1pbmUgaWYgb25lIG9mIHRoZSB3cmFwcGVycyBlbGVtZW50IFwibG9va3MgbGlrZVwiIHRoZSBleHBlY3RlZFxuICAgKiBlbGVtZW50IGJ5IGNoZWNraW5nIGlmIGFsbCBwcm9wcyBvZiB0aGUgZXhwZWN0ZWQgZWxlbWVudCBhcmUgcHJlc2VudFxuICAgKiBvbiB0aGUgd3JhcHBlcnMgZWxlbWVudCBhbmQgZXF1YWxzIHRvIGVhY2ggb3RoZXIuXG4gICAqXG4gICAqIEV4YW1wbGU6XG4gICAqIGBgYFxuICAgKiAvLyBNeUNvbXBvbmVudCBvdXRwdXRzIDxkaXY+PGRpdiBjbGFzcz1cImZvb1wiPkhlbGxvPC9kaXY+PC9kaXY+XG4gICAqIGNvbnN0IHdyYXBwZXIgPSBzaGFsbG93KDxNeUNvbXBvbmVudCAvPik7XG4gICAqIGV4cGVjdCh3cmFwcGVyLmNvbnRhaW5zTWF0Y2hpbmdFbGVtZW50KDxkaXY+SGVsbG88L2Rpdj4pKS50by5lcXVhbCh0cnVlKTtcbiAgICogYGBgXG4gICAqXG4gICAqIEBwYXJhbSB7UmVhY3RFbGVtZW50fSBub2RlXG4gICAqIEByZXR1cm5zIHtCb29sZWFufVxuICAgKi9cbiAgY29udGFpbnNNYXRjaGluZ0VsZW1lbnQobm9kZSkge1xuICAgIGNvbnN0IGFkYXB0ZXIgPSBnZXRBZGFwdGVyKHRoaXNbT1BUSU9OU10pO1xuICAgIGNvbnN0IHJzdE5vZGUgPSBhZGFwdGVyLmVsZW1lbnRUb05vZGUobm9kZSk7XG4gICAgY29uc3QgcHJlZGljYXRlID0gb3RoZXIgPT4gbm9kZU1hdGNoZXMocnN0Tm9kZSwgb3RoZXIsIChhLCBiKSA9PiBhIDw9IGIpO1xuICAgIHJldHVybiBmaW5kV2hlcmVVbndyYXBwZWQodGhpcywgcHJlZGljYXRlKS5sZW5ndGggPiAwO1xuICB9XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgb3Igbm90IGFsbCB0aGUgZ2l2ZW4gcmVhY3QgZWxlbWVudHMgZXhpc3RzIGluIHRoZSBzaGFsbG93IHJlbmRlciB0cmVlLlxuICAgKiBNYXRjaCBpcyBiYXNlZCBvbiB0aGUgZXhwZWN0ZWQgZWxlbWVudCBhbmQgbm90IG9uIHdyYXBwZXJzIGVsZW1lbnQuXG4gICAqIEl0IHdpbGwgZGV0ZXJtaW5lIGlmIG9uZSBvZiB0aGUgd3JhcHBlcnMgZWxlbWVudCBcImxvb2tzIGxpa2VcIiB0aGUgZXhwZWN0ZWRcbiAgICogZWxlbWVudCBieSBjaGVja2luZyBpZiBhbGwgcHJvcHMgb2YgdGhlIGV4cGVjdGVkIGVsZW1lbnQgYXJlIHByZXNlbnRcbiAgICogb24gdGhlIHdyYXBwZXJzIGVsZW1lbnQgYW5kIGVxdWFscyB0byBlYWNoIG90aGVyLlxuICAgKlxuICAgKiBFeGFtcGxlOlxuICAgKiBgYGBcbiAgICogY29uc3Qgd3JhcHBlciA9IHNoYWxsb3coPE15Q29tcG9uZW50IC8+KTtcbiAgICogZXhwZWN0KHdyYXBwZXIuY29udGFpbnNBbGxNYXRjaGluZ0VsZW1lbnRzKFtcbiAgICogICA8ZGl2PkhlbGxvPC9kaXY+LFxuICAgKiAgIDxkaXY+R29vZGJ5ZTwvZGl2PixcbiAgICogXSkpLnRvLmVxdWFsKHRydWUpO1xuICAgKiBgYGBcbiAgICpcbiAgICogQHBhcmFtIHtBcnJheTxSZWFjdEVsZW1lbnQ+fSBub2Rlc1xuICAgKiBAcmV0dXJucyB7Qm9vbGVhbn1cbiAgICovXG4gIGNvbnRhaW5zQWxsTWF0Y2hpbmdFbGVtZW50cyhub2Rlcykge1xuICAgIGlmICghQXJyYXkuaXNBcnJheShub2RlcykpIHtcbiAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ25vZGVzIHNob3VsZCBiZSBhbiBBcnJheScpO1xuICAgIH1cblxuICAgIHJldHVybiBub2Rlcy5ldmVyeShub2RlID0+IHRoaXMuY29udGFpbnNNYXRjaGluZ0VsZW1lbnQobm9kZSkpO1xuICB9XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgb3Igbm90IG9uZSBvZiB0aGUgZ2l2ZW4gcmVhY3QgZWxlbWVudHMgZXhpc3RzIGluIHRoZSBzaGFsbG93IHJlbmRlciB0cmVlLlxuICAgKiBNYXRjaCBpcyBiYXNlZCBvbiB0aGUgZXhwZWN0ZWQgZWxlbWVudCBhbmQgbm90IG9uIHdyYXBwZXJzIGVsZW1lbnQuXG4gICAqIEl0IHdpbGwgZGV0ZXJtaW5lIGlmIG9uZSBvZiB0aGUgd3JhcHBlcnMgZWxlbWVudCBcImxvb2tzIGxpa2VcIiB0aGUgZXhwZWN0ZWRcbiAgICogZWxlbWVudCBieSBjaGVja2luZyBpZiBhbGwgcHJvcHMgb2YgdGhlIGV4cGVjdGVkIGVsZW1lbnQgYXJlIHByZXNlbnRcbiAgICogb24gdGhlIHdyYXBwZXJzIGVsZW1lbnQgYW5kIGVxdWFscyB0byBlYWNoIG90aGVyLlxuICAgKlxuICAgKiBFeGFtcGxlOlxuICAgKiBgYGBcbiAgICogY29uc3Qgd3JhcHBlciA9IHNoYWxsb3coPE15Q29tcG9uZW50IC8+KTtcbiAgICogZXhwZWN0KHdyYXBwZXIuY29udGFpbnNBbnlNYXRjaGluZ0VsZW1lbnRzKFtcbiAgICogICA8ZGl2PkhlbGxvPC9kaXY+LFxuICAgKiAgIDxkaXY+R29vZGJ5ZTwvZGl2PixcbiAgICogXSkpLnRvLmVxdWFsKHRydWUpO1xuICAgKiBgYGBcbiAgICpcbiAgICogQHBhcmFtIHtBcnJheTxSZWFjdEVsZW1lbnQ+fSBub2Rlc1xuICAgKiBAcmV0dXJucyB7Qm9vbGVhbn1cbiAgICovXG4gIGNvbnRhaW5zQW55TWF0Y2hpbmdFbGVtZW50cyhub2Rlcykge1xuICAgIHJldHVybiBBcnJheS5pc0FycmF5KG5vZGVzKSAmJiBub2Rlcy5zb21lKG5vZGUgPT4gdGhpcy5jb250YWluc01hdGNoaW5nRWxlbWVudChub2RlKSk7XG4gIH1cblxuICAvKipcbiAgICogV2hldGhlciBvciBub3QgYSBnaXZlbiByZWFjdCBlbGVtZW50IGV4aXN0cyBpbiB0aGUgcmVuZGVyIHRyZWUuXG4gICAqXG4gICAqIEV4YW1wbGU6XG4gICAqIGBgYFxuICAgKiBjb25zdCB3cmFwcGVyID0gc2hhbGxvdyg8TXlDb21wb25lbnQgLz4pO1xuICAgKiBleHBlY3Qod3JhcHBlci5jb250YWlucyg8ZGl2IGNsYXNzTmFtZT1cImZvbyBiYXJcIiAvPikpLnRvLmVxdWFsKHRydWUpO1xuICAgKiBgYGBcbiAgICpcbiAgICogQHBhcmFtIHtSZWFjdEVsZW1lbnR9IG5vZGVcbiAgICogQHJldHVybnMge0Jvb2xlYW59XG4gICAqL1xuICBlcXVhbHMobm9kZSkge1xuICAgIHJldHVybiB0aGlzLnNpbmdsZSgnZXF1YWxzJywgKCkgPT4gbm9kZUVxdWFsKHRoaXMuZ2V0Tm9kZUludGVybmFsKCksIG5vZGUpKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBXaGV0aGVyIG9yIG5vdCBhIGdpdmVuIHJlYWN0IGVsZW1lbnQgbWF0Y2hlcyB0aGUgcmVuZGVyIHRyZWUuXG4gICAqIE1hdGNoIGlzIGJhc2VkIG9uIHRoZSBleHBlY3RlZCBlbGVtZW50IGFuZCBub3Qgb24gd3JhcHBlciByb290IG5vZGUuXG4gICAqIEl0IHdpbGwgZGV0ZXJtaW5lIGlmIHRoZSB3cmFwcGVyIHJvb3Qgbm9kZSBcImxvb2tzIGxpa2VcIiB0aGUgZXhwZWN0ZWRcbiAgICogZWxlbWVudCBieSBjaGVja2luZyBpZiBhbGwgcHJvcHMgb2YgdGhlIGV4cGVjdGVkIGVsZW1lbnQgYXJlIHByZXNlbnRcbiAgICogb24gdGhlIHdyYXBwZXIgcm9vdCBub2RlIGFuZCBlcXVhbHMgdG8gZWFjaCBvdGhlci5cbiAgICpcbiAgICogRXhhbXBsZTpcbiAgICogYGBgXG4gICAqIC8vIE15Q29tcG9uZW50IG91dHB1dHMgPGRpdiBjbGFzcz1cImZvb1wiPkhlbGxvPC9kaXY+XG4gICAqIGNvbnN0IHdyYXBwZXIgPSBzaGFsbG93KDxNeUNvbXBvbmVudCAvPik7XG4gICAqIGV4cGVjdCh3cmFwcGVyLm1hdGNoZXNFbGVtZW50KDxkaXY+SGVsbG88L2Rpdj4pKS50by5lcXVhbCh0cnVlKTtcbiAgICogYGBgXG4gICAqXG4gICAqIEBwYXJhbSB7UmVhY3RFbGVtZW50fSBub2RlXG4gICAqIEByZXR1cm5zIHtCb29sZWFufVxuICAgKi9cbiAgbWF0Y2hlc0VsZW1lbnQobm9kZSkge1xuICAgIHJldHVybiB0aGlzLnNpbmdsZSgnbWF0Y2hlc0VsZW1lbnQnLCAoKSA9PiB7XG4gICAgICBjb25zdCBhZGFwdGVyID0gZ2V0QWRhcHRlcih0aGlzW09QVElPTlNdKTtcbiAgICAgIGNvbnN0IHJzdE5vZGUgPSBhZGFwdGVyLmVsZW1lbnRUb05vZGUobm9kZSk7XG4gICAgICByZXR1cm4gbm9kZU1hdGNoZXMocnN0Tm9kZSwgdGhpcy5nZXROb2RlSW50ZXJuYWwoKSwgKGEsIGIpID0+IGEgPD0gYik7XG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogRmluZHMgZXZlcnkgbm9kZSBpbiB0aGUgcmVuZGVyIHRyZWUgb2YgdGhlIGN1cnJlbnQgd3JhcHBlciB0aGF0IG1hdGNoZXMgdGhlIHByb3ZpZGVkIHNlbGVjdG9yLlxuICAgKlxuICAgKiBAcGFyYW0ge0VuenltZVNlbGVjdG9yfSBzZWxlY3RvclxuICAgKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ9XG4gICAqL1xuICBmaW5kKHNlbGVjdG9yKSB7XG4gICAgcmV0dXJuIHRoaXMud3JhcChyZWR1Y2VUcmVlc0J5U2VsZWN0b3Ioc2VsZWN0b3IsIHRoaXMuZ2V0Tm9kZXNJbnRlcm5hbCgpKSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB3aGV0aGVyIG9yIG5vdCBjdXJyZW50IG5vZGUgbWF0Y2hlcyBhIHByb3ZpZGVkIHNlbGVjdG9yLlxuICAgKlxuICAgKiBOT1RFOiBjYW4gb25seSBiZSBjYWxsZWQgb24gYSB3cmFwcGVyIG9mIGEgc2luZ2xlIG5vZGUuXG4gICAqXG4gICAqIEBwYXJhbSB7RW56eW1lU2VsZWN0b3J9IHNlbGVjdG9yXG4gICAqIEByZXR1cm5zIHtib29sZWFufVxuICAgKi9cbiAgaXMoc2VsZWN0b3IpIHtcbiAgICBjb25zdCBwcmVkaWNhdGUgPSBidWlsZFByZWRpY2F0ZShzZWxlY3Rvcik7XG4gICAgcmV0dXJuIHRoaXMuc2luZ2xlKCdpcycsIG4gPT4gcHJlZGljYXRlKG4pKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRydWUgaWYgdGhlIGNvbXBvbmVudCByZW5kZXJlZCBub3RoaW5nLCBpLmUuLCBudWxsIG9yIGZhbHNlLlxuICAgKlxuICAgKiBAcmV0dXJucyB7Ym9vbGVhbn1cbiAgICovXG4gIGlzRW1wdHlSZW5kZXIoKSB7XG4gICAgY29uc3Qgbm9kZXMgPSB0aGlzLmdldE5vZGVzSW50ZXJuYWwoKTtcblxuICAgIHJldHVybiBub2Rlcy5ldmVyeShuID0+IGlzRW1wdHlWYWx1ZShuKSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIG5ldyB3cmFwcGVyIGluc3RhbmNlIHdpdGggb25seSB0aGUgbm9kZXMgb2YgdGhlIGN1cnJlbnQgd3JhcHBlciBpbnN0YW5jZSB0aGF0IG1hdGNoXG4gICAqIHRoZSBwcm92aWRlZCBwcmVkaWNhdGUgZnVuY3Rpb24uIFRoZSBwcmVkaWNhdGUgc2hvdWxkIHJlY2VpdmUgYSB3cmFwcGVkIG5vZGUgYXMgaXRzIGZpcnN0XG4gICAqIGFyZ3VtZW50LlxuICAgKlxuICAgKiBAcGFyYW0ge0Z1bmN0aW9ufSBwcmVkaWNhdGVcbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgZmlsdGVyV2hlcmUocHJlZGljYXRlKSB7XG4gICAgcmV0dXJuIGZpbHRlcldoZXJlVW53cmFwcGVkKHRoaXMsIG4gPT4gcHJlZGljYXRlKHRoaXMud3JhcChuKSkpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYSBuZXcgd3JhcHBlciBpbnN0YW5jZSB3aXRoIG9ubHkgdGhlIG5vZGVzIG9mIHRoZSBjdXJyZW50IHdyYXBwZXIgaW5zdGFuY2UgdGhhdCBtYXRjaFxuICAgKiB0aGUgcHJvdmlkZWQgc2VsZWN0b3IuXG4gICAqXG4gICAqIEBwYXJhbSB7RW56eW1lU2VsZWN0b3J9IHNlbGVjdG9yXG4gICAqIEByZXR1cm5zIHtTaGFsbG93V3JhcHBlcn1cbiAgICovXG4gIGZpbHRlcihzZWxlY3Rvcikge1xuICAgIGNvbnN0IHByZWRpY2F0ZSA9IGJ1aWxkUHJlZGljYXRlKHNlbGVjdG9yKTtcbiAgICByZXR1cm4gZmlsdGVyV2hlcmVVbndyYXBwZWQodGhpcywgcHJlZGljYXRlKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgbmV3IHdyYXBwZXIgaW5zdGFuY2Ugd2l0aCBvbmx5IHRoZSBub2RlcyBvZiB0aGUgY3VycmVudCB3cmFwcGVyIHRoYXQgZGlkIG5vdCBtYXRjaFxuICAgKiB0aGUgcHJvdmlkZWQgc2VsZWN0b3IuIEVzc2VudGlhbGx5IHRoZSBpbnZlcnNlIG9mIGBmaWx0ZXJgLlxuICAgKlxuICAgKiBAcGFyYW0ge0VuenltZVNlbGVjdG9yfSBzZWxlY3RvclxuICAgKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ9XG4gICAqL1xuICBub3Qoc2VsZWN0b3IpIHtcbiAgICBjb25zdCBwcmVkaWNhdGUgPSBidWlsZFByZWRpY2F0ZShzZWxlY3Rvcik7XG4gICAgcmV0dXJuIGZpbHRlcldoZXJlVW53cmFwcGVkKHRoaXMsIG4gPT4gIXByZWRpY2F0ZShuKSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIHN0cmluZyBvZiB0aGUgcmVuZGVyZWQgdGV4dCBvZiB0aGUgY3VycmVudCByZW5kZXIgdHJlZS4gIFRoaXMgZnVuY3Rpb24gc2hvdWxkIGJlXG4gICAqIGxvb2tlZCBhdCB3aXRoIHNrZXB0aWNpc20gaWYgYmVpbmcgdXNlZCB0byB0ZXN0IHdoYXQgdGhlIGFjdHVhbCBIVE1MIG91dHB1dCBvZiB0aGUgY29tcG9uZW50XG4gICAqIHdpbGwgYmUuIElmIHRoYXQgaXMgd2hhdCB5b3Ugd291bGQgbGlrZSB0byB0ZXN0LCB1c2UgZW56eW1lJ3MgYHJlbmRlcmAgZnVuY3Rpb24gaW5zdGVhZC5cbiAgICpcbiAgICogTk9URTogY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGEgd3JhcHBlciBvZiBhIHNpbmdsZSBub2RlLlxuICAgKlxuICAgKiBAcmV0dXJucyB7U3RyaW5nfVxuICAgKi9cbiAgdGV4dCgpIHtcbiAgICByZXR1cm4gdGhpcy5zaW5nbGUoJ3RleHQnLCBnZXRUZXh0RnJvbU5vZGUpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIEhUTUwgb2YgdGhlIG5vZGUuXG4gICAqXG4gICAqIE5PVEU6IGNhbiBvbmx5IGJlIGNhbGxlZCBvbiBhIHdyYXBwZXIgb2YgYSBzaW5nbGUgbm9kZS5cbiAgICpcbiAgICogQHJldHVybnMge1N0cmluZ31cbiAgICovXG4gIGh0bWwoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2luZ2xlKCdodG1sJywgKG4pID0+IHtcbiAgICAgIGlmICh0aGlzLnR5cGUoKSA9PT0gbnVsbCkgcmV0dXJuIG51bGw7XG4gICAgICBjb25zdCBhZGFwdGVyID0gZ2V0QWRhcHRlcih0aGlzW09QVElPTlNdKTtcbiAgICAgIGNvbnN0IHJlbmRlcmVyID0gYWRhcHRlci5jcmVhdGVSZW5kZXJlcih7IC4uLnRoaXNbT1BUSU9OU10sIG1vZGU6ICdzdHJpbmcnIH0pO1xuICAgICAgcmV0dXJuIHJlbmRlcmVyLnJlbmRlcihhZGFwdGVyLm5vZGVUb0VsZW1lbnQobikpO1xuICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIGN1cnJlbnQgbm9kZSByZW5kZXJlZCB0byBIVE1MIGFuZCB3cmFwcGVkIGluIGEgQ2hlZXJpb1dyYXBwZXIuXG4gICAqXG4gICAqIE5PVEU6IGNhbiBvbmx5IGJlIGNhbGxlZCBvbiBhIHdyYXBwZXIgb2YgYSBzaW5nbGUgbm9kZS5cbiAgICpcbiAgICogQHJldHVybnMge0NoZWVyaW9XcmFwcGVyfVxuICAgKi9cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiB0aGlzLnR5cGUoKSA9PT0gbnVsbCA/IGNoZWVyaW8oKSA6IGNoZWVyaW8ubG9hZCgnJykodGhpcy5odG1sKCkpO1xuICB9XG5cbiAgLyoqXG4gICAqIFVzZWQgdG8gc2ltdWxhdGUgZXZlbnRzLiBQYXNzIGFuIGV2ZW50bmFtZSBhbmQgKG9wdGlvbmFsbHkpIGV2ZW50IGFyZ3VtZW50cy4gVGhpcyBtZXRob2Qgb2ZcbiAgICogdGVzdGluZyBldmVudHMgc2hvdWxkIGJlIG1ldCB3aXRoIHNvbWUgc2tlcHRpY2lzbS5cbiAgICpcbiAgICogQHBhcmFtIHtTdHJpbmd9IGV2ZW50XG4gICAqIEBwYXJhbSB7QXJyYXl9IGFyZ3NcbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgc2ltdWxhdGUoZXZlbnQsIC4uLmFyZ3MpIHtcbiAgICByZXR1cm4gdGhpcy5zaW5nbGUoJ3NpbXVsYXRlJywgKG4pID0+IHtcbiAgICAgIHRoaXNbUkVOREVSRVJdLnNpbXVsYXRlRXZlbnQobiwgZXZlbnQsIC4uLmFyZ3MpO1xuICAgICAgdGhpc1tST09UXS51cGRhdGUoKTtcbiAgICAgIHJldHVybiB0aGlzO1xuICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAqIFVzZWQgdG8gc2ltdWxhdGUgdGhyb3dpbmcgYSByZW5kZXJpbmcgZXJyb3IuIFBhc3MgYW4gZXJyb3IgdG8gdGhyb3cuXG4gICAqXG4gICAqIEBwYXJhbSB7U3RyaW5nfSBlcnJvclxuICAgKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ9XG4gICAqL1xuICBzaW11bGF0ZUVycm9yKGVycm9yKSB7XG4gICAgLy8gaW4gc2hhbGxvdywgdGhlIFwicm9vdFwiIGlzIHRoZSBcInJlbmRlcmVkXCIgdGhpbmcuXG5cbiAgICByZXR1cm4gdGhpcy5zaW5nbGUoJ3NpbXVsYXRlRXJyb3InLCAodGhpc05vZGUpID0+IHtcbiAgICAgIGlmICh0aGlzTm9kZS5ub2RlVHlwZSA9PT0gJ2hvc3QnKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpzaW11bGF0ZUVycm9yKCkgY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGN1c3RvbSBjb21wb25lbnRzJyk7XG4gICAgICB9XG5cbiAgICAgIGNvbnN0IHJlbmRlcmVyID0gdGhpc1tSRU5ERVJFUl07XG4gICAgICBpZiAodHlwZW9mIHJlbmRlcmVyLnNpbXVsYXRlRXJyb3IgIT09ICdmdW5jdGlvbicpIHtcbiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcigneW91ciBhZGFwdGVyIGRvZXMgbm90IHN1cHBvcnQgYHNpbXVsYXRlRXJyb3JgLiBUcnkgdXBncmFkaW5nIGl0IScpO1xuICAgICAgfVxuXG4gICAgICBjb25zdCByb290Tm9kZSA9IGdldFJvb3ROb2RlSW50ZXJuYWwodGhpcyk7XG4gICAgICBjb25zdCBub2RlSGllcmFyY2h5ID0gW3RoaXNOb2RlXS5jb25jYXQobm9kZVBhcmVudHModGhpcywgdGhpc05vZGUpKTtcbiAgICAgIHJlbmRlcmVyLnNpbXVsYXRlRXJyb3Iobm9kZUhpZXJhcmNoeSwgcm9vdE5vZGUsIGVycm9yKTtcblxuICAgICAgcmV0dXJuIHRoaXM7XG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgcHJvcHMgaGFzaCBmb3IgdGhlIGN1cnJlbnQgbm9kZSBvZiB0aGUgd3JhcHBlci5cbiAgICpcbiAgICogTk9URTogY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGEgd3JhcHBlciBvZiBhIHNpbmdsZSBub2RlLlxuICAgKlxuICAgKiBAcmV0dXJucyB7T2JqZWN0fVxuICAgKi9cbiAgcHJvcHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2luZ2xlKCdwcm9wcycsIHByb3BzT2ZOb2RlKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSBzdGF0ZSBoYXNoIGZvciB0aGUgcm9vdCBub2RlIG9mIHRoZSB3cmFwcGVyLiBPcHRpb25hbGx5IHBhc3MgaW4gYSBwcm9wIG5hbWUgYW5kIGl0XG4gICAqIHdpbGwgcmV0dXJuIGp1c3QgdGhhdCB2YWx1ZS5cbiAgICpcbiAgICogTk9URTogY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGEgd3JhcHBlciBvZiBhIHNpbmdsZSBub2RlLlxuICAgKlxuICAgKiBAcGFyYW0ge1N0cmluZ30gbmFtZSAob3B0aW9uYWwpXG4gICAqIEByZXR1cm5zIHsqfVxuICAgKi9cbiAgc3RhdGUobmFtZSkge1xuICAgIGlmICh0aGlzW1JPT1RdICE9PSB0aGlzKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpzdGF0ZSgpIGNhbiBvbmx5IGJlIGNhbGxlZCBvbiB0aGUgcm9vdCcpO1xuICAgIH1cbiAgICBpZiAodGhpcy5pbnN0YW5jZSgpID09PSBudWxsIHx8IHRoaXNbUkVOREVSRVJdLmdldE5vZGUoKS5ub2RlVHlwZSAhPT0gJ2NsYXNzJykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdTaGFsbG93V3JhcHBlcjo6c3RhdGUoKSBjYW4gb25seSBiZSBjYWxsZWQgb24gY2xhc3MgY29tcG9uZW50cycpO1xuICAgIH1cbiAgICBjb25zdCBfc3RhdGUgPSB0aGlzLnNpbmdsZSgnc3RhdGUnLCAoKSA9PiB0aGlzLmluc3RhbmNlKCkuc3RhdGUpO1xuICAgIGlmICh0eXBlb2YgbmFtZSAhPT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgIGlmIChfc3RhdGUgPT0gbnVsbCkge1xuICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKGBTaGFsbG93V3JhcHBlcjo6c3RhdGUoXCIke25hbWV9XCIpIHJlcXVpcmVzIHRoYXQgXFxgc3RhdGVcXGAgbm90IGJlIFxcYG51bGxcXGAgb3IgXFxgdW5kZWZpbmVkXFxgYCk7XG4gICAgICB9XG4gICAgICByZXR1cm4gX3N0YXRlW25hbWVdO1xuICAgIH1cbiAgICByZXR1cm4gX3N0YXRlO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIGNvbnRleHQgaGFzaCBmb3IgdGhlIHJvb3Qgbm9kZSBvZiB0aGUgd3JhcHBlci5cbiAgICogT3B0aW9uYWxseSBwYXNzIGluIGEgcHJvcCBuYW1lIGFuZCBpdCB3aWxsIHJldHVybiBqdXN0IHRoYXQgdmFsdWUuXG4gICAqXG4gICAqIE5PVEU6IGNhbiBvbmx5IGJlIGNhbGxlZCBvbiBhIHdyYXBwZXIgb2YgYSBzaW5nbGUgbm9kZS5cbiAgICpcbiAgICogQHBhcmFtIHtTdHJpbmd9IG5hbWUgKG9wdGlvbmFsKVxuICAgKiBAcmV0dXJucyB7Kn1cbiAgICovXG4gIGNvbnRleHQobmFtZSkge1xuICAgIGlmICh0aGlzW1JPT1RdICE9PSB0aGlzKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpjb250ZXh0KCkgY2FuIG9ubHkgYmUgY2FsbGVkIG9uIHRoZSByb290Jyk7XG4gICAgfVxuICAgIGlmICghdGhpc1tPUFRJT05TXS5jb250ZXh0KSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpjb250ZXh0KCkgY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGEgd3JhcHBlciB0aGF0IHdhcyBvcmlnaW5hbGx5IHBhc3NlZCBhIGNvbnRleHQgb3B0aW9uJyk7XG4gICAgfVxuICAgIGlmICh0aGlzLmluc3RhbmNlKCkgPT09IG51bGwpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignU2hhbGxvd1dyYXBwZXI6OmNvbnRleHQoKSBjYW4gb25seSBiZSBjYWxsZWQgb24gd3JhcHBlZCBub2RlcyB0aGF0IGhhdmUgYSBub24tbnVsbCBpbnN0YW5jZScpO1xuICAgIH1cbiAgICBjb25zdCBfY29udGV4dCA9IHRoaXMuc2luZ2xlKCdjb250ZXh0JywgKCkgPT4gdGhpcy5pbnN0YW5jZSgpLmNvbnRleHQpO1xuICAgIGlmIChuYW1lKSB7XG4gICAgICByZXR1cm4gX2NvbnRleHRbbmFtZV07XG4gICAgfVxuICAgIHJldHVybiBfY29udGV4dDtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgbmV3IHdyYXBwZXIgd2l0aCBhbGwgb2YgdGhlIGNoaWxkcmVuIG9mIHRoZSBjdXJyZW50IHdyYXBwZXIuXG4gICAqXG4gICAqIEBwYXJhbSB7RW56eW1lU2VsZWN0b3J9IFtzZWxlY3Rvcl1cbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgY2hpbGRyZW4oc2VsZWN0b3IpIHtcbiAgICBjb25zdCBhbGxDaGlsZHJlbiA9IHRoaXMuZmxhdE1hcChuID0+IGNoaWxkcmVuT2ZOb2RlKG4uZ2V0Tm9kZUludGVybmFsKCkpKTtcbiAgICByZXR1cm4gc2VsZWN0b3IgPyBhbGxDaGlsZHJlbi5maWx0ZXIoc2VsZWN0b3IpIDogYWxsQ2hpbGRyZW47XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIG5ldyB3cmFwcGVyIHdpdGggYSBzcGVjaWZpYyBjaGlsZFxuICAgKlxuICAgKiBAcGFyYW0ge051bWJlcn0gW2luZGV4XVxuICAgKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ9XG4gICAqL1xuICBjaGlsZEF0KGluZGV4KSB7XG4gICAgcmV0dXJuIHRoaXMuc2luZ2xlKCdjaGlsZEF0JywgKCkgPT4gdGhpcy5jaGlsZHJlbigpLmF0KGluZGV4KSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIHdyYXBwZXIgYXJvdW5kIGFsbCBvZiB0aGUgcGFyZW50cy9hbmNlc3RvcnMgb2YgdGhlIHdyYXBwZXIuIERvZXMgbm90IGluY2x1ZGUgdGhlIG5vZGVcbiAgICogaW4gdGhlIGN1cnJlbnQgd3JhcHBlci5cbiAgICpcbiAgICogTk9URTogY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGEgd3JhcHBlciBvZiBhIHNpbmdsZSBub2RlLlxuICAgKlxuICAgKiBAcGFyYW0ge0VuenltZVNlbGVjdG9yfSBbc2VsZWN0b3JdXG4gICAqIEByZXR1cm5zIHtTaGFsbG93V3JhcHBlcn1cbiAgICovXG4gIHBhcmVudHMoc2VsZWN0b3IpIHtcbiAgICByZXR1cm4gdGhpcy5zaW5nbGUoJ3BhcmVudHMnLCAobikgPT4ge1xuICAgICAgY29uc3QgYWxsUGFyZW50cyA9IHRoaXMud3JhcChub2RlUGFyZW50cyh0aGlzLCBuKSk7XG4gICAgICByZXR1cm4gc2VsZWN0b3IgPyBhbGxQYXJlbnRzLmZpbHRlcihzZWxlY3RvcikgOiBhbGxQYXJlbnRzO1xuICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYSB3cmFwcGVyIGFyb3VuZCB0aGUgaW1tZWRpYXRlIHBhcmVudCBvZiB0aGUgY3VycmVudCBub2RlLlxuICAgKlxuICAgKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ9XG4gICAqL1xuICBwYXJlbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZmxhdE1hcChuID0+IFtuLnBhcmVudHMoKS5nZXQoMCldKTtcbiAgfVxuXG4gIC8qKlxuICAgKlxuICAgKiBAcGFyYW0ge0VuenltZVNlbGVjdG9yfSBzZWxlY3RvclxuICAgKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ9XG4gICAqL1xuICBjbG9zZXN0KHNlbGVjdG9yKSB7XG4gICAgaWYgKHRoaXMuaXMoc2VsZWN0b3IpKSB7XG4gICAgICByZXR1cm4gdGhpcztcbiAgICB9XG4gICAgY29uc3QgbWF0Y2hpbmdBbmNlc3RvcnMgPSB0aGlzLnBhcmVudHMoKS5maWx0ZXIoc2VsZWN0b3IpO1xuICAgIHJldHVybiBtYXRjaGluZ0FuY2VzdG9ycy5sZW5ndGggPiAwID8gbWF0Y2hpbmdBbmNlc3RvcnMuZmlyc3QoKSA6IHRoaXMuZmluZFdoZXJlKCgpID0+IGZhbHNlKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBTaGFsbG93IHJlbmRlcnMgdGhlIGN1cnJlbnQgbm9kZSBhbmQgcmV0dXJucyBhIHNoYWxsb3cgd3JhcHBlciBhcm91bmQgaXQuXG4gICAqXG4gICAqIE5PVEU6IGNhbiBvbmx5IGJlIGNhbGxlZCBvbiB3cmFwcGVyIG9mIGEgc2luZ2xlIG5vZGUuXG4gICAqXG4gICAqIEBwYXJhbSB7T2JqZWN0fSBvcHRpb25zXG4gICAqIEByZXR1cm5zIHtTaGFsbG93V3JhcHBlcn1cbiAgICovXG4gIHNoYWxsb3cob3B0aW9ucykge1xuICAgIHJldHVybiB0aGlzLnNpbmdsZSgnc2hhbGxvdycsIG4gPT4gKFxuICAgICAgdGhpcy53cmFwKGdldEFkYXB0ZXIodGhpc1tPUFRJT05TXSkubm9kZVRvRWxlbWVudChuKSwgbnVsbCwgb3B0aW9ucylcbiAgICApKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSB2YWx1ZSBvZiBwcm9wIHdpdGggdGhlIGdpdmVuIG5hbWUgb2YgdGhlIGN1cnJlbnQgbm9kZS5cbiAgICpcbiAgICogQHBhcmFtIHByb3BOYW1lXG4gICAqIEByZXR1cm5zIHsqfVxuICAgKi9cbiAgcHJvcChwcm9wTmFtZSkge1xuICAgIHJldHVybiB0aGlzLnByb3BzKClbcHJvcE5hbWVdO1xuICB9XG5cbiAgLyoqXG4gICAqIFVzZWQgdG8gaW52b2tlIGEgZnVuY3Rpb24gcHJvcC5cbiAgICogV2lsbCBpbnZva2UgYW4gZnVuY3Rpb24gcHJvcCBhbmQgcmV0dXJuIGl0cyB2YWx1ZS5cbiAgICpcbiAgICogQHBhcmFtIHtTdHJpbmd9IHByb3BOYW1lXG4gICAqIEByZXR1cm5zIHtBbnl9XG4gICAqL1xuICBpbnZva2UocHJvcE5hbWUpIHtcbiAgICByZXR1cm4gdGhpcy5zaW5nbGUoJ2ludm9rZScsICgpID0+IHtcbiAgICAgIGNvbnN0IGhhbmRsZXIgPSB0aGlzLnByb3AocHJvcE5hbWUpO1xuICAgICAgaWYgKHR5cGVvZiBoYW5kbGVyICE9PSAnZnVuY3Rpb24nKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjppbnZva2UoKSByZXF1aXJlcyB0aGUgbmFtZSBvZiBhIHByb3Agd2hvc2UgdmFsdWUgaXMgYSBmdW5jdGlvbicpO1xuICAgICAgfVxuICAgICAgcmV0dXJuICguLi5hcmdzKSA9PiB7XG4gICAgICAgIGNvbnN0IHJlc3BvbnNlID0gaGFuZGxlciguLi5hcmdzKTtcbiAgICAgICAgdGhpc1tST09UXS51cGRhdGUoKTtcbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlO1xuICAgICAgfTtcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgd3JhcHBlciBvZiB0aGUgbm9kZSByZW5kZXJlZCBieSB0aGUgcHJvdmlkZWQgcmVuZGVyIHByb3AuXG4gICAqXG4gICAqIEBwYXJhbSB7U3RyaW5nfSBwcm9wTmFtZVxuICAgKiBAcmV0dXJucyB7RnVuY3Rpb259XG4gICAqL1xuICByZW5kZXJQcm9wKHByb3BOYW1lKSB7XG4gICAgY29uc3QgYWRhcHRlciA9IGdldEFkYXB0ZXIodGhpc1tPUFRJT05TXSk7XG4gICAgaWYgKHR5cGVvZiBhZGFwdGVyLndyYXAgIT09ICdmdW5jdGlvbicpIHtcbiAgICAgIHRocm93IG5ldyBSYW5nZUVycm9yKCd5b3VyIGFkYXB0ZXIgZG9lcyBub3Qgc3VwcG9ydCBgd3JhcGAuIFRyeSB1cGdyYWRpbmcgaXQhJyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMuc2luZ2xlKCdyZW5kZXJQcm9wJywgKG4pID0+IHtcbiAgICAgIGlmIChuLm5vZGVUeXBlID09PSAnaG9zdCcpIHtcbiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignU2hhbGxvd1dyYXBwZXI6OnJlbmRlclByb3AoKSBjYW4gb25seSBiZSBjYWxsZWQgb24gY3VzdG9tIGNvbXBvbmVudHMnKTtcbiAgICAgIH1cbiAgICAgIGlmICh0eXBlb2YgcHJvcE5hbWUgIT09ICdzdHJpbmcnKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpyZW5kZXJQcm9wKCk6IGBwcm9wTmFtZWAgbXVzdCBiZSBhIHN0cmluZycpO1xuICAgICAgfVxuICAgICAgY29uc3QgcHJvcHMgPSB0aGlzLnByb3BzKCk7XG4gICAgICBpZiAoIWhhcyhwcm9wcywgcHJvcE5hbWUpKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihgU2hhbGxvd1dyYXBwZXI6OnJlbmRlclByb3AoKTogbm8gcHJvcCBjYWxsZWQg4oCcJHtwcm9wTmFtZX3igJwgZm91bmRgKTtcbiAgICAgIH1cbiAgICAgIGNvbnN0IHByb3BWYWx1ZSA9IHByb3BzW3Byb3BOYW1lXTtcbiAgICAgIGlmICh0eXBlb2YgcHJvcFZhbHVlICE9PSAnZnVuY3Rpb24nKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoYFNoYWxsb3dXcmFwcGVyOjpyZW5kZXJQcm9wKCk6IGV4cGVjdGVkIHByb3Ag4oCcJHtwcm9wTmFtZX3igJwgdG8gY29udGFpbiBhIGZ1bmN0aW9uLCBidXQgaXQgaG9sZHMg4oCcJHt0eXBlb2YgcHJvcFZhbHVlfeKAnGApO1xuICAgICAgfVxuXG4gICAgICByZXR1cm4gKC4uLmFyZ3MpID0+IHtcbiAgICAgICAgY29uc3QgZWxlbWVudCA9IHByb3BWYWx1ZSguLi5hcmdzKTtcbiAgICAgICAgY29uc3Qgd3JhcHBlZCA9IGFkYXB0ZXIud3JhcChlbGVtZW50KTtcbiAgICAgICAgcmV0dXJuIHRoaXMud3JhcCh3cmFwcGVkLCBudWxsLCB0aGlzW09QVElPTlNdKTtcbiAgICAgIH07XG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB0aGUga2V5IGFzc2lnbmVkIHRvIHRoZSBjdXJyZW50IG5vZGUuXG4gICAqXG4gICAqIEByZXR1cm5zIHtTdHJpbmd9XG4gICAqL1xuICBrZXkoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2luZ2xlKCdrZXknLCBuID0+IChuLmtleSA9PT0gdW5kZWZpbmVkID8gbnVsbCA6IG4ua2V5KSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgdHlwZSBvZiB0aGUgY3VycmVudCBub2RlIG9mIHRoaXMgd3JhcHBlci4gSWYgaXQncyBhIGNvbXBvc2l0ZSBjb21wb25lbnQsIHRoaXMgd2lsbFxuICAgKiBiZSB0aGUgY29tcG9uZW50IGNvbnN0cnVjdG9yLiBJZiBpdCdzIGEgbmF0aXZlIERPTSBub2RlLCBpdCB3aWxsIGJlIGEgc3RyaW5nIG9mIHRoZSB0YWcgbmFtZS5cbiAgICogSWYgaXQncyBudWxsLCBpdCB3aWxsIGJlIG51bGwuXG4gICAqXG4gICAqIEByZXR1cm5zIHtTdHJpbmd8RnVuY3Rpb258bnVsbH1cbiAgICovXG4gIHR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2luZ2xlKCd0eXBlJywgbiA9PiB0eXBlT2ZOb2RlKG4pKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSBuYW1lIG9mIHRoZSBjdXJyZW50IG5vZGUgb2YgdGhpcyB3cmFwcGVyLlxuICAgKlxuICAgKiBJbiBvcmRlciBvZiBwcmVjZWRlbmNlID0+IHR5cGUuZGlzcGxheU5hbWUgLT4gdHlwZS5uYW1lIC0+IHR5cGUuXG4gICAqXG4gICAqIEByZXR1cm5zIHtTdHJpbmd9XG4gICAqL1xuICBuYW1lKCkge1xuICAgIGNvbnN0IGFkYXB0ZXIgPSBnZXRBZGFwdGVyKHRoaXNbT1BUSU9OU10pO1xuICAgIHJldHVybiB0aGlzLnNpbmdsZSgnbmFtZScsIG4gPT4gKFxuICAgICAgYWRhcHRlci5kaXNwbGF5TmFtZU9mTm9kZSA/IGFkYXB0ZXIuZGlzcGxheU5hbWVPZk5vZGUobikgOiBkaXNwbGF5TmFtZU9mTm9kZShuKVxuICAgICkpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgd2hldGhlciBvciBub3QgdGhlIGN1cnJlbnQgbm9kZSBoYXMgdGhlIGdpdmVuIGNsYXNzIG5hbWUgb3Igbm90LlxuICAgKlxuICAgKiBOT1RFOiBjYW4gb25seSBiZSBjYWxsZWQgb24gYSB3cmFwcGVyIG9mIGEgc2luZ2xlIG5vZGUuXG4gICAqXG4gICAqIEBwYXJhbSBjbGFzc05hbWVcbiAgICogQHJldHVybnMge0Jvb2xlYW59XG4gICAqL1xuICBoYXNDbGFzcyhjbGFzc05hbWUpIHtcbiAgICBpZiAodHlwZW9mIGNsYXNzTmFtZSA9PT0gJ3N0cmluZycgJiYgY2xhc3NOYW1lLmluZGV4T2YoJy4nKSAhPT0gLTEpIHtcbiAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1jb25zb2xlXG4gICAgICBjb25zb2xlLndhcm4oJ0l0IGxvb2tzIGxpa2UgeW91XFwncmUgY2FsbGluZyBgU2hhbGxvd1dyYXBwZXI6Omhhc0NsYXNzKClgIHdpdGggYSBDU1Mgc2VsZWN0b3IuIGhhc0NsYXNzKCkgZXhwZWN0cyBhIGNsYXNzIG5hbWUsIG5vdCBhIENTUyBzZWxlY3Rvci4nKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuc2luZ2xlKCdoYXNDbGFzcycsIG4gPT4gaGFzQ2xhc3NOYW1lKG4sIGNsYXNzTmFtZSkpO1xuICB9XG5cbiAgLyoqXG4gICAqIEl0ZXJhdGVzIHRocm91Z2ggZWFjaCBub2RlIG9mIHRoZSBjdXJyZW50IHdyYXBwZXIgYW5kIGV4ZWN1dGVzIHRoZSBwcm92aWRlZCBmdW5jdGlvbiB3aXRoIGFcbiAgICogd3JhcHBlciBhcm91bmQgdGhlIGNvcnJlc3BvbmRpbmcgbm9kZSBwYXNzZWQgaW4gYXMgdGhlIGZpcnN0IGFyZ3VtZW50LlxuICAgKlxuICAgKiBAcGFyYW0ge0Z1bmN0aW9ufSBmblxuICAgKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ9XG4gICAqL1xuICBmb3JFYWNoKGZuKSB7XG4gICAgdGhpcy5nZXROb2Rlc0ludGVybmFsKCkuZm9yRWFjaCgobiwgaSkgPT4gZm4uY2FsbCh0aGlzLCB0aGlzLndyYXAobiksIGkpKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBNYXBzIHRoZSBjdXJyZW50IGFycmF5IG9mIG5vZGVzIHRvIGFub3RoZXIgYXJyYXkuIEVhY2ggbm9kZSBpcyBwYXNzZWQgaW4gYXMgYSBgU2hhbGxvd1dyYXBwZXJgXG4gICAqIHRvIHRoZSBtYXAgZnVuY3Rpb24uXG4gICAqXG4gICAqIEBwYXJhbSB7RnVuY3Rpb259IGZuXG4gICAqIEByZXR1cm5zIHtBcnJheX1cbiAgICovXG4gIG1hcChmbikge1xuICAgIHJldHVybiB0aGlzLmdldE5vZGVzSW50ZXJuYWwoKS5tYXAoKG4sIGkpID0+IGZuLmNhbGwodGhpcywgdGhpcy53cmFwKG4pLCBpKSk7XG4gIH1cblxuICAvKipcbiAgICogUmVkdWNlcyB0aGUgY3VycmVudCBhcnJheSBvZiBub2RlcyB0byBhIHZhbHVlLiBFYWNoIG5vZGUgaXMgcGFzc2VkIGluIGFzIGEgYFNoYWxsb3dXcmFwcGVyYFxuICAgKiB0byB0aGUgcmVkdWNlciBmdW5jdGlvbi5cbiAgICpcbiAgICogQHBhcmFtIHtGdW5jdGlvbn0gZm4gLSB0aGUgcmVkdWNlciBmdW5jdGlvblxuICAgKiBAcGFyYW0geyp9IGluaXRpYWxWYWx1ZSAtIHRoZSBpbml0aWFsIHZhbHVlXG4gICAqIEByZXR1cm5zIHsqfVxuICAgKi9cbiAgcmVkdWNlKGZuLCBpbml0aWFsVmFsdWUgPSB1bmRlZmluZWQpIHtcbiAgICBpZiAoYXJndW1lbnRzLmxlbmd0aCA+IDEpIHtcbiAgICAgIHJldHVybiB0aGlzLmdldE5vZGVzSW50ZXJuYWwoKS5yZWR1Y2UoXG4gICAgICAgIChhY2N1bSwgbiwgaSkgPT4gZm4uY2FsbCh0aGlzLCBhY2N1bSwgdGhpcy53cmFwKG4pLCBpKSxcbiAgICAgICAgaW5pdGlhbFZhbHVlLFxuICAgICAgKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuZ2V0Tm9kZXNJbnRlcm5hbCgpLnJlZHVjZSgoYWNjdW0sIG4sIGkpID0+IGZuLmNhbGwoXG4gICAgICB0aGlzLFxuICAgICAgaSA9PT0gMSA/IHRoaXMud3JhcChhY2N1bSkgOiBhY2N1bSxcbiAgICAgIHRoaXMud3JhcChuKSxcbiAgICAgIGksXG4gICAgKSk7XG4gIH1cblxuICAvKipcbiAgICogUmVkdWNlcyB0aGUgY3VycmVudCBhcnJheSBvZiBub2RlcyB0byBhbm90aGVyIGFycmF5LCBmcm9tIHJpZ2h0IHRvIGxlZnQuIEVhY2ggbm9kZSBpcyBwYXNzZWRcbiAgICogaW4gYXMgYSBgU2hhbGxvd1dyYXBwZXJgIHRvIHRoZSByZWR1Y2VyIGZ1bmN0aW9uLlxuICAgKlxuICAgKiBAcGFyYW0ge0Z1bmN0aW9ufSBmbiAtIHRoZSByZWR1Y2VyIGZ1bmN0aW9uXG4gICAqIEBwYXJhbSB7Kn0gaW5pdGlhbFZhbHVlIC0gdGhlIGluaXRpYWwgdmFsdWVcbiAgICogQHJldHVybnMgeyp9XG4gICAqL1xuICByZWR1Y2VSaWdodChmbiwgaW5pdGlhbFZhbHVlID0gdW5kZWZpbmVkKSB7XG4gICAgaWYgKGFyZ3VtZW50cy5sZW5ndGggPiAxKSB7XG4gICAgICByZXR1cm4gdGhpcy5nZXROb2Rlc0ludGVybmFsKCkucmVkdWNlUmlnaHQoXG4gICAgICAgIChhY2N1bSwgbiwgaSkgPT4gZm4uY2FsbCh0aGlzLCBhY2N1bSwgdGhpcy53cmFwKG4pLCBpKSxcbiAgICAgICAgaW5pdGlhbFZhbHVlLFxuICAgICAgKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuZ2V0Tm9kZXNJbnRlcm5hbCgpLnJlZHVjZVJpZ2h0KChhY2N1bSwgbiwgaSkgPT4gZm4uY2FsbChcbiAgICAgIHRoaXMsXG4gICAgICBpID09PSAxID8gdGhpcy53cmFwKGFjY3VtKSA6IGFjY3VtLFxuICAgICAgdGhpcy53cmFwKG4pLFxuICAgICAgaSxcbiAgICApKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgbmV3IHdyYXBwZXIgd2l0aCBhIHN1YnNldCBvZiB0aGUgbm9kZXMgb2YgdGhlIG9yaWdpbmFsIHdyYXBwZXIsIGFjY29yZGluZyB0byB0aGVcbiAgICogcnVsZXMgb2YgYEFycmF5I3NsaWNlYC5cbiAgICpcbiAgICogQHBhcmFtIHtOdW1iZXJ9IGJlZ2luXG4gICAqIEBwYXJhbSB7TnVtYmVyfSBlbmRcbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgc2xpY2UoYmVnaW4sIGVuZCkge1xuICAgIHJldHVybiB0aGlzLndyYXAodGhpcy5nZXROb2Rlc0ludGVybmFsKCkuc2xpY2UoYmVnaW4sIGVuZCkpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgd2hldGhlciBvciBub3QgYW55IG9mIHRoZSBub2RlcyBpbiB0aGUgd3JhcHBlciBtYXRjaCB0aGUgcHJvdmlkZWQgc2VsZWN0b3IuXG4gICAqXG4gICAqIEBwYXJhbSB7RW56eW1lU2VsZWN0b3J9IHNlbGVjdG9yXG4gICAqIEByZXR1cm5zIHtCb29sZWFufVxuICAgKi9cbiAgc29tZShzZWxlY3Rvcikge1xuICAgIGlmICh0aGlzW1JPT1RdID09PSB0aGlzKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpzb21lKCkgY2FuIG5vdCBiZSBjYWxsZWQgb24gdGhlIHJvb3QnKTtcbiAgICB9XG4gICAgY29uc3QgcHJlZGljYXRlID0gYnVpbGRQcmVkaWNhdGUoc2VsZWN0b3IpO1xuICAgIHJldHVybiB0aGlzLmdldE5vZGVzSW50ZXJuYWwoKS5zb21lKHByZWRpY2F0ZSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB3aGV0aGVyIG9yIG5vdCBhbnkgb2YgdGhlIG5vZGVzIGluIHRoZSB3cmFwcGVyIHBhc3MgdGhlIHByb3ZpZGVkIHByZWRpY2F0ZSBmdW5jdGlvbi5cbiAgICpcbiAgICogQHBhcmFtIHtGdW5jdGlvbn0gcHJlZGljYXRlXG4gICAqIEByZXR1cm5zIHtCb29sZWFufVxuICAgKi9cbiAgc29tZVdoZXJlKHByZWRpY2F0ZSkge1xuICAgIHJldHVybiB0aGlzLmdldE5vZGVzSW50ZXJuYWwoKS5zb21lKChuLCBpKSA9PiBwcmVkaWNhdGUuY2FsbCh0aGlzLCB0aGlzLndyYXAobiksIGkpKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHdoZXRoZXIgb3Igbm90IGFsbCBvZiB0aGUgbm9kZXMgaW4gdGhlIHdyYXBwZXIgbWF0Y2ggdGhlIHByb3ZpZGVkIHNlbGVjdG9yLlxuICAgKlxuICAgKiBAcGFyYW0ge0VuenltZVNlbGVjdG9yfSBzZWxlY3RvclxuICAgKiBAcmV0dXJucyB7Qm9vbGVhbn1cbiAgICovXG4gIGV2ZXJ5KHNlbGVjdG9yKSB7XG4gICAgY29uc3QgcHJlZGljYXRlID0gYnVpbGRQcmVkaWNhdGUoc2VsZWN0b3IpO1xuICAgIHJldHVybiB0aGlzLmdldE5vZGVzSW50ZXJuYWwoKS5ldmVyeShwcmVkaWNhdGUpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgd2hldGhlciBvciBub3QgYW55IG9mIHRoZSBub2RlcyBpbiB0aGUgd3JhcHBlciBwYXNzIHRoZSBwcm92aWRlZCBwcmVkaWNhdGUgZnVuY3Rpb24uXG4gICAqXG4gICAqIEBwYXJhbSB7RnVuY3Rpb259IHByZWRpY2F0ZVxuICAgKiBAcmV0dXJucyB7Qm9vbGVhbn1cbiAgICovXG4gIGV2ZXJ5V2hlcmUocHJlZGljYXRlKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Tm9kZXNJbnRlcm5hbCgpLmV2ZXJ5KChuLCBpKSA9PiBwcmVkaWNhdGUuY2FsbCh0aGlzLCB0aGlzLndyYXAobiksIGkpKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBVdGlsaXR5IG1ldGhvZCB1c2VkIHRvIGNyZWF0ZSBuZXcgd3JhcHBlcnMgd2l0aCBhIG1hcHBpbmcgZnVuY3Rpb24gdGhhdCByZXR1cm5zIGFuIGFycmF5IG9mXG4gICAqIG5vZGVzIGluIHJlc3BvbnNlIHRvIGEgc2luZ2xlIG5vZGUgd3JhcHBlci4gVGhlIHJldHVybmVkIHdyYXBwZXIgaXMgYSBzaW5nbGUgd3JhcHBlciBhcm91bmRcbiAgICogYWxsIG9mIHRoZSBtYXBwZWQgbm9kZXMgZmxhdHRlbmVkIChhbmQgZGUtZHVwbGljYXRlZCkuXG4gICAqXG4gICAqIEBwYXJhbSB7RnVuY3Rpb259IGZuXG4gICAqIEByZXR1cm5zIHtTaGFsbG93V3JhcHBlcn1cbiAgICovXG4gIGZsYXRNYXAoZm4pIHtcbiAgICBjb25zdCBub2RlcyA9IHRoaXMuZ2V0Tm9kZXNJbnRlcm5hbCgpLm1hcCgobiwgaSkgPT4gZm4uY2FsbCh0aGlzLCB0aGlzLndyYXAobiksIGkpKTtcbiAgICBjb25zdCBmbGF0dGVuZWQgPSBmbGF0KG5vZGVzLCAxKTtcbiAgICByZXR1cm4gdGhpcy53cmFwKGZsYXR0ZW5lZC5maWx0ZXIoQm9vbGVhbikpO1xuICB9XG5cbiAgLyoqXG4gICAqIEZpbmRzIGFsbCBub2RlcyBpbiB0aGUgY3VycmVudCB3cmFwcGVyIG5vZGVzJyByZW5kZXIgdHJlZXMgdGhhdCBtYXRjaCB0aGUgcHJvdmlkZWQgcHJlZGljYXRlXG4gICAqIGZ1bmN0aW9uLiBUaGUgcHJlZGljYXRlIGZ1bmN0aW9uIHdpbGwgcmVjZWl2ZSB0aGUgbm9kZXMgaW5zaWRlIGEgU2hhbGxvd1dyYXBwZXIgYXMgaXRzXG4gICAqIGZpcnN0IGFyZ3VtZW50LlxuICAgKlxuICAgKiBAcGFyYW0ge0Z1bmN0aW9ufSBwcmVkaWNhdGVcbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgZmluZFdoZXJlKHByZWRpY2F0ZSkge1xuICAgIHJldHVybiBmaW5kV2hlcmVVbndyYXBwZWQodGhpcywgKG4pID0+IHtcbiAgICAgIGNvbnN0IG5vZGUgPSB0aGlzLndyYXAobik7XG4gICAgICByZXR1cm4gbm9kZS5sZW5ndGggPiAwICYmIHByZWRpY2F0ZShub2RlKTtcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSBub2RlIGF0IGEgZ2l2ZW4gaW5kZXggb2YgdGhlIGN1cnJlbnQgd3JhcHBlci5cbiAgICpcbiAgICogQHBhcmFtIGluZGV4XG4gICAqIEByZXR1cm5zIHtSZWFjdEVsZW1lbnR9XG4gICAqL1xuICBnZXQoaW5kZXgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRFbGVtZW50cygpW2luZGV4XTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgd3JhcHBlciBhcm91bmQgdGhlIG5vZGUgYXQgYSBnaXZlbiBpbmRleCBvZiB0aGUgY3VycmVudCB3cmFwcGVyLlxuICAgKlxuICAgKiBAcGFyYW0gaW5kZXhcbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgYXQoaW5kZXgpIHtcbiAgICBjb25zdCBub2RlcyA9IHRoaXMuZ2V0Tm9kZXNJbnRlcm5hbCgpO1xuICAgIGlmIChpbmRleCA8IG5vZGVzLmxlbmd0aCkge1xuICAgICAgcmV0dXJuIHRoaXMud3JhcChub2Rlc1tpbmRleF0pO1xuICAgIH1cbiAgICByZXR1cm4gdGhpcy53cmFwKFtdKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgd3JhcHBlciBhcm91bmQgdGhlIGZpcnN0IG5vZGUgb2YgdGhlIGN1cnJlbnQgd3JhcHBlci5cbiAgICpcbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgZmlyc3QoKSB7XG4gICAgcmV0dXJuIHRoaXMuYXQoMCk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIHdyYXBwZXIgYXJvdW5kIHRoZSBsYXN0IG5vZGUgb2YgdGhlIGN1cnJlbnQgd3JhcHBlci5cbiAgICpcbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgbGFzdCgpIHtcbiAgICByZXR1cm4gdGhpcy5hdCh0aGlzLmxlbmd0aCAtIDEpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGVnYXRlcyB0byBleGlzdHMoKVxuICAgKlxuICAgKiBAcmV0dXJucyB7Ym9vbGVhbn1cbiAgICovXG4gIGlzRW1wdHkoKSB7XG4gICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWNvbnNvbGVcbiAgICBjb25zb2xlLndhcm4oJ0VuenltZTo6RGVwcmVjYXRlZCBtZXRob2QgaXNFbXB0eSgpIGNhbGxlZCwgdXNlIGV4aXN0cygpIGluc3RlYWQuJyk7XG4gICAgcmV0dXJuICF0aGlzLmV4aXN0cygpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdHJ1ZSBpZiB0aGUgY3VycmVudCB3cmFwcGVyIGhhcyBub2Rlcy4gRmFsc2Ugb3RoZXJ3aXNlLlxuICAgKiBJZiBjYWxsZWQgd2l0aCBhIHNlbGVjdG9yIGl0IHJldHVybnMgYC5maW5kKHNlbGVjdG9yKS5leGlzdHMoKWAgaW5zdGVhZC5cbiAgICpcbiAgICogQHBhcmFtIHtFbnp5bWVTZWxlY3Rvcn0gc2VsZWN0b3IgKG9wdGlvbmFsKVxuICAgKiBAcmV0dXJucyB7Ym9vbGVhbn1cbiAgICovXG4gIGV4aXN0cyhzZWxlY3RvciA9IG51bGwpIHtcbiAgICByZXR1cm4gYXJndW1lbnRzLmxlbmd0aCA+IDAgPyB0aGlzLmZpbmQoc2VsZWN0b3IpLmV4aXN0cygpIDogdGhpcy5sZW5ndGggPiAwO1xuICB9XG5cbiAgLyoqXG4gICAqIFV0aWxpdHkgbWV0aG9kIHRoYXQgdGhyb3dzIGFuIGVycm9yIGlmIHRoZSBjdXJyZW50IGluc3RhbmNlIGhhcyBhIGxlbmd0aCBvdGhlciB0aGFuIG9uZS5cbiAgICogVGhpcyBpcyBwcmltYXJpbHkgdXNlZCB0byBlbmZvcmNlIHRoYXQgY2VydGFpbiBtZXRob2RzIGFyZSBvbmx5IHJ1biBvbiBhIHdyYXBwZXIgd2hlbiBpdCBpc1xuICAgKiB3cmFwcGluZyBhIHNpbmdsZSBub2RlLlxuICAgKlxuICAgKiBAcGFyYW0gZm5cbiAgICogQHJldHVybnMgeyp9XG4gICAqL1xuICBzaW5nbGUobmFtZSwgZm4pIHtcbiAgICBjb25zdCBmbk5hbWUgPSB0eXBlb2YgbmFtZSA9PT0gJ3N0cmluZycgPyBuYW1lIDogJ3Vua25vd24nO1xuICAgIGNvbnN0IGNhbGxiYWNrID0gdHlwZW9mIGZuID09PSAnZnVuY3Rpb24nID8gZm4gOiBuYW1lO1xuICAgIGlmICh0aGlzLmxlbmd0aCAhPT0gMSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBNZXRob2Qg4oCcJHtmbk5hbWV94oCdIGlzIG1lYW50IHRvIGJlIHJ1biBvbiAxIG5vZGUuICR7dGhpcy5sZW5ndGh9IGZvdW5kIGluc3RlYWQuYCk7XG4gICAgfVxuICAgIHJldHVybiBjYWxsYmFjay5jYWxsKHRoaXMsIHRoaXMuZ2V0Tm9kZUludGVybmFsKCkpO1xuICB9XG5cbiAgLyoqXG4gICAqIEhlbHBmdWwgdXRpbGl0eSBtZXRob2QgdG8gY3JlYXRlIGEgbmV3IHdyYXBwZXIgd2l0aCB0aGUgc2FtZSByb290IGFzIHRoZSBjdXJyZW50IHdyYXBwZXIsIHdpdGhcbiAgICogYW55IG5vZGVzIHBhc3NlZCBpbiBhcyB0aGUgZmlyc3QgcGFyYW1ldGVyIGF1dG9tYXRpY2FsbHkgd3JhcHBlZC5cbiAgICpcbiAgICogQHBhcmFtIG5vZGVcbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgd3JhcChub2RlLCByb290ID0gdGhpc1tST09UXSwgLi4uYXJncykge1xuICAgIGlmIChub2RlIGluc3RhbmNlb2YgU2hhbGxvd1dyYXBwZXIpIHtcbiAgICAgIHJldHVybiBub2RlO1xuICAgIH1cbiAgICByZXR1cm4gbmV3IFNoYWxsb3dXcmFwcGVyKG5vZGUsIHJvb3QsIC4uLmFyZ3MpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYW4gSFRNTC1saWtlIHN0cmluZyBvZiB0aGUgc2hhbGxvdyByZW5kZXIgZm9yIGRlYnVnZ2luZyBwdXJwb3Nlcy5cbiAgICpcbiAgICogQHBhcmFtIHtPYmplY3R9IFtvcHRpb25zXSAtIFByb3BlcnR5IGJhZyBvZiBhZGRpdGlvbmFsIG9wdGlvbnMuXG4gICAqIEBwYXJhbSB7Ym9vbGVhbn0gW29wdGlvbnMuaWdub3JlUHJvcHNdIC0gaWYgdHJ1ZSwgcHJvcHMgYXJlIG9taXR0ZWQgZnJvbSB0aGUgc3RyaW5nLlxuICAgKiBAcGFyYW0ge2Jvb2xlYW59IFtvcHRpb25zLnZlcmJvc2VdIC0gaWYgdHJ1ZSwgYXJyYXlzIGFuZCBvYmplY3RzIHRvIGJlIHZlcmJvc2VseSBwcmludGVkLlxuICAgKiBAcmV0dXJucyB7U3RyaW5nfVxuICAgKi9cbiAgZGVidWcob3B0aW9ucyA9IHt9KSB7XG4gICAgcmV0dXJuIGRlYnVnTm9kZXModGhpcy5nZXROb2Rlc0ludGVybmFsKCksIG9wdGlvbnMpO1xuICB9XG5cbiAgLyoqXG4gICAqIEludm9rZXMgaW50ZXJjZXB0ZXIgYW5kIHJldHVybnMgaXRzZWxmLiBpbnRlcmNlcHRlciBpcyBjYWxsZWQgd2l0aCBpdHNlbGYuXG4gICAqIFRoaXMgaXMgaGVscGZ1bCB3aGVuIGRlYnVnZ2luZyBub2RlcyBpbiBtZXRob2QgY2hhaW5zLlxuICAgKiBAcGFyYW0gZm5cbiAgICogQHJldHVybnMge1NoYWxsb3dXcmFwcGVyfVxuICAgKi9cbiAgdGFwKGludGVyY2VwdGVyKSB7XG4gICAgaW50ZXJjZXB0ZXIodGhpcyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUHJpbWFyaWx5IHVzZWZ1bCBmb3IgSE9DcyAoaGlnaGVyLW9yZGVyIGNvbXBvbmVudHMpLCB0aGlzIG1ldGhvZCBtYXkgb25seSBiZVxuICAgKiBydW4gb24gYSBzaW5nbGUsIG5vbi1ET00gbm9kZSwgYW5kIHdpbGwgcmV0dXJuIHRoZSBub2RlLCBzaGFsbG93LXJlbmRlcmVkLlxuICAgKlxuICAgKiBAcGFyYW0ge09iamVjdH0gb3B0aW9uc1xuICAgKiBAcmV0dXJucyB7U2hhbGxvd1dyYXBwZXJ9XG4gICAqL1xuICBkaXZlKG9wdGlvbnMgPSB7fSkge1xuICAgIGNvbnN0IGFkYXB0ZXIgPSBnZXRBZGFwdGVyKHRoaXNbT1BUSU9OU10pO1xuICAgIGNvbnN0IG5hbWUgPSAnZGl2ZSc7XG4gICAgcmV0dXJuIHRoaXMuc2luZ2xlKG5hbWUsIChuKSA9PiB7XG4gICAgICBpZiAobiAmJiBuLm5vZGVUeXBlID09PSAnaG9zdCcpIHtcbiAgICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihgU2hhbGxvd1dyYXBwZXI6OiR7bmFtZX0oKSBjYW4gbm90IGJlIGNhbGxlZCBvbiBIb3N0IENvbXBvbmVudHNgKTtcbiAgICAgIH1cbiAgICAgIGNvbnN0IGVsID0gZ2V0QWRhcHRlcih0aGlzW09QVElPTlNdKS5ub2RlVG9FbGVtZW50KG4pO1xuICAgICAgaWYgKCFpc0N1c3RvbUNvbXBvbmVudEVsZW1lbnQoZWwsIGFkYXB0ZXIpKSB7XG4gICAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoYFNoYWxsb3dXcmFwcGVyOjoke25hbWV9KCkgY2FuIG9ubHkgYmUgY2FsbGVkIG9uIGNvbXBvbmVudHNgKTtcbiAgICAgIH1cbiAgICAgIGNvbnN0IGNoaWxkT3B0aW9ucyA9IHtcbiAgICAgICAgLi4udGhpc1tPUFRJT05TXSxcbiAgICAgICAgLi4ub3B0aW9ucyxcbiAgICAgICAgY29udGV4dDogb3B0aW9ucy5jb250ZXh0IHx8IHtcbiAgICAgICAgICAuLi50aGlzW09QVElPTlNdLmNvbnRleHQsXG4gICAgICAgICAgLi4udGhpc1tST09UXVtDSElMRF9DT05URVhUXSxcbiAgICAgICAgfSxcbiAgICAgIH07XG4gICAgICBwcml2YXRlU2V0KGNoaWxkT3B0aW9ucywgUFJPVklERVJfVkFMVUVTLCB0aGlzW1JPT1RdW1BST1ZJREVSX1ZBTFVFU10pO1xuICAgICAgcmV0dXJuIHRoaXMud3JhcChlbCwgbnVsbCwgY2hpbGRPcHRpb25zKTtcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBTdHJpcHMgb3V0IGFsbCB0aGUgbm90IGhvc3Qtbm9kZXMgZnJvbSB0aGUgbGlzdCBvZiBub2Rlc1xuICAgKlxuICAgKiBUaGlzIG1ldGhvZCBpcyB1c2VmdWwgaWYgeW91IHdhbnQgdG8gY2hlY2sgZm9yIHRoZSBwcmVzZW5jZSBvZiBob3N0IG5vZGVzXG4gICAqIChhY3R1YWxseSByZW5kZXJlZCBIVE1MIGVsZW1lbnRzKSBpZ25vcmluZyB0aGUgUmVhY3Qgbm9kZXMuXG4gICAqL1xuICBob3N0Tm9kZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZmlsdGVyV2hlcmUobiA9PiB0eXBlb2Ygbi50eXBlKCkgPT09ICdzdHJpbmcnKTtcbiAgfVxufVxuXG4vKipcbiAqIFVwZGF0ZXMgdGhlIGNvbnRleHQgb2YgdGhlIHByaW1hcnkgd3JhcHBlciB3aGVuIHRoZVxuICogYHdyYXBwaW5nQ29tcG9uZW50YCByZS1yZW5kZXJzLlxuICovXG5mdW5jdGlvbiB1cGRhdGVQcmltYXJ5Um9vdENvbnRleHQod3JhcHBpbmdDb21wb25lbnQpIHtcbiAgY29uc3QgYWRhcHRlciA9IGdldEFkYXB0ZXIod3JhcHBpbmdDb21wb25lbnRbT1BUSU9OU10pO1xuICBjb25zdCBwcmltYXJ5V3JhcHBlciA9IHdyYXBwaW5nQ29tcG9uZW50W1BSSU1BUllfV1JBUFBFUl07XG4gIGNvbnN0IHByaW1hcnlSZW5kZXJlciA9IHByaW1hcnlXcmFwcGVyW1JFTkRFUkVSXTtcbiAgY29uc3QgcHJpbWFyeU5vZGUgPSBwcmltYXJ5UmVuZGVyZXIuZ2V0Tm9kZSgpO1xuICBjb25zdCB7XG4gICAgbGVnYWN5Q29udGV4dCxcbiAgICBwcm92aWRlclZhbHVlcyxcbiAgfSA9IGdldENvbnRleHRGcm9tV3JhcHBpbmdDb21wb25lbnQod3JhcHBpbmdDb21wb25lbnQsIGFkYXB0ZXIpO1xuICBjb25zdCBwcmV2UHJvdmlkZXJWYWx1ZXMgPSBwcmltYXJ5V3JhcHBlcltQUk9WSURFUl9WQUxVRVNdO1xuXG4gIHByaW1hcnlXcmFwcGVyLnNldENvbnRleHQoe1xuICAgIC4uLndyYXBwaW5nQ29tcG9uZW50W1BSSU1BUllfV1JBUFBFUl1bT1BUSU9OU10uY29udGV4dCxcbiAgICAuLi5sZWdhY3lDb250ZXh0LFxuICB9KTtcbiAgcHJpbWFyeVdyYXBwZXJbUFJPVklERVJfVkFMVUVTXSA9IG5ldyBNYXAoWy4uLnByZXZQcm92aWRlclZhbHVlcywgLi4ucHJvdmlkZXJWYWx1ZXNdKTtcblxuICBpZiAodHlwZW9mIGFkYXB0ZXIuaXNDb250ZXh0Q29uc3VtZXIgPT09ICdmdW5jdGlvbicgJiYgYWRhcHRlci5pc0NvbnRleHRDb25zdW1lcihwcmltYXJ5Tm9kZS50eXBlKSkge1xuICAgIGNvbnN0IENvbnN1bWVyID0gcHJpbWFyeU5vZGUudHlwZTtcbiAgICAvLyBBZGFwdGVycyB3aXRoIGFuIGBpc0NvbnRleHRDb25zdW1lcmAgbWV0aG9kIHdpbGwgZGVmaW5pdGVseSBoYXZlIGEgYGdldFByb3ZpZGVyRnJvbUNvbnN1bWVyYFxuICAgIC8vIG1ldGhvZC5cbiAgICBjb25zdCBQcm92aWRlciA9IGFkYXB0ZXIuZ2V0UHJvdmlkZXJGcm9tQ29uc3VtZXIoQ29uc3VtZXIpO1xuICAgIGNvbnN0IG5ld1ZhbHVlID0gcHJvdmlkZXJWYWx1ZXMuZ2V0KFByb3ZpZGVyKTtcbiAgICBjb25zdCBvbGRWYWx1ZSA9IHByZXZQcm92aWRlclZhbHVlcy5nZXQoUHJvdmlkZXIpO1xuXG4gICAgLy8gVXNlIHJlZmVyZW50aWFsIGNvbXBhcmlzb24gbGlrZSBSZWFjdFxuICAgIGlmIChuZXdWYWx1ZSAhPT0gb2xkVmFsdWUpIHtcbiAgICAgIHByaW1hcnlXcmFwcGVyLnJlcmVuZGVyKCk7XG4gICAgfVxuICB9XG59XG5cbi8qKlxuICogQSAqc3BlY2lhbCogXCJyb290XCIgd3JhcHBlciB0aGF0IHJlcHJlc2VudHMgdGhlIGNvbXBvbmVudCBwYXNzZWQgYXMgYHdyYXBwaW5nQ29tcG9uZW50YC5cbiAqIEl0IGlzIGxpbmtlZCB0byB0aGUgcHJpbWFyeSByb290IHN1Y2ggdGhhdCB1cGRhdGVzIHRvIGl0IHdpbGwgdXBkYXRlIHRoZSBwcmltYXJ5LlxuICpcbiAqIEBjbGFzcyBXcmFwcGluZ0NvbXBvbmVudFdyYXBwZXJcbiAqL1xuY2xhc3MgV3JhcHBpbmdDb21wb25lbnRXcmFwcGVyIGV4dGVuZHMgU2hhbGxvd1dyYXBwZXIge1xuICBjb25zdHJ1Y3Rvcihub2Rlcywgcm9vdCwgUm9vdEZpbmRlcikge1xuICAgIHN1cGVyKG5vZGVzKTtcbiAgICBwcml2YXRlU2V0KHRoaXMsIFBSSU1BUllfV1JBUFBFUiwgcm9vdCk7XG4gICAgcHJpdmF0ZVNldCh0aGlzLCBST09UX0ZJTkRFUiwgUm9vdEZpbmRlcik7XG4gIH1cblxuICAvKipcbiAgICogTGlrZSByZXJlbmRlcigpIG9uIFNoYWxsb3dXcmFwcGVyLCBleGNlcHQgaXQgYWxzbyBkb2VzIGEgXCJmdWxsIHJlbmRlclwiIG9mXG4gICAqIGl0c2VsZiBhbmQgdXBkYXRlcyB0aGUgcHJpbWFyeSBTaGFsbG93V3JhcHBlcidzIGNvbnRleHQuXG4gICAqL1xuICByZXJlbmRlciguLi5hcmdzKSB7XG4gICAgY29uc3QgcmVzdWx0ID0gc3VwZXIucmVyZW5kZXIoLi4uYXJncyk7XG4gICAgdXBkYXRlUHJpbWFyeVJvb3RDb250ZXh0KHRoaXMpO1xuICAgIHJldHVybiByZXN1bHQ7XG4gIH1cblxuICAvKipcbiAgICogTGlrZSBzZXRTdGF0ZSgpIG9uIFNoYWxsb3dXcmFwcGVyLCBleGNlcHQgaXQgYWxzbyBkb2VzIGEgXCJmdWxsIHJlbmRlclwiIG9mXG4gICAqIGl0c2VsZiBhbmQgdXBkYXRlcyB0aGUgcHJpbWFyeSBTaGFsbG93V3JhcHBlcidzIGNvbnRleHQuXG4gICAqL1xuICBzZXRTdGF0ZSguLi5hcmdzKSB7XG4gICAgY29uc3QgcmVzdWx0ID0gc3VwZXIuc2V0U3RhdGUoLi4uYXJncyk7XG4gICAgdXBkYXRlUHJpbWFyeVJvb3RDb250ZXh0KHRoaXMpO1xuICAgIHJldHVybiByZXN1bHQ7XG4gIH1cblxuICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgY2xhc3MtbWV0aG9kcy11c2UtdGhpc1xuICBnZXRXcmFwcGluZ0NvbXBvbmVudCgpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ1NoYWxsb3dXcmFwcGVyOjpnZXRXcmFwcGluZ0NvbXBvbmVudCgpIGNhbiBvbmx5IGJlIGNhbGxlZCBvbiB0aGUgcm9vdCcpO1xuICB9XG59XG5cbmlmIChJVEVSQVRPUl9TWU1CT0wpIHtcbiAgT2JqZWN0LmRlZmluZVByb3BlcnR5KFNoYWxsb3dXcmFwcGVyLnByb3RvdHlwZSwgSVRFUkFUT1JfU1lNQk9MLCB7XG4gICAgY29uZmlndXJhYmxlOiB0cnVlLFxuICAgIHZhbHVlOiBmdW5jdGlvbiBpdGVyYXRvcigpIHtcbiAgICAgIGNvbnN0IGl0ZXIgPSB0aGlzLmdldE5vZGVzSW50ZXJuYWwoKVtJVEVSQVRPUl9TWU1CT0xdKCk7XG4gICAgICBjb25zdCBhZGFwdGVyID0gZ2V0QWRhcHRlcih0aGlzW09QVElPTlNdKTtcbiAgICAgIHJldHVybiB7XG4gICAgICAgIFtJVEVSQVRPUl9TWU1CT0xdKCkgeyByZXR1cm4gdGhpczsgfSxcbiAgICAgICAgbmV4dCgpIHtcbiAgICAgICAgICBjb25zdCBuZXh0ID0gaXRlci5uZXh0KCk7XG4gICAgICAgICAgaWYgKG5leHQuZG9uZSkge1xuICAgICAgICAgICAgcmV0dXJuIHsgZG9uZTogdHJ1ZSB9O1xuICAgICAgICAgIH1cbiAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgZG9uZTogZmFsc2UsXG4gICAgICAgICAgICB2YWx1ZTogYWRhcHRlci5ub2RlVG9FbGVtZW50KG5leHQudmFsdWUpLFxuICAgICAgICAgIH07XG4gICAgICAgIH0sXG4gICAgICB9O1xuICAgIH0sXG4gIH0pO1xufVxuXG5mdW5jdGlvbiBwcml2YXRlV2FybmluZyhwcm9wLCBleHRyYU1lc3NhZ2UpIHtcbiAgT2JqZWN0LmRlZmluZVByb3BlcnR5KFNoYWxsb3dXcmFwcGVyLnByb3RvdHlwZSwgcHJvcCwge1xuICAgIGdldCgpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgXG4gICAgICAgIEF0dGVtcHRlZCB0byBhY2Nlc3MgU2hhbGxvd1dyYXBwZXI6OiR7cHJvcH0sIHdoaWNoIHdhcyBwcmV2aW91c2x5IGEgcHJpdmF0ZSBwcm9wZXJ0eSBvblxuICAgICAgICBFbnp5bWUgU2hhbGxvd1dyYXBwZXIgaW5zdGFuY2VzLCBidXQgaXMgbm8gbG9uZ2VyIGFuZCBzaG91bGQgbm90IGJlIHJlbGllZCB1cG9uLlxuICAgICAgICAke2V4dHJhTWVzc2FnZX1cbiAgICAgIGApO1xuICAgIH0sXG4gICAgZW51bWVyYWJsZTogZmFsc2UsXG4gICAgY29uZmlndXJhYmxlOiBmYWxzZSxcbiAgfSk7XG59XG5cbnByaXZhdGVXYXJuaW5nKCdub2RlJywgJ0NvbnNpZGVyIHVzaW5nIHRoZSBnZXRFbGVtZW50KCkgbWV0aG9kIGluc3RlYWQuJyk7XG5wcml2YXRlV2FybmluZygnbm9kZXMnLCAnQ29uc2lkZXIgdXNpbmcgdGhlIGdldEVsZW1lbnRzKCkgbWV0aG9kIGluc3RlYWQuJyk7XG5wcml2YXRlV2FybmluZygncmVuZGVyZXInLCAnJyk7XG5wcml2YXRlV2FybmluZygnb3B0aW9ucycsICcnKTtcbnByaXZhdGVXYXJuaW5nKCdjb21wbGV4U2VsZWN0b3InLCAnJyk7XG5cbmV4cG9ydCBkZWZhdWx0IFNoYWxsb3dXcmFwcGVyO1xuIl19
//# sourceMappingURL=ShallowWrapper.js.map