import PropTypes from 'prop-types';
import { Component } from 'react';
import { ColorResult } from 'react-color';
import { KnobControlConfig, KnobControlProps } from './types';
declare type ColorTypeKnobValue = string;
export declare type ColorTypeKnob = KnobControlConfig<ColorTypeKnobValue>;
declare type ColorTypeProps = KnobControlProps<ColorTypeKnobValue>;
interface ColorTypeState {
    displayColorPicker: boolean;
}
export default class ColorType extends Component<ColorTypeProps, ColorTypeState> {
    static propTypes: {
        knob: PropTypes.Validator<KnobControlConfig<string>>;
        onChange: PropTypes.Validator<(value: string) => string>;
    };
    static defaultProps: ColorTypeProps;
    static serialize: (value: string) => string;
    static deserialize: (value: string) => string;
    state: ColorTypeState;
    popover: HTMLDivElement;
    componentDidMount(): void;
    shouldComponentUpdate(nextProps: ColorTypeProps, nextState: ColorTypeState): boolean;
    componentWillUnmount(): void;
    handleWindowMouseDown: (e: MouseEvent) => void;
    handleClick: () => void;
    handleChange: (color: ColorResult) => void;
    render(): JSX.Element;
}
export {};
