/*!
 *
 */
var process = process || { env: {NODE_ENV: 'lib'}}; 
var ustore_core = (function (exports) {
  'use strict';

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  };

  var classCallCheck = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };

  var createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();

  var defineProperty = function (obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  };

  var slicedToArray = function () {
    function sliceIterator(arr, i) {
      var _arr = [];
      var _n = true;
      var _d = false;
      var _e = undefined;

      try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);

          if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;
        _e = err;
      } finally {
        try {
          if (!_n && _i["return"]) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }

      return _arr;
    }

    return function (arr, i) {
      if (Array.isArray(arr)) {
        return arr;
      } else if (Symbol.iterator in Object(arr)) {
        return sliceIterator(arr, i);
      } else {
        throw new TypeError("Invalid attempt to destructure non-iterable instance");
      }
    };
  }();

  var toConsumableArray = function (arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

      return arr2;
    } else {
      return Array.from(arr);
    }
  };

  var global$1 = typeof globalThis !== 'undefined' && globalThis || typeof self !== 'undefined' && self || typeof global$1 !== 'undefined' && global$1;

  var support = {
    searchParams: 'URLSearchParams' in global$1,
    iterable: 'Symbol' in global$1 && 'iterator' in Symbol,
    blob: 'FileReader' in global$1 && 'Blob' in global$1 && function () {
      try {
        new Blob();
        return true;
      } catch (e) {
        return false;
      }
    }(),
    formData: 'FormData' in global$1,
    arrayBuffer: 'ArrayBuffer' in global$1
  };

  function isDataView(obj) {
    return obj && DataView.prototype.isPrototypeOf(obj);
  }

  if (support.arrayBuffer) {
    var viewClasses = ['[object Int8Array]', '[object Uint8Array]', '[object Uint8ClampedArray]', '[object Int16Array]', '[object Uint16Array]', '[object Int32Array]', '[object Uint32Array]', '[object Float32Array]', '[object Float64Array]'];

    var isArrayBufferView = ArrayBuffer.isView || function (obj) {
      return obj && viewClasses.indexOf(Object.prototype.toString.call(obj)) > -1;
    };
  }

  function normalizeName(name) {
    if (typeof name !== 'string') {
      name = String(name);
    }
    if (/[^a-z0-9\-#$%&'*+.^_`|~!]/i.test(name) || name === '') {
      throw new TypeError('Invalid character in header field name');
    }
    return name.toLowerCase();
  }

  function normalizeValue(value) {
    if (typeof value !== 'string') {
      value = String(value);
    }
    return value;
  }

  // Build a destructive iterator for the value list
  function iteratorFor(items) {
    var iterator = {
      next: function next() {
        var value = items.shift();
        return { done: value === undefined, value: value };
      }
    };

    if (support.iterable) {
      iterator[Symbol.iterator] = function () {
        return iterator;
      };
    }

    return iterator;
  }

  function Headers(headers) {
    this.map = {};

    if (headers instanceof Headers) {
      headers.forEach(function (value, name) {
        this.append(name, value);
      }, this);
    } else if (Array.isArray(headers)) {
      headers.forEach(function (header) {
        this.append(header[0], header[1]);
      }, this);
    } else if (headers) {
      Object.getOwnPropertyNames(headers).forEach(function (name) {
        this.append(name, headers[name]);
      }, this);
    }
  }

  Headers.prototype.append = function (name, value) {
    name = normalizeName(name);
    value = normalizeValue(value);
    var oldValue = this.map[name];
    this.map[name] = oldValue ? oldValue + ', ' + value : value;
  };

  Headers.prototype['delete'] = function (name) {
    delete this.map[normalizeName(name)];
  };

  Headers.prototype.get = function (name) {
    name = normalizeName(name);
    return this.has(name) ? this.map[name] : null;
  };

  Headers.prototype.has = function (name) {
    return this.map.hasOwnProperty(normalizeName(name));
  };

  Headers.prototype.set = function (name, value) {
    this.map[normalizeName(name)] = normalizeValue(value);
  };

  Headers.prototype.forEach = function (callback, thisArg) {
    for (var name in this.map) {
      if (this.map.hasOwnProperty(name)) {
        callback.call(thisArg, this.map[name], name, this);
      }
    }
  };

  Headers.prototype.keys = function () {
    var items = [];
    this.forEach(function (value, name) {
      items.push(name);
    });
    return iteratorFor(items);
  };

  Headers.prototype.values = function () {
    var items = [];
    this.forEach(function (value) {
      items.push(value);
    });
    return iteratorFor(items);
  };

  Headers.prototype.entries = function () {
    var items = [];
    this.forEach(function (value, name) {
      items.push([name, value]);
    });
    return iteratorFor(items);
  };

  if (support.iterable) {
    Headers.prototype[Symbol.iterator] = Headers.prototype.entries;
  }

  function consumed(body) {
    if (body.bodyUsed) {
      return Promise.reject(new TypeError('Already read'));
    }
    body.bodyUsed = true;
  }

  function fileReaderReady(reader) {
    return new Promise(function (resolve, reject) {
      reader.onload = function () {
        resolve(reader.result);
      };
      reader.onerror = function () {
        reject(reader.error);
      };
    });
  }

  function readBlobAsArrayBuffer(blob) {
    var reader = new FileReader();
    var promise = fileReaderReady(reader);
    reader.readAsArrayBuffer(blob);
    return promise;
  }

  function readBlobAsText(blob) {
    var reader = new FileReader();
    var promise = fileReaderReady(reader);
    reader.readAsText(blob);
    return promise;
  }

  function readArrayBufferAsText(buf) {
    var view = new Uint8Array(buf);
    var chars = new Array(view.length);

    for (var i = 0; i < view.length; i++) {
      chars[i] = String.fromCharCode(view[i]);
    }
    return chars.join('');
  }

  function bufferClone(buf) {
    if (buf.slice) {
      return buf.slice(0);
    } else {
      var view = new Uint8Array(buf.byteLength);
      view.set(new Uint8Array(buf));
      return view.buffer;
    }
  }

  function Body() {
    this.bodyUsed = false;

    this._initBody = function (body) {
      /*
        fetch-mock wraps the Response object in an ES6 Proxy to
        provide useful test harness features such as flush. However, on
        ES5 browsers without fetch or Proxy support pollyfills must be used;
        the proxy-pollyfill is unable to proxy an attribute unless it exists
        on the object before the Proxy is created. This change ensures
        Response.bodyUsed exists on the instance, while maintaining the
        semantic of setting Request.bodyUsed in the constructor before
        _initBody is called.
      */
      this.bodyUsed = this.bodyUsed;
      this._bodyInit = body;
      if (!body) {
        this._bodyText = '';
      } else if (typeof body === 'string') {
        this._bodyText = body;
      } else if (support.blob && Blob.prototype.isPrototypeOf(body)) {
        this._bodyBlob = body;
      } else if (support.formData && FormData.prototype.isPrototypeOf(body)) {
        this._bodyFormData = body;
      } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
        this._bodyText = body.toString();
      } else if (support.arrayBuffer && support.blob && isDataView(body)) {
        this._bodyArrayBuffer = bufferClone(body.buffer);
        // IE 10-11 can't handle a DataView body.
        this._bodyInit = new Blob([this._bodyArrayBuffer]);
      } else if (support.arrayBuffer && (ArrayBuffer.prototype.isPrototypeOf(body) || isArrayBufferView(body))) {
        this._bodyArrayBuffer = bufferClone(body);
      } else {
        this._bodyText = body = Object.prototype.toString.call(body);
      }

      if (!this.headers.get('content-type')) {
        if (typeof body === 'string') {
          this.headers.set('content-type', 'text/plain;charset=UTF-8');
        } else if (this._bodyBlob && this._bodyBlob.type) {
          this.headers.set('content-type', this._bodyBlob.type);
        } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
          this.headers.set('content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
        }
      }
    };

    if (support.blob) {
      this.blob = function () {
        var rejected = consumed(this);
        if (rejected) {
          return rejected;
        }

        if (this._bodyBlob) {
          return Promise.resolve(this._bodyBlob);
        } else if (this._bodyArrayBuffer) {
          return Promise.resolve(new Blob([this._bodyArrayBuffer]));
        } else if (this._bodyFormData) {
          throw new Error('could not read FormData body as blob');
        } else {
          return Promise.resolve(new Blob([this._bodyText]));
        }
      };

      this.arrayBuffer = function () {
        if (this._bodyArrayBuffer) {
          var isConsumed = consumed(this);
          if (isConsumed) {
            return isConsumed;
          }
          if (ArrayBuffer.isView(this._bodyArrayBuffer)) {
            return Promise.resolve(this._bodyArrayBuffer.buffer.slice(this._bodyArrayBuffer.byteOffset, this._bodyArrayBuffer.byteOffset + this._bodyArrayBuffer.byteLength));
          } else {
            return Promise.resolve(this._bodyArrayBuffer);
          }
        } else {
          return this.blob().then(readBlobAsArrayBuffer);
        }
      };
    }

    this.text = function () {
      var rejected = consumed(this);
      if (rejected) {
        return rejected;
      }

      if (this._bodyBlob) {
        return readBlobAsText(this._bodyBlob);
      } else if (this._bodyArrayBuffer) {
        return Promise.resolve(readArrayBufferAsText(this._bodyArrayBuffer));
      } else if (this._bodyFormData) {
        throw new Error('could not read FormData body as text');
      } else {
        return Promise.resolve(this._bodyText);
      }
    };

    if (support.formData) {
      this.formData = function () {
        return this.text().then(decode);
      };
    }

    this.json = function () {
      return this.text().then(JSON.parse);
    };

    return this;
  }

  // HTTP methods whose capitalization should be normalized
  var methods = ['DELETE', 'GET', 'HEAD', 'OPTIONS', 'POST', 'PUT'];

  function normalizeMethod(method) {
    var upcased = method.toUpperCase();
    return methods.indexOf(upcased) > -1 ? upcased : method;
  }

  function Request(input, options) {
    if (!(this instanceof Request)) {
      throw new TypeError('Please use the "new" operator, this DOM object constructor cannot be called as a function.');
    }

    options = options || {};
    var body = options.body;

    if (input instanceof Request) {
      if (input.bodyUsed) {
        throw new TypeError('Already read');
      }
      this.url = input.url;
      this.credentials = input.credentials;
      if (!options.headers) {
        this.headers = new Headers(input.headers);
      }
      this.method = input.method;
      this.mode = input.mode;
      this.signal = input.signal;
      if (!body && input._bodyInit != null) {
        body = input._bodyInit;
        input.bodyUsed = true;
      }
    } else {
      this.url = String(input);
    }

    this.credentials = options.credentials || this.credentials || 'same-origin';
    if (options.headers || !this.headers) {
      this.headers = new Headers(options.headers);
    }
    this.method = normalizeMethod(options.method || this.method || 'GET');
    this.mode = options.mode || this.mode || null;
    this.signal = options.signal || this.signal;
    this.referrer = null;

    if ((this.method === 'GET' || this.method === 'HEAD') && body) {
      throw new TypeError('Body not allowed for GET or HEAD requests');
    }
    this._initBody(body);

    if (this.method === 'GET' || this.method === 'HEAD') {
      if (options.cache === 'no-store' || options.cache === 'no-cache') {
        // Search for a '_' parameter in the query string
        var reParamSearch = /([?&])_=[^&]*/;
        if (reParamSearch.test(this.url)) {
          // If it already exists then set the value with the current time
          this.url = this.url.replace(reParamSearch, '$1_=' + new Date().getTime());
        } else {
          // Otherwise add a new '_' parameter to the end with the current time
          var reQueryString = /\?/;
          this.url += (reQueryString.test(this.url) ? '&' : '?') + '_=' + new Date().getTime();
        }
      }
    }
  }

  Request.prototype.clone = function () {
    return new Request(this, { body: this._bodyInit });
  };

  function decode(body) {
    var form = new FormData();
    body.trim().split('&').forEach(function (bytes) {
      if (bytes) {
        var split = bytes.split('=');
        var name = split.shift().replace(/\+/g, ' ');
        var value = split.join('=').replace(/\+/g, ' ');
        form.append(decodeURIComponent(name), decodeURIComponent(value));
      }
    });
    return form;
  }

  function parseHeaders(rawHeaders) {
    var headers = new Headers();
    // Replace instances of \r\n and \n followed by at least one space or horizontal tab with a space
    // https://tools.ietf.org/html/rfc7230#section-3.2
    var preProcessedHeaders = rawHeaders.replace(/\r?\n[\t ]+/g, ' ');
    preProcessedHeaders.split(/\r?\n/).forEach(function (line) {
      var parts = line.split(':');
      var key = parts.shift().trim();
      if (key) {
        var value = parts.join(':').trim();
        headers.append(key, value);
      }
    });
    return headers;
  }

  Body.call(Request.prototype);

  function Response(bodyInit, options) {
    if (!(this instanceof Response)) {
      throw new TypeError('Please use the "new" operator, this DOM object constructor cannot be called as a function.');
    }
    if (!options) {
      options = {};
    }

    this.type = 'default';
    this.status = options.status === undefined ? 200 : options.status;
    this.ok = this.status >= 200 && this.status < 300;
    this.statusText = 'statusText' in options ? options.statusText : '';
    this.headers = new Headers(options.headers);
    this.url = options.url || '';
    this._initBody(bodyInit);
  }

  Body.call(Response.prototype);

  Response.prototype.clone = function () {
    return new Response(this._bodyInit, {
      status: this.status,
      statusText: this.statusText,
      headers: new Headers(this.headers),
      url: this.url
    });
  };

  Response.error = function () {
    var response = new Response(null, { status: 0, statusText: '' });
    response.type = 'error';
    return response;
  };

  var redirectStatuses = [301, 302, 303, 307, 308];

  Response.redirect = function (url, status) {
    if (redirectStatuses.indexOf(status) === -1) {
      throw new RangeError('Invalid status code');
    }

    return new Response(null, { status: status, headers: { location: url } });
  };

  var DOMException = global$1.DOMException;
  try {
    new DOMException();
  } catch (err) {
    DOMException = function DOMException(message, name) {
      this.message = message;
      this.name = name;
      var error = Error(message);
      this.stack = error.stack;
    };
    DOMException.prototype = Object.create(Error.prototype);
    DOMException.prototype.constructor = DOMException;
  }

  function fetch$1(input, init) {
    return new Promise(function (resolve, reject) {
      var request = new Request(input, init);

      if (request.signal && request.signal.aborted) {
        return reject(new DOMException('Aborted', 'AbortError'));
      }

      var xhr = new XMLHttpRequest();

      function abortXhr() {
        xhr.abort();
      }

      xhr.onload = function () {
        var options = {
          status: xhr.status,
          statusText: xhr.statusText,
          headers: parseHeaders(xhr.getAllResponseHeaders() || '')
        };
        options.url = 'responseURL' in xhr ? xhr.responseURL : options.headers.get('X-Request-URL');
        var body = 'response' in xhr ? xhr.response : xhr.responseText;
        setTimeout(function () {
          resolve(new Response(body, options));
        }, 0);
      };

      xhr.onerror = function () {
        setTimeout(function () {
          reject(new TypeError('Network request failed'));
        }, 0);
      };

      xhr.ontimeout = function () {
        setTimeout(function () {
          reject(new TypeError('Network request failed'));
        }, 0);
      };

      xhr.onabort = function () {
        setTimeout(function () {
          reject(new DOMException('Aborted', 'AbortError'));
        }, 0);
      };

      function fixUrl(url) {
        try {
          return url === '' && global$1.location.href ? global$1.location.href : url;
        } catch (e) {
          return url;
        }
      }

      xhr.open(request.method, fixUrl(request.url), true);

      if (request.credentials === 'include') {
        xhr.withCredentials = true;
      } else if (request.credentials === 'omit') {
        xhr.withCredentials = false;
      }

      if ('responseType' in xhr) {
        if (support.blob) {
          xhr.responseType = 'blob';
        } else if (support.arrayBuffer && request.headers.get('Content-Type') && request.headers.get('Content-Type').indexOf('application/octet-stream') !== -1) {
          xhr.responseType = 'arraybuffer';
        }
      }

      if (init && _typeof(init.headers) === 'object' && !(init.headers instanceof Headers)) {
        Object.getOwnPropertyNames(init.headers).forEach(function (name) {
          xhr.setRequestHeader(name, normalizeValue(init.headers[name]));
        });
      } else {
        request.headers.forEach(function (value, name) {
          xhr.setRequestHeader(name, value);
        });
      }

      if (request.signal) {
        request.signal.addEventListener('abort', abortXhr);

        xhr.onreadystatechange = function () {
          // DONE (success or failure)
          if (xhr.readyState === 4) {
            request.signal.removeEventListener('abort', abortXhr);
          }
        };
      }

      xhr.send(typeof request._bodyInit === 'undefined' ? null : request._bodyInit);
    });
  }

  fetch$1.polyfill = true;

  if (!global$1.fetch) {
    global$1.fetch = fetch$1;
    global$1.Headers = Headers;
    global$1.Request = Request;
    global$1.Response = Response;
  }

  // the whatwg-fetch polyfill installs the fetch() function
  // on the global object (window or self)
  //
  // Return that as the export for use in Webpack, Browserify etc.

  var fetchNpmBrowserify = self.fetch.bind(self);

  var Context = function () {
    function Context() {
      classCallCheck(this, Context);

      this.context = {};
    }

    createClass(Context, [{
      key: "set",
      value: function set$$1(obj) {
        this.context = Object.assign({}, this.context, obj);
      }
    }, {
      key: "getValue",
      value: function getValue(key) {
        return this.context[key];
      }
    }, {
      key: "setValue",
      value: function setValue(key, value) {
        this.context[key] = value;
      }
    }, {
      key: "clear",
      value: function clear() {
        this.context = {};
      }
    }, {
      key: "get",
      value: function get$$1() {
        return this.context;
      }
    }]);
    return Context;
  }();

  var contextService = new Context();

  var Logger = function () {
    function Logger() {
      classCallCheck(this, Logger);
    }

    createClass(Logger, [{
      key: 'log',
      value: function log() {
        var _logger;

        (_logger = this.logger).log.apply(_logger, arguments);
      }
    }, {
      key: 'warn',
      value: function warn() {
        var _logger2;

        (_logger2 = this.logger).warn.apply(_logger2, arguments);
      }
    }, {
      key: 'info',
      value: function info() {
        var _logger3;

        (_logger3 = this.logger).info.apply(_logger3, arguments);
      }
    }, {
      key: 'error',
      value: function error() {
        var _logger4;

        (_logger4 = this.logger).error.apply(_logger4, arguments);
      }
    }, {
      key: 'logger',
      get: function get$$1() {
        if (!this._logger) {
          this._logger = require('logdown')('ustore');
          this._logger.isEnabled = process.env.NODE_ENV !== "production";
        }
        return this._logger;
      }
    }]);
    return Logger;
  }();

  var logger = new Logger();

  function createHeaders(options) {
    //get parameters from coreStateParams to init data in header
    var token = contextService.getValue('securityToken');
    var contentLanguage = contextService.getValue('languageCode');

    if (!options.static) {
      var headers = Object.assign({}, {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
        'Accept-Language': contentLanguage
      });

      if (options.auth) {
        Object.assign(headers, { 'Authorization': 'uStore ' + token });
      }

      return headers;
    }

    return {};
  }

  async function formatResponse(callOptions, response) {
    try {
      if (callOptions.json) {
        return await response.json();
      }
      return await response.text();
    } catch (e) {
      logger.error('Error on formatting response : ', callOptions, response);
      return response;
    }
  }

  var http = ['get', 'post', 'put', 'delete'].reduce(function (map, method) {
    map[method] = async function (url, requestBody, options) {

      var callOptions = Object.assign({
        auth: true,
        json: true,
        static: false
      }, options);

      var reqOptions = {
        headers: createHeaders(callOptions),
        method: method,
        body: requestBody ? JSON.stringify(requestBody) : undefined
      };

      var res = await fetch('' + url, reqOptions);
      logger.info('Request to API : ', url, reqOptions);

      var formatedResponse = await formatResponse(callOptions, res);
      logger.info('Response from API : ', JSON.stringify(formatedResponse));

      if (!res.ok) {
        try {
          logger.error('Error in request : ', url, reqOptions);

          if (formatedResponse.TypeName === 'AccessDenied') {
            contextService.getValue('onAccessDenied')();
          } else if (formatedResponse.TypeName === 'ResourceNotAvailable.Store') {
            contextService.getValue('onStoreNotAvailable')();
          } else contextService.getValue('onGeneralError')();
          throw formatedResponse;
        } catch (error) {
          // logger.info('General Error')
          if (!error || !error.TypeName) contextService.getValue('onGeneralError')();

          throw formatedResponse;
        }
      }
      return formatedResponse;
    };

    return map;
  }, {});

  function symbolObservablePonyfill(root) {
  	var result;
  	var _Symbol = root.Symbol;

  	if (typeof _Symbol === 'function') {
  		if (_Symbol.observable) {
  			result = _Symbol.observable;
  		} else {
  			result = _Symbol('observable');
  			_Symbol.observable = result;
  		}
  	} else {
  		result = '@@observable';
  	}

  	return result;
  }

  /* global window */

  var root;

  if (typeof self !== 'undefined') {
    root = self;
  } else if (typeof window !== 'undefined') {
    root = window;
  } else if (typeof global !== 'undefined') {
    root = global;
  } else if (typeof module !== 'undefined') {
    root = module;
  } else {
    root = Function('return this')();
  }

  var result = symbolObservablePonyfill(root);

  /**
   * These are private action types reserved by Redux.
   * For any unknown actions, you must return the current state.
   * If the current state is undefined, you must return the initial state.
   * Do not reference these action types directly in your code.
   */
  var ActionTypes = {
    INIT: '@@redux/INIT' + Math.random().toString(36).substring(7).split('').join('.'),
    REPLACE: '@@redux/REPLACE' + Math.random().toString(36).substring(7).split('').join('.')
  };

  var _typeof$1 = typeof Symbol === "function" && _typeof(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === 'undefined' ? 'undefined' : _typeof(obj);
  } : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === 'undefined' ? 'undefined' : _typeof(obj);
  };

  var _extends$1 = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  /**
   * @param {any} obj The object to inspect.
   * @returns {boolean} True if the argument appears to be a plain object.
   */
  function isPlainObject(obj) {
    if ((typeof obj === 'undefined' ? 'undefined' : _typeof$1(obj)) !== 'object' || obj === null) return false;

    var proto = obj;
    while (Object.getPrototypeOf(proto) !== null) {
      proto = Object.getPrototypeOf(proto);
    }

    return Object.getPrototypeOf(obj) === proto;
  }

  /**
   * Creates a Redux store that holds the state tree.
   * The only way to change the data in the store is to call `dispatch()` on it.
   *
   * There should only be a single store in your app. To specify how different
   * parts of the state tree respond to actions, you may combine several reducers
   * into a single reducer function by using `combineReducers`.
   *
   * @param {Function} reducer A function that returns the next state tree, given
   * the current state tree and the action to handle.
   *
   * @param {any} [preloadedState] The initial state. You may optionally specify it
   * to hydrate the state from the server in universal apps, or to restore a
   * previously serialized user session.
   * If you use `combineReducers` to produce the root reducer function, this must be
   * an object with the same shape as `combineReducers` keys.
   *
   * @param {Function} [enhancer] The store enhancer. You may optionally specify it
   * to enhance the store with third-party capabilities such as middleware,
   * time travel, persistence, etc. The only store enhancer that ships with Redux
   * is `applyMiddleware()`.
   *
   * @returns {Store} A Redux store that lets you read the state, dispatch actions
   * and subscribe to changes.
   */
  function createStore(reducer, preloadedState, enhancer) {
    var _ref2;

    if (typeof preloadedState === 'function' && typeof enhancer === 'undefined') {
      enhancer = preloadedState;
      preloadedState = undefined;
    }

    if (typeof enhancer !== 'undefined') {
      if (typeof enhancer !== 'function') {
        throw new Error('Expected the enhancer to be a function.');
      }

      return enhancer(createStore)(reducer, preloadedState);
    }

    if (typeof reducer !== 'function') {
      throw new Error('Expected the reducer to be a function.');
    }

    var currentReducer = reducer;
    var currentState = preloadedState;
    var currentListeners = [];
    var nextListeners = currentListeners;
    var isDispatching = false;

    function ensureCanMutateNextListeners() {
      if (nextListeners === currentListeners) {
        nextListeners = currentListeners.slice();
      }
    }

    /**
     * Reads the state tree managed by the store.
     *
     * @returns {any} The current state tree of your application.
     */
    function getState() {
      if (isDispatching) {
        throw new Error('You may not call store.getState() while the reducer is executing. ' + 'The reducer has already received the state as an argument. ' + 'Pass it down from the top reducer instead of reading it from the store.');
      }

      return currentState;
    }

    /**
     * Adds a change listener. It will be called any time an action is dispatched,
     * and some part of the state tree may potentially have changed. You may then
     * call `getState()` to read the current state tree inside the callback.
     *
     * You may call `dispatch()` from a change listener, with the following
     * caveats:
     *
     * 1. The subscriptions are snapshotted just before every `dispatch()` call.
     * If you subscribe or unsubscribe while the listeners are being invoked, this
     * will not have any effect on the `dispatch()` that is currently in progress.
     * However, the next `dispatch()` call, whether nested or not, will use a more
     * recent snapshot of the subscription list.
     *
     * 2. The listener should not expect to see all state changes, as the state
     * might have been updated multiple times during a nested `dispatch()` before
     * the listener is called. It is, however, guaranteed that all subscribers
     * registered before the `dispatch()` started will be called with the latest
     * state by the time it exits.
     *
     * @param {Function} listener A callback to be invoked on every dispatch.
     * @returns {Function} A function to remove this change listener.
     */
    function subscribe(listener) {
      if (typeof listener !== 'function') {
        throw new Error('Expected the listener to be a function.');
      }

      if (isDispatching) {
        throw new Error('You may not call store.subscribe() while the reducer is executing. ' + 'If you would like to be notified after the store has been updated, subscribe from a ' + 'component and invoke store.getState() in the callback to access the latest state. ' + 'See https://redux.js.org/api-reference/store#subscribe(listener) for more details.');
      }

      var isSubscribed = true;

      ensureCanMutateNextListeners();
      nextListeners.push(listener);

      return function unsubscribe() {
        if (!isSubscribed) {
          return;
        }

        if (isDispatching) {
          throw new Error('You may not unsubscribe from a store listener while the reducer is executing. ' + 'See https://redux.js.org/api-reference/store#subscribe(listener) for more details.');
        }

        isSubscribed = false;

        ensureCanMutateNextListeners();
        var index = nextListeners.indexOf(listener);
        nextListeners.splice(index, 1);
      };
    }

    /**
     * Dispatches an action. It is the only way to trigger a state change.
     *
     * The `reducer` function, used to create the store, will be called with the
     * current state tree and the given `action`. Its return value will
     * be considered the **next** state of the tree, and the change listeners
     * will be notified.
     *
     * The base implementation only supports plain object actions. If you want to
     * dispatch a Promise, an Observable, a thunk, or something else, you need to
     * wrap your store creating function into the corresponding middleware. For
     * example, see the documentation for the `redux-thunk` package. Even the
     * middleware will eventually dispatch plain object actions using this method.
     *
     * @param {Object} action A plain object representing “what changed”. It is
     * a good idea to keep actions serializable so you can record and replay user
     * sessions, or use the time travelling `redux-devtools`. An action must have
     * a `type` property which may not be `undefined`. It is a good idea to use
     * string constants for action types.
     *
     * @returns {Object} For convenience, the same action object you dispatched.
     *
     * Note that, if you use a custom middleware, it may wrap `dispatch()` to
     * return something else (for example, a Promise you can await).
     */
    function dispatch(action) {
      if (!isPlainObject(action)) {
        throw new Error('Actions must be plain objects. ' + 'Use custom middleware for async actions.');
      }

      if (typeof action.type === 'undefined') {
        throw new Error('Actions may not have an undefined "type" property. ' + 'Have you misspelled a constant?');
      }

      if (isDispatching) {
        throw new Error('Reducers may not dispatch actions.');
      }

      try {
        isDispatching = true;
        currentState = currentReducer(currentState, action);
      } finally {
        isDispatching = false;
      }

      var listeners = currentListeners = nextListeners;
      for (var i = 0; i < listeners.length; i++) {
        var listener = listeners[i];
        listener();
      }

      return action;
    }

    /**
     * Replaces the reducer currently used by the store to calculate the state.
     *
     * You might need this if your app implements code splitting and you want to
     * load some of the reducers dynamically. You might also need this if you
     * implement a hot reloading mechanism for Redux.
     *
     * @param {Function} nextReducer The reducer for the store to use instead.
     * @returns {void}
     */
    function replaceReducer(nextReducer) {
      if (typeof nextReducer !== 'function') {
        throw new Error('Expected the nextReducer to be a function.');
      }

      currentReducer = nextReducer;
      dispatch({ type: ActionTypes.REPLACE });
    }

    /**
     * Interoperability point for observable/reactive libraries.
     * @returns {observable} A minimal observable of state changes.
     * For more information, see the observable proposal:
     * https://github.com/tc39/proposal-observable
     */
    function observable() {
      var _ref;

      var outerSubscribe = subscribe;
      return _ref = {
        /**
         * The minimal observable subscription method.
         * @param {Object} observer Any object that can be used as an observer.
         * The observer object should have a `next` method.
         * @returns {subscription} An object with an `unsubscribe` method that can
         * be used to unsubscribe the observable from the store, and prevent further
         * emission of values from the observable.
         */
        subscribe: function subscribe(observer) {
          if ((typeof observer === 'undefined' ? 'undefined' : _typeof$1(observer)) !== 'object' || observer === null) {
            throw new TypeError('Expected the observer to be an object.');
          }

          function observeState() {
            if (observer.next) {
              observer.next(getState());
            }
          }

          observeState();
          var unsubscribe = outerSubscribe(observeState);
          return { unsubscribe: unsubscribe };
        }
      }, _ref[result] = function () {
        return this;
      }, _ref;
    }

    // When a store is created, an "INIT" action is dispatched so that every
    // reducer returns their initial state. This effectively populates
    // the initial state tree.
    dispatch({ type: ActionTypes.INIT });

    return _ref2 = {
      dispatch: dispatch,
      subscribe: subscribe,
      getState: getState,
      replaceReducer: replaceReducer
    }, _ref2[result] = observable, _ref2;
  }

  /**
   * Prints a warning in the console if it exists.
   *
   * @param {String} message The warning message.
   * @returns {void}
   */
  function warning(message) {
    /* eslint-disable no-console */
    if (typeof console !== 'undefined' && typeof console.error === 'function') {
      console.error(message);
    }
    /* eslint-enable no-console */
    try {
      // This error was thrown as a convenience so that if you enable
      // "break on all exceptions" in your console,
      // it would pause the execution at this line.
      throw new Error(message);
    } catch (e) {} // eslint-disable-line no-empty
  }

  /**
   * Composes single-argument functions from right to left. The rightmost
   * function can take multiple arguments as it provides the signature for
   * the resulting composite function.
   *
   * @param {...Function} funcs The functions to compose.
   * @returns {Function} A function obtained by composing the argument functions
   * from right to left. For example, compose(f, g, h) is identical to doing
   * (...args) => f(g(h(...args))).
   */

  function compose() {
    for (var _len = arguments.length, funcs = Array(_len), _key = 0; _key < _len; _key++) {
      funcs[_key] = arguments[_key];
    }

    if (funcs.length === 0) {
      return function (arg) {
        return arg;
      };
    }

    if (funcs.length === 1) {
      return funcs[0];
    }

    return funcs.reduce(function (a, b) {
      return function () {
        return a(b.apply(undefined, arguments));
      };
    });
  }

  /**
   * Creates a store enhancer that applies middleware to the dispatch method
   * of the Redux store. This is handy for a variety of tasks, such as expressing
   * asynchronous actions in a concise manner, or logging every action payload.
   *
   * See `redux-thunk` package as an example of the Redux middleware.
   *
   * Because middleware is potentially asynchronous, this should be the first
   * store enhancer in the composition chain.
   *
   * Note that each middleware will be given the `dispatch` and `getState` functions
   * as named arguments.
   *
   * @param {...Function} middlewares The middleware chain to be applied.
   * @returns {Function} A store enhancer applying the middleware.
   */
  function applyMiddleware() {
    for (var _len = arguments.length, middlewares = Array(_len), _key = 0; _key < _len; _key++) {
      middlewares[_key] = arguments[_key];
    }

    return function (createStore) {
      return function () {
        for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }

        var store = createStore.apply(undefined, args);
        var _dispatch = function dispatch() {
          throw new Error('Dispatching while constructing your middleware is not allowed. ' + 'Other middleware would not be applied to this dispatch.');
        };

        var middlewareAPI = {
          getState: store.getState,
          dispatch: function dispatch() {
            return _dispatch.apply(undefined, arguments);
          }
        };
        var chain = middlewares.map(function (middleware) {
          return middleware(middlewareAPI);
        });
        _dispatch = compose.apply(undefined, chain)(store.dispatch);

        return _extends$1({}, store, {
          dispatch: _dispatch
        });
      };
    };
  }

  /*
   * This is a dummy function to check if the function name has been altered by minification.
   * If the function has been minified and NODE_ENV !== 'production', warn the user.
   */
  function isCrushed() {}

  if (process.env.NODE_ENV !== 'production' && typeof isCrushed.name === 'string' && isCrushed.name !== 'isCrushed') {
    warning("You are currently using minified code outside of NODE_ENV === 'production'. " + 'This means that you are running a slower development build of Redux. ' + 'You can use loose-envify (https://github.com/zertosh/loose-envify) for browserify ' + 'or DefinePlugin for webpack (http://stackoverflow.com/questions/30030031) ' + 'to ensure you have the correct code for your production build.');
  }

  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var lib = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  function createThunkMiddleware(extraArgument) {
    return function (_ref) {
      var dispatch = _ref.dispatch,
          getState = _ref.getState;
      return function (next) {
        return function (action) {
          if (typeof action === 'function') {
            return action(dispatch, getState, extraArgument);
          }

          return next(action);
        };
      };
    };
  }

  var thunk = createThunkMiddleware();
  thunk.withExtraArgument = createThunkMiddleware;

  exports['default'] = thunk;
  });

  var thunkMiddleware = unwrapExports(lib);

  var defaultState = {
    currentStore: null,
    currentUser: null,
    initState: true,
    customState: {},
    cultures: [],
    currentCulture: null,
    currencies: [],
    currentCurrency: null
  };

  var LOAD_CURRENT_STORE = 'LOAD_CURRENT_STORE';
  var LOAD_CURRENT_USER = 'LOAD_CURRENT_USER';
  var LOAD_USER_ORDERS_SUMMARY = 'LOAD_USER_ORDERS_SUMMARY';
  var LOAD_PRODUCTS = 'LOAD_PRODUCTS';
  var SET_CUSTOM_VAR = 'SET_CUSTOM_VAR';
  var DELETE_CUSTOM_VAR = 'DELETE_CUSTOM_VAR';
  var MERGE_CUSTOM_STATE = 'MERGE_CUSTOM_STATE';
  var LOAD_CATEGORIES = 'LOAD_CATEGORIES';
  var LOAD_CATEGORIES_TREE = 'LOAD_CATEGORIES_TREE';
  var LOAD_SUB_CATEGORIES = 'LOAD_SUB_CATEGORIES';
  var LOAD_CULTURES = 'LOAD_CULTURES';
  var LOAD_CURRENT_CATEGORY = 'LOAD_CURRENT_CATEGORY';

  var LOAD_CURRENCIES = 'LOAD_CURRENCIES';
  var SET_CURRENT_CURRENCY = 'SET_CURRENT_CURRENCY';
  var SET_CURRENT_CULTURE = 'SET_CURRENT_CULTURE';
  var SET_CURRENT_CULTURE_BY_LANGUAGE = 'SET_CURRENT_CULTURE_BY_LANGUAGE';
  var CLEAR_STATE = 'CLEAR_STATE';

  exports.__esModule = true;

  var _copy = require('./copy');

  var _polyfill = require('./polyfill');

  function defaultCustomizer(target) {
    return void 0;
  }

  function deepcopy(target) {
    var customizer = arguments.length <= 1 || arguments[1] === void 0 ? defaultCustomizer : arguments[1];

    if (target === null) {
      // copy null
      return null;
    }

    var resultValue = (0, _copy.copyValue)(target);

    if (resultValue !== null) {
      // copy some primitive types
      return resultValue;
    }

    var resultCollection = (0, _copy.copyCollection)(target, customizer),
        clone = resultCollection !== null ? resultCollection : target;

    var visited = [target],
        reference = [clone];

    // recursively copy from collection
    return recursiveCopy(target, customizer, clone, visited, reference);
  }

  function recursiveCopy(target, customizer, clone, visited, reference) {
    if (target === null) {
      // copy null
      return null;
    }

    var resultValue = (0, _copy.copyValue)(target);

    if (resultValue !== null) {
      // copy some primitive types
      return resultValue;
    }

    var keys = (0, _polyfill.getKeys)(target).concat((0, _polyfill.getSymbols)(target));

    var i = void 0,
        len = void 0;

    var key = void 0,
        value = void 0,
        index = void 0,
        resultCopy = void 0,
        result = void 0,
        ref = void 0;

    for (i = 0, len = keys.length; i < len; ++i) {
      key = keys[i];
      value = target[key];
      index = (0, _polyfill.indexOf)(visited, value);

      resultCopy = void 0;
      result = void 0;
      ref = void 0;

      if (index === -1) {
        resultCopy = (0, _copy.copy)(value, customizer);
        result = resultCopy !== null ? resultCopy : value;

        if (value !== null && /^(?:function|object)$/.test(typeof value === 'undefined' ? 'undefined' : _typeof(value))) {
          visited.push(value);
          reference.push(result);
        }
      } else {
        // circular reference
        ref = reference[index];
      }

      clone[key] = ref || recursiveCopy(value, customizer, result, visited, reference);
    }

    return clone;
  }

  exports['default'] = deepcopy;
  module.exports = exports['default'];

  var lib$1 = /*#__PURE__*/Object.freeze({

  });

  var deepcopy$1 = lib$1;

  var convertObjectToQueryString = function convertObjectToQueryString(obj) {
    return Object.entries(obj).map(function (_ref) {
      var _ref2 = slicedToArray(_ref, 2),
          key = _ref2[0],
          value = _ref2[1];

      return key && value ? key + '=' + encodeURIComponent(value) : '';
    }).filter(function (s) {
      return !!s;
    }).join('&');
  };

  var merge = function merge(o1, o2) {
    var o = deepcopy$1(o1);
    for (var n in o2) {
      if (_typeof(o2[n]) !== 'object' || o2[n] === null) {
        o[n] = o2[n];
      } else if (Array.isArray(o2[n])) {
        o[n] = [].concat(toConsumableArray(o2[n]));
      } else {
        o[n] = o[n] ? merge(o[n], o2[n]) : merge({}, o2[n]);
      }
    }
    return o;
  };

  // import update from 'immutability-helper'

  // REDUCERS
  var reducer = (function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultState;
    var action = arguments[1];


    switch (action.type) {
      case '@@INIT_STATE':
        return Object.assign({}, state, action.data, { initState: false });
      case LOAD_CURRENT_STORE:
        return Object.assign({}, state, { currentStore: action.data });
      case LOAD_CURRENT_USER:
        return Object.assign({}, state, { currentUser: action.data });
      case LOAD_USER_ORDERS_SUMMARY:
        return Object.assign({}, state, { userOrdersSummary: action.data });
      case LOAD_CATEGORIES:
        return Object.assign({}, state, { categories: action.data });
      case LOAD_CATEGORIES_TREE:
        var categoriesTree = action.data;
        var firstLevelCategories = categoriesTree.map(function (node) {
          return node.Category;
        });
        return Object.assign({}, state, { categoriesTree: categoriesTree, categories: firstLevelCategories });
      case LOAD_SUB_CATEGORIES:
        return Object.assign({}, state, { subCategories: action.data });
      case LOAD_CULTURES:
        return Object.assign({}, state, { cultures: action.data });
      case LOAD_CURRENCIES:
        return Object.assign({}, state, { currencies: action.data });
      case SET_CURRENT_CULTURE:
        return Object.assign({}, state, { currentCulture: action.data });
      case SET_CURRENT_CULTURE_BY_LANGUAGE:
        var culture = action.data && state.cultures.length > 0 ? state.cultures.filter(function (c) {
          return c.LanguageCode === action.data;
        })[0] : null;
        return Object.assign({}, state, { currentCulture: culture });
      case SET_CURRENT_CURRENCY:
        var currency = action.data ? action.data : state.currencies.length > 0 ? state.currencies.filter(function (c) {
          return c.ID === state.currentStore.PrimaryCurrencyID;
        })[0] : null;
        return Object.assign({}, state, { currentCurrency: currency });
      case LOAD_CURRENT_CATEGORY:
        return Object.assign({}, state, { currentCategory: action.data, subCategories: null });
      case LOAD_PRODUCTS:
        return Object.assign({}, state, { products: action.data.products });
      case SET_CUSTOM_VAR:
        var mergedCustomState = Object.assign(state.customState, action.data);
        return Object.assign({}, state, { customState: mergedCustomState });
      case DELETE_CUSTOM_VAR:
        var customStateDup = Object.assign({}, state.customState);
        delete customStateDup[action.data.name];
        return Object.assign({}, state, { customState: customStateDup });
      case MERGE_CUSTOM_STATE:
        return Object.assign({}, state, { customState: merge(state.customState, action.data) });
      case CLEAR_STATE:
        return Object.assign({}, state, defaultState);
    }

    return state;
  });

  var initStore = function initStore() {
    var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultState;

    // the following lines are not duplicate
    // the build will select the correct line according to the type of the build
    // ==== DO NOT DELETE ====

    return createStore(reducer, initialState, applyMiddleware(thunkMiddleware));
  };

  var ProviderState = function () {
    function ProviderState() {
      classCallCheck(this, ProviderState);

      this.store = initStore();
    }

    createClass(ProviderState, [{
      key: 'get',
      value: function get$$1() {
        return this.store.getState();
      }
    }, {
      key: 'set',
      value: function set$$1(state) {
        this.store.dispatch({ type: '@@INIT_STATE', data: state });
      }
    }, {
      key: 'setCustomState',
      value: function setCustomState(name, value) {
        this.store.dispatch({ type: SET_CUSTOM_VAR, data: defineProperty({}, name, value) });
      }
    }, {
      key: 'setBulkCustomState',
      value: function setBulkCustomState(obj) {
        this.store.dispatch({ type: SET_CUSTOM_VAR, data: obj });
      }
    }, {
      key: 'deleteCustomState',
      value: function deleteCustomState(name) {
        this.store.dispatch({ type: DELETE_CUSTOM_VAR, data: { name: name } });
      }
    }, {
      key: 'mergeCustomState',
      value: function mergeCustomState(newState) {
        this.store.dispatch({ type: MERGE_CUSTOM_STATE, data: newState });
      }
    }, {
      key: 'clear',
      value: function clear() {
        this.store.dispatch({ type: CLEAR_STATE, data: {} });
      }
    }, {
      key: 'dispatch',
      get: function get$$1() {
        return this.store.dispatch;
      }
    }, {
      key: 'subscribe',
      get: function get$$1() {
        return this.store.subscribe;
      }
    }]);
    return ProviderState;
  }();

  var providerState = new ProviderState();

  var Config = function () {
    function Config() {
      classCallCheck(this, Config);
    }

    createClass(Config, [{
      key: "set",
      value: function set$$1(obj) {
        this.config = obj;
        this.configInit = true;
      }
    }, {
      key: "getValue",
      value: function getValue(key) {
        return this.config[key];
      }
    }, {
      key: "isInit",
      value: function isInit() {
        return this.configInit;
      }
    }, {
      key: "get",
      value: function get$$1() {
        return this.config;
      }
    }]);
    return Config;
  }();

  var config = new Config();

  var getTopCategories = async function getTopCategories(pageNumber, pageSize) {
    var params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
    return await http.get(config.getValue('apiUrl') + '/v1/store/categories' + (params.length ? '?' + params : ''));
  };

  var getSubCategories = async function getSubCategories(categoryID, pageNumber, pageSize) {
    var params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
    return await http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID + '/categories' + (params.length ? '?' + params : ''));
  };

  var getCategoryIDByFriendlyID = async function getCategoryIDByFriendlyID(categoryFriendlyID) {
    return await http.get(config.getValue('apiUrl') + '/v1/store/categories/id?friendlyID=' + categoryFriendlyID);
  };

  var getCategory = async function getCategory(categoryID) {
    return await http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID);
  };

  var getCategoryTree = async function getCategoryTree(depth) {
    return await http.get(config.getValue('apiUrl') + '/v1/store/categories/tree?depth=' + depth);
  };

  /**
   * Represent the categories logic and API in the system
   */

  var Categories = function () {
    function Categories() {
      classCallCheck(this, Categories);
    }

    createClass(Categories, [{
      key: 'loadCategoriesTree',


      /**
       * Set **state.categoriesTree** with the categories tree.
       * Set **state.categories** with the first level categories group.
       * @param {number} [depth] - Indicates the maximum depth of the tree to return. By default (1), returns root categories only.
       * @returns {CategoryTreeModel} - The tree of categories
       */
      value: async function loadCategoriesTree() {
        var depth = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

        var _ref = await getCategoryTree(depth),
            Categories = _ref.Categories;

        providerState.dispatch({ type: LOAD_CATEGORIES_TREE, data: Categories });
        return Categories;
      }

      /**
       * Set **state.subCategories** with the sub-categories of the given category in the store, using paging.
       * Sub-categories without online product(s) on any level of their branch - are not included.
       * @param {string} categoryFriendlyID - the category friendly ID
       * @param {number} [pageNumber] - The 1-based number of the page.
       * @param {number} [pageSize] - The amount of the categories in one page.
       * @returns Array of sub categories in a specific page
       */

    }, {
      key: 'loadSubCategories',
      value: async function loadSubCategories(categoryFriendlyID) {
        var pageNumber = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
        var pageSize = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

        var categoryID = await getCategoryIDByFriendlyID(categoryFriendlyID);

        var _ref2 = await getSubCategories(categoryID, pageNumber, pageSize),
            Categories = _ref2.Categories;

        providerState.dispatch({ type: LOAD_SUB_CATEGORIES, data: Categories });
        return Categories;
      }

      /**
       * Set state.currentCategory with the requested category by friendlyID.
       * @param {string} categoryFriendlyID - the category friendly ID
       * @returns {CategoryModel} - A category model
       */

    }, {
      key: 'loadCurrentCategory',
      value: async function loadCurrentCategory(categoryFriendlyID) {
        var categoryID = await getCategoryIDByFriendlyID(categoryFriendlyID);
        var currentCategory = await getCategory(categoryID);
        providerState.dispatch({ type: LOAD_CURRENT_CATEGORY, data: currentCategory });
        return currentCategory;
      }
    }]);
    return Categories;
  }();

  var categories = new Categories();

  /**
   * Represent the products logic and API in the system
   */
  var Products = function Products() {
    classCallCheck(this, Products);
  };

  var products = new Products();

  var Binding = function () {
    function Binding() {
      var _this = this;

      classCallCheck(this, Binding);

      this.webComponents = {};
      this.componentId = 1;
      this.state = providerState;

      //subscribe to store changes and set model attribute on all
      //connected components
      this.state.store.subscribe(function () {
        setTimeout(function () {
          var model = JSON.stringify(_this.state.get());
          Object.values(_this.webComponents).forEach(function (c) {
            return c.setAttribute('model', model);
          });
        }, 0);
      });
    }

    //register a new component set an binding id to allow removing the
    //component when unregistering
    //listening to the action event and dispatching it to redux store.


    createClass(Binding, [{
      key: 'register',
      value: function register(component) {
        var _this2 = this;

        var model = JSON.stringify(this.state.get());
        component.ustoreBindingId = this.componentId;
        component.addEventListener('action', function (_ref) {
          var data = _ref.data;
          return _this2.state.dispatch(data);
        });
        this.webComponents[this.componentId] = component;
        component.setAttribute('model', model);
        this.componentId++;
      }
    }, {
      key: 'unregister',
      value: function unregister(ustoreBindingId) {
        delete this.webComponents[ustoreBindingId];
      }
    }]);
    return Binding;
  }();

  var bindingService = new Binding();

  /**
   * Represents the culture logic in the system
   */

  var Culture = function () {
    function Culture() {
      classCallCheck(this, Culture);
    }

    createClass(Culture, [{
      key: 'setCurrentCurrency',


      /**
       * Set **state.currentCurrency** with the requested currency model
       * @param {CurrencyModel} currentCurrency - the requested currency to set as the current currency
       */
      value: function setCurrentCurrency(currentCurrency) {
        providerState.dispatch({ type: SET_CURRENT_CURRENCY, data: currentCurrency });
      }

      /**
       * Set **state.currentCurrency** according the the language code requested
       * @param {string} languageCode - the requested language code
       */

    }, {
      key: 'setCurrentCultureByLanguage',
      value: function setCurrentCultureByLanguage(languageCode) {
        providerState.dispatch({ type: SET_CURRENT_CULTURE_BY_LANGUAGE, data: languageCode });
      }

      /**
       * Get the converted price according to the current currency in the state
       * @param {ProductPriceModel} priceModel - the price model to be converted
       * @returns {json} - price, tax and priceIncludingTax that are converted by the current currency
       */

    }, {
      key: 'getConvertedPrices',
      value: function getConvertedPrices(priceModel) {
        var _providerState$get = providerState.get(),
            currentCurrency = _providerState$get.currentCurrency;

        return {
          price: priceModel.Price * currentCurrency.ConversionRate,
          tax: priceModel.Tax * currentCurrency.ConversionRate,
          priceIncludingTax: (priceModel.Price + priceModel.Tax) * currentCurrency.ConversionRate
        };
      }
    }]);
    return Culture;
  }();

  var culture = new Culture();

  var getCurrentStore = async function getCurrentStore() {
    return await http.get(config.getValue('apiUrl') + "/v1/store");
  };

  var getCurrentUser = async function getCurrentUser() {
    return await http.get(config.getValue('apiUrl') + "/v1/store/login/user");
  };

  var getCultures = async function getCultures() {
    return await http.get(config.getValue('apiUrl') + "/v1/store/cultures", null);
    //Use this for mock data from cultures.json
    //return await http.get(`${config.getValue('baseUrl')}/config/stores/store-a/cultures.json`)
  };

  var getCurrencies = async function getCurrencies() {
    return await http.get(config.getValue('apiUrl') + "/v1/store/currencies");
    //Use this for mock data from currencies.json
    //return await http.get(`${config.getValue('baseUrl')}/config/stores/store-a/currencies.json`)
  };

  /**
   * Represent the store logic and API in the system
   */

  var Store = function () {
    function Store() {
      classCallCheck(this, Store);
    }

    createClass(Store, [{
      key: "loadCurrentStore",


      /**
       * Set **state.currentStore** with the data of the store, that is associated with the security token and culture
       * in the request headers.
       * @returns {StoreModel} - the store data
       */
      value: async function loadCurrentStore() {
        var currentStore = await getCurrentStore();
        providerState.dispatch({ type: LOAD_CURRENT_STORE, data: currentStore });
        return currentStore;
      }

      /**
       * Set **state.currentUser** with the user, that is logged-in to the store
       * @returns {UserModel} - the user data
       */

    }, {
      key: "loadCurrentUser",
      value: async function loadCurrentUser() {
        var currentUser = await getCurrentUser();
        providerState.dispatch({ type: LOAD_CURRENT_USER, data: currentUser });
        return currentUser;
      }

      /**
       * Set **state.cultures** with the list of the cultures, that are set for the store.
       * @returns {CultureModel[]} - list of the cultures
       */

    }, {
      key: "loadStoreCultures",
      value: async function loadStoreCultures() {
        var cultures = await getCultures();
        providerState.dispatch({ type: LOAD_CULTURES, data: cultures });
        return cultures;
      }

      /**
       * Set **state.currencies** with the list of the currencies, that are set for the store.
       * @returns {CurrencyModel[]} - list of the currencies
       */

    }, {
      key: "loadStoreCurrencies",
      value: async function loadStoreCurrencies() {
        var currencies = await getCurrencies();
        providerState.dispatch({ type: LOAD_CURRENCIES, data: currencies });
        return currencies;
      }
    }]);
    return Store;
  }();

  var store = new Store();

  var getUserOrdersSummary = async function getUserOrdersSummary() {
    return await http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/summary");
  };

  var addOrderItem = async function addOrderItem(productID) {
    return await http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/draft/items?productID=" + productID);
  };

  var getOrderItem = async function getOrderItem(orderItemID) {
    return await http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID);
  };

  var updateOrderItem = async function updateOrderItem(orderItemID, orderItem) {
    return await http.put(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID, orderItem);
  };

  var getPriceOrderItem = async function getPriceOrderItem(orderItemID, orderItem) {
    return await http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/price/calculate", orderItem);
  };

  var reorder = async function reorder(orderItemID) {
    return await http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/submitted/items/" + orderItemID + "/reorder");
  };

  var getLastOrder = async function getLastOrder(productID) {
    return await http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/submitted/items/last/status?productID=" + productID);
  };

  var addToCart = async function addToCart(orderItemID) {
    return await http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/addToCart");
  };

  var saveForLater = async function saveForLater(orderItemID) {
    return await http.post(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/saveForLater");
  };

  var getDeliveryServices = async function getDeliveryServices(orderItemID) {
    return await http.get(config.getValue('apiUrl') + "/v1/store/login/user/orders/unsubmitted/items/" + orderItemID + "/deliveryServices");
  };

  var getProductIDByFriendlyID = async function getProductIDByFriendlyID(friendlyID) {
    return await http.get(config.getValue('apiUrl') + "/v1/store/products/id?friendlyID=" + friendlyID);
  };

  var getProducts = async function getProducts(categoryID, pageNumber, pageSize) {
    var params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
    return await http.get(config.getValue('apiUrl') + "/v1/store/categories/" + categoryID + "/products" + (params.length ? "?" + params : ''));
  };

  var getProductsByIDs = async function getProductsByIDs(IDs) {
    var sIDs = IDs.map(function (val, ind) {
      return "productIDs[" + ind + "]=" + val;
    }).join('&');
    return await http.get(config.getValue('apiUrl') + "/v1/store/products?" + sIDs);
  };

  var getProductByID = async function getProductByID(productID, retrieveTypeSpecificData) {
    return await http.get(config.getValue('apiUrl') + "/v1/store/products/" + productID + "?retrieveTypeSpecificData=" + retrieveTypeSpecificData);
  };

  var getProductThumbnails = async function getProductThumbnails(productID) {
    return await http.get(config.getValue('apiUrl') + "/v1/store/products/" + productID + "/thumbnails");
  };

  var productType = {
    Undefined: -1,
    Dynamic: 1,
    Static: 2,
    Email: 3,
    Uploaded: 4,
    Composite: 5,
    DynamicWithPurl: 6,
    EmailWithPurl: 7,
    CircleProject: 8,
    PrintTouchPoint: 9,
    EmailTouchPoint: 10,
    WebTouchPoint: 11,
    PdfOnDemandTouchPoint: 12,
    TriggeredEmailTouchPoint: 13,
    Kit: 14
  };

  var api = {

    categories: {
      getTopCategories: getTopCategories,
      getSubCategories: getSubCategories,
      getCategoryIDByFriendlyID: getCategoryIDByFriendlyID,
      getCategory: getCategory,
      getCategoryTree: getCategoryTree
    },
    orders: {
      getUserOrdersSummary: getUserOrdersSummary,
      addOrderItem: addOrderItem,
      getOrderItem: getOrderItem,
      updateOrderItem: updateOrderItem,
      getPriceOrderItem: getPriceOrderItem,
      reorder: reorder,
      getLastOrder: getLastOrder,
      addToCart: addToCart,
      saveForLater: saveForLater,
      getDeliveryServices: getDeliveryServices
    },
    products: {
      getProductIDByFriendlyID: getProductIDByFriendlyID,
      getProducts: getProducts,
      getProductByID: getProductByID,
      productType: productType,
      getProductsByIDs: getProductsByIDs,
      getProductThumbnails: getProductThumbnails
    },
    store: {
      getCurrentStore: getCurrentStore,
      getCurrentUser: getCurrentUser,
      getCultures: getCultures,
      getCurrencies: getCurrencies
    }

  };

  var InitialState = function () {
    function InitialState() {
      classCallCheck(this, InitialState);
    }

    createClass(InitialState, [{
      key: 'loadInitialState',
      value: async function loadInitialState() {
        //get initialState from API and set it in redux if needed
        //if state already has data these actions will override it

        await store.loadCurrentStore();

        await store.loadStoreCultures();

        culture.setCurrentCultureByLanguage(contextService.getValue('languageCode'));

        await store.loadStoreCurrencies();

        var currencyFriendlyID = contextService.getValue('currencyFriendlyID');
        var currentCurrency = providerState.get().currencies.filter(function (c) {
          return c.FriendlyID === parseInt(currencyFriendlyID);
        })[0];
        culture.setCurrentCurrency(currentCurrency);

        await store.loadCurrentUser();
      }
    }]);
    return InitialState;
  }();

  var initialStateService = new InitialState();

  var newState = {
    culture: culture,
    store: store,
    categories: categories,
    products: products,
    get: function get() {
      return providerState.get();
    },
    set: function set(state) {
      return providerState.set(state);
    },
    dispatch: providerState.dispatch,
    subscribe: providerState.subscribe,
    customState: {
      set: function set(name, value) {
        return providerState.setCustomState(name, value);
      },
      setBulk: function setBulk(obj) {
        return providerState.setBulkCustomState(obj);
      },
      get: function get(name) {
        return name ? providerState.get().customState[name] : providerState.get().customState;
      },
      delete: function _delete(name) {
        return providerState.deleteCustomState(name);
      },
      merge: function merge(customState) {
        return providerState.mergeCustomState(customState);
      }
    }
  };

  /**
   * UStoreProvider - This is the uStore provider - the entry point to all ustore API's
   */

  var Provider = function () {
    function Provider() {
      classCallCheck(this, Provider);

      this.stateService = providerState;
      this.binding = bindingService;
      this.initialState = initialStateService;
      this.configService = config;
      this.contextService = contextService;
    }

    createClass(Provider, [{
      key: 'init',
      value: async function init(runtimeConfig, params) {
        if (runtimeConfig) {
          this.configService.set(runtimeConfig);
        }
        if (params) {
          this.contextService.set(params);

          if (this.stateService.get().initState) {
            await this.initialState.loadInitialState();
          }
        }
      }
    }, {
      key: 'api',
      get: function get$$1() {
        return api;
      }
    }, {
      key: 'state',
      get: function get$$1() {
        return newState;
      }
    }]);
    return Provider;
  }();

  var UStoreProvider = new Provider();
  //expose UStoreProvider on window so standalone component will have access to it
  //which will allow them to register and let the provider add model binding and
  //action changing
  if (typeof window !== 'undefined') {
    window.UStoreProvider = UStoreProvider;
  }

  exports.http = http;
  exports.UStoreProvider = UStoreProvider;

  return exports;

}({}));
