import React, { Component } from "react"
import './Footer.scss'
import { Router, Link } from '$routes'
import { t } from '$themelocalization'
import { getVariableValue } from '$ustoreinternal/services/cssVariables'

/**
 * This component represents the footer in the store
 */
class Footer extends Component {
  render() {
    const footerLogo = getVariableValue('--POC-footer-logo', require(`$assets/images/xmpie-POC-theme-logo.png`), true)
    const heading1 = getVariableValue('--POC-footer-column1-header', t('footerHeader1'))
    const heading2 = getVariableValue('--POC-footer-column2-header', t('footerHeader2'))
    const textCol1row1 = getVariableValue('--POC-footer-column1-row1', t('footerCol1Row1'));
    const textCol1row2 = getVariableValue('--POC-footer-column1-row2', t('footerCol1Row2'));
    const textCol1row3 = getVariableValue('--POC-footer-column1-row3', t('footerCol1Row3'));
    const linkCol1row1 = getVariableValue('--POC-footer-column1-row1-link', '', false, true);
    const linkCol1row2 = getVariableValue('--POC-footer-column1-row2-link', '', false, true);
    const linkCol1row3 = getVariableValue('--POC-footer-column1-row3-link', '', false, true);
    const textCol2row1 = getVariableValue('--POC-footer-column2-row1', t('footerCol2Row1'));
    const textCol2row2 = getVariableValue('--POC-footer-column2-row2', t('footerCol2Row2'));
    const textCol2row3 = getVariableValue('--POC-footer-column2-row3', t('footerCol2Row3'));
    const linkCol2row1 = getVariableValue('--POC-footer-column2-row1-link', '', false, true);
    const linkCol2row2 = getVariableValue('--POC-footer-column2-row2-link', '', false, true);
    const linkCol2row3 = getVariableValue('--POC-footer-column2-row3-link', '', false, true);
    const textCol3row1 = getVariableValue('--POC-footer-column3-row1', t('footerCol3Row1'));
    const textCol3row2 = getVariableValue('--POC-footer-column3-row2', t('footerCol3Row2'));
    const textCol3row3 = getVariableValue('--POC-footer-column3-row3', t('footerCol3Row3'));
    const linkCol3row1 = getVariableValue('--POC-footer-column3-row1-link', '', false, true);
    const linkCol3row2 = getVariableValue('--POC-footer-column3-row2-link', '', false, true);
    const linkCol3row3 = getVariableValue('--POC-footer-column3-row3-link', 'https://www.xmpie.com/products/web-to-print/storeflow/', false, true);

    return (
      <div className="footer">
        <div id="footer-column-one">
          <span id="footer-colunm-one-header"><strong>{heading1}</strong></span><br />
          <Link to={linkCol1row1}>
            <a id="footer-c1r1">{textCol1row1}</a>
          </Link><br />
          <Link to={linkCol1row2}>
            <a id="footer-c1r2">{textCol1row2}</a>
          </Link><br />
          <Link to={linkCol1row3}>
            <a id="footer-c1r3">{textCol1row3}</a>
          </Link>
        </div>
        <div className="footer-column" id="footer-column-two">
        <span id="footer-colunm-two-header"><strong>{heading2}</strong></span><br />
          <Link to={linkCol2row1}>
            <a id="footer-c2r1">{textCol2row1}</a>
          </Link><br />
          <Link to={linkCol2row2}>
            <a id="footer-c2r2">{textCol2row2}</a>
          </Link><br />
          <Link to={linkCol2row3}>
            <a id="footer-c2r3">{textCol2row3}</a>
          </Link><br />
        </div>
        <div className="footer-column"  id="footer-column-three">
        <div className="footer-logo-container"><img src={footerLogo} className="footerLogo" /></div><br />
          <Link to={linkCol3row1}>
            <a id="footer-c3r1">{textCol3row1}</a>
          </Link><br />
          <Link to={linkCol3row2}>
            <a id="footer-c3r2">{textCol3row2}</a>
          </Link><br />
          <Link to={linkCol3row3}>
            <a id="footer-c3r3">{textCol3row3}</a>
          </Link>
        </div>
      </div>
    )
  }
}
export default Footer
