"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function onExit(fn) {
    function exit(signal = '') {
        try {
            if (listeners.length) {
                fn();
            }
        }
        finally {
            while (listeners.length) {
                const { event, handler } = listeners.shift();
                process.removeListener(event, handler);
            }
            if (signal) {
                process.kill(process.pid, signal);
            }
        }
    }
    const listeners = [
        { event: 'SIGINT', handler: () => exit('SIGINT') },
        { event: 'SIGHUP', handler: () => exit('SIGHUP') },
        { event: 'SIGQUIT', handler: () => exit('SIGQUIT') },
        { event: 'SIGTERM', handler: () => exit('SIGTERM') },
        {
            event: 'uncaughtException',
            handler: (error) => {
                console.error('Got uncaughtException:', error);
                exit();
                process.exit(1);
            },
        },
        { event: 'exit', handler: () => exit() },
    ];
    for (const { event, handler } of listeners) {
        process.on(event, handler);
    }
}
exports.onExit = onExit;
