"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (_ref) {
  var t = _ref.types;

  return {
    visitor: {
      CallExpression: function CallExpression(path) {

        var callee = path.node.callee;

        if (t.isMemberExpression(callee, { computed: false }) && t.isIdentifier(callee.property, { name: "includes" })) {

          callee.property.name = 'indexOf';

          path.replaceWith(t.binaryExpression("!==", path.node, t.numericLiteral(-1)));
        }
      }
    }
  };
};