import React, { useRef } from 'react'
import PropTypes from 'prop-types'

import './tooltipStyles.scss'

const Tooltip = (props) => {
  const { text, className, placement, arrow, maxLine } = props
  const elementRef = useRef()
  const titleRef = useRef()

  const isTargetElement = elementRef.current && (titleRef.current.offsetHeight < titleRef.current.scrollHeight)

  return (
    <div
      ref={elementRef}
      className={`defaultStylesTooltip ${className} placement-${placement}`}
    >
      <div className={`tooltip-title lines-${maxLine}`} ref={titleRef}>
        {text}

      </div>
      {isTargetElement && <div className='tooltip-text' ref={elementRef}>
      <span className={`arrow-${arrow}`}/>
        {text}
      </div>}
    </div>
  )
}

Tooltip.defaultProps = {
  text: '',
  className: '',
  placement: 'top',
  arrow: true,
  maxLine: 2
}

Tooltip.propTypes = {
  maxLine: PropTypes.oneOf([1, 2, 3, 4, 5]),
  text: PropTypes.string,
  className: PropTypes.string,
  placement: PropTypes.oneOf(['top', 'bottom']),
  arrow: PropTypes.bool
}

export default Tooltip
