"use strict";var _interopRequireWildcard=require("@babel/runtime-corejs2/helpers/interopRequireWildcard");var _interopRequireDefault=require("@babel/runtime-corejs2/helpers/interopRequireDefault");exports.__esModule=true;exports.middleware=middleware;exports.NextScript=exports.Main=exports.Head=exports.Html=exports.default=void 0;var _stringify=_interopRequireDefault(require("@babel/runtime-corejs2/core-js/json/stringify"));var _isArray=_interopRequireDefault(require("@babel/runtime-corejs2/core-js/array/is-array"));var _keys=_interopRequireDefault(require("@babel/runtime-corejs2/core-js/object/keys"));var _extends2=_interopRequireDefault(require("@babel/runtime-corejs2/helpers/extends"));var _now=_interopRequireDefault(require("@babel/runtime-corejs2/core-js/date/now"));var _set=_interopRequireDefault(require("@babel/runtime-corejs2/core-js/set"));var _asyncToGenerator2=_interopRequireDefault(require("@babel/runtime-corejs2/helpers/asyncToGenerator"));var _propTypes=_interopRequireDefault(require("prop-types"));var _react=_interopRequireWildcard(require("react"));var _utils=require("../next-server/server/utils");var _utils2=require("../next-server/lib/utils");exports.DocumentContext=_utils2.DocumentContext;exports.DocumentInitialProps=_utils2.DocumentInitialProps;exports.DocumentProps=_utils2.DocumentProps;var _htmlescape=require("../server/htmlescape");var _server=_interopRequireDefault(require("styled-jsx/server"));var _constants=require("../next-server/lib/constants");var _documentContext=require("../next-server/lib/document-context");/* eslint-disable */function middleware(_x){return _middleware.apply(this,arguments);}function _middleware(){_middleware=(0,_asyncToGenerator2.default)(function*(_ref){var{req,res}=_ref;});return _middleware.apply(this,arguments);}function dedupe(bundles){var files=new _set.default();var kept=[];for(var bundle of bundles){if(files.has(bundle.file))continue;files.add(bundle.file);kept.push(bundle);}return kept;}function getOptionalModernScriptVariant(path){if(process.env.__NEXT_MODERN_BUILD){return path.replace(/\.js$/,'.module.js');}return path;}/**
 * `Document` component handles the initial `document` markup and renders only on the server side.
 * Commonly used for implementing server side rendering for `css-in-js` libraries.
 */class Document extends _react.Component{/**
   * `getInitialProps` hook returns the context object with the addition of `renderPage`.
   * `renderPage` callback executes `React` rendering logic synchronously to support server-rendering wrappers
   */static getInitialProps(_ref2){return(0,_asyncToGenerator2.default)(function*(){var{renderPage}=_ref2;var{html,head,dataOnly}=yield renderPage();var styles=(0,_server.default)();return{html,head,styles,dataOnly};})();}static renderDocument(Document,props){return _react.default.createElement(_documentContext.DocumentContext.Provider,{value:{_documentProps:props,// In dev we invalidate the cache by appending a timestamp to the resource URL.
// This is a workaround to fix https://github.com/zeit/next.js/issues/5860
// TODO: remove this workaround when https://bugs.webkit.org/show_bug.cgi?id=187726 is fixed.
_devOnlyInvalidateCacheQueryString:process.env.NODE_ENV!=='production'?'?ts='+(0,_now.default)():''}},_react.default.createElement(Document,props));}render(){return _react.default.createElement(Html,null,_react.default.createElement(Head,null),_react.default.createElement("body",null,_react.default.createElement(Main,null),_react.default.createElement(NextScript,null)));}}exports.default=Document;class Html extends _react.Component{constructor(){super(...arguments);this.context=void 0;}render(){var{inAmpMode}=this.context._documentProps;return _react.default.createElement("html",(0,_extends2.default)({},this.props,{amp:inAmpMode?'':undefined,"data-ampdevmode":inAmpMode&&process.env.NODE_ENV!=='production'?'':undefined}));}}exports.Html=Html;Html.contextType=_documentContext.DocumentContext;Html.propTypes={children:_propTypes.default.node.isRequired};class Head extends _react.Component{constructor(){super(...arguments);this.context=void 0;}getCssLinks(){var{assetPrefix,files}=this.context._documentProps;var cssFiles=files&&files.length?files.filter(f=>/\.css$/.test(f)):[];var cssLinkElements=[];cssFiles.forEach(file=>{cssLinkElements.push(_react.default.createElement("link",{key:"${file}-preload",nonce:this.props.nonce,rel:"preload",href:assetPrefix+"/_next/"+encodeURI(file),as:"style",crossOrigin:this.props.crossOrigin||process.crossOrigin}),_react.default.createElement("link",{key:file,nonce:this.props.nonce,rel:"stylesheet",href:assetPrefix+"/_next/"+encodeURI(file),crossOrigin:this.props.crossOrigin||process.crossOrigin}));});return cssLinkElements.length===0?null:cssLinkElements;}getPreloadDynamicChunks(){var{dynamicImports,assetPrefix}=this.context._documentProps;var{_devOnlyInvalidateCacheQueryString}=this.context;return dedupe(dynamicImports).map(bundle=>{// `dynamicImports` will contain both `.js` and `.module.js` when the
// feature is enabled. This clause will filter down to the modern
// variants only.
if(!bundle.file.endsWith(getOptionalModernScriptVariant('.js'))){return null;}return _react.default.createElement("link",{rel:"preload",key:bundle.file,href:assetPrefix+"/_next/"+encodeURI(bundle.file)+_devOnlyInvalidateCacheQueryString,as:"script",nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin});})// Filter out nulled scripts
.filter(Boolean);}getPreloadMainLinks(){var{assetPrefix,files}=this.context._documentProps;var{_devOnlyInvalidateCacheQueryString}=this.context;var preloadFiles=files&&files.length?files.filter(file=>{// `dynamicImports` will contain both `.js` and `.module.js` when
// the feature is enabled. This clause will filter down to the
// modern variants only.
//
// Also filter out _buildManifest because it should not be
// preloaded for performance reasons.
return file.endsWith(getOptionalModernScriptVariant('.js'))&&!file.includes('_buildManifest');}):[];return preloadFiles.length===0?null:preloadFiles.map(file=>{return _react.default.createElement("link",{key:file,nonce:this.props.nonce,rel:"preload",href:assetPrefix+"/_next/"+encodeURI(file)+_devOnlyInvalidateCacheQueryString,as:"script",crossOrigin:this.props.crossOrigin||process.crossOrigin});});}render(){var{styles,ampPath,inAmpMode,assetPrefix,hybridAmp,canonicalBase,__NEXT_DATA__,dangerousAsPath}=this.context._documentProps;var{_devOnlyInvalidateCacheQueryString}=this.context;var{page,buildId}=__NEXT_DATA__;var{head}=this.context._documentProps;var children=this.props.children;// show a warning if Head contains <title> (only in development)
if(process.env.NODE_ENV!=='production'){children=_react.default.Children.map(children,child=>{var isReactHelmet=child&&child.props&&child.props['data-react-helmet'];if(child&&child.type==='title'&&!isReactHelmet){console.warn("Warning: <title> should not be used in _document.js's <Head>. https://err.sh/next.js/no-document-title");}return child;});if(this.props.crossOrigin)console.warn('Warning: `Head` attribute `crossOrigin` is deprecated. https://err.sh/next.js/doc-crossorigin-deprecated');}var hasAmphtmlRel=false;var hasCanonicalRel=false;// show warning and remove conflicting amp head tags
head=_react.default.Children.map(head||[],child=>{if(!child)return child;var{type,props}=child;if(inAmpMode){var badProp='';if(type==='meta'&&props.name==='viewport'){badProp='name="viewport"';}else if(type==='link'&&props.rel==='canonical'){hasCanonicalRel=true;}else if(type==='script'){// only block if
// 1. it has a src and isn't pointing to ampproject's CDN
// 2. it is using dangerouslySetInnerHTML without a type or
// a type of text/javascript
if(props.src&&props.src.indexOf('ampproject')<-1||props.dangerouslySetInnerHTML&&(!props.type||props.type==='text/javascript')){badProp='<script';(0,_keys.default)(props).forEach(prop=>{badProp+=" "+prop+"=\""+props[prop]+"\"";});badProp+='/>';}}if(badProp){console.warn("Found conflicting amp tag \""+child.type+"\" with conflicting prop "+badProp+" in "+__NEXT_DATA__.page+". https://err.sh/next.js/conflicting-amp-tag");return null;}}else{// non-amp mode
if(type==='link'&&props.rel==='amphtml'){hasAmphtmlRel=true;}}return child;});// try to parse styles from fragment for backwards compat
var curStyles=(0,_isArray.default)(styles)?styles:[];if(inAmpMode&&styles&&// @ts-ignore Property 'props' does not exist on type ReactElement
styles.props&&// @ts-ignore Property 'props' does not exist on type ReactElement
(0,_isArray.default)(styles.props.children)){var hasStyles=el=>el&&el.props&&el.props.dangerouslySetInnerHTML&&el.props.dangerouslySetInnerHTML.__html;// @ts-ignore Property 'props' does not exist on type ReactElement
styles.props.children.map(child=>{if((0,_isArray.default)(child)){child.map(el=>hasStyles(el)&&curStyles.push(el));}else if(hasStyles(child)){curStyles.push(child);}});}return _react.default.createElement("head",this.props,this.context._documentProps.isDevelopment&&this.context._documentProps.hasCssMode&&_react.default.createElement(_react.default.Fragment,null,_react.default.createElement("style",{"data-next-hide-fouc":true,dangerouslySetInnerHTML:{__html:"body{display:none}"}}),_react.default.createElement("noscript",{"data-next-hide-fouc":true},_react.default.createElement("style",{dangerouslySetInnerHTML:{__html:"body{display:block}"}}))),children,head,_react.default.createElement("meta",{name:"next-head-count",content:_react.default.Children.count(head||[]).toString()}),inAmpMode&&_react.default.createElement(_react.default.Fragment,null,_react.default.createElement("meta",{name:"viewport",content:"width=device-width,minimum-scale=1,initial-scale=1"}),!hasCanonicalRel&&_react.default.createElement("link",{rel:"canonical",href:canonicalBase+(0,_utils.cleanAmpPath)(dangerousAsPath)}),_react.default.createElement("link",{rel:"preload",as:"script",href:"https://cdn.ampproject.org/v0.js"}),styles&&_react.default.createElement("style",{"amp-custom":"",dangerouslySetInnerHTML:{__html:curStyles.map(style=>style.props.dangerouslySetInnerHTML.__html).join('').replace(/\/\*# sourceMappingURL=.*\*\//g,'').replace(/\/\*@ sourceURL=.*?\*\//g,'')}}),_react.default.createElement("style",{"amp-boilerplate":"",dangerouslySetInnerHTML:{__html:"body{-webkit-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-moz-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-ms-animation:-amp-start 8s steps(1,end) 0s 1 normal both;animation:-amp-start 8s steps(1,end) 0s 1 normal both}@-webkit-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-moz-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-ms-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-o-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}"}}),_react.default.createElement("noscript",null,_react.default.createElement("style",{"amp-boilerplate":"",dangerouslySetInnerHTML:{__html:"body{-webkit-animation:none;-moz-animation:none;-ms-animation:none;animation:none}"}})),_react.default.createElement("script",{async:true,src:"https://cdn.ampproject.org/v0.js"})),!inAmpMode&&_react.default.createElement(_react.default.Fragment,null,!hasAmphtmlRel&&hybridAmp&&_react.default.createElement("link",{rel:"amphtml",href:canonicalBase+getAmpPath(ampPath,dangerousAsPath)}),page!=='/_error'&&_react.default.createElement("link",{rel:"preload",href:assetPrefix+getOptionalModernScriptVariant(encodeURI("/_next/static/"+buildId+"/pages"+getPageFile(page)))+_devOnlyInvalidateCacheQueryString,as:"script",nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin}),_react.default.createElement("link",{rel:"preload",href:assetPrefix+getOptionalModernScriptVariant(encodeURI("/_next/static/"+buildId+"/pages/_app.js"))+_devOnlyInvalidateCacheQueryString,as:"script",nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin}),this.getPreloadDynamicChunks(),this.getPreloadMainLinks(),this.context._documentProps.isDevelopment&&this.context._documentProps.hasCssMode&&// this element is used to mount development styles so the
// ordering matches production
// (by default, style-loader injects at the bottom of <head />)
_react.default.createElement("noscript",{id:"__next_css__DO_NOT_USE__"}),this.getCssLinks(),styles||null));}}exports.Head=Head;Head.contextType=_documentContext.DocumentContext;Head.propTypes={nonce:_propTypes.default.string,crossOrigin:_propTypes.default.string};class Main extends _react.Component{constructor(){super(...arguments);this.context=void 0;}render(){var{inAmpMode,html}=this.context._documentProps;if(inAmpMode)return'__NEXT_AMP_RENDER_TARGET__';return _react.default.createElement("div",{id:"__next",dangerouslySetInnerHTML:{__html:html}});}}exports.Main=Main;Main.contextType=_documentContext.DocumentContext;class NextScript extends _react.Component{constructor(){super(...arguments);this.context=void 0;}getDynamicChunks(){var{dynamicImports,assetPrefix,files}=this.context._documentProps;var{_devOnlyInvalidateCacheQueryString}=this.context;return dedupe(dynamicImports).map(bundle=>{var modernProps={};if(process.env.__NEXT_MODERN_BUILD){modernProps=/\.module\.js$/.test(bundle.file)?{type:'module'}:{noModule:true};}if(!/\.js$/.test(bundle.file)||files.includes(bundle.file))return null;return _react.default.createElement("script",(0,_extends2.default)({defer:process.env.__NEXT_DEFER_SCRIPTS,async:!process.env.__NEXT_DEFER_SCRIPTS,key:bundle.file,src:assetPrefix+"/_next/"+encodeURI(bundle.file)+_devOnlyInvalidateCacheQueryString,nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin},modernProps));});}getScripts(){var{assetPrefix,files}=this.context._documentProps;if(!files||files.length===0){return null;}var{_devOnlyInvalidateCacheQueryString}=this.context;return files.map(file=>{// Only render .js files here
if(!/\.js$/.test(file)){return null;}var modernProps={};if(process.env.__NEXT_MODERN_BUILD){modernProps=/\.module\.js$/.test(file)?{type:'module'}:{noModule:true};}return _react.default.createElement("script",(0,_extends2.default)({key:file,src:assetPrefix+"/_next/"+encodeURI(file)+_devOnlyInvalidateCacheQueryString,nonce:this.props.nonce,defer:process.env.__NEXT_DEFER_SCRIPTS,async:!process.env.__NEXT_DEFER_SCRIPTS,crossOrigin:this.props.crossOrigin||process.crossOrigin},modernProps));});}static getInlineScriptSource(documentProps){var{__NEXT_DATA__}=documentProps;try{var data=(0,_stringify.default)(__NEXT_DATA__);return(0,_htmlescape.htmlEscapeJsonString)(data);}catch(err){if(err.message.indexOf('circular structure')){throw new Error("Circular structure in \"getInitialProps\" result of page \""+__NEXT_DATA__.page+"\". https://err.sh/zeit/next.js/circular-structure");}throw err;}}render(){var{staticMarkup,assetPrefix,inAmpMode,devFiles,__NEXT_DATA__}=this.context._documentProps;var deferScripts=process.env.__NEXT_DEFER_SCRIPTS;var{_devOnlyInvalidateCacheQueryString}=this.context;if(inAmpMode){if(process.env.NODE_ENV==='production'){return null;}var _devFiles=[_constants.CLIENT_STATIC_FILES_RUNTIME_AMP,_constants.CLIENT_STATIC_FILES_RUNTIME_WEBPACK];return _react.default.createElement(_react.default.Fragment,null,staticMarkup?null:_react.default.createElement("script",{id:"__NEXT_DATA__",type:"application/json",nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin,dangerouslySetInnerHTML:{__html:NextScript.getInlineScriptSource(this.context._documentProps)},"data-ampdevmode":true}),_devFiles?_devFiles.map(file=>_react.default.createElement("script",{key:file,src:assetPrefix+"/_next/"+file+_devOnlyInvalidateCacheQueryString,nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin,"data-ampdevmode":true})):null);}var{page,buildId}=__NEXT_DATA__;if(process.env.NODE_ENV!=='production'){if(this.props.crossOrigin)console.warn('Warning: `NextScript` attribute `crossOrigin` is deprecated. https://err.sh/next.js/doc-crossorigin-deprecated');}var pageScript=[_react.default.createElement("script",(0,_extends2.default)({defer:deferScripts,async:!deferScripts,"data-next-page":page,key:page,src:assetPrefix+encodeURI("/_next/static/"+buildId+"/pages"+getPageFile(page))+_devOnlyInvalidateCacheQueryString,nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin},process.env.__NEXT_MODERN_BUILD?{noModule:true}:{})),process.env.__NEXT_MODERN_BUILD&&_react.default.createElement("script",{defer:deferScripts,async:!deferScripts,"data-next-page":page,key:page+"-modern",src:assetPrefix+getOptionalModernScriptVariant(encodeURI("/_next/static/"+buildId+"/pages"+getPageFile(page)))+_devOnlyInvalidateCacheQueryString,nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin,type:"module"})];var appScript=[_react.default.createElement("script",(0,_extends2.default)({defer:deferScripts,async:!deferScripts,"data-next-page":"/_app",src:assetPrefix+("/_next/static/"+buildId+"/pages/_app.js")+_devOnlyInvalidateCacheQueryString,key:"_app",nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin},process.env.__NEXT_MODERN_BUILD?{noModule:true}:{})),process.env.__NEXT_MODERN_BUILD&&_react.default.createElement("script",{defer:deferScripts,async:!deferScripts,"data-next-page":"/_app",src:assetPrefix+("/_next/static/"+buildId+"/pages/_app.module.js")+_devOnlyInvalidateCacheQueryString,key:"_app-modern",nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin,type:"module"})];return _react.default.createElement(_react.default.Fragment,null,devFiles?devFiles.map(file=>!file.match(/\.js\.map/)&&_react.default.createElement("script",{key:file,src:assetPrefix+"/_next/"+encodeURI(file)+_devOnlyInvalidateCacheQueryString,nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin})):null,staticMarkup?null:_react.default.createElement("script",{id:"__NEXT_DATA__",type:"application/json",nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin,dangerouslySetInnerHTML:{__html:NextScript.getInlineScriptSource(this.context._documentProps)}}),process.env.__NEXT_MODERN_BUILD?_react.default.createElement("script",{nonce:this.props.nonce,crossOrigin:this.props.crossOrigin||process.crossOrigin,noModule:true,dangerouslySetInnerHTML:{__html:NextScript.safariNomoduleFix}}):null,page!=='/_error'&&pageScript,appScript,staticMarkup?null:this.getDynamicChunks(),staticMarkup?null:this.getScripts());}}exports.NextScript=NextScript;NextScript.contextType=_documentContext.DocumentContext;NextScript.propTypes={nonce:_propTypes.default.string,crossOrigin:_propTypes.default.string};NextScript.safariNomoduleFix='!function(){var e=document,t=e.createElement("script");if(!("noModule"in t)&&"onbeforeload"in t){var n=!1;e.addEventListener("beforeload",function(e){if(e.target===t)n=!0;else if(!e.target.hasAttribute("nomodule")||!n)return;e.preventDefault()},!0),t.type="module",t.src=".",e.head.appendChild(t),t.remove()}}();';function getAmpPath(ampPath,asPath){return ampPath?ampPath:""+asPath+(asPath.includes('?')?'&':'?')+"amp=1";}function getPageFile(page,buildId){if(page==='/'){return buildId?"/index."+buildId+".js":'/index.js';}return buildId?page+"."+buildId+".js":page+".js";}