"use strict";exports.__esModule=true;exports.collectPages=collectPages;exports.printTreeView=printTreeView;exports.getPageSizeInKb=getPageSizeInKb;exports.isPageStatic=isPageStatic;exports.hasCustomAppGetInitialProps=hasCustomAppGetInitialProps;var _chalk=_interopRequireDefault(require("chalk"));var _fs=_interopRequireDefault(require("fs"));var _textTable=_interopRequireDefault(require("next/dist/compiled/text-table"));var _path=_interopRequireDefault(require("path"));var _stripAnsi=_interopRequireDefault(require("strip-ansi"));var _util=require("util");var _reactIs=require("react-is");var _prettyBytes=_interopRequireDefault(require("../lib/pretty-bytes"));var _recursiveReaddir=require("../lib/recursive-readdir");var _isDynamic=require("../next-server/lib/router/utils/is-dynamic");var _utils=require("../next-server/lib/router/utils");var _constants=require("../lib/constants");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}const fsStatPromise=(0,_util.promisify)(_fs.default.stat);const fileStats={};const fsStat=file=>{if(fileStats[file])return fileStats[file];fileStats[file]=fsStatPromise(file);return fileStats[file];};function collectPages(directory,pageExtensions){return(0,_recursiveReaddir.recursiveReadDir)(directory,new RegExp(`\\.(?:${pageExtensions.join('|')})$`));}function printTreeView(list,pageInfos,serverless){const getPrettySize=_size=>{const size=(0,_prettyBytes.default)(_size);// green for 0-100kb
if(_size<100*1000)return _chalk.default.green(size);// yellow for 100-250kb
if(_size<250*1000)return _chalk.default.yellow(size);// red for >= 250kb
return _chalk.default.red.bold(size);};const messages=[['Page','Size','Files','Packages'].map(entry=>_chalk.default.underline(entry))];list.sort((a,b)=>a.localeCompare(b)).forEach((item,i)=>{const symbol=i===0?list.length===1?'─':'┌':i===list.length-1?'└':'├';const pageInfo=pageInfos.get(item);messages.push([`${symbol} ${item.startsWith('/_')?' ':pageInfo&&pageInfo.static?_chalk.default.bold('⚡'):serverless?'λ':'σ'} ${item}`,...(pageInfo?[pageInfo.isAmp?_chalk.default.cyan('AMP'):pageInfo.size>=0?getPrettySize(pageInfo.size):'',pageInfo.chunks?pageInfo.chunks.internal.size.toString():'',pageInfo.chunks?pageInfo.chunks.external.size.toString():'']:['','',''])]);});console.log((0,_textTable.default)(messages,{align:['l','l','r','r'],stringLength:str=>(0,_stripAnsi.default)(str).length}));console.log();console.log((0,_textTable.default)([serverless?['λ','(Lambda)',`page was emitted as a lambda (i.e. ${_chalk.default.cyan('getInitialProps')})`]:['σ','(Server)',`page will be server rendered (i.e. ${_chalk.default.cyan('getInitialProps')})`],[_chalk.default.bold('⚡'),'(Static File)','page was prerendered as static HTML']],{align:['l','l','l'],stringLength:str=>(0,_stripAnsi.default)(str).length}));console.log();}async function getPageSizeInKb(page,distPath,buildId,buildManifest,isModern){const clientBundle=_path.default.join(distPath,`static/${buildId}/pages/`,`${page}${isModern?'.module':''}.js`);// With granularChunks flag enabled, each page may have additional chunks that it depends on
const baseDeps=page==='/_app'?[]:buildManifest.pages['/_app'];// Get the list of chunks specific to this page
// With granularChunks: false, this will be []
const deps=(buildManifest.pages[page]||[]).filter(dep=>!baseDeps.includes(dep)&&/\.module\.js$/.test(dep)===isModern).map(dep=>`${distPath}/${dep}`);// Add the main bundle for the page
deps.push(clientBundle);try{let depStats=await Promise.all(deps.map(fsStat));return depStats.reduce((size,stat)=>size+stat.size,0);}catch(_){}return-1;}async function isPageStatic(page,serverBundle,runtimeEnvConfig){try{require('../next-server/lib/runtime-config').setConfig(runtimeEnvConfig);const mod=require(serverBundle);const Comp=mod.default||mod;if(!Comp||!(0,_reactIs.isValidElementType)(Comp)||typeof Comp==='string'){throw new Error('INVALID_DEFAULT_EXPORT');}const hasGetInitialProps=!!Comp.getInitialProps;const hasStaticProps=!!mod.unstable_getStaticProps;const hasStaticParams=!!mod.unstable_getStaticParams;// A page cannot be prerendered _and_ define a data requirement. That's
// contradictory!
if(hasGetInitialProps&&hasStaticProps){throw new Error(_constants.SPR_GET_INITIAL_PROPS_CONFLICT);}// A page cannot have static parameters if it is not a dynamic page.
if(hasStaticProps&&hasStaticParams&&!(0,_isDynamic.isDynamicRoute)(page)){throw new Error(`unstable_getStaticParams can only be used with dynamic pages. https://nextjs.org/docs#dynamic-routing`);}let prerenderPaths;if(hasStaticProps&&hasStaticParams){prerenderPaths=[];const _routeRegex=(0,_utils.getRouteRegex)(page);const _routeMatcher=(0,_utils.getRouteMatcher)(_routeRegex);// Get the default list of allowed params.
const _validParamKeys=Object.keys(_routeMatcher(page));const toPrerender=await mod.unstable_getStaticParams();toPrerender.forEach(entry=>{// For a string-provided path, we must make sure it matches the dynamic
// route.
if(typeof entry==='string'){const result=_routeMatcher(entry);if(!result){throw new Error(`The provided path \`${entry}\` does not match the page: \`${page}\`.`);}prerenderPaths.push(entry);}// For the object-provided path, we must make sure it specifies all
// required keys.
else{let builtPage=page;_validParamKeys.forEach(validParamKey=>{if(typeof entry[validParamKey]!=='string'){throw new Error(`A required parameter (${validParamKey}) was not provided as a string.`);}builtPage=builtPage.replace(`[${validParamKey}]`,encodeURIComponent(entry[validParamKey]));});prerenderPaths.push(builtPage);}});}const config=mod.config||{};return{static:!hasStaticProps&&!hasGetInitialProps,isHybridAmp:config.amp==='hybrid',prerenderRoutes:prerenderPaths,prerender:hasStaticProps};}catch(err){if(err.code==='MODULE_NOT_FOUND')return{};throw err;}}function hasCustomAppGetInitialProps(_appBundle,runtimeEnvConfig){require('../next-server/lib/runtime-config').setConfig(runtimeEnvConfig);let mod=require(_appBundle);if(_appBundle.endsWith('_app.js')){mod=mod.default||mod;}else{// since we don't output _app in serverless mode get it from a page
mod=mod._app;}return mod.getInitialProps!==mod.origGetInitialProps;}