import React, { Component } from 'react'
import Hashids from 'hashids'

import ProductQuantity from './ProductQuantity'
import { t } from '$themelocalization'
import { isServer } from '$ustoreinternal/services/utils'
import PropertiesFormNG from '$core-components/PropertiesFormNG'
import { UStoreProvider } from '@ustore/core'
import { isDate, convertDate, mergeDeep, checkSchemaForDependencies } from '../../services/utils'
import './ProductProperties.scss'
import { throttle } from "throttle-debounce";
import deepcopy from "deepcopy";


const withCustomProps = (WrappedComponent, additionalData = {}) => {
  class ConnectedComponent extends React.Component {
    constructor(props) {
      super(props);
      const regex = new RegExp(/[!$%^&*()+|~=`{}\[\]:";'<>?,.\/]/, 'g');
      this.id = this.props.id.replace('root_', '').replace(regex, '')

    }

    onDucChange = (value, errors = []) => {
      const newDucValue = value === 'default' ? undefined : value
      const schemaErrors = !value && this.props.uiSchema['ui:errorMessages']
        ? Object.values(this.props.uiSchema['ui:errorMessages']).map((err) => err)
        : []

      const errSchema = { [this.props.id]: { __errors: [...schemaErrors, ...errors] }}
      this.props.onChange(this.props.id, newDucValue, errSchema)
    }

    render() {
      const hashids = new Hashids(this.id)
      const hashedID = hashids.encode(1, 2, 3)

      // const propsWithoutOnChange = Object.keys(this.props)
      //   .filter((key) => key !== 'onChange')
      //   .reduce((acc, next) => ({...acc, [next]: this.props[next]}), {})

      return (
        <div className={hashedID}>
          <WrappedComponent
            {...this.props}
            onChange={this.onDucChange}
            id={this.id}
            additionalData={additionalData}
            disabled={this.props.schema.disabled}
          />
        </div>
      )
    }
  }
  return ConnectedComponent
}

const widgets = !isServer() ? uStoreDucs.reduce((r, duc) => ({...r, [duc.name]: withCustomProps(duc.component)}), {})  : {}

const formDataWithoutStrings = (formData) => {
  return Object.keys(formData).reduce((acc, next) => {
    if(formData[next] === '') {
      acc[next] = undefined
    } else {
      acc[next] = formData[next]
    }
    return acc
  }, {})
}

class ProductPropertiesNG extends Component {
  constructor(props) {
    super(props)
    this.state = {
      ducErrors: [],
      formData: this.props.propertiesModel.formData,
      jsonSchema: this.props.propertiesModel.JSONSchema,
      uiSchema: this.props.propertiesModel.UISchema,
      allFormData: {}
    }

    this.iframeSrc = ''
  }

  updatePropertiesState = async (dataToUpdate) => {
    const { orderModel: { ID } } = this.props
    // send the data to BE to be saved in DB.
    const { currentProductProperties: productProperties } = UStoreProvider.state.customState.get()
    const res = await UStoreProvider.api.orders.updatePropertiesState(ID, dataToUpdate)

    if(Object.keys(res).includes('formData')) {
    const updatedData = formDataWithoutStrings(res.formData)
      
    let newData = {}
    if(res.JSONSchema) {
      const newProperties = Object.keys(res.JSONSchema.properties).reduce((acc, key) => {
        acc[key] = {
          ...res.JSONSchema.properties[key]
        }
        return acc
      }, {})

      const newDefinitions = Object.keys(productProperties.JSONSchema.definitions).reduce((acc, key) => {
        let enums = {}
        let enumNames = {}

        if (res.JSONSchema.properties[key] && productProperties.JSONSchema.properties[key].enum) {
          enums = {enum: res.JSONSchema.properties[key].enum}
        }
        if (res.JSONSchema.properties[key] && productProperties.JSONSchema.definitions[key].enumNames) {
          enumNames = {enumNames: res.JSONSchema.properties[key].enumNames}
        }

        acc[key] = {
          ...productProperties.JSONSchema.definitions[key],
          ...enums,
          ...enumNames
        }

        return acc
      }, {})

      newData = {
        ...productProperties,
        UISchema: res.UISchema,
        formData: updatedData,
        JSONSchema: {
          ...productProperties.JSONSchema,
          properties: newProperties,
          definitions: mergeDeep(res.JSONSchema.definitions, newDefinitions)
        }
      }
    } else {
      newData = {
        ...productProperties,
        UISchema: res.UISchema
      }
    }

    const updatedSchema = {
      ...productProperties,
      UISchema: newData.UISchema,
      JSONSchema: {
        ...productProperties.JSONSchema,
        properties: newData.JSONSchema.properties,
        definitions: newData.JSONSchema.definitions,
        dependencies: res.JSONSchema.dependencies,
        required: res.JSONSchema.required
      },
      errors: res.errors ? res.errors : {},
      formData: Object.assign({}, productProperties.formData, res.formData),
    }

    this.setState({
      jsonSchema: updatedSchema.JSONSchema,
      uiSchema: updatedSchema.UISchema,
      formData: updatedSchema.formData,
      errors: res.errors ? res.errors : {}
    })

    UStoreProvider.state.customState.set('currentProductProperties', updatedSchema)
    return updatedSchema
  } else {
    console.error(res)
  }
  }

  onPropertyChange = throttle(500,async (newData, hiddenErrors = [], visibleErrors = [], newSchema) => {
    const prevData = { ...this.state.formData }
    const { onFormChange } = this.props

    const providerState = UStoreProvider.state.customState.get()
    const productProperties = providerState.currentProductProperties

    let errors = [].concat(hiddenErrors || [])

    const updatedData = formDataWithoutStrings(newData)

    const changedProperties = Object.keys(updatedData)
      .filter((propertyName) => newData[propertyName] !== prevData[propertyName])

    if (changedProperties.length > 0) {
      // before sending the data to BE, check if ANY of the ducs is marked as 'autoSaveStateOnChange'
      // if at least one is true - send the entire data structure (not just the ones marked)
      let shouldUpdate = false
      const propertiesToUpdate = Object.keys(updatedData).reduce((updatedProperties, key) => {
        const definition = productProperties.JSONSchema.definitions[key]
        if (definition && definition.custom) {
          shouldUpdate = true
        }

        updatedProperties.push({
          id: definition.custom.id,
          value: updatedData[key]
            ? isDate(updatedData[key])
              ? convertDate(updatedData[key])
              : updatedData[key]
            : ''
        })

        return updatedProperties
      }, [])

      if (shouldUpdate) {
        // save the new data to the state before calling the API so when it returns we can check
        // if the response is different from the request.
        const res = await this.updatePropertiesState(propertiesToUpdate)
        if(res) {
          const errorsCopy = deepcopy(errors)

          const errorsFromRes = res && res.errors ? Object.keys(res.errors).reduce((acc, propertyName) => {
            errorsCopy.some((error) => {
              if(error.dataPath === `['${propertyName}']`) {
                if(error.keyword) {
                  acc = acc.concat({
                    message: res.UISchema[propertyName]['ui:errorMessages'][error.keyword],
                    property: propertyName,
                    dataPath: `[${propertyName}]`,
                    affectPrice: productProperties.JSONSchema.definitions[propertyName].custom.affectPrice
                  })
                }
              }
            })
            return acc
          }, []) : []

          errors = errors.concat(errorsFromRes)

          const updatedDataFromRes = formDataWithoutStrings(res.formData)

          this.setState({ formData: updatedDataFromRes, ducErrors: errors })
          UStoreProvider.state.customState.set('currentProductProperties', {
            ...res,
            formData: updatedDataFromRes,
            errors: errors
          })

          onFormChange && onFormChange(newData, prevData, errors, visibleErrors, newSchema)
        }
      }
    }

  })

  render() {
    const {
      className,
      productModel,
      orderModel,
      onQuantityChange,
      isPriceCalculating,
      propertiesModel,
      validateNGDucs,
      onFirstValidate,
      onFirstAddToCart,
      translations,
    } = this.props
    const { formData, ducErrors, jsonSchema, uiSchema } = this.state

    if (!productModel || !propertiesModel || !propertiesModel.JSONSchema || !propertiesModel.UISchema) {
      return null
    }

    return (
      <div className={` ${className} product-properties`}>
        <div className='quantity'>
          <span className='quantity-label'>{t('product.quantity')}</span>
          <ProductQuantity
            supportsInventory={true}
            productModel={productModel}
            orderModel={orderModel}
            onQuantityChange={onQuantityChange}
          />
        </div>
        <PropertiesFormNG
          errors={ducErrors}
          widgets={widgets}
          orderId={orderModel.ID}
          jsonschema={jsonSchema}
          uischema={uiSchema}
          formData={formData}
          validateNGDucs={validateNGDucs}
          onFormDataChanged={this.onPropertyChange}
          isAddClicked={this.props.isAddClicked}
          onFirstValidate={onFirstValidate}
          onFirstAddToCart={onFirstAddToCart}
          translations={translations}
        />
      </div>
    )
  }
}

export default ProductPropertiesNG
