import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { KnobControlConfig, KnobControlProps } from './types';
export declare type ObjectTypeKnob<T> = KnobControlConfig<T>;
declare type ObjectTypeProps<T> = KnobControlProps<T>;
interface ObjectTypeState<T> {
    value: string;
    failed: boolean;
    json?: T;
}
declare class ObjectType<T> extends Component<ObjectTypeProps<T>> {
    static propTypes: {
        knob: PropTypes.Validator<KnobControlConfig<any>>;
        onChange: PropTypes.Validator<(value: any) => any>;
    };
    static defaultProps: ObjectTypeProps<any>;
    static serialize: {
        <T>(object: T): string;
    };
    static deserialize: {
        <T>(value: string): T;
    };
    static getDerivedStateFromProps<T>(props: ObjectTypeProps<T>, state: ObjectTypeState<T>): ObjectTypeState<T> | null;
    state: ObjectTypeState<T>;
    handleChange: (e: React.ChangeEvent<HTMLTextAreaElement>) => void;
    render(): JSX.Element;
}
export default ObjectType;
