"use strict";exports.__esModule=true;exports.getPageChunks=getPageChunks;exports.ChunkGraphPlugin=void 0;var _constants=require("../../../next-server/lib/constants");var _path=_interopRequireDefault(require("path"));var _querystring=require("querystring");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}const manifest={sharedFiles:[],pages:{},pageChunks:{},chunks:{}};const pageModules={};function getPageChunks(page){if(!manifest.pages[page]&&!pageModules[page]){return;}const external=new Set();// from node_modules
const internal=new Set()// from project
;[...(manifest.pages[page]||[]),...(pageModules[page]||[])].map(mod=>{mod=mod.replace(/\\/g,'/');if(mod.match(/(next-server|next)\//)){return null;}if(mod.includes('node_modules/')){if(mod.match(/node_modules\/(@babel|core-js|styled-jsx|string-hash|object-assign|process|react|react-dom|scheduler|regenerator-runtime|webpack|node-libs-browser)\//)){return null;}mod=mod.split('node_modules/')[1].split('/')[0];if(external.has(mod)){return null;}external.add(mod);return mod;}// don't include the page itself
if(mod.includes(`pages${page==='/'?'/index':page}`)){return null;}// is local e.g. ../components/Layout
if(internal.has(mod)){return null;}internal.add(mod);return mod;});return{external,internal};}function getFiles(dir,modules){if(!(modules&&modules.length)){return[];}function getFileByIdentifier(id){if(id.startsWith('external ')||id.startsWith('multi ')){return null;}let n;if((n=id.lastIndexOf('!'))!==-1){id=id.substring(n+1);}if(id&&!_path.default.isAbsolute(id)){id=_path.default.resolve(dir,id);}return id;}return modules.reduce((acc,val)=>val.modules?acc.concat(getFiles(dir,val.modules)):(acc.push(getFileByIdentifier(typeof val.identifier==='function'?val.identifier():val.identifier)),acc),[]).filter(Boolean);}class ChunkGraphPlugin{constructor(buildId,{dir,distDir,isServer}){this.buildId=void 0;this.dir=void 0;this.distDir=void 0;this.isServer=void 0;this.buildId=buildId;this.dir=dir;this.distDir=distDir;this.isServer=isServer;}apply(compiler){const{dir}=this;compiler.hooks.emit.tap('ChunkGraphPlugin',compilation=>{const sharedFiles=[];const sharedChunks=[];const pages={};const pageChunks={};compilation.chunks.forEach(chunk=>{if(!chunk.hasEntryModule()){return;}const chunkModules=new Map();const queue=new Set(chunk.groupsIterable);const chunksProcessed=new Set();const involvedChunks=new Set();for(const chunkGroup of queue){for(const chunk of chunkGroup.chunks){chunk.files.forEach(file=>involvedChunks.add(file));if(!chunksProcessed.has(chunk)){chunksProcessed.add(chunk);for(const m of chunk.modulesIterable){chunkModules.set(m.id,m);}}}for(const child of chunkGroup.childrenIterable){queue.add(child);}}const modules=[...chunkModules.values()];const nodeModules=[];const files=getFiles(dir,modules)// we don't care about node_modules (yet) because we invalidate the
// entirety of flying shuttle on package changes
.filter(val=>{// store them for build tree stats though
const isModule=val.includes('node_modules');if(isModule)nodeModules.push(val);return!isModule;})// build artifacts shouldn't be considered, so we ensure all paths
// are outside of this directory
.filter(val=>_path.default.relative(this.distDir,val).startsWith('..'))// convert from absolute path to be portable across operating systems
// and directories
.map(f=>_path.default.relative(dir,f));let pageName;if(chunk.entryModule&&chunk.entryModule.loaders){const entryLoader=chunk.entryModule.loaders.find(({loader,options})=>loader&&loader.match(/next-(\w+-)+loader/)&&options);if(entryLoader){const{page}=(0,_querystring.parse)(entryLoader.options);if(typeof page==='string'&&page){pageName=page;}}}if(pageName){if(pageName==='/_app'||pageName==='/_error'||pageName==='/_document'){sharedFiles.push(...files);sharedChunks.push(...involvedChunks);}else{pages[pageName]=files;pageChunks[pageName]=[...involvedChunks];}pageModules[pageName]=nodeModules;}else{if(chunk.name===_constants.CLIENT_STATIC_FILES_RUNTIME_MAIN){sharedFiles.push(...files);sharedChunks.push(...involvedChunks);}else{manifest.chunks[chunk.name]=[...new Set([...(manifest.chunks[chunk.name]||[]),...files])].sort();}}});const getLambdaChunk=name=>name.includes(this.buildId)?name.replace(new RegExp(`${this.buildId}[\\/\\\\]`),'client/').replace(/[.]js$/,`.${this.buildId}.js`):name;manifest.sharedFiles=[...new Set([...(manifest.sharedFiles||[]),...sharedFiles])].sort();for(const page in pages){manifest.pages[page]=[...new Set([...(manifest.pages[page]||[]),...pages[page]])].sort();// There's no chunks to save from serverless bundles
if(!this.isServer){manifest.pageChunks[page]=[...new Set([...(manifest.pageChunks[page]||[]),...pageChunks[page],...pageChunks[page].map(getLambdaChunk),...sharedChunks,...sharedChunks.map(getLambdaChunk)])].sort();}}});}}exports.ChunkGraphPlugin=ChunkGraphPlugin;