"use strict";exports.__esModule=true;exports.default=_default;var _mkdirp=_interopRequireDefault(require("mkdirp"));var _util=require("util");var _path=require("path");var _render=require("../next-server/server/render");var _fs=require("fs");var _amphtmlValidator=_interopRequireDefault(require("amphtml-validator"));var _loadComponents=require("../next-server/server/load-components");var _isDynamic=require("../next-server/lib/router/utils/is-dynamic");var _routeMatcher=require("../next-server/lib/router/utils/route-matcher");var _routeRegex=require("../next-server/lib/router/utils/route-regex");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}const envConfig=require('../next-server/lib/runtime-config');const writeFileP=(0,_util.promisify)(_fs.writeFile);const mkdirp=(0,_util.promisify)(_mkdirp.default);const accessP=(0,_util.promisify)(_fs.access);global.__NEXT_DATA__={nextExport:true};async function _default({path,pathMap,distDir,buildId,outDir,sprDataDir,renderOpts,buildExport,serverRuntimeConfig,subFolders,serverless}){let results={ampValidations:[]};try{let{query={}}=pathMap;const{page}=pathMap;const filePath=path==='/'?'/index':path;const ampPath=`${filePath}.amp`;// Check if the page is a specified dynamic route
if((0,_isDynamic.isDynamicRoute)(page)&&page!==path){const params=(0,_routeMatcher.getRouteMatcher)((0,_routeRegex.getRouteRegex)(page))(path);if(params){query={...query,...params};}else{throw new Error(`The provided export path '${path}' doesn't match the '${page}' page.\nRead more: https://err.sh/zeit/next.js/export-path-mismatch`);}}const headerMocks={headers:{},getHeader:()=>({}),setHeader:()=>{},hasHeader:()=>false,removeHeader:()=>{},getHeaderNames:()=>[]};const req={url:path,...headerMocks};const res={...headerMocks};envConfig.setConfig({serverRuntimeConfig,publicRuntimeConfig:renderOpts.runtimeConfig});let htmlFilename=`${filePath}${_path.sep}index.html`;if(!subFolders)htmlFilename=`${filePath}.html`;const pageExt=(0,_path.extname)(page);const pathExt=(0,_path.extname)(path);// Make sure page isn't a folder with a dot in the name e.g. `v1.2`
if(pageExt!==pathExt&&pathExt!==''){// If the path has an extension, use that as the filename instead
htmlFilename=path;}else if(path==='/'){// If the path is the root, just use index.html
htmlFilename='index.html';}const baseDir=(0,_path.join)(outDir,(0,_path.dirname)(htmlFilename));let htmlFilepath=(0,_path.join)(outDir,htmlFilename);await mkdirp(baseDir);let html;let curRenderOpts={};let renderMethod=_render.renderToHTML;// eslint-disable-next-line camelcase
const renderedDuringBuild=unstable_getStaticProps=>{// eslint-disable-next-line camelcase
return!buildExport&&unstable_getStaticProps&&!(0,_isDynamic.isDynamicRoute)(path);};if(serverless){const mod=require((0,_path.join)(distDir,'serverless/pages',(page==='/'?'index':page)+'.js'));// for non-dynamic SPR pages we should have already
// prerendered the file
if(renderedDuringBuild(mod.unstable_getStaticProps))return results;if(mod.unstable_getStaticProps&&!htmlFilepath.endsWith('.html')){// make sure it ends with .html if the name contains a dot
htmlFilename+='.html';htmlFilepath+='.html';}renderMethod=mod.renderReqToHTML;const result=await renderMethod(req,res,true);curRenderOpts=result.renderOpts||{};html=result.html;if(!html){throw new Error(`Failed to render serverless page`);}}else{const components=await(0,_loadComponents.loadComponents)(distDir,buildId,page,serverless);// for non-dynamic SPR pages we should have already
// prerendered the file
if(renderedDuringBuild(components.unstable_getStaticProps)){return results;}// TODO: de-dupe the logic here between serverless and server mode
if(components.unstable_getStaticProps&&!htmlFilepath.endsWith('.html')){// make sure it ends with .html if the name contains a dot
htmlFilepath+='.html';htmlFilename+='.html';}if(typeof components.Component==='string'){html=components.Component;}else{curRenderOpts={...components,...renderOpts,ampPath};html=await renderMethod(req,res,page,query,curRenderOpts);}}const validateAmp=async(html,page)=>{const validator=await _amphtmlValidator.default.getInstance();const result=validator.validateString(html);const errors=result.errors.filter(e=>e.severity==='ERROR');const warnings=result.errors.filter(e=>e.severity!=='ERROR');if(warnings.length||errors.length){results.ampValidations.push({page,result:{errors,warnings}});}};if(curRenderOpts.inAmpMode){await validateAmp(html,path);}else if(curRenderOpts.hybridAmp){// we need to render the AMP version
let ampHtmlFilename=`${ampPath}${_path.sep}index.html`;if(!subFolders){ampHtmlFilename=`${ampPath}.html`;}const ampBaseDir=(0,_path.join)(outDir,(0,_path.dirname)(ampHtmlFilename));const ampHtmlFilepath=(0,_path.join)(outDir,ampHtmlFilename);try{await accessP(ampHtmlFilepath);}catch(_){// make sure it doesn't exist from manual mapping
let ampHtml;if(serverless){req.url+=(req.url.includes('?')?'&':'?')+'amp=1';ampHtml=(await renderMethod(req,res,true)).html;}else{ampHtml=await renderMethod(req,res,page,{...query,amp:1},curRenderOpts);}await validateAmp(ampHtml,page+'?amp=1');await mkdirp(ampBaseDir);await writeFileP(ampHtmlFilepath,ampHtml,'utf8');}}if(curRenderOpts.sprData){const dataFile=(0,_path.join)(sprDataDir,htmlFilename.replace(/\.html$/,'.json'));await mkdirp((0,_path.dirname)(dataFile));await writeFileP(dataFile,JSON.stringify(curRenderOpts.sprData),'utf8');}results.fromBuildExportRevalidate=curRenderOpts.revalidate;await writeFileP(htmlFilepath,html,'utf8');return results;}catch(error){console.error(`\nError occurred prerendering page "${path}":`,error);return{...results,error:true};}}