"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const webpack_1 = __importDefault(require("webpack"));
const resolve_1 = __importDefault(require("resolve"));
const case_sensitive_paths_webpack_plugin_1 = __importDefault(require("case-sensitive-paths-webpack-plugin"));
const nextjs_ssr_import_1 = __importDefault(require("./webpack/plugins/nextjs-ssr-import"));
const nextjs_ssr_module_cache_1 = __importDefault(require("./webpack/plugins/nextjs-ssr-module-cache"));
const nextjs_require_cache_hot_reloader_1 = __importDefault(require("./webpack/plugins/nextjs-require-cache-hot-reloader"));
const unlink_file_plugin_1 = __importDefault(require("./webpack/plugins/unlink-file-plugin"));
const pages_manifest_plugin_1 = __importDefault(require("./webpack/plugins/pages-manifest-plugin"));
const build_manifest_plugin_1 = __importDefault(require("./webpack/plugins/build-manifest-plugin"));
const chunk_names_plugin_1 = __importDefault(require("./webpack/plugins/chunk-names-plugin"));
const react_loadable_plugin_1 = require("./webpack/plugins/react-loadable-plugin");
const constants_1 = require("next-server/constants");
const constants_2 = require("../lib/constants");
const autodll_webpack_plugin_1 = __importDefault(require("autodll-webpack-plugin"));
const cjs_js_1 = __importDefault(require("./webpack/plugins/terser-webpack-plugin/src/cjs.js"));
const serverless_plugin_1 = require("./webpack/plugins/serverless-plugin");
function getBaseWebpackConfig(dir, { dev = false, isServer = false, buildId, config, target = 'server', entrypoints }) {
    const defaultLoaders = {
        babel: {
            loader: 'next-babel-loader',
            options: { dev, isServer, cwd: dir }
        },
        // Backwards compat
        hotSelfAccept: {
            loader: 'noop-loader'
        }
    };
    // Support for NODE_PATH
    const nodePathList = (process.env.NODE_PATH || '')
        .split(process.platform === 'win32' ? ';' : ':')
        .filter((p) => !!p);
    const distDir = path_1.default.join(dir, config.distDir);
    const outputDir = target === 'serverless' ? 'serverless' : constants_1.SERVER_DIRECTORY;
    const outputPath = path_1.default.join(distDir, isServer ? outputDir : '');
    const totalPages = Object.keys(entrypoints).length;
    const clientEntries = !isServer ? {
        // Backwards compatibility
        'main.js': [],
        [constants_1.CLIENT_STATIC_FILES_RUNTIME_MAIN]: [
            path_1.default.join(constants_2.NEXT_PROJECT_ROOT_DIST_CLIENT, (dev ? `next-dev` : 'next'))
        ].filter(Boolean)
    } : undefined;
    const resolveConfig = {
        // Disable .mjs for node_modules bundling
        extensions: isServer ? ['.wasm', '.js', '.mjs', '.jsx', '.json'] : ['.wasm', '.mjs', '.js', '.jsx', '.json'],
        modules: [
            'node_modules',
            ...nodePathList // Support for NODE_PATH environment variable
        ],
        alias: {
            next: constants_2.NEXT_PROJECT_ROOT,
            [constants_2.PAGES_DIR_ALIAS]: path_1.default.join(dir, 'pages'),
            [constants_2.DOT_NEXT_ALIAS]: distDir
        },
        mainFields: isServer ? ['main', 'module'] : ['browser', 'module', 'main']
    };
    const webpackMode = dev ? 'development' : 'production';
    const terserPluginConfig = {
        parallel: true,
        sourceMap: false,
        cache: true,
        cacheKeys: (keys) => {
            // path changes per build because we add buildId
            // because the input is already hashed the path is not needed
            delete keys.path;
            return keys;
        }
    };
    let webpackConfig = {
        mode: webpackMode,
        devtool: dev ? 'cheap-module-source-map' : false,
        name: isServer ? 'server' : 'client',
        target: isServer ? 'node' : 'web',
        externals: isServer && target !== 'serverless' ? [
            (context, request, callback) => {
                const notExternalModules = ['next/app', 'next/document', 'next/link', 'next/router', 'next/error', 'http-status', 'string-hash', 'hoist-non-react-statics', 'htmlescape'];
                if (notExternalModules.indexOf(request) !== -1) {
                    return callback();
                }
                resolve_1.default(request, { basedir: context, preserveSymlinks: true }, (err, res) => {
                    if (err) {
                        return callback();
                    }
                    if (!res) {
                        return callback();
                    }
                    // Default pages have to be transpiled
                    if (res.match(/next[/\\]dist[/\\]/) || res.match(/node_modules[/\\]@babel[/\\]runtime[/\\]/) || res.match(/node_modules[/\\]@babel[/\\]runtime-corejs2[/\\]/)) {
                        return callback();
                    }
                    // Webpack itself has to be compiled because it doesn't always use module relative paths
                    if (res.match(/node_modules[/\\]webpack/) || res.match(/node_modules[/\\]css-loader/)) {
                        return callback();
                    }
                    // styled-jsx has to be transpiled
                    if (res.match(/node_modules[/\\]styled-jsx/)) {
                        return callback();
                    }
                    if (res.match(/node_modules[/\\].*\.js$/)) {
                        return callback(undefined, `commonjs ${request}`);
                    }
                    callback();
                });
            }
        ] : [
        // When the serverless target is used all node_modules will be compiled into the output bundles
        // So that the serverless bundles have 0 runtime dependencies
        ],
        optimization: isServer ? {
            splitChunks: false,
            minimizer: target === 'serverless' ? [
                new cjs_js_1.default(Object.assign({}, terserPluginConfig, { terserOptions: {
                        compress: false,
                        mangle: false,
                        module: false,
                        keep_classnames: true,
                        keep_fnames: true
                    } }))
            ] : undefined
        } : {
            runtimeChunk: {
                name: constants_1.CLIENT_STATIC_FILES_RUNTIME_WEBPACK
            },
            splitChunks: dev ? {
                cacheGroups: {
                    default: false,
                    vendors: false
                }
            } : {
                chunks: 'all',
                cacheGroups: {
                    default: false,
                    vendors: false,
                    commons: {
                        name: 'commons',
                        chunks: 'all',
                        minChunks: totalPages > 2 ? totalPages * 0.5 : 2
                    },
                    react: {
                        name: 'commons',
                        chunks: 'all',
                        test: /[\\/]node_modules[\\/](react|react-dom)[\\/]/
                    }
                }
            },
            minimizer: !dev ? [
                new cjs_js_1.default(Object.assign({}, terserPluginConfig, { terserOptions: {
                        safari10: true
                    } }))
            ] : undefined,
        },
        recordsPath: path_1.default.join(outputPath, 'records.json'),
        context: dir,
        // Kept as function to be backwards compatible
        entry: async () => {
            return Object.assign({}, clientEntries ? clientEntries : {}, entrypoints);
        },
        output: {
            path: outputPath,
            filename: ({ chunk }) => {
                // Use `[name]-[contenthash].js` in production
                if (!dev && (chunk.name === constants_1.CLIENT_STATIC_FILES_RUNTIME_MAIN || chunk.name === constants_1.CLIENT_STATIC_FILES_RUNTIME_WEBPACK)) {
                    return chunk.name.replace(/\.js$/, '-[contenthash].js');
                }
                return '[name]';
            },
            libraryTarget: isServer ? 'commonjs2' : 'jsonp',
            hotUpdateChunkFilename: 'static/webpack/[id].[hash].hot-update.js',
            hotUpdateMainFilename: 'static/webpack/[hash].hot-update.json',
            // This saves chunks with the name given via `import()`
            chunkFilename: isServer ? `${dev ? '[name]' : '[name].[contenthash]'}.js` : `static/chunks/${dev ? '[name]' : '[name].[contenthash]'}.js`,
            strictModuleExceptionHandling: true,
            crossOriginLoading: config.crossOrigin,
            futureEmitAssets: !dev,
            webassemblyModuleFilename: 'static/wasm/[modulehash].wasm'
        },
        performance: { hints: false },
        resolve: resolveConfig,
        resolveLoader: {
            modules: [
                constants_2.NEXT_PROJECT_ROOT_NODE_MODULES,
                'node_modules',
                path_1.default.join(__dirname, 'webpack', 'loaders'),
                ...nodePathList // Support for NODE_PATH environment variable
            ]
        },
        module: {
            rules: [
                {
                    test: /\.(js|mjs|jsx)$/,
                    include: [dir, /next-server[\\/]dist[\\/]lib/],
                    exclude: (path) => {
                        if (/next-server[\\/]dist[\\/]lib/.test(path)) {
                            return false;
                        }
                        return /node_modules/.test(path);
                    },
                    use: defaultLoaders.babel
                }
            ].filter(Boolean)
        },
        plugins: [
            target === 'serverless' && isServer && new serverless_plugin_1.ServerlessPlugin(),
            // Precompile react / react-dom for development, speeding up webpack
            dev && !isServer && new autodll_webpack_plugin_1.default({
                filename: '[name]_[hash].js',
                path: './static/development/dll',
                context: dir,
                entry: {
                    dll: [
                        'react',
                        'react-dom'
                    ]
                },
                config: {
                    mode: webpackMode,
                    resolve: resolveConfig
                }
            }),
            // This plugin makes sure `output.filename` is used for entry chunks
            new chunk_names_plugin_1.default(),
            !isServer && new react_loadable_plugin_1.ReactLoadablePlugin({
                filename: constants_1.REACT_LOADABLE_MANIFEST
            }),
            // Even though require.cache is server only we have to clear assets from both compilations
            // This is because the client compilation generates the build manifest that's used on the server side
            dev && new nextjs_require_cache_hot_reloader_1.default(),
            dev && !isServer && new webpack_1.default.HotModuleReplacementPlugin(),
            dev && new webpack_1.default.NoEmitOnErrorsPlugin(),
            dev && new unlink_file_plugin_1.default(),
            dev && new case_sensitive_paths_webpack_plugin_1.default(),
            !dev && new webpack_1.default.HashedModuleIdsPlugin(),
            // Removes server/client code by minifier
            new webpack_1.default.DefinePlugin(Object.assign({}, (Object.keys(config.env).reduce((acc, key) => {
                if (/^(?:NODE_.+)|(?:__.+)$/i.test(key)) {
                    throw new Error(`The key "${key}" under "env" in next.config.js is not allowed. https://err.sh/zeit/next.js/env-key-not-allowed`);
                }
                return Object.assign({}, acc, { [`process.env.${key}`]: JSON.stringify(config.env[key]) });
            }, {})), { 'process.crossOrigin': JSON.stringify(config.crossOrigin), 'process.browser': JSON.stringify(!isServer) })),
            // This is used in client/dev-error-overlay/hot-dev-client.js to replace the dist directory
            !isServer && dev && new webpack_1.default.DefinePlugin({
                'process.env.__NEXT_DIST_DIR': JSON.stringify(distDir)
            }),
            target !== 'serverless' && isServer && new pages_manifest_plugin_1.default(),
            !isServer && new build_manifest_plugin_1.default(),
            isServer && new nextjs_ssr_import_1.default(),
            target !== 'serverless' && isServer && new nextjs_ssr_module_cache_1.default({ outputPath }),
            !dev && new webpack_1.default.IgnorePlugin({
                checkResource: (resource) => {
                    return /react-is/.test(resource);
                },
                checkContext: (context) => {
                    return /next-server[\\/]dist[\\/]/.test(context) || /next[\\/]dist[\\/]/.test(context);
                }
            })
        ].filter(Boolean)
    };
    if (typeof config.webpack === 'function') {
        webpackConfig = config.webpack(webpackConfig, { dir, dev, isServer, buildId, config, defaultLoaders, totalPages });
    }
    // Backwards compat for `main.js` entry key
    const originalEntry = webpackConfig.entry;
    if (typeof originalEntry !== 'undefined') {
        webpackConfig.entry = async () => {
            const entry = typeof originalEntry === 'function' ? await originalEntry() : originalEntry;
            if (entry && typeof entry !== 'string' && !Array.isArray(entry)) {
                // Server compilation doesn't have main.js
                if (typeof entry['main.js'] !== 'undefined') {
                    entry[constants_1.CLIENT_STATIC_FILES_RUNTIME_MAIN] = [
                        ...entry['main.js'],
                        ...entry[constants_1.CLIENT_STATIC_FILES_RUNTIME_MAIN]
                    ];
                    delete entry['main.js'];
                }
            }
            return entry;
        };
    }
    return webpackConfig;
}
exports.default = getBaseWebpackConfig;
