'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _object = require('object.assign');

var _object2 = _interopRequireDefault(_object);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _server = require('react-dom/server');

var _server2 = _interopRequireDefault(_server);

var _shallow = require('react-test-renderer/shallow');

var _shallow2 = _interopRequireDefault(_shallow);

var _package = require('react-test-renderer/package.json');

var _testUtils = require('react-dom/test-utils');

var _testUtils2 = _interopRequireDefault(_testUtils);

var _semver = require('semver');

var _semver2 = _interopRequireDefault(_semver);

var _checkPropTypes2 = require('prop-types/checkPropTypes');

var _checkPropTypes3 = _interopRequireDefault(_checkPropTypes2);

var _has = require('has');

var _has2 = _interopRequireDefault(_has);

var _reactIs = require('react-is');

var _enzyme = require('enzyme');

var _Utils = require('enzyme/build/Utils');

var _enzymeAdapterUtils = require('enzyme-adapter-utils');

var _findCurrentFiberUsingSlowPath = require('./findCurrentFiberUsingSlowPath');

var _findCurrentFiberUsingSlowPath2 = _interopRequireDefault(_findCurrentFiberUsingSlowPath);

var _detectFiberTags = require('./detectFiberTags');

var _detectFiberTags2 = _interopRequireDefault(_detectFiberTags);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* eslint no-use-before-define: 0 */

// eslint-disable-next-line import/no-unresolved

// eslint-disable-next-line import/no-unresolved

// eslint-disable-next-line import/no-unresolved


var is164 = !!_testUtils2['default'].Simulate.touchStart; // 16.4+
var is165 = !!_testUtils2['default'].Simulate.auxClick; // 16.5+
var is166 = is165 && !_react2['default'].unstable_AsyncMode; // 16.6+
var is168 = is166 && typeof _testUtils2['default'].act === 'function';

var hasShouldComponentUpdateBug = _semver2['default'].satisfies(_package.version, '< 16.8');

// Lazily populated if DOM is available.
var FiberTags = null;

function nodeAndSiblingsArray(nodeWithSibling) {
  var array = [];
  var node = nodeWithSibling;
  while (node != null) {
    array.push(node);
    node = node.sibling;
  }
  return array;
}

function flatten(arr) {
  var result = [];
  var stack = [{ i: 0, array: arr }];
  while (stack.length) {
    var n = stack.pop();
    while (n.i < n.array.length) {
      var el = n.array[n.i];
      n.i += 1;
      if (Array.isArray(el)) {
        stack.push(n);
        stack.push({ i: 0, array: el });
        break;
      }
      result.push(el);
    }
  }
  return result;
}

function nodeTypeFromType(type) {
  if (type === _reactIs.Portal) {
    return 'portal';
  }

  return (0, _enzymeAdapterUtils.nodeTypeFromType)(type);
}

function unmemoType(type) {
  return (0, _reactIs.isMemo)(type) ? type.type : type;
}

function elementToTree(el) {
  if (!(0, _reactIs.isPortal)(el)) {
    return (0, _enzymeAdapterUtils.elementToTree)(el, elementToTree);
  }

  var children = el.children,
      containerInfo = el.containerInfo;

  var props = { children: children, containerInfo: containerInfo };

  return {
    nodeType: 'portal',
    type: _reactIs.Portal,
    props: props,
    key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(el.key),
    ref: el.ref || null,
    instance: null,
    rendered: elementToTree(el.children)
  };
}

function _toTree(vnode) {
  if (vnode == null) {
    return null;
  }
  // TODO(lmr): I'm not really sure I understand whether or not this is what
  // i should be doing, or if this is a hack for something i'm doing wrong
  // somewhere else. Should talk to sebastian about this perhaps
  var node = (0, _findCurrentFiberUsingSlowPath2['default'])(vnode);
  switch (node.tag) {
    case FiberTags.HostRoot:
      return childrenToTree(node.child);
    case FiberTags.HostPortal:
      {
        var containerInfo = node.stateNode.containerInfo,
            children = node.memoizedProps;

        var props = { containerInfo: containerInfo, children: children };
        return {
          nodeType: 'portal',
          type: _reactIs.Portal,
          props: props,
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.ClassComponent:
      return {
        nodeType: 'class',
        type: node.type,
        props: (0, _object2['default'])({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: node.stateNode,
        rendered: childrenToTree(node.child)
      };
    case FiberTags.FunctionalComponent:
      return {
        nodeType: 'function',
        type: node.type,
        props: (0, _object2['default'])({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: null,
        rendered: childrenToTree(node.child)
      };
    case FiberTags.MemoClass:
      return {
        nodeType: 'class',
        type: node.elementType.type,
        props: (0, _object2['default'])({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: node.stateNode,
        rendered: childrenToTree(node.child.child)
      };
    case FiberTags.MemoSFC:
      {
        var renderedNodes = flatten(nodeAndSiblingsArray(node.child).map(_toTree));
        if (renderedNodes.length === 0) {
          renderedNodes = [node.memoizedProps.children];
        }
        return {
          nodeType: 'function',
          type: node.elementType,
          props: (0, _object2['default'])({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: renderedNodes
        };
      }
    case FiberTags.HostComponent:
      {
        var _renderedNodes = flatten(nodeAndSiblingsArray(node.child).map(_toTree));
        if (_renderedNodes.length === 0) {
          _renderedNodes = [node.memoizedProps.children];
        }
        return {
          nodeType: 'host',
          type: node.type,
          props: (0, _object2['default'])({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: node.stateNode,
          rendered: _renderedNodes
        };
      }
    case FiberTags.HostText:
      return node.memoizedProps;
    case FiberTags.Fragment:
    case FiberTags.Mode:
    case FiberTags.ContextProvider:
    case FiberTags.ContextConsumer:
      return childrenToTree(node.child);
    case FiberTags.Profiler:
    case FiberTags.ForwardRef:
      {
        return {
          nodeType: 'function',
          type: node.type,
          props: (0, _object2['default'])({}, node.pendingProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.Suspense:
      {
        return {
          nodeType: 'function',
          type: _reactIs.Suspense,
          props: (0, _object2['default'])({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.Lazy:
      return childrenToTree(node.child);
    default:
      throw new Error('Enzyme Internal Error: unknown node with tag ' + String(node.tag));
  }
}

function childrenToTree(node) {
  if (!node) {
    return null;
  }
  var children = nodeAndSiblingsArray(node);
  if (children.length === 0) {
    return null;
  }
  if (children.length === 1) {
    return _toTree(children[0]);
  }
  return flatten(children.map(_toTree));
}

function _nodeToHostNode(_node) {
  // NOTE(lmr): node could be a function component
  // which wont have an instance prop, but we can get the
  // host node associated with its return value at that point.
  // Although this breaks down if the return value is an array,
  // as is possible with React 16.
  var node = _node;
  while (node && !Array.isArray(node) && node.instance === null) {
    node = node.rendered;
  }
  // if the SFC returned null effectively, there is no host node.
  if (!node) {
    return null;
  }

  var mapper = function mapper(item) {
    if (item && item.instance) return _reactDom2['default'].findDOMNode(item.instance);
    return null;
  };
  if (Array.isArray(node)) {
    return node.map(mapper);
  }
  if (Array.isArray(node.rendered) && node.nodeType === 'class') {
    return node.rendered.map(mapper);
  }
  return mapper(node);
}

function replaceLazyWithFallback(node, fallback) {
  if (!node) {
    return null;
  }
  if (Array.isArray(node)) {
    return node.map(function (el) {
      return replaceLazyWithFallback(el, fallback);
    });
  }
  if ((0, _reactIs.isLazy)(node.type)) {
    return fallback;
  }
  return (0, _object2['default'])({}, node, {
    props: (0, _object2['default'])({}, node.props, {
      children: replaceLazyWithFallback(node.props.children, fallback)
    })
  });
}

var eventOptions = {
  animation: true,
  pointerEvents: is164,
  auxClick: is165
};

function getEmptyStateValue() {
  // this handles a bug in React 16.0 - 16.2
  // see https://github.com/facebook/react/commit/39be83565c65f9c522150e52375167568a2a1459
  // also see https://github.com/facebook/react/pull/11965

  // eslint-disable-next-line react/prefer-stateless-function
  var EmptyState = function (_React$Component) {
    _inherits(EmptyState, _React$Component);

    function EmptyState() {
      _classCallCheck(this, EmptyState);

      return _possibleConstructorReturn(this, (EmptyState.__proto__ || Object.getPrototypeOf(EmptyState)).apply(this, arguments));
    }

    _createClass(EmptyState, [{
      key: 'render',
      value: function () {
        function render() {
          return null;
        }

        return render;
      }()
    }]);

    return EmptyState;
  }(_react2['default'].Component);

  var testRenderer = new _shallow2['default']();
  testRenderer.render(_react2['default'].createElement(EmptyState));
  return testRenderer._instance.state;
}

function wrapAct(fn) {
  if (!is168) {
    return fn();
  }
  var returnVal = void 0;
  _testUtils2['default'].act(function () {
    returnVal = fn();
  });
  return returnVal;
}

function getProviderDefaultValue(Provider) {
  // React stores references to the Provider's defaultValue differently across versions.
  if ('_defaultValue' in Provider._context) {
    return Provider._context._defaultValue;
  }
  if ('_currentValue' in Provider._context) {
    return Provider._context._currentValue;
  }
  throw new Error('Enzyme Internal Error: can’t figure out how to get Provider’s default value');
}

function makeFakeElement(type) {
  return { $$typeof: _reactIs.Element, type: type };
}

function isStateful(Component) {
  return Component.prototype && (Component.prototype.isReactComponent || Array.isArray(Component.__reactAutoBindPairs) // fallback for createClass components
  );
}

var ReactSixteenAdapter = function (_EnzymeAdapter) {
  _inherits(ReactSixteenAdapter, _EnzymeAdapter);

  function ReactSixteenAdapter() {
    _classCallCheck(this, ReactSixteenAdapter);

    var _this2 = _possibleConstructorReturn(this, (ReactSixteenAdapter.__proto__ || Object.getPrototypeOf(ReactSixteenAdapter)).call(this));

    var lifecycles = _this2.options.lifecycles;

    _this2.options = (0, _object2['default'])({}, _this2.options, {
      enableComponentDidUpdateOnSetState: true, // TODO: remove, semver-major
      legacyContextMode: 'parent',
      lifecycles: (0, _object2['default'])({}, lifecycles, {
        componentDidUpdate: {
          onSetState: true
        },
        getDerivedStateFromProps: {
          hasShouldComponentUpdateBug: hasShouldComponentUpdateBug
        },
        getSnapshotBeforeUpdate: true,
        setState: {
          skipsComponentDidUpdateOnNullish: true
        },
        getChildContext: {
          calledByRenderer: false
        },
        getDerivedStateFromError: is166
      })
    });
    return _this2;
  }

  _createClass(ReactSixteenAdapter, [{
    key: 'createMountRenderer',
    value: function () {
      function createMountRenderer(options) {
        (0, _enzymeAdapterUtils.assertDomAvailable)('mount');
        if ((0, _has2['default'])(options, 'suspenseFallback')) {
          throw new TypeError('`suspenseFallback` is not supported by the `mount` renderer');
        }
        if (FiberTags === null) {
          // Requires DOM.
          FiberTags = (0, _detectFiberTags2['default'])();
        }
        var attachTo = options.attachTo,
            hydrateIn = options.hydrateIn,
            wrappingComponentProps = options.wrappingComponentProps;

        var domNode = hydrateIn || attachTo || global.document.createElement('div');
        var instance = null;
        var adapter = this;
        return {
          render: function () {
            function render(el, context, callback) {
              return wrapAct(function () {
                if (instance === null) {
                  var type = el.type,
                      props = el.props,
                      ref = el.ref;

                  var wrapperProps = (0, _object2['default'])({
                    Component: type,
                    props: props,
                    wrappingComponentProps: wrappingComponentProps,
                    context: context
                  }, ref && { ref: ref });
                  var ReactWrapperComponent = (0, _enzymeAdapterUtils.createMountWrapper)(el, (0, _object2['default'])({}, options, { adapter: adapter }));
                  var wrappedEl = _react2['default'].createElement(ReactWrapperComponent, wrapperProps);
                  instance = hydrateIn ? _reactDom2['default'].hydrate(wrappedEl, domNode) : _reactDom2['default'].render(wrappedEl, domNode);
                  if (typeof callback === 'function') {
                    callback();
                  }
                } else {
                  instance.setChildProps(el.props, context, callback);
                }
              });
            }

            return render;
          }(),
          unmount: function () {
            function unmount() {
              _reactDom2['default'].unmountComponentAtNode(domNode);
              instance = null;
            }

            return unmount;
          }(),
          getNode: function () {
            function getNode() {
              if (!instance) {
                return null;
              }
              return (0, _enzymeAdapterUtils.getNodeFromRootFinder)(adapter.isCustomComponent, _toTree(instance._reactInternalFiber), options);
            }

            return getNode;
          }(),
          simulateError: function () {
            function simulateError(nodeHierarchy, rootNode, error) {
              var isErrorBoundary = function () {
                function isErrorBoundary(_ref) {
                  var elInstance = _ref.instance,
                      type = _ref.type;

                  if (is166 && type && type.getDerivedStateFromError) {
                    return true;
                  }
                  return elInstance && elInstance.componentDidCatch;
                }

                return isErrorBoundary;
              }();

              var _ref2 = nodeHierarchy.find(isErrorBoundary) || {},
                  catchingInstance = _ref2.instance,
                  catchingType = _ref2.type;

              (0, _enzymeAdapterUtils.simulateError)(error, catchingInstance, rootNode, nodeHierarchy, nodeTypeFromType, adapter.displayNameOfNode, is166 ? catchingType : undefined);
            }

            return simulateError;
          }(),
          simulateEvent: function () {
            function simulateEvent(node, event, mock) {
              var mappedEvent = (0, _enzymeAdapterUtils.mapNativeEventNames)(event, eventOptions);
              var eventFn = _testUtils2['default'].Simulate[mappedEvent];
              if (!eventFn) {
                throw new TypeError('ReactWrapper::simulate() event \'' + String(event) + '\' does not exist');
              }
              wrapAct(function () {
                eventFn(adapter.nodeToHostNode(node), mock);
              });
            }

            return simulateEvent;
          }(),
          batchedUpdates: function () {
            function batchedUpdates(fn) {
              return fn();
              // return ReactDOM.unstable_batchedUpdates(fn);
            }

            return batchedUpdates;
          }(),
          getWrappingComponentRenderer: function () {
            function getWrappingComponentRenderer() {
              return (0, _object2['default'])({}, this, (0, _enzymeAdapterUtils.getWrappingComponentMountRenderer)({
                toTree: function () {
                  function toTree(inst) {
                    return _toTree(inst._reactInternalFiber);
                  }

                  return toTree;
                }(),
                getMountWrapperInstance: function () {
                  function getMountWrapperInstance() {
                    return instance;
                  }

                  return getMountWrapperInstance;
                }()
              }));
            }

            return getWrappingComponentRenderer;
          }()
        };
      }

      return createMountRenderer;
    }()
  }, {
    key: 'createShallowRenderer',
    value: function () {
      function createShallowRenderer() {
        var _this4 = this;

        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        var adapter = this;
        var renderer = new _shallow2['default']();
        var suspenseFallback = options.suspenseFallback;

        if (typeof suspenseFallback !== 'undefined' && typeof suspenseFallback !== 'boolean') {
          throw TypeError('`options.suspenseFallback` should be boolean or undefined');
        }
        var isDOM = false;
        var cachedNode = null;

        var lastComponent = null;
        var wrappedComponent = null;
        var sentinel = {};

        // wrap memo components with a PureComponent, or a class component with sCU
        var wrapPureComponent = function () {
          function wrapPureComponent(Component, compare) {
            if (!is166) {
              throw new RangeError('this function should not be called in React < 16.6. Please report this!');
            }
            if (lastComponent !== Component) {
              if (isStateful(Component)) {
                wrappedComponent = function (_Component) {
                  _inherits(wrappedComponent, _Component);

                  function wrappedComponent() {
                    _classCallCheck(this, wrappedComponent);

                    return _possibleConstructorReturn(this, (wrappedComponent.__proto__ || Object.getPrototypeOf(wrappedComponent)).apply(this, arguments));
                  }

                  return wrappedComponent;
                }(Component); // eslint-disable-line react/prefer-stateless-function
                if (compare) {
                  wrappedComponent.prototype.shouldComponentUpdate = function (nextProps) {
                    return !compare(_this4.props, nextProps);
                  };
                } else {
                  wrappedComponent.prototype.isPureReactComponent = true;
                }
              } else {
                var memoized = sentinel;
                var prevProps = void 0;
                wrappedComponent = function () {
                  function wrappedComponent(props) {
                    var shouldUpdate = memoized === sentinel || (compare ? !compare(prevProps, props) : !(0, _Utils.shallowEqual)(prevProps, props));
                    if (shouldUpdate) {
                      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                        args[_key - 1] = arguments[_key];
                      }

                      memoized = Component.apply(undefined, [(0, _object2['default'])({}, Component.defaultProps, props)].concat(args));
                      prevProps = props;
                    }
                    return memoized;
                  }

                  return wrappedComponent;
                }();
              }
              (0, _object2['default'])(wrappedComponent, Component, { displayName: adapter.displayNameOfNode({ type: Component }) });
              lastComponent = Component;
            }
            return wrappedComponent;
          }

          return wrapPureComponent;
        }();

        // Wrap functional components on versions prior to 16.5,
        // to avoid inadvertently pass a `this` instance to it.
        var wrapFunctionalComponent = function () {
          function wrapFunctionalComponent(Component) {
            if (is166 && (0, _has2['default'])(Component, 'defaultProps')) {
              if (lastComponent !== Component) {
                wrappedComponent = (0, _object2['default'])(
                // eslint-disable-next-line new-cap
                function (props) {
                  for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
                    args[_key2 - 1] = arguments[_key2];
                  }

                  return Component.apply(undefined, [(0, _object2['default'])({}, Component.defaultProps, props)].concat(args));
                }, Component, { displayName: adapter.displayNameOfNode({ type: Component }) });
                lastComponent = Component;
              }
              return wrappedComponent;
            }
            if (is165) {
              return Component;
            }

            if (lastComponent !== Component) {
              wrappedComponent = (0, _object2['default'])(function () {
                return Component.apply(undefined, arguments);
              }, // eslint-disable-line new-cap
              Component);
              lastComponent = Component;
            }
            return wrappedComponent;
          }

          return wrapFunctionalComponent;
        }();

        return {
          render: function () {
            function render(el, unmaskedContext) {
              var _ref3 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
                  _ref3$providerValues = _ref3.providerValues,
                  providerValues = _ref3$providerValues === undefined ? new Map() : _ref3$providerValues;

              cachedNode = el;
              /* eslint consistent-return: 0 */
              if (typeof el.type === 'string') {
                isDOM = true;
              } else if ((0, _reactIs.isContextProvider)(el)) {
                providerValues.set(el.type, el.props.value);
                var MockProvider = (0, _object2['default'])(function (props) {
                  return props.children;
                }, el.type);
                return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                  return renderer.render((0, _object2['default'])({}, el, { type: MockProvider }));
                });
              } else if ((0, _reactIs.isContextConsumer)(el)) {
                var Provider = adapter.getProviderFromConsumer(el.type);
                var value = providerValues.has(Provider) ? providerValues.get(Provider) : getProviderDefaultValue(Provider);
                var MockConsumer = (0, _object2['default'])(function (props) {
                  return props.children(value);
                }, el.type);
                return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                  return renderer.render((0, _object2['default'])({}, el, { type: MockConsumer }));
                });
              } else {
                isDOM = false;
                var renderedEl = el;
                if ((0, _reactIs.isLazy)(renderedEl)) {
                  throw TypeError('`React.lazy` is not supported by shallow rendering.');
                }
                if ((0, _reactIs.isSuspense)(renderedEl)) {
                  var children = renderedEl.props.children;

                  if (suspenseFallback) {
                    var fallback = renderedEl.props.fallback;

                    children = replaceLazyWithFallback(children, fallback);
                  }
                  var FakeSuspenseWrapper = function () {
                    function FakeSuspenseWrapper() {
                      return children;
                    }

                    return FakeSuspenseWrapper;
                  }();
                  renderedEl = _react2['default'].createElement(FakeSuspenseWrapper, null, children);
                }
                var _renderedEl = renderedEl,
                    Component = _renderedEl.type;


                var context = (0, _enzymeAdapterUtils.getMaskedContext)(Component.contextTypes, unmaskedContext);

                if ((0, _reactIs.isMemo)(el.type)) {
                  var _el$type = el.type,
                      InnerComp = _el$type.type,
                      compare = _el$type.compare;


                  return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                    return renderer.render((0, _object2['default'])({}, el, { type: wrapPureComponent(InnerComp, compare) }), context);
                  });
                }

                if (!isStateful(Component) && typeof Component === 'function') {
                  return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                    return renderer.render((0, _object2['default'])({}, renderedEl, { type: wrapFunctionalComponent(Component) }), context);
                  });
                }

                if (isStateful) {
                  // fix react bug; see implementation of `getEmptyStateValue`
                  var emptyStateValue = getEmptyStateValue();
                  if (emptyStateValue) {
                    Object.defineProperty(Component.prototype, 'state', {
                      configurable: true,
                      enumerable: true,
                      get: function () {
                        function get() {
                          return null;
                        }

                        return get;
                      }(),
                      set: function () {
                        function set(value) {
                          if (value !== emptyStateValue) {
                            Object.defineProperty(this, 'state', {
                              configurable: true,
                              enumerable: true,
                              value: value,
                              writable: true
                            });
                          }
                          return true;
                        }

                        return set;
                      }()
                    });
                  }
                }
                return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                  return renderer.render(renderedEl, context);
                });
              }
            }

            return render;
          }(),
          unmount: function () {
            function unmount() {
              renderer.unmount();
            }

            return unmount;
          }(),
          getNode: function () {
            function getNode() {
              if (isDOM) {
                return elementToTree(cachedNode);
              }
              var output = renderer.getRenderOutput();
              return {
                nodeType: nodeTypeFromType(cachedNode.type),
                type: cachedNode.type,
                props: cachedNode.props,
                key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(cachedNode.key),
                ref: cachedNode.ref,
                instance: renderer._instance,
                rendered: Array.isArray(output) ? flatten(output).map(function (el) {
                  return elementToTree(el);
                }) : elementToTree(output)
              };
            }

            return getNode;
          }(),
          simulateError: function () {
            function simulateError(nodeHierarchy, rootNode, error) {
              (0, _enzymeAdapterUtils.simulateError)(error, renderer._instance, cachedNode, nodeHierarchy.concat(cachedNode), nodeTypeFromType, adapter.displayNameOfNode, is166 ? cachedNode.type : undefined);
            }

            return simulateError;
          }(),
          simulateEvent: function () {
            function simulateEvent(node, event) {
              for (var _len3 = arguments.length, args = Array(_len3 > 2 ? _len3 - 2 : 0), _key3 = 2; _key3 < _len3; _key3++) {
                args[_key3 - 2] = arguments[_key3];
              }

              var handler = node.props[(0, _enzymeAdapterUtils.propFromEvent)(event, eventOptions)];
              if (handler) {
                (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                  // TODO(lmr): create/use synthetic events
                  // TODO(lmr): emulate React's event propagation
                  // ReactDOM.unstable_batchedUpdates(() => {
                  handler.apply(undefined, _toConsumableArray(args));
                  // });
                });
              }
            }

            return simulateEvent;
          }(),
          batchedUpdates: function () {
            function batchedUpdates(fn) {
              return fn();
              // return ReactDOM.unstable_batchedUpdates(fn);
            }

            return batchedUpdates;
          }(),
          checkPropTypes: function () {
            function checkPropTypes(typeSpecs, values, location, hierarchy) {
              return (0, _checkPropTypes3['default'])(typeSpecs, values, location, (0, _enzymeAdapterUtils.displayNameOfNode)(cachedNode), function () {
                return (0, _enzymeAdapterUtils.getComponentStack)(hierarchy.concat([cachedNode]));
              });
            }

            return checkPropTypes;
          }()
        };
      }

      return createShallowRenderer;
    }()
  }, {
    key: 'createStringRenderer',
    value: function () {
      function createStringRenderer(options) {
        if ((0, _has2['default'])(options, 'suspenseFallback')) {
          throw new TypeError('`suspenseFallback` should not be specified in options of string renderer');
        }
        return {
          render: function () {
            function render(el, context) {
              if (options.context && (el.type.contextTypes || options.childContextTypes)) {
                var childContextTypes = (0, _object2['default'])({}, el.type.contextTypes || {}, options.childContextTypes);
                var ContextWrapper = (0, _enzymeAdapterUtils.createRenderWrapper)(el, context, childContextTypes);
                return _server2['default'].renderToStaticMarkup(_react2['default'].createElement(ContextWrapper));
              }
              return _server2['default'].renderToStaticMarkup(el);
            }

            return render;
          }()
        };
      }

      return createStringRenderer;
    }()

    // Provided a bag of options, return an `EnzymeRenderer`. Some options can be implementation
    // specific, like `attach` etc. for React, but not part of this interface explicitly.
    // eslint-disable-next-line class-methods-use-this

  }, {
    key: 'createRenderer',
    value: function () {
      function createRenderer(options) {
        switch (options.mode) {
          case _enzyme.EnzymeAdapter.MODES.MOUNT:
            return this.createMountRenderer(options);
          case _enzyme.EnzymeAdapter.MODES.SHALLOW:
            return this.createShallowRenderer(options);
          case _enzyme.EnzymeAdapter.MODES.STRING:
            return this.createStringRenderer(options);
          default:
            throw new Error('Enzyme Internal Error: Unrecognized mode: ' + String(options.mode));
        }
      }

      return createRenderer;
    }()
  }, {
    key: 'wrap',
    value: function () {
      function wrap(element) {
        return (0, _enzymeAdapterUtils.wrap)(element);
      }

      return wrap;
    }()

    // converts an RSTNode to the corresponding JSX Pragma Element. This will be needed
    // in order to implement the `Wrapper.mount()` and `Wrapper.shallow()` methods, but should
    // be pretty straightforward for people to implement.
    // eslint-disable-next-line class-methods-use-this

  }, {
    key: 'nodeToElement',
    value: function () {
      function nodeToElement(node) {
        if (!node || (typeof node === 'undefined' ? 'undefined' : _typeof(node)) !== 'object') return null;
        var type = node.type;

        return _react2['default'].createElement(unmemoType(type), (0, _enzymeAdapterUtils.propsWithKeysAndRef)(node));
      }

      return nodeToElement;
    }()

    // eslint-disable-next-line class-methods-use-this

  }, {
    key: 'matchesElementType',
    value: function () {
      function matchesElementType(node, matchingType) {
        if (!node) {
          return node;
        }
        var type = node.type;

        return unmemoType(type) === unmemoType(matchingType);
      }

      return matchesElementType;
    }()
  }, {
    key: 'elementToNode',
    value: function () {
      function elementToNode(element) {
        return elementToTree(element);
      }

      return elementToNode;
    }()
  }, {
    key: 'nodeToHostNode',
    value: function () {
      function nodeToHostNode(node) {
        var supportsArray = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

        var nodes = _nodeToHostNode(node);
        if (Array.isArray(nodes) && !supportsArray) {
          return nodes[0];
        }
        return nodes;
      }

      return nodeToHostNode;
    }()
  }, {
    key: 'displayNameOfNode',
    value: function () {
      function displayNameOfNode(node) {
        if (!node) return null;
        var type = node.type,
            $$typeof = node.$$typeof;


        var nodeType = type || $$typeof;

        // newer node types may be undefined, so only test if the nodeType exists
        if (nodeType) {
          switch (nodeType) {
            case (is166 ? _reactIs.ConcurrentMode : _reactIs.AsyncMode) || NaN:
              return is166 ? 'ConcurrentMode' : 'AsyncMode';
            case _reactIs.Fragment || NaN:
              return 'Fragment';
            case _reactIs.StrictMode || NaN:
              return 'StrictMode';
            case _reactIs.Profiler || NaN:
              return 'Profiler';
            case _reactIs.Portal || NaN:
              return 'Portal';
            case _reactIs.Suspense || NaN:
              return 'Suspense';
            default:
          }
        }

        var $$typeofType = type && type.$$typeof;

        switch ($$typeofType) {
          case _reactIs.ContextConsumer || NaN:
            return 'ContextConsumer';
          case _reactIs.ContextProvider || NaN:
            return 'ContextProvider';
          case _reactIs.Memo || NaN:
            {
              var nodeName = (0, _enzymeAdapterUtils.displayNameOfNode)(node);
              return typeof nodeName === 'string' ? nodeName : 'Memo(' + String((0, _enzymeAdapterUtils.displayNameOfNode)(type)) + ')';
            }
          case _reactIs.ForwardRef || NaN:
            {
              if (type.displayName) {
                return type.displayName;
              }
              var name = (0, _enzymeAdapterUtils.displayNameOfNode)({ type: type.render });
              return name ? 'ForwardRef(' + String(name) + ')' : 'ForwardRef';
            }
          case _reactIs.Lazy || NaN:
            {
              return 'lazy';
            }
          default:
            return (0, _enzymeAdapterUtils.displayNameOfNode)(node);
        }
      }

      return displayNameOfNode;
    }()
  }, {
    key: 'isValidElement',
    value: function () {
      function isValidElement(element) {
        return (0, _reactIs.isElement)(element);
      }

      return isValidElement;
    }()
  }, {
    key: 'isValidElementType',
    value: function () {
      function isValidElementType(object) {
        return !!object && (0, _reactIs.isValidElementType)(object);
      }

      return isValidElementType;
    }()
  }, {
    key: 'isFragment',
    value: function () {
      function isFragment(fragment) {
        return (0, _Utils.typeOfNode)(fragment) === _reactIs.Fragment;
      }

      return isFragment;
    }()
  }, {
    key: 'isCustomComponent',
    value: function () {
      function isCustomComponent(type) {
        var fakeElement = makeFakeElement(type);
        return !!type && (typeof type === 'function' || (0, _reactIs.isForwardRef)(fakeElement) || (0, _reactIs.isContextProvider)(fakeElement) || (0, _reactIs.isContextConsumer)(fakeElement) || (0, _reactIs.isSuspense)(fakeElement));
      }

      return isCustomComponent;
    }()
  }, {
    key: 'isContextConsumer',
    value: function () {
      function isContextConsumer(type) {
        return !!type && (0, _reactIs.isContextConsumer)(makeFakeElement(type));
      }

      return isContextConsumer;
    }()
  }, {
    key: 'isCustomComponentElement',
    value: function () {
      function isCustomComponentElement(inst) {
        if (!inst || !this.isValidElement(inst)) {
          return false;
        }
        return this.isCustomComponent(inst.type);
      }

      return isCustomComponentElement;
    }()
  }, {
    key: 'getProviderFromConsumer',
    value: function () {
      function getProviderFromConsumer(Consumer) {
        // React stores references to the Provider on a Consumer differently across versions.
        if (Consumer) {
          var Provider = void 0;
          if (Consumer._context) {
            Provider = Consumer._context.Provider; // check this first, to avoid a deprecation warning
          } else if (Consumer.Provider) {
            Provider = Consumer.Provider;
          }
          if (Provider) {
            return Provider;
          }
        }
        throw new Error('Enzyme Internal Error: can’t figure out how to get Provider from Consumer');
      }

      return getProviderFromConsumer;
    }()
  }, {
    key: 'createElement',
    value: function () {
      function createElement() {
        return _react2['default'].createElement.apply(_react2['default'], arguments);
      }

      return createElement;
    }()
  }, {
    key: 'wrapWithWrappingComponent',
    value: function () {
      function wrapWithWrappingComponent(node, options) {
        return {
          RootFinder: _enzymeAdapterUtils.RootFinder,
          node: (0, _enzymeAdapterUtils.wrapWithWrappingComponent)(_react2['default'].createElement, node, options)
        };
      }

      return wrapWithWrappingComponent;
    }()
  }]);

  return ReactSixteenAdapter;
}(_enzyme.EnzymeAdapter);

module.exports = ReactSixteenAdapter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=ReactSixteenAdapter.js.map