import { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { API } from '@storybook/api';
import { KnobStoreKnob } from '../KnobStore';
export declare const DEFAULT_GROUP_ID = "Other";
interface KnobPanelProps {
    active: boolean;
    onReset?: object;
    api: Pick<API, 'on' | 'off' | 'emit' | 'getQueryParam' | 'setQueryParams'>;
}
interface KnobPanelState {
    knobs: Record<string, KnobStoreKnob>;
}
interface KnobPanelOptions {
    timestamps?: boolean;
}
export default class KnobPanel extends PureComponent<KnobPanelProps> {
    static propTypes: {
        active: PropTypes.Validator<boolean>;
        onReset: PropTypes.Validator<object | undefined>;
        api: PropTypes.Validator<Pick<API, "on" | "off" | "emit" | "getQueryParam" | "setQueryParams">>;
    };
    static defaultProps: KnobPanelProps;
    state: KnobPanelState;
    options: KnobPanelOptions;
    lastEdit: number;
    loadedFromUrl: boolean;
    mounted: boolean;
    stopListeningOnStory: Function;
    componentDidMount(): void;
    componentWillUnmount(): void;
    setOptions: (options?: KnobPanelOptions) => void;
    setKnobs: ({ knobs, timestamp, }: {
        knobs: Record<string, KnobStoreKnob>;
        timestamp?: number | undefined;
    }) => void;
    reset: () => void;
    copy: () => void;
    emitChange: (changedKnob: KnobStoreKnob) => void;
    handleChange: (changedKnob: KnobStoreKnob) => void;
    handleClick: (knob: KnobStoreKnob) => void;
    render(): JSX.Element | null;
}
export {};
