"use strict";
/* global window, location */

var _interopRequireDefault = require("@babel/runtime-corejs2/helpers/interopRequireDefault");

var _regenerator = _interopRequireDefault(require("@babel/runtime-corejs2/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime-corejs2/helpers/asyncToGenerator"));

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var router_1 = __importDefault(require("next/router"));

var unfetch_1 = __importDefault(require("unfetch"));

var evtSource;
var currentPage;
var retryTimeout;
var retryWait = 5000;

exports.default =
/*#__PURE__*/
function () {
  var _ref2 = (0, _asyncToGenerator2.default)(
  /*#__PURE__*/
  _regenerator.default.mark(function _callee(_ref) {
    var assetPrefix, setupPing;
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            setupPing = function _ref3(retry) {
              // Make sure to only create new EventSource request if page has changed
              if (router_1.default.pathname === currentPage && !retry) return; // close current EventSource connection

              if (evtSource) {
                evtSource.close();
              }

              currentPage = router_1.default.pathname;
              var url = "".concat(assetPrefix, "/_next/on-demand-entries-ping?page=").concat(currentPage);
              evtSource = new window.EventSource(url);

              evtSource.onerror = function () {
                retryTimeout = setTimeout(function () {
                  return setupPing(true);
                }, retryWait);
              };

              evtSource.onopen = function () {
                clearTimeout(retryTimeout);
              };

              evtSource.onmessage = function (event) {
                try {
                  var payload = JSON.parse(event.data);

                  if (payload.invalid) {
                    // Payload can be invalid even if the page does not exist.
                    // So, we need to make sure it exists before reloading.
                    unfetch_1.default(location.href, {
                      credentials: 'same-origin'
                    }).then(function (pageRes) {
                      if (pageRes.status === 200) {
                        location.reload();
                      }
                    });
                  }
                } catch (err) {
                  console.error('on-demand-entries failed to parse response', err);
                }
              };
            };

            assetPrefix = _ref.assetPrefix;
            router_1.default.ready(function () {
              router_1.default.events.on('routeChangeComplete', setupPing);
            });
            setupPing(currentPage);

          case 4:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function (_x) {
    return _ref2.apply(this, arguments);
  };
}();