import React from 'react'
import Popper from '$core-components/Popper'
import { t } from '$themelocalization'
import LoadingDots from '$core-components/LoadingDots'
import PriceDisplay from '../Price'

const Price = ({ price, isPriceCalculating, showMinimumPrice }) => {
  if (!price) return null
  return (
    <div className='static-product-price'>
      <div className='total-price' id='total-price-component'>
        {isPriceCalculating || !price
          ? <LoadingDots />
          : <div className='price-wrapper'>
            <PriceDisplay
              model={price.Price}
              showCurrency
              isMinimumPrice={showMinimumPrice}
            />
          </div>
        }
      </div>
    </div>
  )
}

export default Price
